/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.apm.webview.webview_trace.manager;

import com.instabug.apm.configuration.APMConfigurationProvider;
import com.instabug.apm.di.Provider;
import com.instabug.apm.logger.internal.Logger;
import com.instabug.apm.webview.dispatch.WebViewEventDispatcher;
import com.instabug.apm.webview.dispatch.WebViewEventListener;
import com.instabug.apm.webview.webview_trace.configuration.WebViewTraceConfigurationProvider;
import com.instabug.apm.webview.webview_trace.handler.WebViewTraceEventListener;
import com.instabug.apm.webview.webview_trace.handler.WebViewTraceHandler;
import com.instabug.apm.webview.webview_trace.manager.WebViewTraceManager;
import java.util.Collections;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.Executor;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u000e\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0007\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\b\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0012H\u0016J\u0010\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/instabug/apm/webview/webview_trace/manager/WebViewTraceManagerImpl;", "Lcom/instabug/apm/webview/webview_trace/manager/WebViewTraceManager;", "webViewTraceConfigurations", "Lcom/instabug/apm/webview/webview_trace/configuration/WebViewTraceConfigurationProvider;", "apmConfigurations", "Lcom/instabug/apm/configuration/APMConfigurationProvider;", "handler", "Lcom/instabug/apm/di/Provider;", "Lcom/instabug/apm/webview/webview_trace/handler/WebViewTraceHandler;", "logger", "Lcom/instabug/apm/logger/internal/Logger;", "executor", "Ljava/util/concurrent/Executor;", "(Lcom/instabug/apm/webview/webview_trace/configuration/WebViewTraceConfigurationProvider;Lcom/instabug/apm/configuration/APMConfigurationProvider;Lcom/instabug/apm/di/Provider;Lcom/instabug/apm/di/Provider;Ljava/util/concurrent/Executor;)V", "listeners", "", "Lcom/instabug/apm/webview/dispatch/WebViewEventListener;", "onStateChangeSynchronous", "", "onStateChanged", "registerWebViewEventListener", "listener", "Lcom/instabug/apm/webview/webview_trace/handler/WebViewTraceEventListener;", "setSDKEnabled", "isEnabled", "", "setWebViewTracesSdkEnabledValue", "unregisterWebViewEventListener", "instabug-apm_defaultUiRelease"})
@SourceDebugExtension(value={"SMAP\nWebViewTraceManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WebViewTraceManager.kt\ncom/instabug/apm/webview/webview_trace/manager/WebViewTraceManagerImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,81:1\n1855#2,2:82\n*S KotlinDebug\n*F\n+ 1 WebViewTraceManager.kt\ncom/instabug/apm/webview/webview_trace/manager/WebViewTraceManagerImpl\n*L\n46#1:82,2\n*E\n"})
public final class WebViewTraceManagerImpl
implements WebViewTraceManager {
    @NotNull
    private final WebViewTraceConfigurationProvider webViewTraceConfigurations;
    @NotNull
    private final APMConfigurationProvider apmConfigurations;
    @NotNull
    private final Provider<WebViewTraceHandler> handler;
    @NotNull
    private final Provider<Logger> logger;
    @NotNull
    private final Executor executor;
    @NotNull
    private final Set<WebViewEventListener> listeners;

    public WebViewTraceManagerImpl(@NotNull WebViewTraceConfigurationProvider webViewTraceConfigurationProvider, @NotNull APMConfigurationProvider aPMConfigurationProvider, @NotNull Provider<WebViewTraceHandler> provider, @NotNull Provider<Logger> provider2, @NotNull Executor executor2) {
        WebViewTraceManagerImpl webViewTraceManagerImpl = this;
        Intrinsics.checkNotNullParameter((Object)webViewTraceConfigurationProvider, (String)"webViewTraceConfigurations");
        Intrinsics.checkNotNullParameter((Object)aPMConfigurationProvider, (String)"apmConfigurations");
        Intrinsics.checkNotNullParameter(provider, (String)"handler");
        Intrinsics.checkNotNullParameter(provider2, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)executor2, (String)"executor");
        this.webViewTraceConfigurations = webViewTraceConfigurationProvider;
        this.apmConfigurations = aPMConfigurationProvider;
        this.handler = provider;
        this.logger = provider2;
        webViewTraceManagerImpl.executor = executor2;
        Set set = Collections.synchronizedSet(Collections.newSetFromMap(new WeakHashMap()));
        Intrinsics.checkNotNullExpressionValue(set, (String)"synchronizedSet(\n       \u2026(WeakHashMap())\n        )");
        webViewTraceManagerImpl.listeners = set;
    }

    private final void onStateChangeSynchronous() {
        if (!this.webViewTraceConfigurations.getEnabled()) {
            Object object = this.handler.invoke();
            if (object != null) {
                object.clearAll();
            }
            object = this.listeners.iterator();
            while (object.hasNext()) {
                WebViewEventDispatcher.INSTANCE.minusAssign((WebViewEventListener)object.next());
            }
            this.listeners.clear();
        }
    }

    private final void setWebViewTracesSdkEnabledValue(boolean bl) {
        WebViewTraceManagerImpl webViewTraceManagerImpl = this;
        webViewTraceManagerImpl.webViewTraceConfigurations.setSdkEnabled(bl);
        webViewTraceManagerImpl.onStateChangeSynchronous();
    }

    private static final void onStateChanged$lambda$0(WebViewTraceManagerImpl webViewTraceManagerImpl) {
        WebViewTraceManagerImpl webViewTraceManagerImpl2 = webViewTraceManagerImpl;
        Intrinsics.checkNotNullParameter((Object)webViewTraceManagerImpl2, (String)"this$0");
        webViewTraceManagerImpl2.onStateChangeSynchronous();
    }

    private static final void setSDKEnabled$lambda$2(WebViewTraceManagerImpl webViewTraceManagerImpl, boolean bl) {
        WebViewTraceManagerImpl webViewTraceManagerImpl2 = webViewTraceManagerImpl;
        Intrinsics.checkNotNullParameter((Object)webViewTraceManagerImpl2, (String)"this$0");
        if (!webViewTraceManagerImpl2.apmConfigurations.isAPMFeatureAvailable()) {
            webViewTraceManagerImpl.logger.invoke().e("setWebViewsEnabled wasn\u2019t called as the feature seems to be disabled for your company on Instabug. Please contact Instabug\u2019s support team from your dashboard for more information.");
        } else if (!webViewTraceManagerImpl.apmConfigurations.isAPMSdkEnabled()) {
            webViewTraceManagerImpl.logger.invoke().e("setWebViewsEnabled wasn't called. Please make sure to enable APM first by following the instructions at this link: https://docs.instabug.com/reference#enable-or-disable-apm");
        } else if (!webViewTraceManagerImpl.apmConfigurations.isUiTraceSdkEnabled()) {
            webViewTraceManagerImpl.logger.invoke().e("setWebViewsEnabled wasn't called. Please make sure to enable Auto UI Traces first by following the instructions at this link: https://docs.instabug.com/reference/enable-or-disable-auto-ui-trace");
        } else if (!webViewTraceManagerImpl.apmConfigurations.isUiLoadingMetricsFeatureEnabled()) {
            webViewTraceManagerImpl.logger.invoke().e("setWebViewsEnabled wasn\u2019t called as the feature seems to be disabled for your Instabug company account. Please contact support for more information.");
        } else if (!webViewTraceManagerImpl.apmConfigurations.isUiLoadingMetricsSdkEnabled()) {
            webViewTraceManagerImpl.logger.invoke().e("setWebViewsEnabled wasn't called. Please make sure to enable Screen Loading first by following the instructions at this link: https://docs.instabug.com/reference/enable-or-disable-screen-loading");
        } else if (!webViewTraceManagerImpl.webViewTraceConfigurations.getFeatureEnabled()) {
            webViewTraceManagerImpl.logger.invoke().e("setWebViewsEnabled wasn\u2019t called as the feature seems to be disabled for your Instabug company account. Please contact support for more information.");
        } else {
            webViewTraceManagerImpl.setWebViewTracesSdkEnabledValue(bl);
        }
    }

    private static final void registerWebViewEventListener$lambda$3(WebViewTraceManagerImpl webViewTraceManagerImpl, WebViewTraceEventListener webViewTraceEventListener) {
        Intrinsics.checkNotNullParameter((Object)webViewTraceManagerImpl, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)webViewTraceEventListener, (String)"$listener");
        if (webViewTraceManagerImpl.webViewTraceConfigurations.getEnabled()) {
            WebViewEventDispatcher.INSTANCE.plusAssign(webViewTraceEventListener);
            webViewTraceManagerImpl.listeners.add(webViewTraceEventListener);
        }
    }

    private static final void unregisterWebViewEventListener$lambda$4(WebViewTraceEventListener webViewTraceEventListener, WebViewTraceManagerImpl webViewTraceManagerImpl) {
        WebViewTraceManagerImpl webViewTraceManagerImpl2 = webViewTraceManagerImpl;
        Intrinsics.checkNotNullParameter((Object)webViewTraceEventListener, (String)"$listener");
        Intrinsics.checkNotNullParameter((Object)webViewTraceManagerImpl2, (String)"this$0");
        WebViewEventDispatcher.INSTANCE.minusAssign(webViewTraceEventListener);
        webViewTraceManagerImpl2.listeners.remove(webViewTraceEventListener);
    }

    @Override
    public void onStateChanged() {
        this.executor.execute(() -> WebViewTraceManagerImpl.onStateChanged$lambda$0(this));
    }

    @Override
    public void setSDKEnabled(boolean bl) {
        this.executor.execute(() -> WebViewTraceManagerImpl.setSDKEnabled$lambda$2(this, bl));
    }

    @Override
    public void registerWebViewEventListener(@NotNull WebViewTraceEventListener webViewTraceEventListener) {
        Intrinsics.checkNotNullParameter((Object)webViewTraceEventListener, (String)"listener");
        this.executor.execute(() -> WebViewTraceManagerImpl.registerWebViewEventListener$lambda$3(this, webViewTraceEventListener));
    }

    @Override
    public void unregisterWebViewEventListener(@NotNull WebViewTraceEventListener webViewTraceEventListener) {
        Intrinsics.checkNotNullParameter((Object)webViewTraceEventListener, (String)"listener");
        this.executor.execute(() -> WebViewTraceManagerImpl.unregisterWebViewEventListener$lambda$4(webViewTraceEventListener, this));
    }
}

