/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.apm.webview.webview_trace.handler;

import com.instabug.apm.model.EventTimeMetricCapture;
import com.instabug.apm.webview.webview_trace.flow.WebViewEventFlow;
import com.instabug.apm.webview.webview_trace.model.WebViewTraceModel;
import com.instabug.apm.webview.webview_trace.model.event.WebViewEvent;
import com.instabug.apm.webview.webview_trace.model.event.WebViewLoadUrlEvent;
import com.instabug.apm.webview.webview_trace.model.event.WebViewSizeReadyEvent;
import com.instabug.apm.webview.webview_trace.model.event.WebViewTraceInitiationEvent;
import com.instabug.apm.webview.webview_trace.model.event.WebViewVitalEvent;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\fJ\u0006\u0010\u000e\u001a\u00020\u000fJ\u0006\u0010\u0010\u001a\u00020\u000fJ\u0014\u0010\u0011\u001a\u00020\u0012*\u00020\u00072\u0006\u0010\r\u001a\u00020\u0013H\u0002J\u0014\u0010\u0011\u001a\u00020\u0012*\u00020\u00072\u0006\u0010\r\u001a\u00020\u0014H\u0002J\u0014\u0010\u0011\u001a\u00020\u0012*\u00020\u00072\u0006\u0010\r\u001a\u00020\u0015H\u0002J\u0014\u0010\u000b\u001a\u00020\u0012*\u00020\u00072\u0006\u0010\r\u001a\u00020\fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\b\u001a\u0004\u0018\u00010\u00072\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/instabug/apm/webview/webview_trace/handler/WebViewTraceModelWrapper;", "", "flows", "Lcom/instabug/apm/webview/webview_trace/flow/WebViewEventFlow;", "vitalsFlow", "(Lcom/instabug/apm/webview/webview_trace/flow/WebViewEventFlow;Lcom/instabug/apm/webview/webview_trace/flow/WebViewEventFlow;)V", "<set-?>", "Lcom/instabug/apm/webview/webview_trace/model/WebViewTraceModel;", "traceModel", "getTraceModel", "()Lcom/instabug/apm/webview/webview_trace/model/WebViewTraceModel;", "handleEvent", "Lcom/instabug/apm/webview/webview_trace/model/event/WebViewEvent;", "event", "isSizeResolved", "", "shouldRegisterWebVitalsListener", "handle", "", "Lcom/instabug/apm/webview/webview_trace/model/event/WebViewLoadUrlEvent;", "Lcom/instabug/apm/webview/webview_trace/model/event/WebViewSizeReadyEvent;", "Lcom/instabug/apm/webview/webview_trace/model/event/WebViewVitalEvent;", "instabug-apm_defaultUiRelease"})
@SourceDebugExtension(value={"SMAP\nWebViewTraceModelWrapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WebViewTraceModelWrapper.kt\ncom/instabug/apm/webview/webview_trace/handler/WebViewTraceModelWrapper\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,65:1\n1#2:66\n*E\n"})
public final class WebViewTraceModelWrapper {
    @NotNull
    private final WebViewEventFlow flows;
    @NotNull
    private final WebViewEventFlow vitalsFlow;
    @Nullable
    private WebViewTraceModel traceModel;

    public WebViewTraceModelWrapper(@NotNull WebViewEventFlow webViewEventFlow, @NotNull WebViewEventFlow webViewEventFlow2) {
        Intrinsics.checkNotNullParameter((Object)webViewEventFlow, (String)"flows");
        Intrinsics.checkNotNullParameter((Object)webViewEventFlow2, (String)"vitalsFlow");
        this.flows = webViewEventFlow;
        this.vitalsFlow = webViewEventFlow2;
    }

    private final void handleEvent(WebViewTraceModel webViewTraceModel, WebViewEvent webViewEvent) {
        if (webViewEvent.isTimeBased()) {
            webViewTraceModel.setLastEventTimeCapture(webViewEvent.getTimeCapture());
        }
        if (webViewEvent instanceof WebViewLoadUrlEvent) {
            this.handle(webViewTraceModel, (WebViewLoadUrlEvent)webViewEvent);
        } else if (webViewEvent instanceof WebViewVitalEvent) {
            this.handle(webViewTraceModel, (WebViewVitalEvent)webViewEvent);
        } else if (webViewEvent instanceof WebViewSizeReadyEvent) {
            this.handle(webViewTraceModel, (WebViewSizeReadyEvent)webViewEvent);
        }
    }

    private final void handle(WebViewTraceModel webViewTraceModel, WebViewLoadUrlEvent webViewLoadUrlEvent) {
        if (webViewTraceModel.getUrl() == null) {
            webViewTraceModel.setUrl(webViewLoadUrlEvent.getUrl());
        }
    }

    private final void handle(WebViewTraceModel webViewTraceModel, WebViewVitalEvent webViewVitalEvent) {
        Map<String, Double> map = webViewTraceModel.getVitals();
        if (map == null) {
            HashMap hashMap;
            map = hashMap;
            hashMap = new HashMap();
            webViewTraceModel.setVitals(map);
        }
        map.put(webViewVitalEvent.getName(), webViewVitalEvent.getValue());
    }

    private final void handle(WebViewTraceModel webViewTraceModel, WebViewSizeReadyEvent webViewSizeReadyEvent) {
        if (!webViewTraceModel.isSizeResolved()) {
            webViewTraceModel.setFullScreen(webViewSizeReadyEvent.isFullScreen());
        }
    }

    @Nullable
    public final WebViewTraceModel getTraceModel() {
        return this.traceModel;
    }

    @Nullable
    public final WebViewEvent handleEvent(@NotNull WebViewEvent webViewEvent) {
        Intrinsics.checkNotNullParameter((Object)webViewEvent, (String)"event");
        if (this.flows.process(webViewEvent)) {
            WebViewTraceModel webViewTraceModel;
            if (this.traceModel == null && webViewEvent instanceof WebViewTraceInitiationEvent) {
                WebViewEvent webViewEvent2 = webViewEvent;
                long l = ((WebViewTraceInitiationEvent)((Object)webViewEvent2)).getTraceId();
                EventTimeMetricCapture eventTimeMetricCapture = webViewEvent2.getTimeCapture();
                this.traceModel = new WebViewTraceModel(l, null, eventTimeMetricCapture, null, null, null, 58, null);
            }
            if ((webViewTraceModel = this.traceModel) != null) {
                this.handleEvent(webViewTraceModel, webViewEvent);
            }
        }
        return this.flows.getPendingEvent();
    }

    public final boolean shouldRegisterWebVitalsListener() {
        return this.vitalsFlow.finished();
    }

    public final boolean isSizeResolved() {
        WebViewTraceModel webViewTraceModel = ((WebViewTraceModelWrapper)((Object)webViewTraceModel)).traceModel;
        return webViewTraceModel != null ? webViewTraceModel.isSizeResolved() : false;
    }
}

