/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.apm.util.powermanagement;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Build;
import android.os.PowerManager;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import com.instabug.apm.di.ServiceLocator;
import com.instabug.apm.logger.internal.Logger;
import com.instabug.apm.util.powermanagement.PowerManagementCallback;
import com.instabug.library.core.InstabugCore;
import java.util.ArrayList;
import java.util.List;

public class PowerSaveModeBroadcast
extends BroadcastReceiver {
    private final Logger apmLogger = ServiceLocator.getApmLogger();
    @NonNull
    private final List<PowerManagementCallback> callbacks = new ArrayList<PowerManagementCallback>();
    @NonNull
    private final Context appContext;

    public PowerSaveModeBroadcast(@NonNull Context context) {
        this.appContext = context;
    }

    public synchronized void onReceive(Context context, Intent object2) {
        if ((context = (PowerManager)context.getApplicationContext().getSystemService("power")) != null) {
            for (PowerManagementCallback powerManagementCallback : ((PowerSaveModeBroadcast)((Object)this)).callbacks) {
                if (Build.VERSION.SDK_INT < 21) continue;
                powerManagementCallback.onPowerSaveModeChanged(context.isPowerSaveMode());
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @RequiresApi(api=21)
    public synchronized void register(@NonNull PowerManagementCallback powerManagementCallback) {
        Exception exception2;
        block6: {
            block5: {
                IntentFilter intentFilter;
                PowerSaveModeBroadcast powerSaveModeBroadcast;
                Context context;
                PowerSaveModeBroadcast powerSaveModeBroadcast2;
                try {
                    if (this.callbacks.size() > 0) {
                        this.apmLogger.logSDKProtected("PowerSaveModeBroadcast is already registered. Skipping re-registering");
                        break block5;
                    }
                    PowerSaveModeBroadcast powerSaveModeBroadcast3 = this;
                    powerSaveModeBroadcast2 = powerSaveModeBroadcast3;
                    context = powerSaveModeBroadcast3.appContext;
                    powerSaveModeBroadcast = this;
                }
                catch (Exception exception2) {}
                IntentFilter intentFilter2 = intentFilter;
                intentFilter = new IntentFilter("android.os.action.POWER_SAVE_MODE_CHANGED");
                context.registerReceiver((BroadcastReceiver)powerSaveModeBroadcast, intentFilter2);
                powerSaveModeBroadcast2.apmLogger.logSDKProtected("PowerSaveModeReceiver registered on " + powerManagementCallback.getClass().getSimpleName());
                break block6;
            }
            this.callbacks.add(powerManagementCallback);
            return;
        }
        this.apmLogger.logSDKProtected("Error: " + exception2.getMessage() + "While registering power saver mode receiver");
    }

    @RequiresApi(api=21)
    public synchronized void unregister(@NonNull PowerManagementCallback powerManagementCallback) {
        block4: {
            if (!this.callbacks.remove(powerManagementCallback)) break block4;
            if (!this.callbacks.isEmpty()) break block4;
            try {
                PowerSaveModeBroadcast powerSaveModeBroadcast = this;
                powerSaveModeBroadcast.appContext.unregisterReceiver((BroadcastReceiver)this);
                powerSaveModeBroadcast.apmLogger.logSDKProtected("PowerSaveModeReceiver unregistered from " + powerManagementCallback.getClass().getSimpleName());
            }
            catch (Exception exception) {
                InstabugCore.reportError((Throwable)exception, (String)"unregister PowerSaveModeBroadcast got error");
            }
        }
    }
}

