/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.apm.util.powermanagement;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.instabug.apm.di.ServiceLocator;
import com.instabug.apm.logger.internal.Logger;
import com.instabug.apm.util.powermanagement.PowerManagementCallback;
import com.instabug.library.core.InstabugCore;
import java.util.ArrayList;
import java.util.List;

@RequiresApi(api=16)
public class BatteryLevelChangeBroadcast
extends BroadcastReceiver {
    private final Logger apmLogger = ServiceLocator.getApmLogger();
    private final List<PowerManagementCallback> callbacks = new ArrayList<PowerManagementCallback>();
    private final Context appContext;

    public BatteryLevelChangeBroadcast(@NonNull Context context) {
        this.appContext = context;
    }

    public synchronized void onReceive(Context object, Intent intent) {
        if (intent != null) {
            int n = intent.getIntExtra("level", 0);
            object = this.callbacks.iterator();
            while (object.hasNext()) {
                ((PowerManagementCallback)object.next()).onBatteryLevelChanged(n);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void register(@Nullable PowerManagementCallback powerManagementCallback) {
        Exception exception2;
        block7: {
            block6: {
                IntentFilter intentFilter;
                BatteryLevelChangeBroadcast batteryLevelChangeBroadcast;
                Context context;
                BatteryLevelChangeBroadcast batteryLevelChangeBroadcast2;
                if (powerManagementCallback == null) {
                    return;
                }
                try {
                    if (this.callbacks.size() > 0) {
                        this.apmLogger.logSDKProtected("BatteryLevelChangeBroadcast is already registered. Skipping re-registering");
                        break block6;
                    }
                    BatteryLevelChangeBroadcast batteryLevelChangeBroadcast3 = this;
                    batteryLevelChangeBroadcast2 = batteryLevelChangeBroadcast3;
                    context = batteryLevelChangeBroadcast3.appContext;
                    batteryLevelChangeBroadcast = this;
                }
                catch (Exception exception2) {}
                IntentFilter intentFilter2 = intentFilter;
                intentFilter = new IntentFilter("android.intent.action.BATTERY_CHANGED");
                context.registerReceiver((BroadcastReceiver)batteryLevelChangeBroadcast, intentFilter2);
                batteryLevelChangeBroadcast2.apmLogger.logSDKProtected("batteryLevelReceiver registered on " + powerManagementCallback.getClass().getSimpleName());
                break block7;
            }
            this.callbacks.add(powerManagementCallback);
            return;
        }
        this.apmLogger.logSDKProtected("Error: " + exception2.getMessage() + "While registering battery level receiver");
    }

    public synchronized void unregister(@Nullable PowerManagementCallback powerManagementCallback) {
        block5: {
            if (powerManagementCallback == null) {
                return;
            }
            if (!this.callbacks.remove(powerManagementCallback)) break block5;
            if (!this.callbacks.isEmpty()) break block5;
            try {
                BatteryLevelChangeBroadcast batteryLevelChangeBroadcast = this;
                batteryLevelChangeBroadcast.appContext.unregisterReceiver((BroadcastReceiver)this);
                batteryLevelChangeBroadcast.apmLogger.logSDKProtected("batteryLevelReceiver unregistered from " + powerManagementCallback.getClass().getSimpleName());
            }
            catch (Exception exception) {
                InstabugCore.reportError((Throwable)exception, (String)"unregister BatteryLevelChangeBroadcast got error");
            }
        }
    }
}

