/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.apm.uitrace.util;

import android.app.Activity;
import android.content.Context;
import com.instabug.apm.cache.model.UiTraceCacheModel;
import com.instabug.apm.logger.internal.Logger;
import com.instabug.apm.uitrace.model.UiTraceEndParams;
import com.instabug.apm.uitrace.util.ActivityExtKt;
import com.instabug.apm.uitrace.util.UiTraceExtKt;
import com.instabug.apm.util.ClassModuleHelper;
import com.instabug.apm.util.device.APMDeviceStateProvider;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u001a\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u001a\u0010\u0007\u001a\u00020\b*\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r\u001a\u0012\u0010\u000e\u001a\u00020\b*\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\u000f"}, d2={"getUiTraceEndParams", "Lcom/instabug/apm/uitrace/model/UiTraceEndParams;", "Landroid/app/Activity;", "deviceStateProvider", "Lcom/instabug/apm/util/device/APMDeviceStateProvider;", "elapsedTimeMicro", "", "logAutomaticUiTraceSuccessfullyEnded", "", "Lcom/instabug/apm/logger/internal/Logger;", "screenName", "", "cacheModel", "Lcom/instabug/apm/cache/model/UiTraceCacheModel;", "logAutomaticUiTraceSuccessfullyStarted", "instabug-apm_defaultUiRelease"})
public abstract class UiTraceUtilsKt {
    @NotNull
    public static final UiTraceEndParams getUiTraceEndParams(@NotNull Activity object, @NotNull APMDeviceStateProvider object2, long l) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)object2, (String)"deviceStateProvider");
        APMDeviceStateProvider aPMDeviceStateProvider = object2;
        Activity activity = object;
        object = ActivityExtKt.getScreenName(activity);
        object2 = ClassModuleHelper.getModuleName(activity.getClass());
        int n = aPMDeviceStateProvider.getRefreshRate((Context)activity);
        return new UiTraceEndParams((String)object, (String)object2, n, l);
    }

    public static final void logAutomaticUiTraceSuccessfullyStarted(@NotNull Logger logger2, @NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)logger2, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)string, (String)"screenName");
        logger2.logSDKDebug("Started Auto UI Trace for screen with name \"" + string + "\".");
    }

    public static final void logAutomaticUiTraceSuccessfullyEnded(@NotNull Logger logger2, @NotNull String string, @NotNull UiTraceCacheModel uiTraceCacheModel) {
        Intrinsics.checkNotNullParameter((Object)logger2, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)string, (String)"screenName");
        Intrinsics.checkNotNullParameter((Object)uiTraceCacheModel, (String)"cacheModel");
        logger2.logSDKDebug("Ended Auto UI Trace for screen with name \"" + string + "\".\nTotal duration: " + UiTraceExtKt.getTotalDurationInSeconds(uiTraceCacheModel) + " seconds\nTotal hang duration: " + UiTraceExtKt.getTotalHangDurationMillis(uiTraceCacheModel) + " ms");
    }
}

