/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.apm.screenloading.validator;

import com.instabug.apm.configuration.APMConfigurationProvider;
import com.instabug.apm.logger.internal.Logger;
import com.instabug.apm.sanitization.Validator;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0015\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/instabug/apm/screenloading/validator/EndScreenLoadingConfigurationValidator;", "Lcom/instabug/apm/sanitization/Validator;", "", "apmConfigurationProvider", "Lcom/instabug/apm/configuration/APMConfigurationProvider;", "logger", "Lcom/instabug/apm/logger/internal/Logger;", "(Lcom/instabug/apm/configuration/APMConfigurationProvider;Lcom/instabug/apm/logger/internal/Logger;)V", "isValid", "", "item", "(Lkotlin/Unit;)Z", "setInvalidAndLog", "errorMessage", "", "instabug-apm_defaultUiRelease"})
public final class EndScreenLoadingConfigurationValidator
implements Validator<Unit> {
    @NotNull
    private final APMConfigurationProvider apmConfigurationProvider;
    @NotNull
    private final Logger logger;

    public EndScreenLoadingConfigurationValidator(@NotNull APMConfigurationProvider aPMConfigurationProvider, @NotNull Logger logger2) {
        Intrinsics.checkNotNullParameter((Object)aPMConfigurationProvider, (String)"apmConfigurationProvider");
        Intrinsics.checkNotNullParameter((Object)logger2, (String)"logger");
        this.apmConfigurationProvider = aPMConfigurationProvider;
        this.logger = logger2;
    }

    private final boolean setInvalidAndLog(String string) {
        this.logger.logSDKError(string);
        return false;
    }

    @Override
    public boolean isValid(@NotNull Unit object) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"item");
        object = this.apmConfigurationProvider;
        return !object.isAPMFeatureAvailable() ? this.setInvalidAndLog("endScreenLoading wasn\u2019t called as the feature seems to be disabled for your Instabug company account. Please contact support for more information.") : (!object.isAPMSdkEnabled() ? this.setInvalidAndLog("endScreenLoading wasn't called. Please make sure to enable APM first by following the instructions at this link: https://docs.instabug.com/reference#enable-or-disable-apm") : (!object.isUiLoadingMetricsFeatureEnabled() ? this.setInvalidAndLog("endScreenLoading wasn\u2019t called as the feature seems to be disabled for your Instabug company account. Please contact support for more information.") : (!object.isUiLoadingMetricsSdkEnabled() ? this.setInvalidAndLog("endScreenLoading wasn't called as Screen Loading seems to be disabled. Please make sure to enable Screen Loading first by following the instructions at this link: https://docs.instabug.com/reference/enable-or-disable-screen-loading") : (!object.isUiTraceSdkEnabled() ? this.setInvalidAndLog("endScreenLoading wasn't called as Auto UI Traces seems to be disabled. Please make sure to enable Auto UI Traces first by following the instructions at this link: https://docs.instabug.com/reference#enable-or-disable-auto-ui-traces") : (!object.isEndScreenLoadingFeatureEnabled() ? this.setInvalidAndLog("endScreenLoading wasn\u2019t called as the feature seems to be disabled for your Instabug company account. Please contact support for more information.") : true)))));
    }
}

