/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.apm.networkinterception.utils;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.io.IOException;
import java.io.InputStream;

public class APMCountableInputStream
extends InputStream {
    private long count = 0L;
    private int mark = -1;
    private boolean callbackCompleted = false;
    private final InputStream stream;
    private final Callback callback;

    public APMCountableInputStream(InputStream inputStream, Callback callback) {
        this.stream = inputStream;
        this.callback = callback;
    }

    @Override
    public int read() {
        int n = this.stream.read();
        if (n != -1) {
            ++this.count;
        } else if (!this.callbackCompleted) {
            this.callbackCompleted = true;
            this.callback.onReadCompleted(this.count);
        }
        return n;
    }

    @Override
    public int read(@NonNull byte[] byArray, int n, int n2) {
        int n3 = this.stream.read(byArray, n, n2);
        if (n3 != -1) {
            this.count += (long)n3;
        } else if (!this.callbackCompleted) {
            this.callbackCompleted = true;
            this.callback.onReadCompleted(this.count);
        }
        return n3;
    }

    @Override
    public long skip(long l) {
        l = this.stream.skip(l);
        this.count += l;
        return l;
    }

    @Override
    public void mark(int n) {
        APMCountableInputStream aPMCountableInputStream = this;
        aPMCountableInputStream.stream.mark(n);
        aPMCountableInputStream.mark = (int)aPMCountableInputStream.count;
    }

    @Override
    public void reset() {
        if (this.stream.markSupported()) {
            if (this.mark != -1) {
                APMCountableInputStream aPMCountableInputStream = this;
                aPMCountableInputStream.stream.reset();
                aPMCountableInputStream.count = aPMCountableInputStream.mark;
                return;
            }
            throw new IOException("Mark not set");
        }
        throw new IOException("Mark not supported");
    }

    @Nullable
    public String getBody() {
        return null;
    }

    public static interface Callback {
        public void onReadCompleted(long var1);
    }
}

