/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.apm.networking.mapping.uitrace;

import android.annotation.SuppressLint;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.instabug.apm.cache.model.UiLoadingModel;
import com.instabug.apm.cache.model.UiTraceCacheModel;
import com.instabug.apm.networking.mapping.uiloading.UiLoadingMapper;
import com.instabug.apm.networking.mapping.uitrace.UiTraceMapper;
import com.instabug.apm.webview.webview_trace.WebViewCacheModelToJsonMapper;
import com.instabug.apm.webview.webview_trace.model.WebViewCacheModel;
import java.util.Iterator;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

@SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
public class UiTraceMapperImpl
implements UiTraceMapper {
    @NonNull
    private final UiLoadingMapper uiLoadingMapper;
    @NonNull
    private final WebViewCacheModelToJsonMapper webViewMapper;

    public UiTraceMapperImpl(@NonNull UiLoadingMapper uiLoadingMapper, @NonNull WebViewCacheModelToJsonMapper webViewCacheModelToJsonMapper) {
        this.uiLoadingMapper = uiLoadingMapper;
        this.webViewMapper = webViewCacheModelToJsonMapper;
    }

    private void putWebViewTraces(@NonNull JSONObject jSONObject, @Nullable List<WebViewCacheModel> list) {
        UiTraceMapperImpl uiTraceMapperImpl = uiTraceMapperImpl.webViewMapper.map(list);
        if (uiTraceMapperImpl != null) {
            jSONObject.put("wv", (Object)uiTraceMapperImpl);
        }
    }

    @Override
    public JSONArray toJsonArray(List<UiTraceCacheModel> jSONArray) {
        JSONArray jSONArray2;
        JSONArray jSONArray3 = jSONArray;
        jSONArray = jSONArray2;
        jSONArray2 = new JSONArray();
        Iterator iterator = jSONArray3.iterator();
        while (iterator.hasNext()) {
            jSONArray.put((Object)this.toJson((UiTraceCacheModel)iterator.next()));
        }
        return jSONArray;
    }

    public JSONObject toJson(UiTraceCacheModel uiTraceCacheModel) {
        UiLoadingMapper uiLoadingMapper;
        UiLoadingModel uiLoadingModel;
        JSONObject jSONObject;
        JSONObject jSONObject2 = jSONObject;
        new JSONObject().put("n", (Object)uiTraceCacheModel.getName());
        long l = uiTraceCacheModel.getDuration();
        jSONObject2.put("dmus", l);
        l = uiTraceCacheModel.getLargeDropsDuration();
        long l2 = uiTraceCacheModel.getSmallDropsDuration();
        if (l != -1L && l2 != -1L) {
            JSONObject jSONObject3 = jSONObject2;
            jSONObject3.put("ldd", l);
            jSONObject3.put("sdd", l2);
        }
        JSONObject jSONObject4 = jSONObject2;
        jSONObject4.put("ud", uiTraceCacheModel.isUserDefined());
        l = uiTraceCacheModel.getStartTimestamp();
        jSONObject4.put("st", l);
        jSONObject4.put("rr", uiTraceCacheModel.getRefreshRate());
        if (uiTraceCacheModel.getBatteryLevel() != -1) {
            jSONObject2.put("bl", uiTraceCacheModel.getBatteryLevel());
        }
        if (uiTraceCacheModel.getContainerName() != null) {
            jSONObject2.put("cn", (Object)uiTraceCacheModel.getContainerName());
        }
        if (uiTraceCacheModel.getScreenTitle() != null) {
            jSONObject2.put("snt", (Object)uiTraceCacheModel.getScreenTitle());
        }
        if (uiTraceCacheModel.getOrientation() != null) {
            jSONObject2.put("o", (Object)uiTraceCacheModel.getOrientation());
        }
        if (uiTraceCacheModel.getModuleName() != null) {
            jSONObject2.put("mn", (Object)uiTraceCacheModel.getModuleName());
        }
        if (uiTraceCacheModel.getPowerSaveMode() != null) {
            jSONObject2.put("pws", (Object)uiTraceCacheModel.getPowerSaveMode());
        }
        if ((uiLoadingModel = uiTraceCacheModel.getUiLoadingModel()) != null && (uiLoadingMapper = this.uiLoadingMapper) != null && (uiLoadingModel = uiLoadingMapper.toJson(uiLoadingModel)) != null) {
            jSONObject2.put("sl", (Object)uiLoadingModel);
        }
        this.putWebViewTraces(jSONObject2, uiTraceCacheModel.getWebViewTraces());
        return jSONObject2;
    }
}

