/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.apm.handler.uitrace.uiloading;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.instabug.apm.cache.model.UiLoadingModel;
import com.instabug.apm.handler.uitrace.uiloading.ActivityEventToUiLoadingModelMapper;
import com.instabug.apm.handler.uitrace.uiloading.UiLoadingMetricHandler;
import com.instabug.apm.logger.internal.Logger;
import com.instabug.apm.model.EmptyTimeMetric;
import com.instabug.apm.model.EventTimeMetricCapture;
import java.util.Arrays;

public class UiLoadingMetricHandlerImpl
implements UiLoadingMetricHandler {
    private final EventTimeMetricCapture[] activityEventsTimeMetric;
    private final ActivityEventToUiLoadingModelMapper mapper;
    private final Logger apmLogger;

    public UiLoadingMetricHandlerImpl(@NonNull ActivityEventToUiLoadingModelMapper activityEventToUiLoadingModelMapper, @NonNull Logger logger2) {
        EmptyTimeMetric emptyTimeMetric;
        Object[] objectArray = new EventTimeMetricCapture[11];
        UiLoadingMetricHandlerImpl uiLoadingMetricHandlerImpl = emptyTimeMetric2;
        uiLoadingMetricHandlerImpl.activityEventsTimeMetric = objectArray;
        uiLoadingMetricHandlerImpl.mapper = activityEventToUiLoadingModelMapper;
        uiLoadingMetricHandlerImpl.apmLogger = logger2;
        EmptyTimeMetric emptyTimeMetric2 = emptyTimeMetric;
        emptyTimeMetric = new EmptyTimeMetric();
        Arrays.fill(objectArray, emptyTimeMetric2);
    }

    private boolean isValidEventIndex(int n) {
        if (n >= 0 && n < this.activityEventsTimeMetric.length) {
            return this.hasEventNeverBeenReportedBefore(n);
        }
        return false;
    }

    private boolean hasEventBeenReportedAfterTimeNano(int n, long l) {
        return this.activityEventsTimeMetric[n].getNanoTime() > l;
    }

    private boolean hasEventNotBeenReportedOrBeenReportedAfterTimeNano(int n, long l) {
        return this.hasEventNeverBeenReportedBefore(n) || this.hasEventBeenReportedAfterTimeNano(n, l);
    }

    private boolean hasLastAutomaticUiLoadingEventNotBeenCollectedBeforeTimeNano(long l) {
        return this.hasEventNotBeenReportedOrBeenReportedAfterTimeNano(8, l) && this.hasEventNotBeenReportedOrBeenReportedAfterTimeNano(9, l);
    }

    @Override
    public void addActivityEvent(int n, @NonNull EventTimeMetricCapture eventTimeMetricCapture) {
        if (this.isValidEventIndex(n)) {
            this.activityEventsTimeMetric[n] = eventTimeMetricCapture;
        }
    }

    @Override
    public void onScreenLoadingEnded(EventTimeMetricCapture eventTimeMetricCapture) {
        int n = 10;
        if (!((UiLoadingMetricHandlerImpl)((Object)logger2)).hasEventNeverBeenReportedBefore(10)) {
            Logger logger2 = ((UiLoadingMetricHandlerImpl)((Object)logger2)).apmLogger;
            if (logger2 != null) {
                logger2.logSDKWarning("endScreenLoading has already been called for the current screen visit. Multiple calls to this API are not allowed during a single screen visit, only the first call will be considered.");
            }
        } else {
            Logger logger3;
            if (((UiLoadingMetricHandlerImpl)((Object)logger2)).hasLastAutomaticUiLoadingEventNotBeenCollectedBeforeTimeNano(eventTimeMetricCapture.getNanoTime()) && (logger3 = ((UiLoadingMetricHandlerImpl)((Object)logger2)).apmLogger) != null) {
                logger3.logSDKError("endScreenLoading was called too early in the Screen Loading cycle. Please make sure to call the API after the screen is done loading.");
            }
            ((UiLoadingMetricHandlerImpl)((Object)logger2)).activityEventsTimeMetric[n] = eventTimeMetricCapture;
        }
    }

    @Override
    @Nullable
    public UiLoadingModel getUiLoadingModel() {
        ActivityEventToUiLoadingModelMapper activityEventToUiLoadingModelMapper = ((UiLoadingMetricHandlerImpl)((Object)uiLoadingModel)).mapper;
        if (activityEventToUiLoadingModelMapper == null) {
            return null;
        }
        UiLoadingModel uiLoadingModel = activityEventToUiLoadingModelMapper.getUiLoadingModel(((UiLoadingMetricHandlerImpl)((Object)uiLoadingModel)).activityEventsTimeMetric);
        if (uiLoadingModel != null && uiLoadingModel.isValid()) {
            return uiLoadingModel;
        }
        return null;
    }

    @Override
    public boolean hasEventNeverBeenReportedBefore(int n) {
        return this.activityEventsTimeMetric[n] instanceof EmptyTimeMetric;
    }
}

