/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.apm.handler.uitrace.customuitraces;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.os.Looper;
import android.view.Choreographer;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.WorkerThread;
import com.instabug.apm.cache.handler.session.SessionMetaDataCacheHandler;
import com.instabug.apm.cache.handler.uitrace.UiTraceCacheHandler;
import com.instabug.apm.cache.model.UiTraceCacheModel;
import com.instabug.apm.configuration.APMConfigurationProvider;
import com.instabug.apm.di.ServiceLocator;
import com.instabug.apm.handler.uitrace.customuitraces.CustomUiTraceHandler;
import com.instabug.apm.logger.internal.Logger;
import com.instabug.apm.model.EventTimeMetricCapture;
import com.instabug.apm.uitrace.activitycallbacks.APMUiTraceActivityCallbacks;
import com.instabug.apm.uitrace.di.UiTracesServiceLocator;
import com.instabug.apm.uitrace.uihangs.APMChoreographer;
import com.instabug.apm.uitrace.uihangs.FrameDropsCalculator;
import com.instabug.apm.util.ClassModuleHelper;
import com.instabug.apm.util.device.APMDeviceStateProvider;
import com.instabug.apm.util.powermanagement.BatteryLevelChangeBroadcast;
import com.instabug.apm.util.powermanagement.PowerManagementCallback;
import com.instabug.apm.util.powermanagement.PowerSaveModeBroadcast;
import com.instabug.apm.util.view.InstabugViews;
import com.instabug.library.BuildFieldsProvider;
import com.instabug.library.diagnostics.IBGDiagnostics;
import com.instabug.library.model.common.Session;
import com.instabug.library.tracking.InstabugInternalTrackingDelegate;
import com.instabug.library.util.TimeUtils;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@RequiresApi(api=16)
public class CustomUiTraceHandlerImpl
implements CustomUiTraceHandler,
Choreographer.FrameCallback,
PowerManagementCallback,
APMUiTraceActivityCallbacks {
    private final APMDeviceStateProvider deviceStateProvider;
    private final APMConfigurationProvider apmConfigurationProvider;
    private final Logger apmLogger;
    @Nullable
    private final APMChoreographer apmChoreographer;
    private final Executor customUiTraceThreadExecutor;
    @Nullable
    private UiTraceCacheModel cacheModel;
    UiTraceCacheHandler cacheHandler;
    @Nullable
    SessionMetaDataCacheHandler sessionMetaDataCacheHandler;
    @NonNull
    private final BatteryLevelChangeBroadcast batteryBroadcastReceiver;
    @NonNull
    private final PowerSaveModeBroadcast powerSaveModeBroadcast;
    private float uiTraceLargeDropThreshold;
    private float uiTraceSmallDropThreshold;
    private final FrameDropsCalculator frameDropsCalculator;

    public CustomUiTraceHandlerImpl(@NonNull BatteryLevelChangeBroadcast batteryLevelChangeBroadcast, @NonNull PowerSaveModeBroadcast powerSaveModeBroadcast, APMDeviceStateProvider aPMDeviceStateProvider, APMConfigurationProvider aPMConfigurationProvider, Logger logger2, @NonNull FrameDropsCalculator frameDropsCalculator) {
        CustomUiTraceHandlerImpl customUiTraceHandlerImpl = this;
        CustomUiTraceHandlerImpl customUiTraceHandlerImpl2 = this;
        this.uiTraceLargeDropThreshold = Float.MAX_VALUE;
        this.uiTraceSmallDropThreshold = Float.MAX_VALUE;
        this.deviceStateProvider = aPMDeviceStateProvider;
        this.apmConfigurationProvider = aPMConfigurationProvider;
        this.apmLogger = logger2;
        this.batteryBroadcastReceiver = batteryLevelChangeBroadcast;
        customUiTraceHandlerImpl2.powerSaveModeBroadcast = powerSaveModeBroadcast;
        customUiTraceHandlerImpl2.apmChoreographer = UiTracesServiceLocator.INSTANCE.getApmChoreographer();
        customUiTraceHandlerImpl.frameDropsCalculator = frameDropsCalculator;
        customUiTraceHandlerImpl.cacheHandler = ServiceLocator.getUiTraceCacheHandler();
        customUiTraceHandlerImpl.sessionMetaDataCacheHandler = ServiceLocator.getSessionMetaDataCacheHandler();
        customUiTraceHandlerImpl.customUiTraceThreadExecutor = ServiceLocator.getSingleThreadExecutor("CustomUiTraceHandler");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @WorkerThread
    private void endUiTraceOnSameThread(Activity var1_1, @Nullable Looper var2_2) {
        block10: {
            block9: {
                var2_2 = this.apmLogger;
                var3_4 = new StringBuilder().append("Ui trace ");
                var4_5 = this.cacheModel;
                var4_5 = var4_5 != null ? var4_5.getName() : "";
                var2_2.logSDKProtected(var3_4.append((String)var4_5).append(" is ending in ").append(var1_1.getClass().getSimpleName()).toString());
                var2_2 = this.apmChoreographer;
                if (var2_2 != null) {
                    var2_2.removeCallback(this);
                }
                try {
                    this.unregisterPowerSaveModeListener();
                    this.unregisterBatteryLevelListener();
                    this.updateCacheModel((Activity)var1_1);
                    var1_1 = this.cacheModel;
                    if (var1_1 != null) break block9;
                }
                catch (Exception v0) {
                    break block10;
                }
                this.apmLogger.logSDKProtected("uiTraceModel is null, can't insert to DB");
                return;
            }
            if ((var1_1 = var1_1.getSessionId()) == null) ** GOTO lbl35
            {
                if (this.cacheHandler.insert(this.cacheModel) == -1L) ** GOTO lbl33
                var2_2 = this.sessionMetaDataCacheHandler;
                if (var2_2 == null) ** GOTO lbl30
            }
            {
                var2_2.addToUITracesTotalCount((String)var1_1, 1);
            }
            {
                var2_3 = this.cacheHandler.trimToLimit((String)var1_1, this.apmConfigurationProvider.getUiTraceLimitPerRequest());
                if (var2_3 <= 0) ** GOTO lbl30
            }
            {
                this.sessionMetaDataCacheHandler.addToUITracesDroppedCount((String)var1_1, var2_3);
lbl30:
                // 3 sources

                this.cacheHandler.clearPreviousUnEndedTraces((String)var1_1);
            }
            {
                block11: {
                    this.cacheHandler.trimToLimit(this.apmConfigurationProvider.getUiTraceStoreLimit());
lbl33:
                    // 2 sources

                    this.apmLogger.logSDKDebug("Custom UI Trace \"" + this.cacheModel.getName() + "\" has ended.\nTotal duration: " + this.getTotalDurationSeconds(this.cacheModel) + " seconds\nTotal hang duration: " + this.getTotalHangsDurationMillis(this.cacheModel) + " ms");
                    break block11;
lbl35:
                    // 1 sources

                    this.apmLogger.logSDKProtected("currentSession is null, can't insert to DB");
                }
                this.cacheModel = null;
                return;
            }
        }
        IBGDiagnostics.reportNonFatal((Throwable)v0, (String)"Unable to end ui trace");
    }

    private boolean isInstabugActivity(@NonNull Activity activity) {
        return InstabugViews.isInstabugActivity(activity);
    }

    private void createCacheModel(@NonNull String string, Activity activity, @NonNull Session session) {
        UiTraceCacheModel uiTraceCacheModel;
        UiTraceCacheModel uiTraceCacheModel2;
        CustomUiTraceHandlerImpl customUiTraceHandlerImpl = this;
        UiTraceCacheModel uiTraceCacheModel3 = uiTraceCacheModel2 = uiTraceCacheModel;
        uiTraceCacheModel3();
        this.cacheModel = uiTraceCacheModel3;
        uiTraceCacheModel.setSessionId(session.getId());
        customUiTraceHandlerImpl.cacheModel.setName(string);
        customUiTraceHandlerImpl.cacheModel.setStartTimestamp(TimeUnit.MILLISECONDS.toMicros(System.currentTimeMillis()));
        customUiTraceHandlerImpl.cacheModel.setStartTimeInMicros(TimeUtils.microTime());
        customUiTraceHandlerImpl.cacheModel.setBatteryLevel(this.deviceStateProvider.getBatteryLevel((Context)activity));
        customUiTraceHandlerImpl.cacheModel.setPowerSaveMode(this.deviceStateProvider.isPowerSaveModeEnabled((Context)activity));
        customUiTraceHandlerImpl.cacheModel.setOrientation(this.deviceStateProvider.getScreenOrientation(activity));
        customUiTraceHandlerImpl.cacheModel.setUserDefined(true);
        customUiTraceHandlerImpl.cacheModel.setId(System.currentTimeMillis());
    }

    private void updateCacheModel(Activity activity) {
        UiTraceCacheModel uiTraceCacheModel = this.cacheModel;
        if (uiTraceCacheModel != null) {
            uiTraceCacheModel.setDuration(TimeUtils.microTime() - this.cacheModel.getStartTimeInMicros());
            if (activity != null) {
                this.cacheModel.setContainerName(activity.getClass().getSimpleName());
                if (activity.getTitle() != null) {
                    this.cacheModel.setScreenTitle(activity.getTitle().toString());
                }
                this.cacheModel.setModuleName(ClassModuleHelper.getModuleName(activity.getClass()));
            }
            this.cacheModel.setRefreshRate(this.deviceStateProvider.getRefreshRate((Context)activity));
        }
    }

    private void registerBatteryLevelListener() {
        this.batteryBroadcastReceiver.register(this);
    }

    @SuppressLint(value={"NewApi"})
    private void registerPowerSaveModeListener() {
        if (BuildFieldsProvider.INSTANCE.provideBuildVersion() >= 21) {
            this.powerSaveModeBroadcast.register(this);
        }
    }

    private void unregisterBatteryLevelListener() {
        this.batteryBroadcastReceiver.unregister(this);
    }

    @SuppressLint(value={"NewApi"})
    private void unregisterPowerSaveModeListener() {
        if (BuildFieldsProvider.INSTANCE.provideBuildVersion() >= 21) {
            this.powerSaveModeBroadcast.unregister(this);
        }
    }

    @Override
    public void startUiTrace(@NonNull String string, Activity activity, @Nullable Looper looper) {
        this.customUiTraceThreadExecutor.execute(() -> {
            CustomUiTraceHandlerImpl customUiTraceHandlerImpl = this;
            customUiTraceHandlerImpl.uiTraceLargeDropThreshold = customUiTraceHandlerImpl.apmConfigurationProvider.getUiTraceLargeDropThreshold();
            customUiTraceHandlerImpl.uiTraceSmallDropThreshold = customUiTraceHandlerImpl.apmConfigurationProvider.getUiTraceSmallDropThreshold();
            if (customUiTraceHandlerImpl.cacheModel != null) {
                CustomUiTraceHandlerImpl customUiTraceHandlerImpl2 = this;
                customUiTraceHandlerImpl2.apmLogger.logSDKProtected("Existing Ui trace " + this.getCurrentUiTrace() + " need to be ended first");
                if (customUiTraceHandlerImpl2.getCurrentUiTrace() != null) {
                    this.apmLogger.logSDKWarning("Custom UI Trace \"$s1\" has started and \"$s2\" has been ended. Please make sure to end traces before starting a new one by following the instructions at this link: https://docs.instabug.com/reference#end-ui-trace".replace("$s1", string).replace("$s2", this.getCurrentUiTrace()));
                }
                this.endUiTraceOnSameThread(activity, looper);
            }
            if ((looper = ServiceLocator.getSessionHandler().getCurrentSession()) == null) {
                return;
            }
            CustomUiTraceHandlerImpl customUiTraceHandlerImpl3 = this;
            customUiTraceHandlerImpl3.createCacheModel(string, activity, (Session)looper);
            customUiTraceHandlerImpl3.registerBatteryLevelListener();
            customUiTraceHandlerImpl3.registerPowerSaveModeListener();
            if (customUiTraceHandlerImpl3.apmChoreographer != null) {
                CustomUiTraceHandlerImpl customUiTraceHandlerImpl4 = this;
                customUiTraceHandlerImpl4.frameDropsCalculator.reset();
                customUiTraceHandlerImpl4.apmChoreographer.addCallback(this);
            }
            this.apmLogger.logSDKDebug("Custom UI Trace  \"" + string + "\" has started.");
        });
    }

    @Override
    public void endUiTrace(Activity activity, @Nullable Looper looper) {
        this.customUiTraceThreadExecutor.execute(() -> this.endUiTraceOnSameThread(activity, looper));
    }

    @Override
    @Nullable
    public String getCurrentUiTrace() {
        UiTraceCacheModel uiTraceCacheModel = ((CustomUiTraceHandlerImpl)((Object)uiTraceCacheModel)).cacheModel;
        return uiTraceCacheModel != null ? uiTraceCacheModel.getName() : null;
    }

    @Override
    public void forceStop() {
        if (InstabugInternalTrackingDelegate.getInstance().getCurrentActivity() != null) {
            this.endUiTrace(InstabugInternalTrackingDelegate.getInstance().getCurrentActivity(), Looper.myLooper());
        }
    }

    @Override
    public void onActivityStarted(@NonNull Activity object, @NonNull EventTimeMetricCapture objectArray) {
        if (this.cacheModel != null && !this.isInstabugActivity((Activity)object)) {
            CustomUiTraceHandlerImpl customUiTraceHandlerImpl = this;
            object = this.getCurrentUiTrace();
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = object;
            customUiTraceHandlerImpl.apmLogger.logSDKProtected(String.format("New activity resumed while ui Trace %s is running, registering broadcast receivers\u2026", objectArray));
            customUiTraceHandlerImpl.customUiTraceThreadExecutor.execute(() -> {
                CustomUiTraceHandlerImpl customUiTraceHandlerImpl = this;
                customUiTraceHandlerImpl.registerPowerSaveModeListener();
                customUiTraceHandlerImpl.registerBatteryLevelListener();
            });
        }
    }

    @Override
    public void onActivityStopped(@NonNull Activity objectArray, boolean bl) {
        if (((CustomUiTraceHandlerImpl)((Object)string)).isInstabugActivity((Activity)objectArray)) {
            return;
        }
        if (((CustomUiTraceHandlerImpl)((Object)string)).cacheModel != null && bl) {
            CustomUiTraceHandlerImpl customUiTraceHandlerImpl = string;
            Object[] objectArray2 = objectArray;
            String string = ((CustomUiTraceHandlerImpl)((Object)string)).getCurrentUiTrace();
            Object[] objectArray3 = new Object[1];
            objectArray = objectArray3;
            objectArray3[0] = string;
            ((CustomUiTraceHandlerImpl)((Object)string)).apmLogger.logSDKProtected(String.format("App went background while ui Trace %s is running, ending the trace\u2026", objectArray));
            customUiTraceHandlerImpl.endUiTrace((Activity)objectArray2, Looper.myLooper());
        } else {
            ((CustomUiTraceHandlerImpl)((Object)string)).customUiTraceThreadExecutor.execute(() -> {
                CustomUiTraceHandlerImpl customUiTraceHandlerImpl = this;
                customUiTraceHandlerImpl.unregisterPowerSaveModeListener();
                customUiTraceHandlerImpl.unregisterBatteryLevelListener();
            });
        }
    }

    public void doFrame(long l) {
        Long l2 = this.frameDropsCalculator.calculateFrameDuration(l, this.uiTraceSmallDropThreshold);
        if (l2 != null) {
            this.onFrameDrop(l2);
        }
    }

    public void onFrameDrop(long l) {
        UiTraceCacheModel uiTraceCacheModel = this.cacheModel;
        if (uiTraceCacheModel != null) {
            UiTraceCacheModel uiTraceCacheModel2 = uiTraceCacheModel;
            uiTraceCacheModel2.setSmallDropsDuration(uiTraceCacheModel2.getSmallDropsDuration() + l);
            if ((float)l > this.uiTraceLargeDropThreshold) {
                UiTraceCacheModel uiTraceCacheModel3 = this.cacheModel;
                uiTraceCacheModel3.setLargeDropsDuration(uiTraceCacheModel3.getLargeDropsDuration() + l);
            }
        }
    }

    @Override
    public void onBatteryLevelChanged(int n) {
        UiTraceCacheModel uiTraceCacheModel = this.cacheModel;
        if (uiTraceCacheModel != null) {
            if (uiTraceCacheModel.getBatteryLevel() == -1) {
                this.cacheModel.setBatteryLevel(n);
            } else {
                UiTraceCacheModel uiTraceCacheModel2 = this.cacheModel;
                uiTraceCacheModel2.setBatteryLevel(Math.min(n, uiTraceCacheModel2.getBatteryLevel()));
            }
        }
    }

    @Override
    public void onPowerSaveModeChanged(boolean bl) {
        if (bl && (this = ((CustomUiTraceHandlerImpl)this).cacheModel) != null) {
            ((UiTraceCacheModel)this).setPowerSaveMode(bl);
        }
    }

    public long getTotalDurationSeconds(@NonNull UiTraceCacheModel uiTraceCacheModel) {
        return TimeUnit.MICROSECONDS.toSeconds(uiTraceCacheModel.getDuration());
    }

    public long getTotalHangsDurationMillis(@NonNull UiTraceCacheModel uiTraceCacheModel) {
        return TimeUnit.MICROSECONDS.toMillis(uiTraceCacheModel.getSmallDropsDuration() + uiTraceCacheModel.getLargeDropsDuration());
    }
}

