/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.apm.handler.session;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.instabug.apm.di.ServiceLocator;
import com.instabug.apm.handler.session.APMSessionObserver;
import com.instabug.library.model.common.Session;
import java.util.Iterator;

public abstract class SessionObserverHandler {
    public static void register(@NonNull APMSessionObserver aPMSessionObserver) {
        ServiceLocator.getSessionObserverRegistry().register(aPMSessionObserver);
    }

    public static void unregister(@NonNull APMSessionObserver aPMSessionObserver) {
        ServiceLocator.getSessionObserverRegistry().unregister(aPMSessionObserver);
    }

    static void notifyNewSessionStarted(@NonNull Session session, @Nullable Session session2) {
        Iterator<APMSessionObserver> iterator = ServiceLocator.getSessionObserverRegistry().getObservers().iterator();
        while (iterator.hasNext()) {
            iterator.next().onNewSessionStarted(session, session2);
        }
    }
}

