/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.apm.handler.session;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import com.instabug.apm.APMPlugin;
import com.instabug.apm.cache.handler.session.SessionCacheHandler;
import com.instabug.apm.cache.model.SessionCacheModel;
import com.instabug.apm.configuration.APMConfigurationProvider;
import com.instabug.apm.configuration.APMStateProvider;
import com.instabug.apm.di.ServiceLocator;
import com.instabug.apm.handler.experiment.ExperimentHandler;
import com.instabug.apm.handler.session.SessionHandler;
import com.instabug.apm.handler.session.SessionObserverHandler;
import com.instabug.apm.logger.internal.Logger;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.internal.utils.stability.execution.Executable;
import com.instabug.library.internal.utils.stability.handler.exception.ExceptionHandler;
import com.instabug.library.model.common.Session;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class SessionHandlerImpl
implements SessionHandler {
    @NonNull
    private final APMConfigurationProvider configurationProvider;
    @NonNull
    private final APMStateProvider stateProvider;
    @NonNull
    private final SessionCacheHandler cacheHandler;
    @NonNull
    private final ExceptionHandler exceptionHandler;
    @NonNull
    private final Logger logger;
    @Nullable
    private Runnable sessionStartRunnable;
    @Nullable
    private volatile SessionCacheModel currentSession;
    @NonNull
    private final Executor sessionExecutor;

    public SessionHandlerImpl(@NonNull APMConfigurationProvider aPMConfigurationProvider, @NonNull APMStateProvider aPMStateProvider, @NonNull SessionCacheHandler sessionCacheHandler, @NonNull ExceptionHandler exceptionHandler, @NonNull Logger logger2) {
        SessionHandlerImpl sessionHandlerImpl = this;
        this.configurationProvider = aPMConfigurationProvider;
        this.stateProvider = aPMStateProvider;
        this.cacheHandler = sessionCacheHandler;
        this.exceptionHandler = exceptionHandler;
        sessionHandlerImpl.logger = logger2;
        sessionHandlerImpl.sessionExecutor = ServiceLocator.getSyncThreadExecutor();
    }

    private void storeExperimentsAsync(SessionCacheModel sessionCacheModel) {
        if (sessionCacheModel.getVersion().equals("V3")) {
            return;
        }
        ExperimentHandler experimentHandler = ServiceLocator.getExperimentHandler();
        if (experimentHandler != null) {
            experimentHandler.storeExperimentsAsync(sessionCacheModel.getId());
        }
    }

    private synchronized void setCurrentSession(@Nullable SessionCacheModel sessionCacheModel) {
        this.currentSession = sessionCacheModel;
    }

    @NonNull
    private Runnable getSessionStartRunnable(final @NonNull Session session) {
        return new Runnable(){

            @Override
            public void run() {
                SessionHandlerImpl.this.exceptionHandler.execute(new Executable(){

                    public void execute() {
                        SessionHandlerImpl.this.sessionExecutor.execute(new Runnable(){

                            /*
                             * Enabled aggressive block sorting
                             * Enabled unnecessary exception pruning
                             * Enabled aggressive exception aggregation
                             */
                            @Override
                            public void run() {
                                Object object = APMPlugin.lock;
                                synchronized (object) {
                                    Throwable throwable2;
                                    block6: {
                                        block5: {
                                            block4: {
                                                SessionCacheModel sessionCacheModel;
                                                try {
                                                    if (SessionHandlerImpl.this.getCurrentSession() != null) break block4;
                                                    1 v0 = this;
                                                    SessionHandlerImpl sessionHandlerImpl = v0.SessionHandlerImpl.this;
                                                    sessionHandlerImpl.setCurrentSession(sessionHandlerImpl.cacheHandler.insert(session));
                                                    sessionCacheModel = v0.SessionHandlerImpl.this.getCurrentSession();
                                                    if (sessionCacheModel == null) break block5;
                                                }
                                                catch (Throwable throwable2) {
                                                    break block6;
                                                }
                                                1 v3 = this;
                                                v3.SessionHandlerImpl.this.resetDroppedSessionsCountIfPossible(sessionCacheModel);
                                                v3.SessionHandlerImpl.this.trimSessionsIfPossible();
                                                SessionObserverHandler.notifyNewSessionStarted(sessionCacheModel, v3.SessionHandlerImpl.this.cacheHandler.getPreviousSession(sessionCacheModel.getId()));
                                                break block5;
                                            }
                                            SessionHandlerImpl.this.logger.logSDKProtected("Attempted to start session while another session is already running. Skipping..");
                                        }
                                        return;
                                    }
                                    throw throwable2;
                                }
                            }
                        });
                    }
                });
            }
        };
    }

    static /* synthetic */ Runnable access$002(SessionHandlerImpl sessionHandlerImpl, Runnable runnable) {
        sessionHandlerImpl.sessionStartRunnable = runnable;
        return runnable;
    }

    @Override
    public void startSession(@NonNull Session session) {
        if (this.configurationProvider.isAPMEnabled() && this.getCurrentSession() == null && this.sessionStartRunnable == null) {
            SessionHandlerImpl sessionHandlerImpl = this;
            sessionHandlerImpl.sessionStartRunnable = sessionHandlerImpl.getSessionStartRunnable(session);
            if (sessionHandlerImpl.configurationProvider.isAPMEnabled()) {
                this.sessionStartRunnable.run();
            }
        }
    }

    @Override
    public void endSession(final int n) {
        this.exceptionHandler.execute(new Executable(){

            public void execute() {
                1 v0 = this;
                SessionHandlerImpl.access$002(v0.SessionHandlerImpl.this, null);
                Object object = v0.SessionHandlerImpl.this.getCurrentSession();
                if (object != null) {
                    SessionCacheModel sessionCacheModel;
                    1 v1 = this;
                    long l = ((SessionCacheModel)object).getStartNanoTime();
                    l = TimeUnit.NANOSECONDS.toMicros(System.nanoTime() - l);
                    final SessionCacheModel sessionCacheModel2 = sessionCacheModel;
                    SessionCacheModel sessionCacheModel3 = object;
                    object = sessionCacheModel3.getId();
                    String string = sessionCacheModel3.getCoreId();
                    String string2 = sessionCacheModel3.getOs();
                    String string3 = sessionCacheModel3.getAppVersion();
                    String string4 = sessionCacheModel3.getUuid();
                    long l2 = sessionCacheModel3.getStartTimestampMicros();
                    long l3 = sessionCacheModel3.getStartNanoTime();
                    String string5 = sessionCacheModel3.getVersion();
                    int n2 = n;
                    sessionCacheModel = new SessionCacheModel((String)object, string, string2, string3, string4, l, l2, l3, string5, n2, -1);
                    v1.SessionHandlerImpl.this.setCurrentSession(null);
                    v1.SessionHandlerImpl.this.sessionExecutor.execute(new Runnable(){

                        @Override
                        public void run() {
                            SessionHandlerImpl.this.cacheHandler.update(sessionCacheModel2);
                        }
                    });
                    v1.SessionHandlerImpl.this.storeExperimentsAsync(sessionCacheModel2);
                    v1.SessionHandlerImpl.this.logger.logSDKDebug("Ending session #" + sessionCacheModel2.getId());
                } else {
                    SessionHandlerImpl.this.logger.logSDKProtected("Attempted to end session without calling start");
                }
                SessionHandlerImpl.this.configurationProvider.setShouldDependOnV3Session(InstabugCore.isV3SessionEnabled());
            }
        });
    }

    @Override
    @Nullable
    public synchronized SessionCacheModel getCurrentSession() {
        return this.currentSession;
    }

    @Override
    @Nullable
    public String getCurrentCoreSessionId() {
        SessionCacheModel sessionCacheModel = ((SessionHandlerImpl)((Object)sessionCacheModel)).currentSession;
        if (sessionCacheModel != null) {
            return sessionCacheModel.getCoreId();
        }
        return null;
    }

    @Override
    @NonNull
    public List<SessionCacheModel> getReadyToBeSentSessions() {
        return this.cacheHandler.getReadyToBeSentSessions();
    }

    @Override
    @Nullable
    public SessionCacheModel getNextSession(String string) {
        return this.cacheHandler.getNextSession(string);
    }

    @Override
    public void changeSessionSyncStatus(@NonNull List<String> list, int n) {
        this.cacheHandler.changeSessionSyncStatus(list, n);
    }

    @Override
    public void deleteSessionsBySyncStatus(int n) {
        this.cacheHandler.deleteSessionsBySyncStatus(n);
    }

    @Override
    public void updateSessionEndReason(final @NonNull String string, final long l, final int n) {
        ServiceLocator.getIOExecutor().execute(new Runnable(){

            @Override
            public void run() {
                2 v0 = string2;
                String string2 = v0.string;
                long l2 = v0.l;
                int n2 = v0.n;
                string2.SessionHandlerImpl.this.cacheHandler.updateEndReason(string2, l2, n2);
            }
        });
    }

    @Override
    @NonNull
    public List<SessionCacheModel> getSessionsByCoreIds(@NonNull List<String> list) {
        return this.cacheHandler.queryByCoreIds(list);
    }

    @Override
    public void deleteSessionsByCoreIds(@NonNull List<String> list) {
        this.cacheHandler.deleteByCoreIds(list);
    }

    @Override
    @Nullable
    public String getPreviousSessionId(@NonNull String string) {
        if (string != null && (this = ((SessionHandlerImpl)this).cacheHandler.getPreviousSession(string)) != null) {
            return ((SessionCacheModel)this).getId();
        }
        return null;
    }

    @WorkerThread
    public void resetDroppedSessionsCountIfPossible(@NonNull SessionCacheModel sessionCacheModel) {
        if ("1".equals(sessionCacheModel.getId()) && (this = ((SessionHandlerImpl)this).stateProvider) != null) {
            this.resetStoreLimitDroppedSessionCount();
        }
    }

    @WorkerThread
    public void trimSessionsIfPossible() {
        APMConfigurationProvider aPMConfigurationProvider;
        if (this.stateProvider != null && (aPMConfigurationProvider = this.configurationProvider) != null && aPMConfigurationProvider.isSessionStoreLimitEnabled()) {
            SessionHandlerImpl sessionHandlerImpl = this;
            int n = sessionHandlerImpl.configurationProvider.getSessionStoreLimit();
            if ((n = sessionHandlerImpl.cacheHandler.trimSessions(n)) > 0) {
                this.stateProvider.incrementStoreLimitDroppedSessionsCount(n);
            }
        }
    }
}

