/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.apm.fragment;

import androidx.annotation.VisibleForTesting;
import com.instabug.apm.configuration.APMConfigurationProvider;
import com.instabug.apm.di.Provider;
import com.instabug.apm.fragment.FragmentEventDispatcher;
import com.instabug.apm.fragment.FragmentLifecycleEventListener;
import com.instabug.apm.fragment.FragmentSpansHelper;
import com.instabug.apm.handler.fragment.FragmentSpansHandler;
import com.instabug.apm.logger.internal.Logger;
import com.instabug.library.diagnostics.IBGDiagnostics;
import java.util.concurrent.Executor;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\b\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u000e\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0006\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b\r\u0010\u000eJ\u000f\u0010\u0010\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u000f\u0010\u0012\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0011J\u000f\u0010\u0013\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0011J\u000f\u0010\u0014\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0011J\u0017\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u0015H\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u000f\u0010\u001a\u001a\u00020\u0019H\u0007\u00a2\u0006\u0004\b\u001a\u0010\u001bR\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u001cR\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u001dR\u001c\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\b\u0010\u001eR\u0014\u0010\n\u001a\u00020\t8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\n\u0010\u001fR\u0014\u0010\f\u001a\u00020\u000b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\f\u0010 \u00a8\u0006!"}, d2={"Lcom/instabug/apm/fragment/FragmentSpansHelperImpl;", "Lcom/instabug/apm/fragment/FragmentSpansHelper;", "Lcom/instabug/apm/configuration/APMConfigurationProvider;", "apmConfigurationProvider", "Lcom/instabug/apm/fragment/FragmentLifecycleEventListener;", "fragmentsLifecycleListener", "Lcom/instabug/apm/di/Provider;", "Lcom/instabug/apm/handler/fragment/FragmentSpansHandler;", "fragmentSpansHandlerProvider", "Ljava/util/concurrent/Executor;", "executor", "Lcom/instabug/apm/logger/internal/Logger;", "logger", "<init>", "(Lcom/instabug/apm/configuration/APMConfigurationProvider;Lcom/instabug/apm/fragment/FragmentLifecycleEventListener;Lcom/instabug/apm/di/Provider;Ljava/util/concurrent/Executor;Lcom/instabug/apm/logger/internal/Logger;)V", "", "stopSynchronous", "()V", "startFragmentsLifecycleCapturing", "stopFragmentsLifecycleCapturing", "onFeatureDisabled", "", "sessionId", "onNewSessionStarted", "(Ljava/lang/String;)V", "", "canStartFragmentsCapturing", "()Z", "Lcom/instabug/apm/configuration/APMConfigurationProvider;", "Lcom/instabug/apm/fragment/FragmentLifecycleEventListener;", "Lcom/instabug/apm/di/Provider;", "Ljava/util/concurrent/Executor;", "Lcom/instabug/apm/logger/internal/Logger;", "instabug-apm_defaultUiRelease"}, xi=48)
@SourceDebugExtension(value={"SMAP\nFragmentSpansHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FragmentSpansHelper.kt\ncom/instabug/apm/fragment/FragmentSpansHelperImpl\n*L\n1#1,69:1\n62#1,7:70\n62#1,7:77\n62#1,7:84\n62#1,7:91\n*S KotlinDebug\n*F\n+ 1 FragmentSpansHelper.kt\ncom/instabug/apm/fragment/FragmentSpansHelperImpl\n*L\n27#1:70,7\n35#1:77,7\n46#1:84,7\n53#1:91,7\n*E\n"})
public final class FragmentSpansHelperImpl
implements FragmentSpansHelper {
    @NotNull
    private final APMConfigurationProvider apmConfigurationProvider;
    @NotNull
    private final FragmentLifecycleEventListener fragmentsLifecycleListener;
    @NotNull
    private final Provider<FragmentSpansHandler> fragmentSpansHandlerProvider;
    @NotNull
    private final Executor executor;
    @NotNull
    private final Logger logger;

    public FragmentSpansHelperImpl(@NotNull APMConfigurationProvider aPMConfigurationProvider, @NotNull FragmentLifecycleEventListener fragmentLifecycleEventListener, @NotNull Provider<FragmentSpansHandler> provider, @NotNull Executor executor2, @NotNull Logger logger2) {
        Intrinsics.checkNotNullParameter((Object)aPMConfigurationProvider, (String)"apmConfigurationProvider");
        Intrinsics.checkNotNullParameter((Object)fragmentLifecycleEventListener, (String)"fragmentsLifecycleListener");
        Intrinsics.checkNotNullParameter(provider, (String)"fragmentSpansHandlerProvider");
        Intrinsics.checkNotNullParameter((Object)executor2, (String)"executor");
        Intrinsics.checkNotNullParameter((Object)logger2, (String)"logger");
        this.apmConfigurationProvider = aPMConfigurationProvider;
        this.fragmentsLifecycleListener = fragmentLifecycleEventListener;
        this.fragmentSpansHandlerProvider = provider;
        this.executor = executor2;
        this.logger = logger2;
    }

    private final void stopSynchronous() {
        this.fragmentsLifecycleListener.cleanup();
        FragmentEventDispatcher.Companion.removeListener(this.fragmentsLifecycleListener);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final void startFragmentsLifecycleCapturing$lambda$1(FragmentSpansHelperImpl object) {
        Object object2;
        String string;
        block6: {
            Throwable throwable2;
            block5: {
                FragmentSpansHelperImpl fragmentSpansHelperImpl = object;
                Intrinsics.checkNotNullParameter((Object)fragmentSpansHelperImpl, (String)"this$0");
                string = "starting fragments capturing feature";
                try {
                    // empty try
                }
                catch (Throwable throwable2) {
                    break block5;
                }
                if (fragmentSpansHelperImpl.canStartFragmentsCapturing()) {
                    FragmentEventDispatcher.Companion.addListener(((FragmentSpansHelperImpl)object).fragmentsLifecycleListener);
                }
                object2 = Result.constructor-impl((Object)Unit.INSTANCE);
                break block6;
            }
            object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable2));
        }
        object2 = Result.exceptionOrNull-impl((Object)object2);
        if (object2 != null) {
            FragmentSpansHelperImpl fragmentSpansHelperImpl = object;
            object = "Error occurred while " + string + ": " + ((Throwable)object2).getMessage();
            IBGDiagnostics.reportNonFatal((Throwable)object2, (String)object);
            fragmentSpansHelperImpl.logger.logSDKProtected((String)object);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final void stopFragmentsLifecycleCapturing$lambda$3(FragmentSpansHelperImpl object) {
        Object object2;
        String string;
        block4: {
            Object object3 = object;
            Intrinsics.checkNotNullParameter((Object)object3, (String)"this$0");
            string = "stopping fragments capturing feature";
            try {
                // empty try
            }
            catch (Throwable throwable) {
                object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                break block4;
            }
            {
                super.stopSynchronous();
                object2 = Result.constructor-impl((Object)Unit.INSTANCE);
            }
        }
        object2 = Result.exceptionOrNull-impl((Object)object2);
        if (object2 != null) {
            Object object4 = object;
            object = "Error occurred while " + string + ": " + ((Throwable)object2).getMessage();
            IBGDiagnostics.reportNonFatal((Throwable)object2, (String)object);
            ((FragmentSpansHelperImpl)object4).logger.logSDKProtected((String)object);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final void onFeatureDisabled$lambda$5(FragmentSpansHelperImpl object) {
        Object object2;
        String string;
        block7: {
            Throwable throwable2;
            block5: {
                block6: {
                    FragmentSpansHelperImpl fragmentSpansHelperImpl = object;
                    Intrinsics.checkNotNullParameter((Object)fragmentSpansHelperImpl, (String)"this$0");
                    string = "handling fragments capturing feature feature disabled";
                    try {
                        // empty try
                    }
                    catch (Throwable throwable2) {
                        break block5;
                    }
                    {
                        fragmentSpansHelperImpl.stopSynchronous();
                        object2 = fragmentSpansHelperImpl.fragmentSpansHandlerProvider.invoke();
                        if (object2 == null) break block6;
                    }
                    object2.clearCache();
                }
                object2 = Result.constructor-impl((Object)Unit.INSTANCE);
                break block7;
            }
            object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable2));
        }
        object2 = Result.exceptionOrNull-impl((Object)object2);
        if (object2 != null) {
            FragmentSpansHelperImpl fragmentSpansHelperImpl = object;
            object = "Error occurred while " + string + ": " + ((Throwable)object2).getMessage();
            IBGDiagnostics.reportNonFatal((Throwable)object2, (String)object);
            fragmentSpansHelperImpl.logger.logSDKProtected((String)object);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final void onNewSessionStarted$lambda$7(FragmentSpansHelperImpl object, String object2) {
        String string;
        block7: {
            Throwable throwable2;
            block5: {
                block6: {
                    FragmentSpansHandler fragmentSpansHandler;
                    Intrinsics.checkNotNullParameter((Object)object, (String)"this$0");
                    Intrinsics.checkNotNullParameter((Object)object2, (String)"$sessionId");
                    string = "handling fragment capturing on new session started";
                    try {
                        // empty try
                    }
                    catch (Throwable throwable2) {
                        break block5;
                    }
                    {
                        if (!((FragmentSpansHelperImpl)object).canStartFragmentsCapturing() || (fragmentSpansHandler = ((FragmentSpansHelperImpl)object).fragmentSpansHandlerProvider.invoke()) == null) break block6;
                    }
                    fragmentSpansHandler.onNewSession((String)object2);
                }
                object2 = Result.constructor-impl((Object)Unit.INSTANCE);
                break block7;
            }
            object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable2));
        }
        object2 = Result.exceptionOrNull-impl((Object)object2);
        if (object2 != null) {
            FragmentSpansHelperImpl fragmentSpansHelperImpl = object;
            object = "Error occurred while " + string + ": " + ((Throwable)object2).getMessage();
            IBGDiagnostics.reportNonFatal((Throwable)object2, (String)object);
            fragmentSpansHelperImpl.logger.logSDKProtected((String)object);
        }
    }

    @Override
    public void startFragmentsLifecycleCapturing() {
        this.executor.execute(() -> FragmentSpansHelperImpl.startFragmentsLifecycleCapturing$lambda$1(this));
    }

    @Override
    public void stopFragmentsLifecycleCapturing() {
        this.executor.execute(() -> FragmentSpansHelperImpl.stopFragmentsLifecycleCapturing$lambda$3(this));
    }

    @Override
    public void onFeatureDisabled() {
        this.executor.execute(() -> FragmentSpansHelperImpl.onFeatureDisabled$lambda$5(this));
    }

    @Override
    public void onNewSessionStarted(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"sessionId");
        this.executor.execute(() -> FragmentSpansHelperImpl.onNewSessionStarted$lambda$7(this, string));
    }

    @VisibleForTesting
    public final boolean canStartFragmentsCapturing() {
        return this.apmConfigurationProvider.isAPMEnabled() && this.apmConfigurationProvider.isFragmentSpansEnabled();
    }
}

