/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.apm.configuration;

import android.annotation.SuppressLint;
import android.content.SharedPreferences;
import androidx.annotation.Nullable;
import com.instabug.apm.configuration.APMConfigurationProvider;
import com.instabug.apm.configuration.APMPerSessionConfigurationProvider;
import com.instabug.apm.configuration.APMStateProvider;
import com.instabug.apm.di.ServiceLocator;
import com.instabug.library.Feature;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.networkinterception.config.IBGNetworkInterceptionConfigurationProvider;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.util.LimitConstraintApplier;

public class APMConfigurationProviderImpl
implements APMConfigurationProvider,
APMStateProvider {
    @Nullable
    private SharedPreferences sharedPreferences;
    @Nullable
    private SharedPreferences.Editor editor;
    private APMPerSessionConfigurationProvider apmPerSessionConfigurationProvider;
    private LimitConstraintApplier limitConstraintApplier;
    @Nullable
    private Boolean isUiLoadingMetricFeatureEnabled;
    @Nullable
    private Boolean isUiHangsFeatureEnabled;
    @Nullable
    private Boolean isAPMFeatureAvailable;
    @Nullable
    private volatile Boolean isNetworkFeatureEnabled;
    private final IBGNetworkInterceptionConfigurationProvider coreNetworkInterceptionConfigurationProvider;

    @SuppressLint(value={"CommitPrefEdits"})
    public APMConfigurationProviderImpl(LimitConstraintApplier limitConstraintApplier, IBGNetworkInterceptionConfigurationProvider iBGNetworkInterceptionConfigurationProvider) {
        APMConfigurationProviderImpl aPMConfigurationProviderImpl = this;
        aPMConfigurationProviderImpl.sharedPreferences = ServiceLocator.getSharedPreferences();
        aPMConfigurationProviderImpl.apmPerSessionConfigurationProvider = ServiceLocator.getApmPerSessionConfigurationProvider();
        aPMConfigurationProviderImpl.isUiLoadingMetricFeatureEnabled = null;
        aPMConfigurationProviderImpl.isUiHangsFeatureEnabled = null;
        aPMConfigurationProviderImpl.isAPMFeatureAvailable = null;
        aPMConfigurationProviderImpl.isNetworkFeatureEnabled = null;
        SharedPreferences sharedPreferences = aPMConfigurationProviderImpl.sharedPreferences;
        if (sharedPreferences != null) {
            this.editor = sharedPreferences.edit();
        }
        APMConfigurationProviderImpl aPMConfigurationProviderImpl2 = this;
        aPMConfigurationProviderImpl2.limitConstraintApplier = limitConstraintApplier;
        aPMConfigurationProviderImpl2.coreNetworkInterceptionConfigurationProvider = iBGNetworkInterceptionConfigurationProvider;
    }

    private long getColdAppLaunchesStoreLimit() {
        APMConfigurationProviderImpl aPMConfigurationProviderImpl = aPMConfigurationProviderImpl.sharedPreferences;
        if (aPMConfigurationProviderImpl != null) {
            return aPMConfigurationProviderImpl.getLong("COLD_LAUNCHES_STORE_LIMIT", 1000L);
        }
        return 1000L;
    }

    private long getHotAppLaunchesStoreLimit() {
        APMConfigurationProviderImpl aPMConfigurationProviderImpl = aPMConfigurationProviderImpl.sharedPreferences;
        if (aPMConfigurationProviderImpl != null) {
            return aPMConfigurationProviderImpl.getLong("HOT_LAUNCHES_STORE_LIMIT", 1000L);
        }
        return 1000L;
    }

    private long getColdAppLaunchesLimitPerRequest() {
        APMConfigurationProviderImpl aPMConfigurationProviderImpl = aPMConfigurationProviderImpl.sharedPreferences;
        if (aPMConfigurationProviderImpl != null) {
            return aPMConfigurationProviderImpl.getLong("COLD_LAUNCHES_PER_REQUEST_LIMIT", 200L);
        }
        return 200L;
    }

    private long getHotAppLaunchesLimitPerRequest() {
        APMConfigurationProviderImpl aPMConfigurationProviderImpl = aPMConfigurationProviderImpl.sharedPreferences;
        if (aPMConfigurationProviderImpl != null) {
            return aPMConfigurationProviderImpl.getLong("HOT_LAUNCHES_PER_REQUEST_LIMIT", 200L);
        }
        return 200L;
    }

    private boolean isColdAppLaunchFlagsEnabled() {
        return this.isColdAppLaunchesFeatureEnabled() && this.isColdAppLaunchSDKEnabled();
    }

    private boolean isHotAppLaunchFlagsEnabled() {
        return this.isHotAppLaunchesFeatureEnabled() && this.isHotAppLaunchSDKEnabled();
    }

    private int getCorrespondingAPMLogLevel() {
        int n = SettingsManager.getInstance().getLogLevel();
        if (n != 0) {
            if (n != 2) {
                if (n != 3) {
                    return 2;
                }
                return 5;
            }
            return 4;
        }
        return 0;
    }

    private long getWarmAppLaunchRequestLimit() {
        long l = 200L;
        APMConfigurationProviderImpl aPMConfigurationProviderImpl = aPMConfigurationProviderImpl.sharedPreferences;
        if (aPMConfigurationProviderImpl != null) {
            return aPMConfigurationProviderImpl.getLong("WARM_APP_LAUNCHES_PER_REQUEST_LIMIT", l);
        }
        return l;
    }

    private long getWarmAppLaunchStoreLimit() {
        long l = 1000L;
        APMConfigurationProviderImpl aPMConfigurationProviderImpl = aPMConfigurationProviderImpl.sharedPreferences;
        if (aPMConfigurationProviderImpl != null) {
            return aPMConfigurationProviderImpl.getLong("WARM_APP_LAUNCHES_STORE_LIMIT", l);
        }
        return l;
    }

    private boolean isWarmAppLaunchFlagsEnabled() {
        return this.isWarmAppLaunchFeatureEnabled() && this.isWarmAppLaunchSdkEnabled();
    }

    private long getLastApmSessionsRequestStartedAt() {
        APMConfigurationProviderImpl aPMConfigurationProviderImpl = aPMConfigurationProviderImpl.sharedPreferences;
        return aPMConfigurationProviderImpl == null ? 0L : aPMConfigurationProviderImpl.getLong("last_apm_sessions_request_started_at", 0L);
    }

    private long getApmSessionsLimitedUntil() {
        APMConfigurationProviderImpl aPMConfigurationProviderImpl = aPMConfigurationProviderImpl.sharedPreferences;
        return aPMConfigurationProviderImpl == null ? 0L : aPMConfigurationProviderImpl.getLong("apm_sessions_rate_limited_until", 0L);
    }

    @Override
    public void setAPMFeatureAvailability(boolean bl) {
        if (this.editor != null) {
            this.isAPMFeatureAvailable = bl;
            this.editor.putBoolean("IS_APM_FEATURE_AVAILABLE", bl).apply();
        }
    }

    @Override
    public boolean isAPMFeatureAvailable() {
        SharedPreferences sharedPreferences;
        if (((APMConfigurationProviderImpl)this).isAPMFeatureAvailable == null && (sharedPreferences = ((APMConfigurationProviderImpl)this).sharedPreferences) != null) {
            ((APMConfigurationProviderImpl)this).isAPMFeatureAvailable = sharedPreferences.getBoolean("IS_APM_FEATURE_AVAILABLE", false);
        }
        return (this = ((APMConfigurationProviderImpl)this).isAPMFeatureAvailable) != null ? (Boolean)this : false;
    }

    @Override
    public void setAPMSdkEnabled(boolean bl) {
        APMPerSessionConfigurationProvider aPMPerSessionConfigurationProvider = ((APMConfigurationProviderImpl)((Object)aPMPerSessionConfigurationProvider)).apmPerSessionConfigurationProvider;
        if (aPMPerSessionConfigurationProvider != null) {
            aPMPerSessionConfigurationProvider.putConfiguration("IS_APM_SDK_ENABLED", bl);
        }
    }

    @Override
    public boolean isAPMSdkEnabled() {
        APMPerSessionConfigurationProvider aPMPerSessionConfigurationProvider = ((APMConfigurationProviderImpl)((Object)aPMPerSessionConfigurationProvider)).apmPerSessionConfigurationProvider;
        if (aPMPerSessionConfigurationProvider != null) {
            return (Boolean)aPMPerSessionConfigurationProvider.getConfiguration("IS_APM_SDK_ENABLED", Boolean.TRUE);
        }
        return true;
    }

    @Override
    public boolean isAPMEnabled() {
        return this.isInstabugEnabled() && this.isAPMSdkEnabled() && this.isAPMFeatureAvailable();
    }

    public boolean isInstabugEnabled() {
        return InstabugCore.isFeatureAvailable((String)"INSTABUG") && InstabugCore.getFeatureState((String)"INSTABUG") == Feature.State.ENABLED;
    }

    @Override
    public void setSyncInterval(long l) {
        APMConfigurationProviderImpl aPMConfigurationProviderImpl = aPMConfigurationProviderImpl.editor;
        if (aPMConfigurationProviderImpl != null) {
            aPMConfigurationProviderImpl.putLong("SYNC_INTERVAL", l).apply();
        }
    }

    @Override
    public long getSyncInterval() {
        APMConfigurationProviderImpl aPMConfigurationProviderImpl = aPMConfigurationProviderImpl.sharedPreferences;
        if (aPMConfigurationProviderImpl != null) {
            return aPMConfigurationProviderImpl.getLong("SYNC_INTERVAL", 21600L);
        }
        return 21600L;
    }

    @Override
    public boolean isExecutionTraceFeatureEnabled() {
        APMConfigurationProviderImpl aPMConfigurationProviderImpl = aPMConfigurationProviderImpl.sharedPreferences;
        if (aPMConfigurationProviderImpl != null) {
            return aPMConfigurationProviderImpl.getBoolean("TRACES_ENABLED", false);
        }
        return false;
    }

    @Override
    public void setExecutionTraceFeatureEnabled(boolean bl) {
        APMConfigurationProviderImpl aPMConfigurationProviderImpl = aPMConfigurationProviderImpl.editor;
        if (aPMConfigurationProviderImpl != null) {
            aPMConfigurationProviderImpl.putBoolean("TRACES_ENABLED", bl).apply();
        }
    }

    @Override
    public long getExecutionTraceStoreLimit() {
        long l = 1000L;
        SharedPreferences sharedPreferences = this.sharedPreferences;
        if (sharedPreferences != null) {
            l = sharedPreferences.getLong("TRACES_STORE_LIMIT", 1000L);
        }
        return this.limitConstraintApplier.applyConstraints(l);
    }

    @Override
    public void setExecutionTraceStoreLimit(long l) {
        APMConfigurationProviderImpl aPMConfigurationProviderImpl = aPMConfigurationProviderImpl.editor;
        if (aPMConfigurationProviderImpl != null) {
            aPMConfigurationProviderImpl.putLong("TRACES_STORE_LIMIT", l).apply();
        }
    }

    @Override
    public long getExecutionTraceLimitPerRequest() {
        long l = 200L;
        SharedPreferences sharedPreferences = this.sharedPreferences;
        if (sharedPreferences != null) {
            l = sharedPreferences.getLong("TRACES_PER_REQUEST_LIMIT", 200L);
        }
        return this.limitConstraintApplier.applyConstraints(l);
    }

    @Override
    public void setExecutionTraceLimitPerRequest(long l) {
        APMConfigurationProviderImpl aPMConfigurationProviderImpl = aPMConfigurationProviderImpl.editor;
        if (aPMConfigurationProviderImpl != null) {
            aPMConfigurationProviderImpl.putLong("TRACES_PER_REQUEST_LIMIT", l).apply();
        }
    }

    @Override
    public void setExecutionTraceStoreAttributesLimit(int n) {
        APMConfigurationProviderImpl aPMConfigurationProviderImpl = aPMConfigurationProviderImpl.editor;
        if (aPMConfigurationProviderImpl != null) {
            aPMConfigurationProviderImpl.putInt("TRACES_ATTRIBUTES_COUNT", n).apply();
        }
    }

    @Override
    public boolean isColdAppLaunchesFeatureEnabled() {
        APMConfigurationProviderImpl aPMConfigurationProviderImpl = aPMConfigurationProviderImpl.sharedPreferences;
        if (aPMConfigurationProviderImpl != null) {
            return aPMConfigurationProviderImpl.getBoolean("LAUNCHES_ENABLED", false);
        }
        return false;
    }

    @Override
    public boolean isHotAppLaunchesFeatureEnabled() {
        APMConfigurationProviderImpl aPMConfigurationProviderImpl = aPMConfigurationProviderImpl.sharedPreferences;
        if (aPMConfigurationProviderImpl != null) {
            return aPMConfigurationProviderImpl.getBoolean("HOT_LAUNCHES_ENABLED", false);
        }
        return false;
    }

    @Override
    public void setColdAppLaunchesFeatureEnabled(boolean bl) {
        APMConfigurationProviderImpl aPMConfigurationProviderImpl = aPMConfigurationProviderImpl.editor;
        if (aPMConfigurationProviderImpl != null) {
            aPMConfigurationProviderImpl.putBoolean("LAUNCHES_ENABLED", bl).apply();
        }
    }

    @Override
    public void setHotAppLaunchesFeatureEnabled(boolean bl) {
        APMConfigurationProviderImpl aPMConfigurationProviderImpl = aPMConfigurationProviderImpl.editor;
        if (aPMConfigurationProviderImpl != null) {
            aPMConfigurationProviderImpl.putBoolean("HOT_LAUNCHES_ENABLED", bl).apply();
        }
    }

    @Override
    public void setColdAppLaunchesStoreLimit(long l) {
        APMConfigurationProviderImpl aPMConfigurationProviderImpl = aPMConfigurationProviderImpl.editor;
        if (aPMConfigurationProviderImpl != null) {
            aPMConfigurationProviderImpl.putLong("COLD_LAUNCHES_STORE_LIMIT", l).apply();
        }
    }

    @Override
    public void setHotAppLaunchesStoreLimit(long l) {
        APMConfigurationProviderImpl aPMConfigurationProviderImpl = aPMConfigurationProviderImpl.editor;
        if (aPMConfigurationProviderImpl != null) {
            aPMConfigurationProviderImpl.putLong("HOT_LAUNCHES_STORE_LIMIT", l).apply();
        }
    }

    @Override
    public int getExecutionTraceStoreAttributesLimit() {
        APMConfigurationProviderImpl aPMConfigurationProviderImpl = aPMConfigurationProviderImpl.sharedPreferences;
        if (aPMConfigurationProviderImpl != null) {
            return aPMConfigurationProviderImpl.getInt("TRACES_ATTRIBUTES_COUNT", 5);
        }
        return 5;
    }

    @Override
    public void setColdAppLaunchesLimitPerRequest(long l) {
        APMConfigurationProviderImpl aPMConfigurationProviderImpl = aPMConfigurationProviderImpl.editor;
        if (aPMConfigurationProviderImpl != null) {
            aPMConfigurationProviderImpl.putLong("COLD_LAUNCHES_PER_REQUEST_LIMIT", l).apply();
        }
    }

    @Override
    public void setHotAppLaunchesLimitPerRequest(long l) {
        APMConfigurationProviderImpl aPMConfigurationProviderImpl = aPMConfigurationProviderImpl.editor;
        if (aPMConfigurationProviderImpl != null) {
            aPMConfigurationProviderImpl.putLong("HOT_LAUNCHES_PER_REQUEST_LIMIT", l).apply();
        }
    }

    public boolean isColdAppLaunchSDKEnabled() {
        return (Boolean)this.apmPerSessionConfigurationProvider.getConfiguration("COLD_LAUNCHES_SDK_ENABLED", Boolean.TRUE);
    }

    public boolean isHotAppLaunchSDKEnabled() {
        return (Boolean)this.apmPerSessionConfigurationProvider.getConfiguration("HOT_LAUNCHES_SDK_ENABLED", Boolean.TRUE);
    }

    @Override
    public void setColdAppLaunchSDKEnabled(boolean bl) {
        APMPerSessionConfigurationProvider aPMPerSessionConfigurationProvider = ((APMConfigurationProviderImpl)((Object)aPMPerSessionConfigurationProvider)).apmPerSessionConfigurationProvider;
        if (aPMPerSessionConfigurationProvider != null) {
            aPMPerSessionConfigurationProvider.putConfiguration("COLD_LAUNCHES_SDK_ENABLED", bl);
        }
    }

    @Override
    public void setHotAppLaunchSDKEnabled(boolean bl) {
        APMPerSessionConfigurationProvider aPMPerSessionConfigurationProvider = ((APMConfigurationProviderImpl)((Object)aPMPerSessionConfigurationProvider)).apmPerSessionConfigurationProvider;
        if (aPMPerSessionConfigurationProvider != null) {
            aPMPerSessionConfigurationProvider.putConfiguration("HOT_LAUNCHES_SDK_ENABLED", bl);
        }
    }

    public boolean isColdAppLaunchesEnabled() {
        return this.isColdAppLaunchFlagsEnabled() && this.isAPMEnabled();
    }

    public boolean isHotAppLaunchesEnabled() {
        return this.isHotAppLaunchFlagsEnabled() && this.isAPMEnabled();
    }

    @Override
    public void setNetworkEnabled(boolean bl) {
        if (this.editor != null) {
            this.isNetworkFeatureEnabled = bl;
            this.editor.putBoolean("NETWORK_ENABLED", bl).apply();
        }
    }

    @Override
    public boolean isNetworkFeatureEnabled() {
        SharedPreferences sharedPreferences;
        Boolean bl = this.isNetworkFeatureEnabled;
        if (bl == null && (sharedPreferences = this.sharedPreferences) != null) {
            this.isNetworkFeatureEnabled = bl = Boolean.valueOf(sharedPreferences.getBoolean("NETWORK_ENABLED", false));
        }
        return bl != null ? bl : false;
    }

    @Override
    public boolean isNetworkEnabled() {
        return this.isAPMEnabled() && this.isNetworkFeatureEnabled();
    }

    @Override
    public void setNetworkLogsLimitPerRequest(long l) {
        APMConfigurationProviderImpl aPMConfigurationProviderImpl = aPMConfigurationProviderImpl.editor;
        if (aPMConfigurationProviderImpl != null) {
            aPMConfigurationProviderImpl.putLong("NETWORK_LOGS_REQUEST_LIMIT", l).apply();
        }
    }

    @Override
    public long getNetworkLogsRequestLimit() {
        long l = 200L;
        SharedPreferences sharedPreferences = this.sharedPreferences;
        if (sharedPreferences != null) {
            l = sharedPreferences.getLong("NETWORK_LOGS_REQUEST_LIMIT", 200L);
        }
        return this.limitConstraintApplier.applyConstraints(l);
    }

    @Override
    public void setNetworkLogsStoreLimit(long l) {
        APMConfigurationProviderImpl aPMConfigurationProviderImpl = aPMConfigurationProviderImpl.editor;
        if (aPMConfigurationProviderImpl != null) {
            aPMConfigurationProviderImpl.putLong("NETWORK_LOGS_CACHE_LIMIT", l).apply();
        }
    }

    @Override
    public long getNetworkLogsCacheLimit() {
        long l = 1000L;
        SharedPreferences sharedPreferences = this.sharedPreferences;
        if (sharedPreferences != null) {
            l = sharedPreferences.getLong("NETWORK_LOGS_CACHE_LIMIT", 1000L);
        }
        return this.limitConstraintApplier.applyConstraints(l);
    }

    @Override
    public void setLastSyncTime(long l) {
        APMConfigurationProviderImpl aPMConfigurationProviderImpl = aPMConfigurationProviderImpl.editor;
        if (aPMConfigurationProviderImpl != null) {
            aPMConfigurationProviderImpl.putLong("LAST_SYNC_TIME", l).apply();
        }
    }

    @Override
    public long getLastSyncTime() {
        APMConfigurationProviderImpl aPMConfigurationProviderImpl = aPMConfigurationProviderImpl.sharedPreferences;
        if (aPMConfigurationProviderImpl != null) {
            return aPMConfigurationProviderImpl.getLong("LAST_SYNC_TIME", 0L);
        }
        return 0L;
    }

    @Override
    public boolean isNetworkGraphQlFeatureEnabled() {
        APMConfigurationProviderImpl aPMConfigurationProviderImpl = aPMConfigurationProviderImpl.sharedPreferences;
        if (aPMConfigurationProviderImpl != null) {
            return aPMConfigurationProviderImpl.getBoolean("NETWORK_GRAPHQL_ENABLED", false);
        }
        return false;
    }

    @Override
    public void setNetworkGraphQlFeatureEnabled(boolean bl) {
        APMConfigurationProviderImpl aPMConfigurationProviderImpl = aPMConfigurationProviderImpl.editor;
        if (aPMConfigurationProviderImpl != null) {
            aPMConfigurationProviderImpl.putBoolean("NETWORK_GRAPHQL_ENABLED", bl).apply();
        }
    }

    @Override
    public boolean isNetworkGrpcInterceptionFeatureEnabled() {
        APMConfigurationProviderImpl aPMConfigurationProviderImpl = aPMConfigurationProviderImpl.sharedPreferences;
        if (aPMConfigurationProviderImpl != null) {
            return aPMConfigurationProviderImpl.getBoolean("NETWORK_GRPC_ENABLED", false);
        }
        return false;
    }

    @Override
    public void setNetworkGrpcInterceptionFeatureEnabled(boolean bl) {
        APMConfigurationProviderImpl aPMConfigurationProviderImpl = aPMConfigurationProviderImpl.editor;
        if (aPMConfigurationProviderImpl != null) {
            aPMConfigurationProviderImpl.putBoolean("NETWORK_GRPC_ENABLED", bl).apply();
        }
    }

    @Override
    public float getUiTraceLargeDropThreshold() {
        APMConfigurationProviderImpl aPMConfigurationProviderImpl = aPMConfigurationProviderImpl.sharedPreferences;
        if (aPMConfigurationProviderImpl != null) {
            return aPMConfigurationProviderImpl.getFloat("UI_TRACE_LARGE_DROP_THRESHOLD", 250000.0f);
        }
        return 250000.0f;
    }

    @Override
    public void setUiTraceLargeDropThreshold(float f) {
        APMConfigurationProviderImpl aPMConfigurationProviderImpl = aPMConfigurationProviderImpl.editor;
        if (aPMConfigurationProviderImpl != null) {
            aPMConfigurationProviderImpl.putFloat("UI_TRACE_LARGE_DROP_THRESHOLD", f).apply();
        }
    }

    @Override
    public float getUiTraceSmallDropThreshold() {
        APMConfigurationProviderImpl aPMConfigurationProviderImpl = aPMConfigurationProviderImpl.sharedPreferences;
        if (aPMConfigurationProviderImpl != null) {
            return aPMConfigurationProviderImpl.getFloat("UI_TRACE_SMALL_DROP_THRESHOLD", 16700.0f);
        }
        return 16700.0f;
    }

    @Override
    public void setUiTraceSmallDropThreshold(float f) {
        APMConfigurationProviderImpl aPMConfigurationProviderImpl = aPMConfigurationProviderImpl.editor;
        if (aPMConfigurationProviderImpl != null) {
            aPMConfigurationProviderImpl.putFloat("UI_TRACE_SMALL_DROP_THRESHOLD", f).apply();
        }
    }

    @Override
    public long getUiTraceLimitPerRequest() {
        long l = 200L;
        SharedPreferences sharedPreferences = this.sharedPreferences;
        if (sharedPreferences != null) {
            l = sharedPreferences.getLong("KEY_UI_TRACE_LIMIT_PER_REQUEST", 200L);
        }
        return this.limitConstraintApplier.applyConstraints(l);
    }

    @Override
    public void setUiTraceLimitPerRequest(long l) {
        APMConfigurationProviderImpl aPMConfigurationProviderImpl = aPMConfigurationProviderImpl.editor;
        if (aPMConfigurationProviderImpl != null) {
            aPMConfigurationProviderImpl.putLong("KEY_UI_TRACE_LIMIT_PER_REQUEST", l).apply();
        }
    }

    @Override
    public void setUiTraceSdkEnabled(boolean bl) {
        APMPerSessionConfigurationProvider aPMPerSessionConfigurationProvider = ((APMConfigurationProviderImpl)((Object)aPMPerSessionConfigurationProvider)).apmPerSessionConfigurationProvider;
        if (aPMPerSessionConfigurationProvider != null) {
            aPMPerSessionConfigurationProvider.putConfiguration("UI_TRACE_SDK_ENABLED", bl);
        }
    }

    @Override
    public long getUiTraceStoreLimit() {
        long l = 1000L;
        SharedPreferences sharedPreferences = this.sharedPreferences;
        if (sharedPreferences != null) {
            l = sharedPreferences.getLong("KEY_UI_TRACE_STORE_LIMIT", 1000L);
        }
        return this.limitConstraintApplier.applyConstraints(l);
    }

    @Override
    public boolean isUiTraceSdkEnabled() {
        return (Boolean)this.apmPerSessionConfigurationProvider.getConfiguration("UI_TRACE_SDK_ENABLED", Boolean.TRUE);
    }

    public boolean isUiTraceSdkEnabledIncludingASubFeature() {
        return this.isUiTraceSdkEnabled() && (this.isUiHangsSdkEnabled() || this.isUiLoadingMetricsSdkEnabled());
    }

    @Override
    public void setUiTraceStoreLimit(long l) {
        APMConfigurationProviderImpl aPMConfigurationProviderImpl = aPMConfigurationProviderImpl.editor;
        if (aPMConfigurationProviderImpl != null) {
            aPMConfigurationProviderImpl.putLong("KEY_UI_TRACE_STORE_LIMIT", l).apply();
        }
    }

    @Override
    public void setUiHangsFeatureEnabled(boolean bl) {
        if (this.editor != null) {
            this.isUiHangsFeatureEnabled = bl;
            this.editor.putBoolean("UI_TRACE_ENABLED", bl).apply();
        }
    }

    @Override
    public boolean isUiHangsFeatureEnabled() {
        SharedPreferences sharedPreferences;
        if (((APMConfigurationProviderImpl)this).isUiHangsFeatureEnabled == null && (sharedPreferences = ((APMConfigurationProviderImpl)this).sharedPreferences) != null) {
            ((APMConfigurationProviderImpl)this).isUiHangsFeatureEnabled = sharedPreferences.getBoolean("UI_TRACE_ENABLED", false);
        }
        return (this = ((APMConfigurationProviderImpl)this).isUiHangsFeatureEnabled) != null ? (Boolean)this : false;
    }

    @Override
    public void setUiHangsSdkEnabled(boolean bl) {
        APMPerSessionConfigurationProvider aPMPerSessionConfigurationProvider = ((APMConfigurationProviderImpl)((Object)aPMPerSessionConfigurationProvider)).apmPerSessionConfigurationProvider;
        if (aPMPerSessionConfigurationProvider != null) {
            aPMPerSessionConfigurationProvider.putConfiguration("UI_HANG_SDK_ENABLED", bl);
        }
    }

    public boolean isUiHangsSdkEnabled() {
        APMPerSessionConfigurationProvider aPMPerSessionConfigurationProvider = ((APMConfigurationProviderImpl)((Object)aPMPerSessionConfigurationProvider)).apmPerSessionConfigurationProvider;
        if (aPMPerSessionConfigurationProvider != null) {
            return (Boolean)aPMPerSessionConfigurationProvider.getConfiguration("UI_HANG_SDK_ENABLED", Boolean.TRUE);
        }
        return true;
    }

    @Override
    public boolean isUiTraceEnabled() {
        return this.isUiTraceFeatureEnabled() && this.isUiTraceSdkEnabledIncludingASubFeature() && this.isAPMEnabled();
    }

    @Override
    public boolean isAutoUiHangsEnabled() {
        return this.isUiHangsFeatureEnabled() && this.isUiHangsSdkEnabled();
    }

    @Override
    public boolean isUiLoadingMetricsFeatureEnabled() {
        SharedPreferences sharedPreferences;
        if (((APMConfigurationProviderImpl)this).isUiLoadingMetricFeatureEnabled == null && (sharedPreferences = ((APMConfigurationProviderImpl)this).sharedPreferences) != null) {
            ((APMConfigurationProviderImpl)this).isUiLoadingMetricFeatureEnabled = sharedPreferences.getBoolean("UI_LOADING_ENABLED", false);
        }
        return (this = ((APMConfigurationProviderImpl)this).isUiLoadingMetricFeatureEnabled) != null ? (Boolean)this : false;
    }

    @Override
    public void setUiLoadingMetricsFeatureEnabled(boolean bl) {
        if (this.editor != null) {
            this.isUiLoadingMetricFeatureEnabled = bl;
            this.editor.putBoolean("UI_LOADING_ENABLED", bl).apply();
        }
    }

    @Override
    public boolean isUiTraceFeatureEnabled() {
        return this.isUiHangsFeatureEnabled() || this.isUiLoadingMetricsFeatureEnabled();
    }

    @Override
    public boolean isUiLoadingMetricsSdkEnabled() {
        return (Boolean)this.apmPerSessionConfigurationProvider.getConfiguration("UI_LOADING_SDK_ENABLED", Boolean.TRUE);
    }

    @Override
    public void setUiLoadingMetricsSdkEnabled(boolean bl) {
        APMPerSessionConfigurationProvider aPMPerSessionConfigurationProvider = ((APMConfigurationProviderImpl)((Object)aPMPerSessionConfigurationProvider)).apmPerSessionConfigurationProvider;
        if (aPMPerSessionConfigurationProvider != null) {
            aPMPerSessionConfigurationProvider.putConfiguration("UI_LOADING_SDK_ENABLED", bl);
        }
    }

    @Override
    public boolean isAutoUiLoadingMetricsEnabled() {
        return this.isUiLoadingMetricsFeatureEnabled() && this.isUiLoadingMetricsSdkEnabled();
    }

    @Override
    public boolean isAutoUiLoadingMetricsFullyEnabled() {
        return this.isAPMEnabled() && this.isUiTraceSdkEnabled() && this.isAutoUiLoadingMetricsEnabled();
    }

    @Override
    public void setEndScreenLoadingFeatureEnabled(boolean bl) {
        APMConfigurationProviderImpl aPMConfigurationProviderImpl = aPMConfigurationProviderImpl.editor;
        if (aPMConfigurationProviderImpl != null) {
            aPMConfigurationProviderImpl.putBoolean("END_SCREEN_LOADING_ENABLED", bl).apply();
        }
    }

    @Override
    public boolean isEndScreenLoadingFeatureEnabled() {
        APMConfigurationProviderImpl aPMConfigurationProviderImpl = aPMConfigurationProviderImpl.sharedPreferences;
        if (aPMConfigurationProviderImpl != null) {
            return aPMConfigurationProviderImpl.getBoolean("END_SCREEN_LOADING_ENABLED", false);
        }
        return false;
    }

    @Override
    public void setCrashDetectionEnabled(boolean bl) {
        APMConfigurationProviderImpl aPMConfigurationProviderImpl = aPMConfigurationProviderImpl.editor;
        if (aPMConfigurationProviderImpl != null) {
            aPMConfigurationProviderImpl.putBoolean("CRASH_DETECTION_ENABLED", bl).apply();
        }
    }

    @Override
    public boolean isCrashDetectionEnabled() {
        SharedPreferences sharedPreferences = this.sharedPreferences;
        if (sharedPreferences != null) {
            return sharedPreferences.getBoolean("CRASH_DETECTION_ENABLED", false) && this.isAPMEnabled();
        }
        return false;
    }

    @Override
    public int getLogLevel() {
        return this.getCorrespondingAPMLogLevel();
    }

    @Override
    public void setNetworkLogsStoreAttributesLimit(int n) {
        APMConfigurationProviderImpl aPMConfigurationProviderImpl = aPMConfigurationProviderImpl.editor;
        if (aPMConfigurationProviderImpl != null) {
            aPMConfigurationProviderImpl.putInt("NETWORK_LOGS_ATTRIBUTES_COUNT", n).apply();
        }
    }

    @Override
    public int getNetworkLogsStoreAttributesLimit() {
        APMConfigurationProviderImpl aPMConfigurationProviderImpl = aPMConfigurationProviderImpl.sharedPreferences;
        if (aPMConfigurationProviderImpl != null) {
            return aPMConfigurationProviderImpl.getInt("NETWORK_LOGS_ATTRIBUTES_COUNT", 5);
        }
        return 5;
    }

    @Override
    public void setDebugModeEnabled(boolean bl) {
        APMConfigurationProviderImpl aPMConfigurationProviderImpl = aPMConfigurationProviderImpl.editor;
        if (aPMConfigurationProviderImpl != null) {
            aPMConfigurationProviderImpl.putBoolean("DEBUG_MODE_ENABLED", bl).apply();
        }
    }

    @Override
    public boolean isDebugModeEnabled() {
        SharedPreferences sharedPreferences = this.sharedPreferences;
        if (sharedPreferences != null) {
            return sharedPreferences.getBoolean("DEBUG_MODE_ENABLED", false) && this.isAPMEnabled();
        }
        return false;
    }

    @Override
    public void setEndColdAppLaunchFeatureEnabled(boolean bl) {
        APMConfigurationProviderImpl aPMConfigurationProviderImpl = aPMConfigurationProviderImpl.editor;
        if (aPMConfigurationProviderImpl != null) {
            aPMConfigurationProviderImpl.putBoolean("END_COLD_APP_LAUNCH_ENABLED", bl).apply();
        }
    }

    @Override
    public void setEndHotAppLaunchFeatureEnabled(boolean bl) {
        APMConfigurationProviderImpl aPMConfigurationProviderImpl = aPMConfigurationProviderImpl.editor;
        if (aPMConfigurationProviderImpl != null) {
            aPMConfigurationProviderImpl.putBoolean("END_HOT_APP_LAUNCH_ENABLED", bl).apply();
        }
    }

    public boolean isEndColdAppLaunchFeatureEnabled() {
        SharedPreferences sharedPreferences = this.sharedPreferences;
        if (sharedPreferences != null) {
            return sharedPreferences.getBoolean("END_COLD_APP_LAUNCH_ENABLED", false) && this.isAPMEnabled();
        }
        return false;
    }

    public boolean isEndHotAppLaunchFeatureEnabled() {
        SharedPreferences sharedPreferences = this.sharedPreferences;
        if (sharedPreferences != null) {
            return sharedPreferences.getBoolean("END_HOT_APP_LAUNCH_ENABLED", false) && this.isAPMEnabled();
        }
        return false;
    }

    @Override
    public void setWarmAppLaunchFeatureEnabled(boolean bl) {
        APMConfigurationProviderImpl aPMConfigurationProviderImpl = aPMConfigurationProviderImpl.editor;
        if (aPMConfigurationProviderImpl != null) {
            aPMConfigurationProviderImpl.putBoolean("WARM_APP_LAUNCH_ENABLED", bl).apply();
        }
    }

    @Override
    public boolean isWarmAppLaunchFeatureEnabled() {
        boolean bl = false;
        SharedPreferences sharedPreferences = this.sharedPreferences;
        if (sharedPreferences != null) {
            return sharedPreferences.getBoolean("WARM_APP_LAUNCH_ENABLED", bl);
        }
        return bl;
    }

    @Override
    public void setWarmAppLaunchRequestLimit(long l) {
        APMConfigurationProviderImpl aPMConfigurationProviderImpl = aPMConfigurationProviderImpl.editor;
        if (aPMConfigurationProviderImpl != null) {
            aPMConfigurationProviderImpl.putLong("WARM_APP_LAUNCHES_PER_REQUEST_LIMIT", l).apply();
        }
    }

    @Override
    public void setWarmAppLaunchStoreLimit(long l) {
        APMConfigurationProviderImpl aPMConfigurationProviderImpl = aPMConfigurationProviderImpl.editor;
        if (aPMConfigurationProviderImpl != null) {
            aPMConfigurationProviderImpl.putLong("WARM_APP_LAUNCHES_STORE_LIMIT", l).apply();
        }
    }

    @Override
    public void setEndWarmAppLaunchFeatureEnabled(boolean bl) {
        APMConfigurationProviderImpl aPMConfigurationProviderImpl = aPMConfigurationProviderImpl.editor;
        if (aPMConfigurationProviderImpl != null) {
            aPMConfigurationProviderImpl.putBoolean("END_WARM_APP_LAUNCH_ENABLED", bl).apply();
        }
    }

    public boolean isEndWarmAppLaunchFeatureEnabled() {
        boolean bl = false;
        SharedPreferences sharedPreferences = this.sharedPreferences;
        if (sharedPreferences != null) {
            return sharedPreferences.getBoolean("END_WARM_APP_LAUNCH_ENABLED", bl);
        }
        return bl;
    }

    @Override
    public void setWarmAppLaunchSdkEnabled(boolean bl) {
        APMPerSessionConfigurationProvider aPMPerSessionConfigurationProvider = ((APMConfigurationProviderImpl)((Object)aPMPerSessionConfigurationProvider)).apmPerSessionConfigurationProvider;
        if (aPMPerSessionConfigurationProvider != null) {
            aPMPerSessionConfigurationProvider.putConfiguration("WARM_LAUNCHES_SDK_ENABLED", bl);
        }
    }

    public boolean isWarmAppLaunchSdkEnabled() {
        boolean bl = true;
        APMPerSessionConfigurationProvider aPMPerSessionConfigurationProvider = this.apmPerSessionConfigurationProvider;
        if (aPMPerSessionConfigurationProvider != null) {
            return (Boolean)aPMPerSessionConfigurationProvider.getConfiguration("WARM_LAUNCHES_SDK_ENABLED", Boolean.TRUE);
        }
        return bl;
    }

    public boolean isWarmAppLaunchEnabled() {
        return this.isAPMEnabled() && this.isWarmAppLaunchFlagsEnabled();
    }

    public void resetWarmAppLaunchFeatureFlag() {
        APMConfigurationProviderImpl aPMConfigurationProviderImpl = aPMConfigurationProviderImpl.editor;
        if (aPMConfigurationProviderImpl != null) {
            aPMConfigurationProviderImpl.remove("WARM_APP_LAUNCH_ENABLED").apply();
        }
    }

    public void resetWarmAppLaunchRequestLimit() {
        APMConfigurationProviderImpl aPMConfigurationProviderImpl = aPMConfigurationProviderImpl.editor;
        if (aPMConfigurationProviderImpl != null) {
            aPMConfigurationProviderImpl.remove("WARM_APP_LAUNCHES_PER_REQUEST_LIMIT").apply();
        }
    }

    public void resetWarmAppLaunchStoreLimit() {
        APMConfigurationProviderImpl aPMConfigurationProviderImpl = aPMConfigurationProviderImpl.editor;
        if (aPMConfigurationProviderImpl != null) {
            aPMConfigurationProviderImpl.remove("WARM_APP_LAUNCHES_STORE_LIMIT").apply();
        }
    }

    public void resetEndWarmAppLaunchFeatureFlag() {
        APMConfigurationProviderImpl aPMConfigurationProviderImpl = aPMConfigurationProviderImpl.editor;
        if (aPMConfigurationProviderImpl != null) {
            aPMConfigurationProviderImpl.remove("END_WARM_APP_LAUNCH_ENABLED").apply();
        }
    }

    @Override
    public void resetWarmAppLaunchConfigurations() {
        APMConfigurationProviderImpl aPMConfigurationProviderImpl = this;
        aPMConfigurationProviderImpl.resetWarmAppLaunchFeatureFlag();
        aPMConfigurationProviderImpl.resetWarmAppLaunchRequestLimit();
        aPMConfigurationProviderImpl.resetWarmAppLaunchStoreLimit();
        aPMConfigurationProviderImpl.resetEndWarmAppLaunchFeatureFlag();
    }

    @Override
    public boolean isAppLaunchesEnabled() {
        return this.isAPMEnabled() && (this.isColdAppLaunchFlagsEnabled() || this.isWarmAppLaunchFlagsEnabled() || this.isHotAppLaunchFlagsEnabled());
    }

    @Override
    public long getAppLaunchStoreLimit(String string) {
        String string2 = string;
        string2.hashCode();
        int n = -1;
        switch (string2.hashCode()) {
            default: {
                break;
            }
            case 3641989: {
                if (!string.equals("warm")) break;
                n = 2;
                break;
            }
            case 3059428: {
                if (!string.equals("cold")) break;
                n = 1;
                break;
            }
            case 103501: {
                if (!string.equals("hot")) break;
                n = 0;
            }
        }
        switch (n) {
            default: {
                return 0L;
            }
            case 2: {
                return this.getWarmAppLaunchStoreLimit();
            }
            case 1: {
                return this.getColdAppLaunchesStoreLimit();
            }
            case 0: 
        }
        return this.getHotAppLaunchesStoreLimit();
    }

    @Override
    public long getAppLaunchRequestLimit(String string) {
        String string2 = string;
        string2.hashCode();
        int n = -1;
        switch (string2.hashCode()) {
            default: {
                break;
            }
            case 3641989: {
                if (!string.equals("warm")) break;
                n = 2;
                break;
            }
            case 3059428: {
                if (!string.equals("cold")) break;
                n = 1;
                break;
            }
            case 103501: {
                if (!string.equals("hot")) break;
                n = 0;
            }
        }
        switch (n) {
            default: {
                return 0L;
            }
            case 2: {
                return this.getWarmAppLaunchRequestLimit();
            }
            case 1: {
                return this.getColdAppLaunchesLimitPerRequest();
            }
            case 0: 
        }
        return this.getHotAppLaunchesLimitPerRequest();
    }

    @Override
    public boolean isAppLaunchFeatureEnabled(String string) {
        String string2 = string;
        string2.hashCode();
        int n = -1;
        switch (string2.hashCode()) {
            default: {
                break;
            }
            case 3641989: {
                if (!string.equals("warm")) break;
                n = 2;
                break;
            }
            case 3059428: {
                if (!string.equals("cold")) break;
                n = 1;
                break;
            }
            case 103501: {
                if (!string.equals("hot")) break;
                n = 0;
            }
        }
        switch (n) {
            default: {
                return false;
            }
            case 2: {
                return this.isWarmAppLaunchFeatureEnabled();
            }
            case 1: {
                return this.isColdAppLaunchesFeatureEnabled();
            }
            case 0: 
        }
        return this.isHotAppLaunchesFeatureEnabled();
    }

    @Override
    public boolean isAppLaunchSdkEnabled(String string) {
        String string2 = string;
        string2.hashCode();
        int n = -1;
        switch (string2.hashCode()) {
            default: {
                break;
            }
            case 3641989: {
                if (!string.equals("warm")) break;
                n = 2;
                break;
            }
            case 3059428: {
                if (!string.equals("cold")) break;
                n = 1;
                break;
            }
            case 103501: {
                if (!string.equals("hot")) break;
                n = 0;
            }
        }
        switch (n) {
            default: {
                return false;
            }
            case 2: {
                return this.isWarmAppLaunchSdkEnabled();
            }
            case 1: {
                return this.isColdAppLaunchSDKEnabled();
            }
            case 0: 
        }
        return this.isHotAppLaunchSDKEnabled();
    }

    @Override
    public boolean isEndAppLaunchFeatureEnabled(String string) {
        String string2 = string;
        string2.hashCode();
        int n = -1;
        switch (string2.hashCode()) {
            default: {
                break;
            }
            case 3641989: {
                if (!string.equals("warm")) break;
                n = 2;
                break;
            }
            case 3059428: {
                if (!string.equals("cold")) break;
                n = 1;
                break;
            }
            case 103501: {
                if (!string.equals("hot")) break;
                n = 0;
            }
        }
        switch (n) {
            default: {
                return false;
            }
            case 2: {
                return this.isEndWarmAppLaunchFeatureEnabled();
            }
            case 1: {
                return this.isEndColdAppLaunchFeatureEnabled();
            }
            case 0: 
        }
        return this.isEndHotAppLaunchFeatureEnabled();
    }

    @Override
    public boolean isAppLaunchEnabled(String string) {
        String string2 = string;
        string2.hashCode();
        int n = -1;
        switch (string2.hashCode()) {
            default: {
                break;
            }
            case 3641989: {
                if (!string.equals("warm")) break;
                n = 2;
                break;
            }
            case 3059428: {
                if (!string.equals("cold")) break;
                n = 1;
                break;
            }
            case 103501: {
                if (!string.equals("hot")) break;
                n = 0;
            }
        }
        switch (n) {
            default: {
                return false;
            }
            case 2: {
                return this.isWarmAppLaunchEnabled();
            }
            case 1: {
                return this.isColdAppLaunchesEnabled();
            }
            case 0: 
        }
        return this.isHotAppLaunchesEnabled();
    }

    @Override
    public void setExperimentsFeatureEnabled(boolean bl) {
        APMConfigurationProviderImpl aPMConfigurationProviderImpl = aPMConfigurationProviderImpl.editor;
        if (aPMConfigurationProviderImpl != null) {
            aPMConfigurationProviderImpl.putBoolean("EXPERIMENTS_ENABLED", bl).apply();
        }
    }

    @Override
    public void resetExperimentsFeatureEnabledFlag() {
        this.setExperimentsFeatureEnabled(false);
    }

    @Override
    public boolean isExperimentsFeatureEnabled() {
        boolean bl = false;
        SharedPreferences sharedPreferences = this.sharedPreferences;
        if (sharedPreferences != null) {
            return sharedPreferences.getBoolean("EXPERIMENTS_ENABLED", bl);
        }
        return bl;
    }

    @Override
    public void setExperimentsLimitPerRequest(int n) {
        APMConfigurationProviderImpl aPMConfigurationProviderImpl = aPMConfigurationProviderImpl.editor;
        if (aPMConfigurationProviderImpl != null) {
            aPMConfigurationProviderImpl.putInt("EXPERIMENTS_LIMIT_PER_REQUEST", n).apply();
        }
    }

    @Override
    public void resetExperimentsLimitPerRequest() {
        this.setExperimentsLimitPerRequest(1000);
    }

    @Override
    public int getExperimentsLimitPerRequest() {
        int n = 1000;
        SharedPreferences sharedPreferences = this.sharedPreferences;
        if (sharedPreferences != null) {
            return sharedPreferences.getInt("EXPERIMENTS_LIMIT_PER_REQUEST", n);
        }
        return n;
    }

    @Override
    public void setSessionStoreLimitEnabled(boolean bl) {
        APMConfigurationProviderImpl aPMConfigurationProviderImpl = aPMConfigurationProviderImpl.editor;
        if (aPMConfigurationProviderImpl != null) {
            aPMConfigurationProviderImpl.putBoolean("SESSION_STORE_LIMIT_ENABLED", bl).apply();
        }
    }

    @Override
    public boolean isSessionStoreLimitEnabled() {
        boolean bl = false;
        SharedPreferences sharedPreferences = this.sharedPreferences;
        if (sharedPreferences != null) {
            return sharedPreferences.getBoolean("SESSION_STORE_LIMIT_ENABLED", bl);
        }
        return bl;
    }

    @Override
    public void resetSessionStoreLimitEnabledFlag() {
        APMConfigurationProviderImpl aPMConfigurationProviderImpl = aPMConfigurationProviderImpl.editor;
        if (aPMConfigurationProviderImpl != null) {
            aPMConfigurationProviderImpl.remove("SESSION_STORE_LIMIT_ENABLED").apply();
        }
    }

    @Override
    public void setSessionStoreLimit(int n) {
        APMConfigurationProviderImpl aPMConfigurationProviderImpl = aPMConfigurationProviderImpl.editor;
        if (aPMConfigurationProviderImpl != null) {
            aPMConfigurationProviderImpl.putInt("SESSION_STORE_LIMIT", n).apply();
        }
    }

    @Override
    public int getSessionStoreLimit() {
        int n = 300;
        SharedPreferences sharedPreferences = this.sharedPreferences;
        if (sharedPreferences != null) {
            return sharedPreferences.getInt("SESSION_STORE_LIMIT", n);
        }
        return n;
    }

    @Override
    public void resetSessionStoreLimit() {
        APMConfigurationProviderImpl aPMConfigurationProviderImpl = aPMConfigurationProviderImpl.editor;
        if (aPMConfigurationProviderImpl != null) {
            aPMConfigurationProviderImpl.remove("SESSION_STORE_LIMIT").apply();
        }
    }

    @Override
    public void setShouldDependOnV3Session(boolean bl) {
        APMConfigurationProviderImpl aPMConfigurationProviderImpl = aPMConfigurationProviderImpl.editor;
        if (aPMConfigurationProviderImpl != null) {
            aPMConfigurationProviderImpl.putBoolean("SHOULD_DEPEND_ON_V3_SESSION", bl).apply();
        }
    }

    @Override
    public boolean shouldDependOnV3Session() {
        APMConfigurationProviderImpl aPMConfigurationProviderImpl = aPMConfigurationProviderImpl.sharedPreferences;
        return aPMConfigurationProviderImpl != null ? aPMConfigurationProviderImpl.getBoolean("SHOULD_DEPEND_ON_V3_SESSION", false) : false;
    }

    @Override
    public void clearState() {
        this.resetStoreLimitDroppedSessionCount();
    }

    @Override
    public void incrementStoreLimitDroppedSessionsCount(int n) {
        APMConfigurationProviderImpl aPMConfigurationProviderImpl = this;
        int n2 = aPMConfigurationProviderImpl.getStoreLimitDroppedSessionsCount() + n;
        SharedPreferences.Editor editor = aPMConfigurationProviderImpl.editor;
        if (editor != null) {
            editor.putInt("DROPPED_SESSION_COUNT_STORE_LIMIT", n2).apply();
        }
    }

    @Override
    public int getStoreLimitDroppedSessionsCount() {
        APMConfigurationProviderImpl aPMConfigurationProviderImpl = aPMConfigurationProviderImpl.sharedPreferences;
        if (aPMConfigurationProviderImpl != null) {
            return aPMConfigurationProviderImpl.getInt("DROPPED_SESSION_COUNT_STORE_LIMIT", 0);
        }
        return 0;
    }

    @Override
    public void resetStoreLimitDroppedSessionCount() {
        APMConfigurationProviderImpl aPMConfigurationProviderImpl = aPMConfigurationProviderImpl.editor;
        if (aPMConfigurationProviderImpl != null) {
            aPMConfigurationProviderImpl.remove("DROPPED_SESSION_COUNT_STORE_LIMIT").apply();
        }
    }

    @Override
    public void setLastApmSessionsRequestStartedAt(long l) {
        APMConfigurationProviderImpl aPMConfigurationProviderImpl = aPMConfigurationProviderImpl.editor;
        if (aPMConfigurationProviderImpl == null) {
            return;
        }
        aPMConfigurationProviderImpl.putLong("last_apm_sessions_request_started_at", l).apply();
    }

    @Override
    public void setApmSessionsLimitedUntil(int n) {
        if (this.sharedPreferences == null) {
            return;
        }
        APMConfigurationProviderImpl aPMConfigurationProviderImpl = this;
        long l = aPMConfigurationProviderImpl.getLastApmSessionsRequestStartedAt() + (long)n * 1000L;
        SharedPreferences.Editor editor = aPMConfigurationProviderImpl.editor;
        if (editor != null) {
            editor.putLong("apm_sessions_rate_limited_until", l).apply();
        }
    }

    @Override
    public boolean isApmSessionsRateLimited() {
        long l = this.getLastApmSessionsRequestStartedAt();
        long l2 = this.getApmSessionsLimitedUntil();
        long l3 = System.currentTimeMillis();
        return l != 0L && l2 != 0L && l3 > l && l3 < l2;
    }

    @Override
    public void setSendLegacyAPMSessions(boolean bl) {
        APMConfigurationProviderImpl aPMConfigurationProviderImpl = aPMConfigurationProviderImpl.editor;
        if (aPMConfigurationProviderImpl != null) {
            aPMConfigurationProviderImpl.putBoolean("SHOULD_SEND_LEGACY_APM_SESSIONS", bl).apply();
        }
    }

    @Override
    public boolean shouldSendLegacyAPMSessions() {
        APMConfigurationProviderImpl aPMConfigurationProviderImpl = aPMConfigurationProviderImpl.sharedPreferences;
        if (aPMConfigurationProviderImpl != null) {
            return aPMConfigurationProviderImpl.getBoolean("SHOULD_SEND_LEGACY_APM_SESSIONS", false);
        }
        return false;
    }

    @Override
    public int getFragmentSpansStoreLimit() {
        APMConfigurationProviderImpl aPMConfigurationProviderImpl = aPMConfigurationProviderImpl.sharedPreferences;
        return aPMConfigurationProviderImpl == null ? 1000 : aPMConfigurationProviderImpl.getInt("FRAGMENT_SPANS_STORE_LIMIT", 1000);
    }

    @Override
    public int getFragmentSpansLimitPerRequest() {
        APMConfigurationProviderImpl aPMConfigurationProviderImpl = aPMConfigurationProviderImpl.sharedPreferences;
        return aPMConfigurationProviderImpl == null ? 200 : aPMConfigurationProviderImpl.getInt("FRAGMENT_SPANS_LIMIT_PER_REQUEST", 200);
    }

    @Override
    public void setFragmentSpansFeatureEnabledFlag(boolean bl) {
        if (aPMConfigurationProviderImpl.sharedPreferences == null) {
            return;
        }
        APMConfigurationProviderImpl aPMConfigurationProviderImpl = aPMConfigurationProviderImpl.editor;
        if (aPMConfigurationProviderImpl != null) {
            aPMConfigurationProviderImpl.putBoolean("FRAGMENT_SPANS_ENABLED", bl).apply();
        }
    }

    @Override
    public void setFragmentSpansStoreLimit(int n) {
        if (aPMConfigurationProviderImpl.sharedPreferences == null) {
            return;
        }
        APMConfigurationProviderImpl aPMConfigurationProviderImpl = aPMConfigurationProviderImpl.editor;
        if (aPMConfigurationProviderImpl != null) {
            aPMConfigurationProviderImpl.putInt("FRAGMENT_SPANS_STORE_LIMIT", n).apply();
        }
    }

    @Override
    public void setFragmentSpansLimitPerRequest(int n) {
        if (aPMConfigurationProviderImpl.sharedPreferences == null) {
            return;
        }
        APMConfigurationProviderImpl aPMConfigurationProviderImpl = aPMConfigurationProviderImpl.editor;
        if (aPMConfigurationProviderImpl != null) {
            aPMConfigurationProviderImpl.putInt("FRAGMENT_SPANS_LIMIT_PER_REQUEST", n).apply();
        }
    }

    @Override
    public boolean isFragmentSpansFeatureEnabled() {
        APMConfigurationProviderImpl aPMConfigurationProviderImpl = aPMConfigurationProviderImpl.sharedPreferences;
        return aPMConfigurationProviderImpl == null ? false : aPMConfigurationProviderImpl.getBoolean("FRAGMENT_SPANS_ENABLED", false);
    }

    @Override
    public void resetFragmentSpansFeatureEnabledFlag() {
        this.setFragmentSpansFeatureEnabledFlag(false);
    }

    @Override
    public void resetFragmentSpansStoreLimit() {
        this.setFragmentSpansStoreLimit(1000);
    }

    @Override
    public void resetFragmentSpansLimitPerRequest() {
        this.setFragmentSpansLimitPerRequest(200);
    }

    @Override
    public void setFragmentSpansSDKEnabled(boolean bl) {
        APMPerSessionConfigurationProvider aPMPerSessionConfigurationProvider = ((APMConfigurationProviderImpl)((Object)aPMPerSessionConfigurationProvider)).apmPerSessionConfigurationProvider;
        if (aPMPerSessionConfigurationProvider != null) {
            aPMPerSessionConfigurationProvider.putConfiguration("FRAGMENT_SPANS_SDK_ENABLED", bl);
        }
    }

    public boolean isFragmentSpansSDKEnabled() {
        return (Boolean)this.apmPerSessionConfigurationProvider.getConfiguration("FRAGMENT_SPANS_SDK_ENABLED", Boolean.TRUE);
    }

    @Override
    public boolean isFragmentSpansEnabled() {
        return this.isFragmentSpansFeatureEnabled() && this.isFragmentSpansSDKEnabled();
    }

    @Override
    public boolean isW3CNetworkExternalTraceIdEnabled() {
        return this.isNetworkEnabled() && this.coreNetworkInterceptionConfigurationProvider.isW3CNetworkExternalTraceIdEnabled();
    }

    @Override
    public boolean isAttachingGeneratedW3CExternalTraceIdFeatureAvailable() {
        return this.coreNetworkInterceptionConfigurationProvider.isAttachingGeneratedW3CExternalTraceIdFeatureAvailable();
    }

    @Override
    public boolean isAttachingGeneratedW3CExternalTraceIdEnabled() {
        return this.isNetworkEnabled() && this.coreNetworkInterceptionConfigurationProvider.isAttachingGeneratedW3CExternalTraceIdEnabled();
    }

    @Override
    public boolean isAttachingCapturedW3CExternalTraceIdFeatureAvailable() {
        return this.coreNetworkInterceptionConfigurationProvider.isAttachingCapturedW3CExternalTraceIdFeatureAvailable();
    }

    @Override
    public boolean isAttachingCapturedW3CExternalTraceIdEnabled() {
        return this.isNetworkEnabled() && this.coreNetworkInterceptionConfigurationProvider.isAttachingCapturedW3CExternalTraceIdEnabled();
    }
}

