/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.apm.compose.compose_spans.model.transform;

import com.instabug.apm.logger.internal.Logger;
import com.instabug.library.map.Mapper;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0012\u0010\b\u001a\u0004\u0018\u00010\u00022\u0006\u0010\t\u001a\u00020\u0002H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/instabug/apm/compose/compose_spans/model/transform/ComposableNameLengthSanitizer;", "Lcom/instabug/library/map/Mapper;", "", "maxAllowedLength", "", "logger", "Lcom/instabug/apm/logger/internal/Logger;", "(ILcom/instabug/apm/logger/internal/Logger;)V", "map", "from", "instabug-apm_defaultUiRelease"})
public final class ComposableNameLengthSanitizer
implements Mapper<String, String> {
    private final int maxAllowedLength;
    @NotNull
    private final Logger logger;

    public ComposableNameLengthSanitizer(int n, @NotNull Logger logger2) {
        Intrinsics.checkNotNullParameter((Object)logger2, (String)"logger");
        this.maxAllowedLength = n;
        this.logger = logger2;
    }

    @Nullable
    public String map(@NotNull String string) {
        String string2 = string;
        Intrinsics.checkNotNullParameter((Object)string2, (String)"from");
        String string3 = ((Object)StringsKt.trim((CharSequence)string2)).toString();
        if (string3.length() == 0) {
            this.logger.logSDKError("Composable screen trace wasn't created. Composable screen trace name can't be empty or null.");
            string3 = null;
        } else if (string3.length() > this.maxAllowedLength) {
            ComposableNameLengthSanitizer composableNameLengthSanitizer = this;
            composableNameLengthSanitizer.logger.logSDKWarning(StringsKt.replace$default((String)StringsKt.replace$default((String)"Composable screen trace name \"$s\" was truncated as it was too long. Please limit composable names to $L characters.", (String)"$s", (String)string, (boolean)false, (int)4, null), (String)"$L", (String)String.valueOf(this.maxAllowedLength), (boolean)false, (int)4, null));
            string3 = string3.substring(0, composableNameLengthSanitizer.maxAllowedLength);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        }
        return string3;
    }
}

