/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.apm.cache.model;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.instabug.apm.appflow.model.AppFlowCacheModel;
import com.instabug.apm.cache.model.AppLaunchCacheModel;
import com.instabug.apm.cache.model.ExecutionTraceCacheModel;
import com.instabug.apm.cache.model.FragmentSpansCacheModel;
import com.instabug.apm.cache.model.SessionMetaData;
import com.instabug.apm.cache.model.UiTraceCacheModel;
import com.instabug.apm.compose.compose_spans.model.ComposeSpansCacheModel;
import com.instabug.apm.model.APMNetworkLog;
import com.instabug.library.model.common.Session;
import java.util.List;

public class SessionCacheModel
implements Session {
    @NonNull
    private final String id;
    @NonNull
    private final String coreId;
    @NonNull
    private final String os;
    @NonNull
    private final String appVersion;
    @NonNull
    private final String uuid;
    private final long duration;
    private final long startTimestampMicros;
    private final long startNanoTime;
    private final int terminationStatusCode;
    private int syncStatus;
    @Nullable
    private List<AppLaunchCacheModel> appLaunches;
    @Nullable
    private List<ExecutionTraceCacheModel> executionTraces;
    @Nullable
    private List<UiTraceCacheModel> uiTraces;
    @Nullable
    private List<APMNetworkLog> networkLogs;
    @Nullable
    private SessionMetaData sessionMetaData;
    @Nullable
    private List<String> experiments;
    @Nullable
    private List<FragmentSpansCacheModel> fragmentSpans;
    @Nullable
    private List<ComposeSpansCacheModel> composeSpans;
    @Nullable
    private List<AppFlowCacheModel> appFlows;
    @NonNull
    private final String coreSessionVersion;

    public SessionCacheModel(@NonNull String string, @NonNull Session object) {
        Session session = object;
        String string2 = session.getId();
        String string3 = session.getOs();
        String string4 = session.getAppVersion() != null ? object.getAppVersion() : "";
        SessionCacheModel sessionCacheModel = string5;
        Session session2 = object;
        String string5 = session2.getUuid();
        long l = session2.getStartTimestampMicros();
        long l2 = session2.getStartNanoTime();
        object = session2.getVersion();
        sessionCacheModel(string, string2, string3, string4, string5, 0L, l, l2, (String)object, -1, -1);
    }

    public SessionCacheModel(@NonNull String string, @NonNull String string2, @NonNull String string3, @NonNull String string4, @NonNull String string5, long l, long l2, long l3, @NonNull String string6, int n, int n2) {
        this.id = string;
        this.coreId = string2;
        this.os = string3;
        this.appVersion = string4;
        this.uuid = string5;
        this.duration = l;
        this.startTimestampMicros = l2;
        this.terminationStatusCode = n;
        this.startNanoTime = l3;
        this.syncStatus = n2;
        this.coreSessionVersion = string6;
    }

    @NonNull
    public String getId() {
        return this.id;
    }

    @NonNull
    public String getCoreId() {
        return this.coreId;
    }

    @NonNull
    public String getOs() {
        return this.os;
    }

    @NonNull
    public String getAppVersion() {
        return this.appVersion;
    }

    @NonNull
    public String getUuid() {
        return this.uuid;
    }

    public long getDuration() {
        return this.duration;
    }

    public long getStartTimestampMicros() {
        return this.startTimestampMicros;
    }

    public long getStartNanoTime() {
        return this.startNanoTime;
    }

    public String getVersion() {
        return this.coreSessionVersion;
    }

    public int getTerminationStatusCode() {
        return this.terminationStatusCode;
    }

    @Nullable
    public List<AppLaunchCacheModel> getAppLaunches() {
        return this.appLaunches;
    }

    public void setAppLaunches(@Nullable List<AppLaunchCacheModel> list) {
        this.appLaunches = list;
    }

    @Nullable
    public List<ExecutionTraceCacheModel> getExecutionTraces() {
        return this.executionTraces;
    }

    public void setExecutionTraces(@Nullable List<ExecutionTraceCacheModel> list) {
        this.executionTraces = list;
    }

    @Nullable
    public List<UiTraceCacheModel> getUiTraces() {
        return this.uiTraces;
    }

    public void setUiTraces(@Nullable List<UiTraceCacheModel> list) {
        this.uiTraces = list;
    }

    @Nullable
    public List<APMNetworkLog> getNetworkLogs() {
        return this.networkLogs;
    }

    public void setNetworkLogs(@Nullable List<APMNetworkLog> list) {
        this.networkLogs = list;
    }

    @Nullable
    public SessionMetaData getSessionMetaData() {
        return this.sessionMetaData;
    }

    public void setSessionMetaData(@Nullable SessionMetaData sessionMetaData) {
        this.sessionMetaData = sessionMetaData;
    }

    @Nullable
    public List<String> getExperiments() {
        return this.experiments;
    }

    public void setExperiments(@Nullable List<String> list) {
        this.experiments = list;
    }

    @Nullable
    public List<FragmentSpansCacheModel> getFragmentSpans() {
        return this.fragmentSpans;
    }

    public void setFragmentSpans(@Nullable List<FragmentSpansCacheModel> list) {
        this.fragmentSpans = list;
    }

    @Nullable
    public List<ComposeSpansCacheModel> getComposeSpans() {
        return this.composeSpans;
    }

    public void setComposeSpans(@Nullable List<ComposeSpansCacheModel> list) {
        this.composeSpans = list;
    }

    public int getWebViewTraceTotalCount() {
        int n = 0;
        List<UiTraceCacheModel> list = this.uiTraces;
        if (list != null) {
            for (UiTraceCacheModel uiTraceCacheModel : list) {
                if (uiTraceCacheModel == null) continue;
                n += uiTraceCacheModel.getWebViewTraceCount();
            }
        }
        return n;
    }

    @Nullable
    public List<AppFlowCacheModel> getAppFlows() {
        return this.appFlows;
    }

    public void setAppFlows(@Nullable List<AppFlowCacheModel> list) {
        this.appFlows = list;
    }
}

