/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.apm.cache.handler.networklog;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.instabug.apm.cache.handler.networklog.DanglingNetworkLogCacheHandler;
import com.instabug.apm.cache.handler.networklog.NetworkLogCacheHandler;
import com.instabug.apm.cache.handler.networklog.NetworkLogMigrationHandler;
import com.instabug.apm.cache.handler.session.SessionMetaDataCacheHandler;
import com.instabug.apm.configuration.APMConfigurationProvider;
import com.instabug.apm.di.ServiceLocator;
import com.instabug.apm.logger.internal.Logger;
import com.instabug.apm.model.APMNetworkLog;
import com.instabug.library.model.common.Session;
import java.util.List;

public class NetworkLogMigrationHandlerImpl
implements NetworkLogMigrationHandler {
    @NonNull
    private final NetworkLogCacheHandler cacheHandler;
    @NonNull
    private final DanglingNetworkLogCacheHandler danglingCacheHandler;
    @NonNull
    private final APMConfigurationProvider configurationProvider;
    @Nullable
    private final SessionMetaDataCacheHandler sessionMetaDataCacheHandler;
    private Logger apmLogger = ServiceLocator.getApmLogger();

    public NetworkLogMigrationHandlerImpl(@NonNull NetworkLogCacheHandler networkLogCacheHandler, @NonNull DanglingNetworkLogCacheHandler danglingNetworkLogCacheHandler, @NonNull APMConfigurationProvider aPMConfigurationProvider, @Nullable SessionMetaDataCacheHandler sessionMetaDataCacheHandler) {
        this.cacheHandler = networkLogCacheHandler;
        this.danglingCacheHandler = danglingNetworkLogCacheHandler;
        this.configurationProvider = aPMConfigurationProvider;
        this.sessionMetaDataCacheHandler = sessionMetaDataCacheHandler;
    }

    @Override
    public void migrate(@NonNull Session session, @NonNull Session session2) {
        List<APMNetworkLog> list;
        long l = this.configurationProvider.getNetworkLogsRequestLimit();
        do {
            if ((list = this.getBatch(l)) == null) continue;
            for (APMNetworkLog aPMNetworkLog : list) {
                if (this.shouldLinkToLastSession(aPMNetworkLog)) {
                    this.migrate(aPMNetworkLog, session2);
                    continue;
                }
                this.migrate(aPMNetworkLog, session);
            }
            this.deleteBatch(list);
        } while (list != null && list.size() > 0);
    }

    @Nullable
    @VisibleForTesting
    List<APMNetworkLog> getBatch(long l) {
        return this.danglingCacheHandler.getNetworkLogsByLimit(l);
    }

    @VisibleForTesting
    void migrate(@NonNull APMNetworkLog aPMNetworkLog, @NonNull Session session) {
        if (this.sessionMetaDataCacheHandler != null) {
            long l = this.cacheHandler.insertNetworkLog(session.getId(), aPMNetworkLog);
            if (l != -1L) {
                String string = "[" + aPMNetworkLog.getMethod() + "] " + aPMNetworkLog.getUrl();
                this.cacheHandler.addAttributes(l, string, this.danglingCacheHandler.getTraceAttributes(aPMNetworkLog.getId()));
            }
            this.apmLogger.d("Migrated network request: " + aPMNetworkLog.getUrl());
            if (l > 0L) {
                NetworkLogMigrationHandlerImpl networkLogMigrationHandlerImpl = this;
                networkLogMigrationHandlerImpl.sessionMetaDataCacheHandler.addToNetworkLogsTotalCount(session.getId(), 1);
                int n = networkLogMigrationHandlerImpl.cacheHandler.trimToLimit(session.getId(), this.configurationProvider.getNetworkLogsRequestLimit());
                if (n > 0) {
                    this.sessionMetaDataCacheHandler.addToNetworkLogsDroppedCount(session.getId(), n);
                }
                this.cacheHandler.trimToLimit(this.configurationProvider.getNetworkLogsCacheLimit());
            }
        }
    }

    @VisibleForTesting
    void deleteBatch(@NonNull List<APMNetworkLog> list) {
        this.danglingCacheHandler.deleteNetworkLogsByLimit(list.size());
    }

    @VisibleForTesting
    boolean shouldLinkToLastSession(@NonNull APMNetworkLog aPMNetworkLog) {
        return aPMNetworkLog.getExecutedInBackground() ^ true;
    }
}

