/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.apm.cache.handler.executiontraces;

import android.annotation.SuppressLint;
import android.content.ContentValues;
import android.database.Cursor;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.collection.ArrayMap;
import com.instabug.apm.cache.handler.executiontraces.ExecutionTracesCacheHandler;
import com.instabug.apm.cache.model.ExecutionTraceCacheModel;
import com.instabug.apm.di.ServiceLocator;
import com.instabug.apm.logger.internal.Logger;
import com.instabug.library.diagnostics.IBGDiagnostics;
import com.instabug.library.internal.storage.cache.db.DatabaseManager;
import com.instabug.library.internal.storage.cache.db.SQLiteDatabaseWrapper;
import com.instabug.library.internal.utils.stability.handler.exception.ExceptionHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ExecutionTracesCacheHandlerImpl
implements ExecutionTracesCacheHandler {
    private ExceptionHandler exceptionHandler = ServiceLocator.getExceptionHandler();
    @Nullable
    private DatabaseManager databaseManager = ServiceLocator.getDatabaseManager();
    private Logger apmLogger = ServiceLocator.getApmLogger();

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private List<ExecutionTraceCacheModel> getTracesByQueryString(String object) {
        Throwable throwable2222222;
        Cursor cursor;
        block5: {
            DatabaseManager databaseManager = this.databaseManager;
            if (databaseManager == null) return null;
            databaseManager = databaseManager.openDatabase();
            cursor = null;
            cursor = databaseManager.rawQuery((String)object, null);
            {
                catch (Throwable throwable2222222) {
                    break block5;
                }
                catch (Exception exception) {}
                {
                    this.apmLogger.logSDKError("DB execution a sql failed: " + exception.getMessage(), exception);
                    IBGDiagnostics.reportNonFatal((Throwable)exception, (String)("DB execution a sql failed: " + exception.getMessage()));
                    if (cursor == null) return null;
                }
                cursor.close();
                return null;
            }
            {
                object = this.getTracesFromCursor((SQLiteDatabaseWrapper)databaseManager, cursor);
                databaseManager.close();
                if (cursor == null) return object;
            }
            cursor.close();
            return object;
        }
        if (cursor == null) throw throwable2222222;
        cursor.close();
        throw throwable2222222;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @SuppressLint(value={"Range"})
    private ArrayList<ExecutionTraceCacheModel> getTracesFromCursor(SQLiteDatabaseWrapper var1_2, @Nullable Cursor var2_3) {
        block12: {
            var3_4 = v0;
            v0 = new ArrayList<ExecutionTraceCacheModel>();
            if (var2_3 == null) break block12;
            while (var2_3.moveToNext()) {
                block11: {
                    block13: {
                        block10: {
                            v1 = var2_3;
                            var4_5 = v2;
                            v3 = var2_3;
                            v4 = var2_3;
                            v5 = var2_3;
                            v6 = var2_3;
                            var4_5();
                            var4_5.setId(v6.getLong(v6.getColumnIndex("trace_id")));
                            var4_5.setName(v5.getString(v5.getColumnIndex("name")));
                            var4_5.setStartTime(v4.getLong(v4.getColumnIndex("start_time")));
                            v2.setDuration(v3.getLong(v3.getColumnIndex("duration")));
                            var5_7 = v1.getInt(v1.getColumnIndex("started_on_background")) == 1;
                            v7 = var2_3;
                            var4_5.setStartedInBackground(var5_7);
                            var5_7 = v7.getInt(v7.getColumnIndex("ended_on_background")) == 1;
                            var4_5.setEndedInBackground(var5_7);
                            var5_6 = null;
                            var5_6 = var1_2.rawQuery("select* from execution_traces_attributes where trace_id = " + var4_5.getId(), null);
                            if (var5_6 == null) break block10;
                            var6_8 = v8;
                            try {
                                v8 = new ArrayMap();
                                while (var5_6.moveToNext()) {
                                    v9 = var5_6;
                                    var7_10 = v9.getString(v9.getColumnIndex("attribute_key"));
                                    var6_8.put(var7_10, v9.getString(v9.getColumnIndex("attribute_value")));
                                }
                            }
                            catch (Throwable var0_1) {}
                            {
                                continue;
                                break;
                            }
                            if (var5_6 != null) {
                                var5_6.close();
                            }
                            throw var0_1;
                            catch (Exception var6_9) {
                                ** GOTO lbl-1000
                            }
                            {
                                var4_5.setAttrs((Map<String, String>)var6_8);
                            }
                        }
                        if (var5_6 == null) break block11;
                        break block13;
lbl-1000:
                        // 1 sources

                        {
                            this.apmLogger.logSDKError("DB execution a sql failed: " + var6_9.getMessage(), var6_9);
                            IBGDiagnostics.reportNonFatal((Throwable)var6_9, (String)("DB execution a sql failed: " + var6_9.getMessage()));
                            if (var5_6 == null) break block11;
                        }
                    }
                    var5_6.close();
                }
                var3_4.add(var4_5);
            }
        }
        return var3_4;
    }

    private void addAttribute(long l, @NonNull String string, @Nullable String string2) {
        if (this.databaseManager != null) {
            ContentValues contentValues;
            ContentValues contentValues2 = contentValues;
            contentValues2();
            contentValues.put("trace_id", Long.valueOf(l));
            contentValues.put("attribute_key", string);
            if (string2 != null) {
                contentValues2.put("attribute_value", string2);
            }
            SQLiteDatabaseWrapper sQLiteDatabaseWrapper = this.databaseManager.openDatabase();
            sQLiteDatabaseWrapper.insert("execution_traces_attributes", null, contentValues2);
            sQLiteDatabaseWrapper.close();
        }
    }

    @Override
    public boolean insertTrace(@NonNull String string, @NonNull ExecutionTraceCacheModel object) {
        DatabaseManager databaseManager = this.databaseManager;
        if (databaseManager != null) {
            ContentValues contentValues;
            databaseManager = databaseManager.openDatabase();
            ContentValues contentValues2 = contentValues;
            contentValues2();
            contentValues.put("trace_id", Long.valueOf(((ExecutionTraceCacheModel)object).getId()));
            contentValues.put("session_id", string);
            if (((ExecutionTraceCacheModel)object).getName() != null) {
                contentValues2.put("name", ((ExecutionTraceCacheModel)object).getName());
            }
            ContentValues contentValues3 = contentValues2;
            contentValues2.put("start_time", Long.valueOf(((ExecutionTraceCacheModel)object).getStartTime()));
            contentValues3.put("duration", Long.valueOf(((ExecutionTraceCacheModel)object).getDuration()));
            contentValues3.put("started_on_background", Integer.valueOf(((ExecutionTraceCacheModel)object).startedInBackground() ? 1 : 0));
            contentValues3.put("ended_on_background", Integer.valueOf(((ExecutionTraceCacheModel)object).endedInBackground() ? 1 : 0));
            long l = databaseManager.insert("execution_traces", null, contentValues2);
            if (l != -1L && ((ExecutionTraceCacheModel)object).getName() != null && ((ExecutionTraceCacheModel)object).getAttrs() != null) {
                ExecutionTraceCacheModel executionTraceCacheModel = object;
                long l2 = executionTraceCacheModel.getId();
                object = executionTraceCacheModel.getName();
                Map<String, String> map = executionTraceCacheModel.getAttrs();
                this.setAttributes(l2, (String)object, map);
            }
            databaseManager.close();
            return l != -1L;
        }
        return false;
    }

    public void setAttribute(long l, @NonNull String string, @NonNull String string2, @Nullable String string3) {
        this.addAttribute(l, string2, string3);
    }

    public void setAttributes(long l, @NonNull String string, @NonNull Map<String, String> object) {
        for (Map.Entry entry : object.entrySet()) {
            String string2 = (String)entry.getKey();
            String string3 = (String)entry.getValue();
            this.setAttribute(l, string, string2, string3);
        }
    }

    @Override
    public void removeAll() {
        ExecutionTracesCacheHandlerImpl executionTracesCacheHandlerImpl = executionTracesCacheHandlerImpl.databaseManager;
        if (executionTracesCacheHandlerImpl != null) {
            SQLiteDatabaseWrapper sQLiteDatabaseWrapper = executionTracesCacheHandlerImpl.openDatabase();
            sQLiteDatabaseWrapper.execSQL("delete from execution_traces");
            sQLiteDatabaseWrapper.close();
        }
    }

    @Override
    public void removeUnEndedTraces() {
        if (this.databaseManager != null) {
            List<ExecutionTraceCacheModel> list = this.getTracesByQueryString("select * from execution_traces where duration = -1");
            if (list != null) {
                for (ExecutionTraceCacheModel executionTraceCacheModel : list) {
                    if (executionTraceCacheModel.getName() == null) continue;
                    String string = executionTraceCacheModel.getName();
                    this.apmLogger.logSDKError("Execution trace \"$s\" wasn't saved because it didn't end last session.".replace("$s", string));
                }
            }
            SQLiteDatabaseWrapper sQLiteDatabaseWrapper = this.databaseManager.openDatabase();
            sQLiteDatabaseWrapper.execSQL("delete from execution_traces where duration = -1");
            sQLiteDatabaseWrapper.close();
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Nullable
    public List<ExecutionTraceCacheModel> getExecutionTracesForSession(String string) {
        Throwable throwable2222222;
        block5: {
            Object object = this.databaseManager;
            if (object == null) return null;
            object = object.openDatabase();
            String string2 = "session_id = ? AND duration > ?";
            String[] stringArray = new String[2];
            String[] stringArray2 = stringArray;
            stringArray[0] = string;
            stringArray[1] = "0";
            string = null;
            string = object.query("execution_traces", null, string2, stringArray2, null, null, null);
            {
                catch (Throwable throwable2222222) {
                    break block5;
                }
                catch (Exception exception) {}
                {
                    this.apmLogger.logSDKError("DB execution a sql failed: " + exception.getMessage(), exception);
                    IBGDiagnostics.reportNonFatal((Throwable)exception, (String)("DB execution a sql failed: " + exception.getMessage()));
                    if (string == null) return null;
                }
                string.close();
                return null;
            }
            {
                DatabaseManager databaseManager = object;
                object = this.getTracesFromCursor((SQLiteDatabaseWrapper)object, (Cursor)string);
                databaseManager.close();
                if (string == null) return object;
            }
            string.close();
            return object;
        }
        if (string == null) throw throwable2222222;
        string.close();
        throw throwable2222222;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void trimTracesToLimit(long l) {
        Throwable throwable2222222;
        String string;
        block4: {
            if (this.databaseManager == null) return;
            String string2 = "trace_id IN (" + "SELECT trace_id FROM execution_traces ORDER BY start_time DESC LIMIT ? OFFSET ?" + ")";
            string = String.valueOf(l);
            String[] stringArray = new String[2];
            String[] stringArray2 = stringArray;
            stringArray[0] = "-1";
            stringArray[1] = string;
            string = this.databaseManager.openDatabase();
            string.delete("execution_traces", string2, stringArray2);
            {
                catch (Throwable throwable2222222) {
                    break block4;
                }
                catch (Exception exception) {}
                {
                    this.apmLogger.logSDKError("DB execution a sql failed: " + exception.getMessage(), exception);
                    IBGDiagnostics.reportNonFatal((Throwable)exception, (String)("DB execution a sql failed: " + exception.getMessage()));
                    if (string == null) return;
                }
                string.close();
                return;
            }
            string.close();
            return;
        }
        if (string == null) throw throwable2222222;
        string.close();
        throw throwable2222222;
    }

    @Override
    public int trimTracesToLimit(String string, long l) {
        if (((ExecutionTracesCacheHandlerImpl)((Object)string2)).databaseManager != null) {
            ExecutionTracesCacheHandlerImpl executionTracesCacheHandlerImpl = string2;
            String string2 = "session_id = ? AND trace_id NOT IN (" + "SELECT trace_id FROM execution_traces where session_id = ? ORDER BY start_time DESC LIMIT ?" + ")";
            String string3 = String.valueOf(l);
            String[] stringArray = new String[3];
            String[] stringArray2 = stringArray;
            stringArray[0] = string;
            stringArray[1] = string;
            stringArray[2] = string3;
            string = executionTracesCacheHandlerImpl.databaseManager.openDatabase();
            int n = string.delete("execution_traces", string2, stringArray2);
            string.close();
            return n;
        }
        return -1;
    }
}

