/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.apm.cache.handler.applaunch;

import android.annotation.SuppressLint;
import android.content.ContentValues;
import android.database.Cursor;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.collection.ArrayMap;
import com.instabug.apm.cache.handler.applaunch.AppLaunchCacheHandler;
import com.instabug.apm.cache.model.AppLaunchCacheModel;
import com.instabug.apm.di.ServiceLocator;
import com.instabug.apm.logger.internal.Logger;
import com.instabug.library.diagnostics.IBGDiagnostics;
import com.instabug.library.internal.storage.cache.db.DatabaseManager;
import com.instabug.library.internal.storage.cache.db.SQLiteDatabaseWrapper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class AppLaunchCacheHandlerImpl
implements AppLaunchCacheHandler {
    @Nullable
    private DatabaseManager databaseManager = ServiceLocator.getDatabaseManager();
    private Logger apmLogger = ServiceLocator.getApmLogger();
    private String[] updatableStagesKeys = new String[]{"eal_mus", "eal_mus_st"};

    @SuppressLint(value={"Range"})
    private ArrayList<AppLaunchCacheModel> getAppLaunchesFromCursor(SQLiteDatabaseWrapper sQLiteDatabaseWrapper, @Nullable Cursor cursor) {
        ArrayList<AppLaunchCacheModel> arrayList;
        ArrayList<AppLaunchCacheModel> arrayList2 = arrayList;
        arrayList = new ArrayList<AppLaunchCacheModel>();
        if (cursor != null) {
            while (cursor.moveToNext()) {
                AppLaunchCacheModel appLaunchCacheModel;
                AppLaunchCacheModel appLaunchCacheModel2;
                AppLaunchCacheModel appLaunchCacheModel3 = appLaunchCacheModel2 = appLaunchCacheModel;
                Cursor cursor2 = cursor;
                Cursor cursor3 = cursor;
                Cursor cursor4 = cursor;
                Cursor cursor5 = cursor;
                Cursor cursor6 = cursor;
                appLaunchCacheModel2();
                appLaunchCacheModel2.setId(cursor6.getLong(cursor6.getColumnIndex("app_launch_id")));
                appLaunchCacheModel2.setType(cursor5.getString(cursor5.getColumnIndex("name")));
                appLaunchCacheModel2.setScreenName(cursor4.getString(cursor4.getColumnIndex("screen_name")));
                appLaunchCacheModel2.setStartTime(cursor3.getLong(cursor3.getColumnIndex("start_time")));
                appLaunchCacheModel3.setDuration(cursor2.getLong(cursor2.getColumnIndex("duration")));
                appLaunchCacheModel.setStages(this.getAppLaunchStages(appLaunchCacheModel3.getId(), sQLiteDatabaseWrapper));
                arrayList2.add(appLaunchCacheModel);
            }
        }
        return arrayList2;
    }

    @Override
    public long insertAppLaunch(String object, AppLaunchCacheModel object22) {
        if (this.databaseManager != null && object22 != null) {
            ContentValues contentValues;
            AppLaunchCacheHandlerImpl appLaunchCacheHandlerImpl = this;
            appLaunchCacheHandlerImpl.apmLogger.logSDKProtected("inserting app launch");
            SQLiteDatabaseWrapper sQLiteDatabaseWrapper = appLaunchCacheHandlerImpl.databaseManager.openDatabase();
            ContentValues contentValues2 = contentValues;
            new ContentValues().put("session_id", (String)((Object)object));
            if (((AppLaunchCacheModel)object22).getType() != null) {
                contentValues2.put("name", ((AppLaunchCacheModel)object22).getType());
            }
            if (((AppLaunchCacheModel)object22).getScreenName() != null) {
                contentValues2.put("screen_name", ((AppLaunchCacheModel)object22).getScreenName());
            }
            contentValues2.put("start_time", Long.valueOf(((AppLaunchCacheModel)object22).getStartTime()));
            contentValues2.put("duration", Long.valueOf(((AppLaunchCacheModel)object22).getDuration()));
            long l = sQLiteDatabaseWrapper.insert("app_launch", null, contentValues2);
            if (((AppLaunchCacheModel)object22).getStages() != null) {
                for (Map.Entry<String, String> entry : ((AppLaunchCacheModel)object22).getStages().entrySet()) {
                    ContentValues contentValues3;
                    ContentValues contentValues4 = contentValues3;
                    contentValues4();
                    contentValues4.put("app_launch_id", Long.valueOf(l));
                    contentValues4.put("attribute_key", entry.getKey());
                    contentValues3.put("attribute_value", entry.getValue());
                    sQLiteDatabaseWrapper.insert("app_launch_attributes", null, contentValues4);
                }
            }
            sQLiteDatabaseWrapper.close();
            this.apmLogger.logSDKProtected("inserting app launch done with id " + l);
            return l;
        }
        return -1L;
    }

    @SuppressLint(value={"Range"})
    @Nullable
    public Map<String, String> getAppLaunchStages(long l, @Nullable SQLiteDatabaseWrapper sQLiteDatabaseWrapper) {
        AppLaunchCacheHandlerImpl appLaunchCacheHandlerImpl = appLaunchCacheHandlerImpl.databaseManager;
        if (appLaunchCacheHandlerImpl != null) {
            ArrayMap arrayMap;
            boolean bl = sQLiteDatabaseWrapper != null;
            if (!bl) {
                sQLiteDatabaseWrapper = appLaunchCacheHandlerImpl.openDatabase();
            }
            appLaunchCacheHandlerImpl = arrayMap;
            arrayMap = new ArrayMap();
            String string = "select * from app_launch_attributes where app_launch_id = " + l;
            if (sQLiteDatabaseWrapper != null && (string = sQLiteDatabaseWrapper.rawQuery(string, null)) != null) {
                while (string.moveToNext()) {
                    String string2 = string;
                    String string3 = string2.getString(string2.getColumnIndex("attribute_key"));
                    appLaunchCacheHandlerImpl.put(string3, string2.getString(string2.getColumnIndex("attribute_value")));
                }
                string.close();
            }
            if (!bl && sQLiteDatabaseWrapper != null) {
                sQLiteDatabaseWrapper.close();
            }
            return appLaunchCacheHandlerImpl;
        }
        return null;
    }

    @Override
    public void removeAppLaunches(@NonNull String string) {
        DatabaseManager databaseManager = databaseManager.databaseManager;
        if (databaseManager != null) {
            SQLiteDatabaseWrapper sQLiteDatabaseWrapper = databaseManager.openDatabase();
            DatabaseManager databaseManager2 = new String[1];
            databaseManager = databaseManager2;
            databaseManager2[0] = string;
            sQLiteDatabaseWrapper.delete("app_launch", "name = ? ", (String[])databaseManager);
            sQLiteDatabaseWrapper.close();
        }
    }

    @Override
    public void removeAll() {
        AppLaunchCacheHandlerImpl appLaunchCacheHandlerImpl = appLaunchCacheHandlerImpl.databaseManager;
        if (appLaunchCacheHandlerImpl != null) {
            SQLiteDatabaseWrapper sQLiteDatabaseWrapper = appLaunchCacheHandlerImpl.openDatabase();
            sQLiteDatabaseWrapper.execSQL("delete from app_launch_attributes");
            sQLiteDatabaseWrapper.execSQL("delete from app_launch");
            sQLiteDatabaseWrapper.close();
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Nullable
    public List<AppLaunchCacheModel> getAppLaunchesForSession(String string) {
        Throwable throwable2222222;
        block5: {
            Object object = this.databaseManager;
            if (object == null) return null;
            object = object.openDatabase();
            String string2 = "session_id = ?";
            String[] stringArray = new String[1];
            String[] stringArray2 = stringArray;
            stringArray[0] = string;
            string = null;
            string = object.query("app_launch", null, string2, stringArray2, null, null, null);
            {
                catch (Throwable throwable2222222) {
                    break block5;
                }
                catch (Exception exception) {}
                {
                    this.apmLogger.logSDKError("Error while getting app launches for session: " + exception.getMessage(), exception);
                    IBGDiagnostics.reportNonFatal((Throwable)exception, (String)("Error while getting app launches for session: " + exception.getMessage()));
                    if (string == null) return null;
                }
                string.close();
                return null;
            }
            {
                DatabaseManager databaseManager = object;
                object = this.getAppLaunchesFromCursor((SQLiteDatabaseWrapper)object, (Cursor)string);
                databaseManager.close();
                if (string == null) return object;
            }
            string.close();
            return object;
        }
        if (string == null) throw throwable2222222;
        string.close();
        throw throwable2222222;
    }

    @Override
    public void trimAppLaunchesToLimit(long l, String string) {
        if (this.databaseManager != null) {
            String string2 = "app_launch_id IN (" + "SELECT app_launch_id FROM app_launch WHERE name = ? ORDER BY app_launch_id DESC LIMIT ? OFFSET ?" + ")";
            String string3 = String.valueOf(l);
            String[] stringArray = new String[3];
            String[] stringArray2 = stringArray;
            stringArray[0] = string;
            stringArray[1] = "-1";
            stringArray[2] = string3;
            try {
                this.databaseManager.openDatabase().delete("app_launch", string2, stringArray2);
            }
            catch (Exception exception) {
                this.apmLogger.logSDKError("Error while trimming app launches: " + exception.getMessage(), exception);
                IBGDiagnostics.reportNonFatal((Throwable)exception, (String)("Error while trimming app launches: " + exception.getMessage()));
            }
        }
    }

    @Override
    public int trimAppLaunchesToLimit(String string, long l, String string2) {
        if (this.databaseManager != null) {
            String string3 = "session_id = ? AND name = ? AND app_launch_id NOT IN (" + "SELECT app_launch_id FROM app_launch where session_id = ? AND name = ? ORDER BY app_launch_id DESC LIMIT ?" + ")";
            String string4 = String.valueOf(l);
            String[] stringArray = new String[5];
            String[] stringArray2 = stringArray;
            stringArray[0] = string;
            stringArray[1] = string2;
            stringArray[2] = string;
            stringArray[3] = string2;
            stringArray[4] = string4;
            try {
                return this.databaseManager.openDatabase().delete("app_launch", string3, stringArray2);
            }
            catch (Exception exception) {
                this.apmLogger.logSDKError("Error while trimming app launches: " + exception.getMessage(), exception);
                IBGDiagnostics.reportNonFatal((Throwable)exception, (String)("Error while trimming app launches: " + exception.getMessage()));
            }
        }
        return -1;
    }

    @Override
    public void updateAppLaunch(AppLaunchCacheModel appLaunchCacheModel) {
        if (this.databaseManager != null && appLaunchCacheModel != null) {
            ContentValues contentValues;
            AppLaunchCacheHandlerImpl appLaunchCacheHandlerImpl = this;
            appLaunchCacheHandlerImpl.apmLogger.logSDKProtected("updating app launch");
            SQLiteDatabaseWrapper sQLiteDatabaseWrapper = appLaunchCacheHandlerImpl.databaseManager.openDatabase();
            Object object = contentValues;
            contentValues = new ContentValues();
            if (appLaunchCacheModel.getScreenName() != null) {
                object.put("screen_name", appLaunchCacheModel.getScreenName());
            }
            object.put("duration", Long.valueOf(appLaunchCacheModel.getDuration()));
            String[] stringArray = String.valueOf(appLaunchCacheModel.getId());
            String[] stringArray2 = new String[1];
            String[] stringArray3 = stringArray2;
            stringArray2[0] = stringArray;
            sQLiteDatabaseWrapper.update("app_launch", (ContentValues)object, "app_launch_id = ?", stringArray3);
            object = appLaunchCacheModel.getStages();
            if (object != null) {
                stringArray = this.updatableStagesKeys;
                int n = this.updatableStagesKeys.length;
                for (int i = 0; i < n; ++i) {
                    ContentValues contentValues2;
                    ContentValues contentValues3;
                    String string = stringArray[i];
                    if (!object.containsKey(string)) continue;
                    ContentValues contentValues4 = contentValues3 = contentValues2;
                    contentValues3();
                    contentValues4.put("app_launch_id", Long.valueOf(appLaunchCacheModel.getId()));
                    contentValues4.put("attribute_key", string);
                    contentValues2.put("attribute_value", (String)object.get(string));
                    sQLiteDatabaseWrapper.insert("app_launch_attributes", null, contentValues3);
                }
            }
            sQLiteDatabaseWrapper.close();
            this.apmLogger.logSDKProtected("updating app launch done with id: " + appLaunchCacheModel.getId());
        }
    }
}

