/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.apm.appflow.validate;

import com.instabug.apm.appflow.log.LoggerExtKt;
import com.instabug.apm.appflow.model.AppFlowAttribute;
import com.instabug.apm.logger.internal.Logger;
import com.instabug.apm.sanitization.Validator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\n\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001d\u0012\u000e\u0010\u0003\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0001\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0002H\u0016J\u0010\u0010\u000b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0002H\u0002J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0002H\u0002J\u001a\u0010\r\u001a\u00020\t2\b\u0010\u000e\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000f\u001a\u00020\u0004H\u0002J$\u0010\u0010\u001a\u00020\t2\b\u0010\u000e\u001a\u0004\u0018\u00010\u00042\b\u0010\u000f\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0011\u001a\u00020\u0004H\u0002J$\u0010\u0012\u001a\u00020\t2\b\u0010\u000e\u001a\u0004\u0018\u00010\u00042\b\u0010\u000f\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0011\u001a\u00020\u0004H\u0002R\u0016\u0010\u0003\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/instabug/apm/appflow/validate/AppFlowAttributeValidator;", "Lcom/instabug/apm/sanitization/Validator;", "Lcom/instabug/apm/appflow/model/AppFlowAttribute;", "appFLowNameValidator", "", "logger", "Lcom/instabug/apm/logger/internal/Logger;", "(Lcom/instabug/apm/sanitization/Validator;Lcom/instabug/apm/logger/internal/Logger;)V", "isValid", "", "item", "validateAttributeKey", "validateAttributeValue", "validateKeyLengthAndLogIfInvalid", "flowName", "key", "validateValueIsNotEmptyAndLogIfNot", "value", "validateValueLengthAndLogIfInvalid", "instabug-apm_defaultUiRelease"})
@SourceDebugExtension(value={"SMAP\nAppFlowAttributeValidator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AppFlowAttributeValidator.kt\ncom/instabug/apm/appflow/validate/AppFlowAttributeValidator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,63:1\n1#2:64\n*E\n"})
public final class AppFlowAttributeValidator
implements Validator<AppFlowAttribute> {
    @NotNull
    private final Validator<String> appFLowNameValidator;
    @NotNull
    private final Logger logger;

    public AppFlowAttributeValidator(@NotNull Validator<String> validator, @NotNull Logger logger2) {
        Intrinsics.checkNotNullParameter(validator, (String)"appFLowNameValidator");
        Intrinsics.checkNotNullParameter((Object)logger2, (String)"logger");
        this.appFLowNameValidator = validator;
        this.logger = logger2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean validateAttributeKey(AppFlowAttribute appFlowAttribute) {
        block5: {
            block4: {
                String string = appFlowAttribute.getKey();
                if (string == null || (string = ((Object)StringsKt.trim((CharSequence)string)).toString()) == null) break block4;
                if (string.length() <= 0) {
                    string = null;
                }
                if (string != null) break block5;
            }
            LoggerExtKt.logAttributeKeyIsNullOrEmpty(((AppFlowAttributeValidator)((Object)string)).logger, appFlowAttribute.getName());
            return false;
        }
        AppFlowAttributeValidator appFlowAttributeValidator = string;
        AppFlowAttribute appFlowAttribute2 = appFlowAttribute;
        String string = appFlowAttribute2.getName();
        boolean bl = appFlowAttributeValidator.validateKeyLengthAndLogIfInvalid(string, appFlowAttribute2.getKey());
        return bl;
    }

    private final boolean validateKeyLengthAndLogIfInvalid(String string, String string2) {
        boolean bl = string2.length() <= 30;
        AppFlowAttributeValidator appFlowAttributeValidator = !bl ? this : null;
        if (appFlowAttributeValidator != null) {
            LoggerExtKt.logAttributeKeyExceededMaxLength(this.logger, string, string2);
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean validateAttributeValue(AppFlowAttribute appFlowAttribute) {
        String string = appFlowAttribute.getValue();
        if (string == null) return true;
        if ((string = ((Object)StringsKt.trim((CharSequence)string)).toString()) == null) return true;
        AppFlowAttribute appFlowAttribute2 = appFlowAttribute;
        String string2 = appFlowAttribute2.getName();
        if (!((AppFlowAttributeValidator)this).validateValueIsNotEmptyAndLogIfNot(string2, appFlowAttribute2.getKey(), string)) return false;
        AppFlowAttribute appFlowAttribute3 = appFlowAttribute;
        if (!((AppFlowAttributeValidator)this).validateValueLengthAndLogIfInvalid((String)(this = appFlowAttribute3.getName()), appFlowAttribute3.getKey(), string)) return false;
        return true;
    }

    private final boolean validateValueIsNotEmptyAndLogIfNot(String string, String string2, String string3) {
        boolean bl = string3.length() > 0;
        AppFlowAttributeValidator appFlowAttributeValidator = !bl ? this : null;
        if (appFlowAttributeValidator != null) {
            LoggerExtKt.logAttributeValueIsEmpty(this.logger, string, string2);
        }
        return bl;
    }

    private final boolean validateValueLengthAndLogIfInvalid(String string, String string2, String string3) {
        boolean bl = string3.length() <= 60;
        AppFlowAttributeValidator appFlowAttributeValidator = !bl ? this : null;
        if (appFlowAttributeValidator != null) {
            LoggerExtKt.logAttributeValueExceededMaxLength(this.logger, string, string2);
        }
        return bl;
    }

    @Override
    public boolean isValid(@NotNull AppFlowAttribute appFlowAttribute) {
        Intrinsics.checkNotNullParameter((Object)appFlowAttribute, (String)"item");
        return this.appFLowNameValidator.isValid(appFlowAttribute.getName()) && this.validateAttributeKey(appFlowAttribute) && this.validateAttributeValue(appFlowAttribute);
    }
}

