/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.apm.appflow.usecases;

import com.instabug.apm.appflow.handler.AppFlowHandler;
import com.instabug.apm.appflow.log.LoggerExtKt;
import com.instabug.apm.appflow.usecases.UseCase;
import com.instabug.apm.appflow.validate.SanitizerKtxKt;
import com.instabug.apm.appflow.validate.ValidatorKtxKt;
import com.instabug.apm.logger.internal.Logger;
import com.instabug.apm.model.TimeCaptureBoundModel;
import com.instabug.apm.model.TimeCaptureBoundModelKt;
import com.instabug.apm.sanitization.Sanitizer;
import com.instabug.apm.sanitization.Validator;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0010\u000b\n\u0002\b\u000e\u0018\u00002\u0016\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0002\u0012\u0004\u0012\u00020\u00040\u0001BY\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\n\u0012\u000e\u0010\u000b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\n\u0012\u000e\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\r\u0012\u0014\u0010\u000e\u001a\u0010\u0012\u0004\u0012\u00020\u000f\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u0001\u00a2\u0006\u0002\u0010\u0011J\u001d\u0010\u0012\u001a\u0004\u0018\u00010\u00102\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u0002\u00a2\u0006\u0002\u0010\u0014J\u0019\u0010\u0015\u001a\u00020\u00042\u000e\u0010\u0016\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0002H\u0096\u0002J\u0019\u0010\u0017\u001a\u0004\u0018\u00010\u00042\b\u0010\u0018\u001a\u0004\u0018\u00010\u0003H\u0002\u00a2\u0006\u0002\u0010\u0019J \u0010\u001a\u001a\u00020\u00102\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\b\u0010\u001c\u001a\u0004\u0018\u00010\u0003H\u0002J\b\u0010\u001d\u001a\u00020\u0010H\u0002R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000e\u001a\u0010\u0012\u0004\u0012\u00020\u000f\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/instabug/apm/appflow/usecases/EndAppFlowUseCase;", "Lcom/instabug/apm/appflow/usecases/UseCase;", "Lcom/instabug/apm/model/TimeCaptureBoundModel;", "", "", "handler", "Lcom/instabug/apm/appflow/handler/AppFlowHandler;", "logger", "Lcom/instabug/apm/logger/internal/Logger;", "configurationsValidator", "Lcom/instabug/apm/sanitization/Validator;", "flowNameValidator", "flowNameSanitizer", "Lcom/instabug/apm/sanitization/Sanitizer;", "refreshBackgroundFlowUseCase", "", "", "(Lcom/instabug/apm/appflow/handler/AppFlowHandler;Lcom/instabug/apm/logger/internal/Logger;Lcom/instabug/apm/sanitization/Validator;Lcom/instabug/apm/sanitization/Validator;Lcom/instabug/apm/sanitization/Sanitizer;Lcom/instabug/apm/appflow/usecases/UseCase;)V", "endAppFlow", "nameModel", "(Lcom/instabug/apm/model/TimeCaptureBoundModel;)Ljava/lang/Boolean;", "invoke", "param", "logNoFlowFoundWithTheProvidedName", "name", "(Ljava/lang/String;)Lkotlin/Unit;", "passedAbandonmentThreshold", "timeBoundModel", "originalName", "validateConfigurations", "instabug-apm_defaultUiRelease"})
@SourceDebugExtension(value={"SMAP\nEndAppFlowUseCase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EndAppFlowUseCase.kt\ncom/instabug/apm/appflow/usecases/EndAppFlowUseCase\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,50:1\n1#2:51\n*E\n"})
public final class EndAppFlowUseCase
implements UseCase<TimeCaptureBoundModel<String>, Unit> {
    @NotNull
    private final AppFlowHandler handler;
    @NotNull
    private final Logger logger;
    @NotNull
    private final Validator<Unit> configurationsValidator;
    @NotNull
    private final Validator<String> flowNameValidator;
    @NotNull
    private final Sanitizer<String> flowNameSanitizer;
    @NotNull
    private final UseCase<Long, Boolean> refreshBackgroundFlowUseCase;

    public EndAppFlowUseCase(@NotNull AppFlowHandler appFlowHandler, @NotNull Logger logger2, @NotNull Validator<Unit> validator, @NotNull Validator<String> validator2, @NotNull Sanitizer<String> sanitizer, @NotNull UseCase<Long, Boolean> useCase) {
        Intrinsics.checkNotNullParameter((Object)appFlowHandler, (String)"handler");
        Intrinsics.checkNotNullParameter((Object)logger2, (String)"logger");
        Intrinsics.checkNotNullParameter(validator, (String)"configurationsValidator");
        Intrinsics.checkNotNullParameter(validator2, (String)"flowNameValidator");
        Intrinsics.checkNotNullParameter(sanitizer, (String)"flowNameSanitizer");
        Intrinsics.checkNotNullParameter(useCase, (String)"refreshBackgroundFlowUseCase");
        this.handler = appFlowHandler;
        this.logger = logger2;
        this.configurationsValidator = validator;
        this.flowNameValidator = validator2;
        this.flowNameSanitizer = sanitizer;
        this.refreshBackgroundFlowUseCase = useCase;
    }

    private final boolean passedAbandonmentThreshold(TimeCaptureBoundModel<String> timeCaptureBoundModel, String string) {
        boolean bl = Intrinsics.areEqual((Object)this.refreshBackgroundFlowUseCase.invoke(timeCaptureBoundModel.getTimeCapture().getTimeStampMillis()), (Object)Boolean.TRUE);
        if (bl) {
            this.logNoFlowFoundWithTheProvidedName(string);
        }
        return bl;
    }

    private final Unit logNoFlowFoundWithTheProvidedName(String string) {
        Unit unit;
        if (string != null) {
            LoggerExtKt.logFlowNotEndedNoMatchingActiveFlow(this.logger, string);
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        return unit;
    }

    private final boolean validateConfigurations() {
        return this.configurationsValidator.isValid(Unit.INSTANCE);
    }

    private final Boolean endAppFlow(TimeCaptureBoundModel<String> timeCaptureBoundModel) {
        return this.handler.end(timeCaptureBoundModel.getModel(), timeCaptureBoundModel.getTimeCapture().getMicroTime());
    }

    @Override
    public void invoke(@NotNull TimeCaptureBoundModel<String> object) {
        Intrinsics.checkNotNullParameter(object, (String)"param");
        Object object2 = this.validateConfigurations() ? this : null;
        if (object2 != null) {
            object2 = ValidatorKtxKt.isBoundModelValid(this.flowNameValidator, object) ? object : null;
            if (object2 != null && (object2 = SanitizerKtxKt.sanitizeBoundModel(this.flowNameSanitizer, object2)) != null && (object2 = TimeCaptureBoundModelKt.takeIfModelNotNull(object2)) != null) {
                if (this.passedAbandonmentThreshold((TimeCaptureBoundModel<String>)object2, (String)((TimeCaptureBoundModel)object).getModel())) {
                    object2 = null;
                }
                if (object2 != null && (object2 = this.endAppFlow((TimeCaptureBoundModel<String>)object2)) != null) {
                    if (((Boolean)object2).booleanValue()) {
                        object2 = null;
                    }
                    if (object2 != null && (object = ((TimeCaptureBoundModel)object).getModel()) != null) {
                        this.logNoFlowFoundWithTheProvidedName((String)object);
                    }
                }
            }
        }
    }
}

