/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.apm;

import android.annotation.SuppressLint;
import android.app.Application;
import android.content.Context;
import android.os.Build;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import com.instabug.apm.appflow.di.AppFlowServiceLocator;
import com.instabug.apm.appflow.manager.AppFlowManager;
import com.instabug.apm.compose.compose_spans.ComposeSpansManager;
import com.instabug.apm.compose.compose_spans.ComposeSpansServiceLocator;
import com.instabug.apm.configuration.APMConfigurationProvider;
import com.instabug.apm.di.ServiceLocator;
import com.instabug.apm.eventbus.APMSdkStateEventBus;
import com.instabug.apm.handler.executiontraces.ExecutionTracesHandler;
import com.instabug.apm.handler.networklog.NetworkLogHandler;
import com.instabug.apm.handler.session.APMSessionObserver;
import com.instabug.apm.handler.session.APMUncaughtExceptionHandler;
import com.instabug.apm.handler.session.SessionHandler;
import com.instabug.apm.handler.session.SessionObserverHandler;
import com.instabug.apm.handler.uitrace.customuitraces.CustomUiTraceHandler;
import com.instabug.apm.lifecycle.ActivityCallbacks;
import com.instabug.apm.logger.internal.Logger;
import com.instabug.apm.model.EventTimeMetricCapture;
import com.instabug.apm.screenloading.di.ScreenLoadingServiceLocator;
import com.instabug.apm.screenloading.manager.ScreenLoadingManager;
import com.instabug.apm.sync.APMSyncManager;
import com.instabug.apm.uitrace.di.UiTracesServiceLocator;
import com.instabug.apm.uitrace.manager.UiTracesManager;
import com.instabug.apm.v3_session_data_readiness.APMSessionReadinessManager;
import com.instabug.apm.webview.webview_trace.manager.WebViewTraceManager;
import com.instabug.library.BuildFieldsProvider;
import com.instabug.library.InstabugState;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.core.eventbus.InstabugStateEventBus;
import com.instabug.library.core.eventbus.NDKSessionCrashedEvent;
import com.instabug.library.core.eventbus.coreeventbus.IBGCoreEventSubscriber;
import com.instabug.library.core.eventbus.coreeventbus.IBGSdkCoreEvent;
import com.instabug.library.core.eventbus.eventpublisher.IBGCompositeDisposable;
import com.instabug.library.core.eventbus.eventpublisher.IBGDisposable;
import com.instabug.library.core.plugin.Plugin;
import com.instabug.library.model.common.Session;
import com.instabug.library.sessionV3.providers.FeatureSessionDataController;
import com.instabug.library.sessionV3.providers.FeatureSessionDataControllerHost;
import com.instabug.library.sessionV3.providers.FeatureSessionLazyDataProvider;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.threading.PoolProvider;
import io.reactivexport.disposables.CompositeDisposable;
import io.reactivexport.functions.Consumer;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class APMPlugin
extends Plugin
implements APMSessionObserver,
FeatureSessionDataControllerHost,
FeatureSessionLazyDataProvider {
    public static final Object lock = new Object();
    private boolean isFirstLaunch = false;
    private final SessionHandler sessionHandler = ServiceLocator.getSessionHandler();
    private final Logger apmLogger = ServiceLocator.getApmLogger();
    @Nullable
    private CompositeDisposable sdkCoreEventsSubscriberDisposable;
    @Nullable
    IBGCompositeDisposable compositeDisposable;
    @Nullable
    @VisibleForTesting
    IBGDisposable apmSdkStateObserver;

    private void handleAppFlowsAppLaunch() {
        AppFlowManager appFlowManager = AppFlowServiceLocator.INSTANCE.getManager();
        if (appFlowManager != null) {
            appFlowManager.onNewAppLaunch();
        }
    }

    private static void registerDataReadinessHandlers() {
        APMSessionReadinessManager[] aPMSessionReadinessManagerArray = ServiceLocator.getAPMSessionReadinessManagersProvider().invoke();
        if (aPMSessionReadinessManagerArray == null) {
            return;
        }
        for (APMSessionReadinessManager aPMSessionReadinessManager : aPMSessionReadinessManagerArray) {
            if (aPMSessionReadinessManager == null) continue;
            aPMSessionReadinessManager.registerReadinessHandler();
        }
    }

    private void startApmSessionAndMetrics(@Nullable Session session) {
        if (session != null) {
            APMPlugin aPMPlugin = this;
            SessionObserverHandler.register(aPMPlugin);
            aPMPlugin.startSession(session);
            aPMPlugin.registerSessionCrashHandler();
            aPMPlugin.registerFragmentLifecycleEventListener();
            aPMPlugin.startComposeSpansManager();
            aPMPlugin.startAppFlowManager();
            aPMPlugin.startUiTracesManager();
            aPMPlugin.startScreenLoadingManager();
            aPMPlugin.registerAPMSdkStateEventBus();
        } else {
            this.apmLogger.logSDKError("APM session not created. Core session is null");
        }
    }

    private boolean shouldDependOnV3Session(APMConfigurationProvider aPMConfigurationProvider, @Nullable Session session) {
        return session != null && session.getVersion().equals("V2") && aPMConfigurationProvider.shouldDependOnV3Session();
    }

    private void unRegisterApmSDKStateEventBus() {
        IBGDisposable iBGDisposable = this.apmSdkStateObserver;
        if (iBGDisposable != null) {
            iBGDisposable.dispose();
            this.apmSdkStateObserver = null;
        }
    }

    private void registerFragmentLifecycleEventListener() {
        ServiceLocator.getFragmentSpansHelper().startFragmentsLifecycleCapturing();
    }

    private void startComposeSpansManager() {
        ComposeSpansManager composeSpansManager = ComposeSpansServiceLocator.INSTANCE.getComposeSpansManager();
        if (composeSpansManager != null) {
            composeSpansManager.start();
        }
    }

    private void startUiTracesManager() {
        UiTracesManager uiTracesManager = UiTracesServiceLocator.getManager();
        if (uiTracesManager != null) {
            uiTracesManager.start();
        }
    }

    private void startScreenLoadingManager() {
        ScreenLoadingManager screenLoadingManager = ScreenLoadingServiceLocator.getManager();
        if (screenLoadingManager != null) {
            screenLoadingManager.start();
        }
    }

    private void handleComposeSpansStateChange() {
        ComposeSpansManager composeSpansManager = ComposeSpansServiceLocator.INSTANCE.getComposeSpansManager();
        if (composeSpansManager != null) {
            composeSpansManager.onStateChanged();
        }
    }

    private void handleUiTracesStateChanged() {
        UiTracesManager uiTracesManager = UiTracesServiceLocator.getManager();
        if (uiTracesManager != null) {
            uiTracesManager.onStateChanged();
        }
    }

    private void handleScreenLoadingStateChanged() {
        ScreenLoadingManager screenLoadingManager = ScreenLoadingServiceLocator.getManager();
        if (screenLoadingManager != null) {
            screenLoadingManager.onStateChanged();
        }
    }

    private void handleWebViewTracesStateChange() {
        WebViewTraceManager webViewTraceManager = ServiceLocator.getWebViewTraceManager();
        if (webViewTraceManager != null) {
            webViewTraceManager.onStateChanged();
        }
    }

    private void startAppFlowManager() {
        AppFlowManager appFlowManager = AppFlowServiceLocator.INSTANCE.getManager();
        if (appFlowManager != null) {
            appFlowManager.start();
        }
    }

    private void handleAppFlowStateChange() {
        AppFlowManager appFlowManager = AppFlowServiceLocator.INSTANCE.getManager();
        if (appFlowManager != null) {
            appFlowManager.onStateChanged();
        }
    }

    private void unRegisterFragmentLifecycleEventListener() {
        ServiceLocator.getFragmentSpansHelper().stopFragmentsLifecycleCapturing();
    }

    private void registerSessionCrashHandler() {
        if (ServiceLocator.getApmConfigurationProvider().isCrashDetectionEnabled() && !(Thread.getDefaultUncaughtExceptionHandler() instanceof APMUncaughtExceptionHandler)) {
            InstabugSDKLogger.d((String)"IBG-APM", (String)"setting Uncaught Exception Handler APMUncaughtExceptionHandler");
            Thread.setDefaultUncaughtExceptionHandler(new APMUncaughtExceptionHandler());
        }
    }

    private void subscribeToSDKState() {
        CompositeDisposable compositeDisposable = this.sdkCoreEventsSubscriberDisposable;
        if (compositeDisposable == null || compositeDisposable.isDisposed()) {
            CompositeDisposable compositeDisposable2;
            compositeDisposable = compositeDisposable2;
            compositeDisposable2 = new CompositeDisposable();
            this.sdkCoreEventsSubscriberDisposable = compositeDisposable;
        }
        this.sdkCoreEventsSubscriberDisposable.add(InstabugStateEventBus.getInstance().getEventObservable().subscribe((Consumer)new Consumer<InstabugState>(){

            public void accept(InstabugState instabugState) {
                if (instabugState == InstabugState.DISABLED) {
                    1 v0 = this;
                    v0.APMPlugin.this.apmLogger.logSDKDebug("Instabug is disabled, purging APM data\u2026");
                    v0.APMPlugin.this.stopRunningMetrics();
                    v0.APMPlugin.this.endSession();
                    v0.APMPlugin.this.purgeData();
                }
            }
        }));
    }

    private void purgeData() {
        ServiceLocator.getApmConfigurationProvider().setLastSyncTime(-1L);
        final APMSyncManager aPMSyncManager = ServiceLocator.getApmSyncManager();
        final boolean bl = aPMSyncManager.shouldSync();
        ServiceLocator.getSingleThreadPoolExecutor("session_purging_thread_executor").execute(new Runnable(){

            @Override
            public void run() {
                aPMSyncManager.start(bl);
            }
        });
    }

    @SuppressLint(value={"NewApi"})
    private void stopRunningMetrics() {
        ServiceLocator.getNetworkLogHandler().forceStop();
        PoolProvider.postMainThreadTask(() -> {
            if (BuildFieldsProvider.INSTANCE.provideBuildVersion() >= 16) {
                APMPlugin.finalizeScreenLoadingCapturing();
                APMPlugin.endAutomaticUiTraces();
                CustomUiTraceHandler customUiTraceHandler = ServiceLocator.getCustomUiTraceHandler();
                if (customUiTraceHandler != null) {
                    customUiTraceHandler.forceStop();
                }
            }
        });
    }

    private static void endAutomaticUiTraces() {
        UiTracesManager uiTracesManager = UiTracesServiceLocator.getManager();
        if (uiTracesManager != null) {
            uiTracesManager.endAll();
        }
    }

    private static void finalizeScreenLoadingCapturing() {
        ScreenLoadingManager screenLoadingManager = ScreenLoadingServiceLocator.getManager();
        if (screenLoadingManager != null) {
            screenLoadingManager.endAll();
        }
    }

    private void clearInvalidCache() {
        final ExecutionTracesHandler executionTracesHandler = ServiceLocator.getExecutionTracesHandler();
        final NetworkLogHandler networkLogHandler = ServiceLocator.getNetworkLogHandler();
        ServiceLocator.getSingleThreadPoolExecutor("execution_traces_thread_executor").execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = lock;
                synchronized (object) {
                    executionTracesHandler.removeUnEndedTraces();
                    return;
                }
            }
        });
        ServiceLocator.getSingleThreadPoolExecutor("network_log_thread_executor").execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (ServiceLocator.getApmConfigurationProvider().isNetworkEnabled()) {
                    Object object = lock;
                    synchronized (object) {
                        networkLogHandler.cleanUp();
                    }
                }
            }
        });
    }

    private void registerConfigurationChange() {
        CompositeDisposable compositeDisposable = this.sdkCoreEventsSubscriberDisposable;
        if (compositeDisposable == null || compositeDisposable.isDisposed()) {
            CompositeDisposable compositeDisposable2;
            compositeDisposable = compositeDisposable2;
            compositeDisposable2 = new CompositeDisposable();
            this.sdkCoreEventsSubscriberDisposable = compositeDisposable;
        }
        APMPlugin aPMPlugin = this;
        aPMPlugin.sdkCoreEventsSubscriberDisposable.add(ServiceLocator.getOnSessionCrashedEventBus().subscribe((Consumer)new Consumer<NDKSessionCrashedEvent>(){

            public void accept(NDKSessionCrashedEvent nDKSessionCrashedEvent) {
                APMPlugin.this.sessionHandler.updateSessionEndReason(nDKSessionCrashedEvent.getSessionId(), TimeUnit.MILLISECONDS.toMicros(nDKSessionCrashedEvent.getSessionDuration()), 1);
            }
        }));
        aPMPlugin.getOrCreateCompositeDisposable().add(this.subscribeToSdkCoreEvents());
    }

    @NonNull
    private IBGDisposable subscribeToSdkCoreEvents() {
        return IBGCoreEventSubscriber.subscribe(this::handleCoreEvent);
    }

    private void handleCoreEvent(IBGSdkCoreEvent iBGSdkCoreEvent) {
        if (iBGSdkCoreEvent instanceof IBGSdkCoreEvent.V3Session) {
            this.handleV3SessionEvent((IBGSdkCoreEvent.V3Session)iBGSdkCoreEvent);
        } else if (iBGSdkCoreEvent instanceof IBGSdkCoreEvent.FeaturesFetched) {
            this.handleFeaturesFetched(((IBGSdkCoreEvent.FeaturesFetched)iBGSdkCoreEvent).getResponse());
        } else if (iBGSdkCoreEvent instanceof IBGSdkCoreEvent.CrossPlatformCrashed) {
            this.updateCurrentSession();
        } else if (iBGSdkCoreEvent instanceof IBGSdkCoreEvent.CrossPlatformScreenChanged) {
            this.handleCPScreenChanged((IBGSdkCoreEvent.CrossPlatformScreenChanged)iBGSdkCoreEvent);
        }
    }

    private void handleCPScreenChanged(IBGSdkCoreEvent.CrossPlatformScreenChanged crossPlatformScreenChanged) {
        EventTimeMetricCapture eventTimeMetricCapture;
        EventTimeMetricCapture eventTimeMetricCapture2 = eventTimeMetricCapture;
        eventTimeMetricCapture = new EventTimeMetricCapture();
        if (SettingsManager.getInstance().getCurrentPlatform() != 8) {
            PoolProvider.getFeaturesFlagsCheckerExecutor().execute(() -> {
                if (ServiceLocator.getApmConfigurationProvider().isUiTraceEnabled()) {
                    APMPlugin.onScreenChanged(crossPlatformScreenChanged, eventTimeMetricCapture2);
                }
            });
        }
    }

    private static void onScreenChanged(IBGSdkCoreEvent.CrossPlatformScreenChanged crossPlatformScreenChanged, EventTimeMetricCapture eventTimeMetricCapture) {
        UiTracesServiceLocator.getUiTracesExecutor().execute(() -> {
            crossPlatformScreenChanged = crossPlatformScreenChanged.getScreenName();
            UiTracesManager uiTracesManager = UiTracesServiceLocator.getManager();
            if (uiTracesManager != null) {
                EventTimeMetricCapture eventTimeMetricCapture2 = eventTimeMetricCapture;
                long l = eventTimeMetricCapture2.getTimeStampMicro();
                long l2 = eventTimeMetricCapture2.getTimeStampMillis();
                uiTracesManager.onScreenChangedSync((String)crossPlatformScreenChanged, l, l2);
            }
        });
    }

    private void handleFeaturesFetched(@NonNull String object) {
        boolean bl = ServiceLocator.getApmConfigurationHandler().handleConfiguration((String)object);
        object = ServiceLocator.getApmConfigurationProvider();
        object.setShouldDependOnV3Session(InstabugCore.isV3SessionEnabled());
        if (bl && object.isAPMEnabled()) {
            object = InstabugCore.getRunningSession();
            if (object != null) {
                APMPlugin aPMPlugin = this;
                SessionObserverHandler.register(aPMPlugin);
                aPMPlugin.startSession((Session)object);
                aPMPlugin.registerSessionCrashHandler();
            }
            APMPlugin aPMPlugin = this;
            aPMPlugin.registerActivityLifeCycleCallbacks();
            aPMPlugin.registerSessionCrashHandler();
            aPMPlugin.registerFragmentLifecycleEventListener();
        }
        APMPlugin aPMPlugin = this;
        aPMPlugin.handleComposeSpansStateChange();
        aPMPlugin.handleUiTracesStateChanged();
        aPMPlugin.handleScreenLoadingStateChanged();
        aPMPlugin.handleWebViewTracesStateChange();
        aPMPlugin.handleAppFlowStateChange();
    }

    private void handleV3SessionEvent(IBGSdkCoreEvent.V3Session v3Session) {
        if (v3Session instanceof IBGSdkCoreEvent.V3Session.V3SessionStarted) {
            this.startApmSessionAndMetrics(InstabugCore.getRunningSession());
        } else if (v3Session instanceof IBGSdkCoreEvent.V3Session.V3SessionFinished) {
            this.endSession();
        }
    }

    private void updateCurrentSession() {
        ServiceLocator.getSyncThreadExecutor().execute(new Runnable(){

            @Override
            public void run() {
                if (InstabugCore.getRunningSession() != null) {
                    APMPlugin.this.sessionHandler.endSession(1);
                }
            }
        });
    }

    private void registerActivityLifeCycleCallbacks() {
        ActivityCallbacks activityCallbacks;
        if (ServiceLocator.getApmConfigurationProvider().isAPMEnabled() && (this = ServiceLocator.getContext()) != null && !ActivityCallbacks.isRegistered() && (activityCallbacks = ServiceLocator.getActivityCallbacks((Context)this, false)) != null) {
            ((Application)this.getApplicationContext()).registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)activityCallbacks);
        }
    }

    private void startSession(@NonNull Session session) {
        if (InstabugCore.isV3SessionEnabled() && !session.getVersion().equals("V3")) {
            return;
        }
        this.sessionHandler.startSession(session);
    }

    private void endSession() {
        this.sessionHandler.endSession(0);
    }

    private void handleFragmentsOnNewSession(String string) {
        ServiceLocator.getFragmentSpansHelper().onNewSessionStarted(string);
    }

    @NonNull
    private IBGCompositeDisposable getOrCreateCompositeDisposable() {
        IBGCompositeDisposable iBGCompositeDisposable = this.compositeDisposable;
        if (iBGCompositeDisposable == null) {
            IBGCompositeDisposable iBGCompositeDisposable2;
            iBGCompositeDisposable = iBGCompositeDisposable2;
            iBGCompositeDisposable2 = new IBGCompositeDisposable();
            this.compositeDisposable = iBGCompositeDisposable;
        }
        return iBGCompositeDisposable;
    }

    public void init(Context context) {
        APMPlugin aPMPlugin = this;
        super.init(context);
        APMPlugin.registerDataReadinessHandlers();
        aPMPlugin.handleAppFlowsAppLaunch();
    }

    public void wake() {
        APMConfigurationProvider aPMConfigurationProvider = ServiceLocator.getApmConfigurationProvider();
        if (aPMConfigurationProvider.isAPMEnabled() && this.isFirstLaunch) {
            this.clearInvalidCache();
            this.isFirstLaunch = false;
        }
        if (this.shouldDependOnV3Session(aPMConfigurationProvider, (Session)(aPMConfigurationProvider = InstabugCore.getRunningSession()))) {
            this.apmLogger.d("v2 trying to start apm session while v3 enabled.. skipping");
            return;
        }
        this.startApmSessionAndMetrics((Session)aPMConfigurationProvider);
    }

    @VisibleForTesting
    void registerAPMSdkStateEventBus() {
        if (this.apmSdkStateObserver == null) {
            this.apmSdkStateObserver = APMSdkStateEventBus.INSTANCE.subscribe(bl -> {
                if (bl.booleanValue()) {
                    this.registerFragmentLifecycleEventListener();
                } else {
                    this.unRegisterFragmentLifecycleEventListener();
                }
                APMPlugin aPMPlugin = this;
                aPMPlugin.handleComposeSpansStateChange();
                aPMPlugin.handleUiTracesStateChanged();
                aPMPlugin.handleScreenLoadingStateChanged();
                aPMPlugin.handleWebViewTracesStateChange();
                aPMPlugin.handleAppFlowStateChange();
            });
        }
    }

    public void stop() {
        CompositeDisposable compositeDisposable = this.sdkCoreEventsSubscriberDisposable;
        if (compositeDisposable != null && !compositeDisposable.isDisposed()) {
            this.sdkCoreEventsSubscriberDisposable.dispose();
        }
        if ((this = this.compositeDisposable) != null) {
            this.dispose();
        }
    }

    public void sleep() {
        APMPlugin aPMPlugin = this;
        aPMPlugin.unRegisterApmSDKStateEventBus();
        aPMPlugin.endSession();
    }

    public void start(Context context) {
        APMPlugin aPMPlugin = this;
        aPMPlugin.isFirstLaunch = true;
        aPMPlugin.registerConfigurationChange();
        aPMPlugin.subscribeToSDKState();
        if (Build.VERSION.SDK_INT < 16) {
            this.apmLogger.logSDKError("Could not enable Auto UI Trace. Feature is supported on API level 16 and up only.");
        }
    }

    public long getLastActivityTime() {
        return 0L;
    }

    @Override
    @WorkerThread
    public void onNewSessionStarted(@NonNull Session session, @Nullable Session session2) {
        if (session2 != null) {
            ServiceLocator.getNetworkLogMigrationHandler().migrate(session, session2);
            ServiceLocator.getExecutionTracesMigrationHandler().migrate(session, session2);
        }
        this.handleFragmentsOnNewSession(session.getId());
        ServiceLocator.getApmSyncManager().start();
    }

    public boolean isFeatureEnabled() {
        return ServiceLocator.getApmConfigurationProvider().isAPMEnabled();
    }

    @NonNull
    public FeatureSessionDataController getSessionDataController() {
        return ServiceLocator.getSessionDataController();
    }

    @NonNull
    public Map<String, Boolean> isDataReady(@NonNull List<String> list) {
        return ServiceLocator.getAPMSessionLazyDataProvider().isDataReady(list);
    }
}

