/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.apm;

import android.annotation.SuppressLint;
import android.app.Application;
import android.content.Context;
import android.os.Build;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.instabug.apm.f.d.b;
import com.instabug.apm.f.d.c;
import com.instabug.apm.f.d.e;
import com.instabug.library.InstabugState;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.core.eventbus.InstabugStateEventBus;
import com.instabug.library.core.eventbus.coreeventbus.SDKCoreEvent;
import com.instabug.library.core.eventbus.coreeventbus.SDKCoreEventSubscriber;
import com.instabug.library.core.plugin.Plugin;
import com.instabug.library.model.common.Session;
import com.instabug.library.util.threading.PoolProvider;
import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.functions.Consumer;

public class APMPlugin
extends Plugin
implements com.instabug.apm.f.d.a {
    private boolean isFirstLaunch = false;
    private final c sessionHandler = com.instabug.apm.e.a.D();
    private final com.instabug.apm.logger.a.a apmLogger = com.instabug.apm.e.a.d();
    @Nullable
    private CompositeDisposable sdkCoreEventsSubscriberDisposable;

    private void registerSessionCrashHandler() {
        if (com.instabug.apm.e.a.b().s() && !(Thread.getDefaultUncaughtExceptionHandler() instanceof b)) {
            Thread.setDefaultUncaughtExceptionHandler(new b());
        }
    }

    private void subscribeToSDKState() {
        CompositeDisposable compositeDisposable = this.sdkCoreEventsSubscriberDisposable;
        if (compositeDisposable == null || compositeDisposable.isDisposed()) {
            CompositeDisposable compositeDisposable2;
            compositeDisposable = compositeDisposable2;
            compositeDisposable2 = new CompositeDisposable();
            this.sdkCoreEventsSubscriberDisposable = compositeDisposable;
        }
        this.sdkCoreEventsSubscriberDisposable.add(InstabugStateEventBus.getInstance().getEventObservable().subscribe((Consumer)new Consumer<InstabugState>(){

            public void a(InstabugState instabugState) throws Exception {
                if (instabugState == InstabugState.DISABLED) {
                    a a2 = this;
                    a2.APMPlugin.this.apmLogger.d("Instabug is disabled, purging APM data\u2026");
                    a2.APMPlugin.this.stopRunningMetrics();
                    a2.APMPlugin.this.endSession();
                    a2.APMPlugin.this.purgeData();
                }
            }
        }));
    }

    private void purgeData() {
        com.instabug.apm.e.a.b().j(-1L);
        final com.instabug.apm.i.a a2 = com.instabug.apm.e.a.f();
        final boolean bl = a2.b();
        com.instabug.apm.e.a.a("session_purging_thread_executor").execute(new Runnable(this){

            @Override
            public void run() {
                a2.a(bl);
            }
        });
    }

    private void stopRunningMetrics() {
        com.instabug.apm.e.a.v().b();
        com.instabug.apm.e.a.z().b();
        PoolProvider.postMainThreadTask((Runnable)new Runnable(this){

            @Override
            public void run() {
                if (Build.VERSION.SDK_INT >= 16) {
                    com.instabug.apm.e.a.k().b();
                    com.instabug.apm.e.a.n().b();
                }
            }
        });
    }

    private void clearInvalidCache() {
        final com.instabug.apm.f.b.a a2 = com.instabug.apm.e.a.v();
        final com.instabug.apm.f.c.a a3 = com.instabug.apm.e.a.z();
        com.instabug.apm.e.a.a("execution_traces_thread_executor").execute(new Runnable(this){

            @Override
            public void run() {
                a2.c();
            }
        });
        com.instabug.apm.e.a.a("network_log_thread_executor").execute(new Runnable(this){

            @Override
            public void run() {
                if (com.instabug.apm.e.a.b().p()) {
                    a3.c();
                }
            }
        });
    }

    private void registerConfigurationChange() {
        CompositeDisposable compositeDisposable = this.sdkCoreEventsSubscriberDisposable;
        if (compositeDisposable == null || compositeDisposable.isDisposed()) {
            CompositeDisposable compositeDisposable2;
            compositeDisposable = compositeDisposable2;
            compositeDisposable2 = new CompositeDisposable();
            this.sdkCoreEventsSubscriberDisposable = compositeDisposable;
        }
        this.sdkCoreEventsSubscriberDisposable.add(SDKCoreEventSubscriber.subscribe((Consumer)new Consumer<SDKCoreEvent>(){

            @SuppressLint(value={"NULL_DEREFERENCE"})
            public void a(SDKCoreEvent sDKCoreEvent) {
                if (sDKCoreEvent.getType().equals("featuresFetched")) {
                    if (com.instabug.apm.e.a.a().a(sDKCoreEvent.getValue())) {
                        sDKCoreEvent = InstabugCore.getRunningSession();
                        if (sDKCoreEvent != null) {
                            f f2 = this;
                            e.a(f2.APMPlugin.this);
                            APMPlugin.access$400(f2.APMPlugin.this, (Session)sDKCoreEvent);
                            f2.APMPlugin.this.registerSessionCrashHandler();
                        }
                        f f3 = this;
                        f3.APMPlugin.this.registerActivityLifeCycleCallbacks();
                        f3.APMPlugin.this.registerSessionCrashHandler();
                    }
                } else if (sDKCoreEvent.getType().equals("cross_platform_state_screen_changed")) {
                    if (Build.VERSION.SDK_INT >= 16) {
                        com.instabug.apm.e.a.l().a(sDKCoreEvent.getValue());
                    }
                } else if (sDKCoreEvent.getType().equals("cross_platform_crashed")) {
                    APMPlugin.this.updateCurrentSession();
                }
            }
        }));
    }

    private void updateCurrentSession() {
        com.instabug.apm.e.a.a("session_thread_executor").execute(new Runnable(){

            @Override
            public void run() {
                if (InstabugCore.getRunningSession() != null) {
                    APMPlugin.this.sessionHandler.b(1);
                }
            }
        });
    }

    private void registerActivityLifeCycleCallbacks() {
        if (com.instabug.apm.e.a.b().c() && (this = com.instabug.apm.e.a.m()) != null && !com.instabug.apm.g.a.b()) {
            ((Application)this.getApplicationContext()).registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)new com.instabug.apm.g.a((Context)this, false));
        }
    }

    /*
     * WARNING - void declaration
     */
    private void startSession(@NonNull Session coreSession) {
        void var1_1;
        this.sessionHandler.a((Session)var1_1);
    }

    private void endSession() {
        this.sessionHandler.b(0);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$400(APMPlugin x0, Session x1) {
        void var1_1;
        x0.startSession((Session)var1_1);
    }

    public void wake() {
        Session session = InstabugCore.getRunningSession();
        if (session != null) {
            APMPlugin aPMPlugin = this;
            e.a(aPMPlugin);
            aPMPlugin.startSession(session);
            aPMPlugin.registerSessionCrashHandler();
        } else {
            this.apmLogger.e("APM session not created. Core session is null");
        }
        if (com.instabug.apm.e.a.b().c() && this.isFirstLaunch) {
            this.clearInvalidCache();
            this.isFirstLaunch = false;
        }
    }

    public void stop() {
        CompositeDisposable compositeDisposable = this.sdkCoreEventsSubscriberDisposable;
        if (compositeDisposable != null && !compositeDisposable.isDisposed()) {
            this.sdkCoreEventsSubscriberDisposable.dispose();
        }
    }

    public void sleep() {
        this.endSession();
    }

    public void start(Context context) {
        APMPlugin aPMPlugin = this;
        aPMPlugin.isFirstLaunch = true;
        aPMPlugin.registerConfigurationChange();
        aPMPlugin.subscribeToSDKState();
        if (Build.VERSION.SDK_INT < 16) {
            this.apmLogger.e("Could not enable Auto UI Trace. Feature is supported on API level 16 and up only.");
        }
    }

    public long getLastActivityTime() {
        return 0L;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onNewSessionStarted(@NonNull Session runningSession, @Nullable Session lastSession) {
        void var1_1;
        void var2_2;
        com.instabug.apm.e.a.a("session_thread_executor").execute(new Runnable(this, (Session)var2_2, (Session)var1_1){
            final /* synthetic */ Session a;
            final /* synthetic */ Session b;
            {
                this.a = session;
                this.b = session2;
            }

            @Override
            public void run() {
                if (h4.a != null) {
                    h h2 = h4;
                    Session session = h2.b;
                    com.instabug.apm.e.a.B().a(session, h2.a);
                    h h3 = h4;
                    h h4 = h3.b;
                    com.instabug.apm.e.a.x().a((Session)h4, h3.a);
                }
                com.instabug.apm.e.a.f().a();
            }
        });
    }
}

