package com.instabug.library.apmokhttplogger;

import androidx.annotation.NonNull;

import com.instabug.library.networkv2.BodyBufferHelper;

import java.io.IOException;
import java.nio.charset.Charset;

import okhttp3.ResponseBody;
import okio.Buffer;
import okio.BufferedSource;

class InstabugAPMOkHttpBuffer {

    private final Buffer buffer;

    public InstabugAPMOkHttpBuffer(@NonNull ResponseBody responseBody) throws IOException {
        BufferedSource source = responseBody.source();
        source.request((long) Integer.MAX_VALUE);
        this.buffer = source.getBuffer();
    }

    public long getSize() {
        return buffer.size();
    }

    public String getBody() {
        if (!BodyBufferHelper.INSTANCE.isBodySizeAllowed(buffer.size()))
            return BodyBufferHelper.MAX_SIZE_ALERT;
        Charset UTF8 = Charset.forName("UTF-8");
        return buffer.clone().readString(UTF8);
    }
}
