package com.instabug.library.di

import com.instabug.apm.di.InterceptorsServiceLocator
import com.instabug.library.apm_network_log_repository.APMNetworkLogRepository
import com.instabug.library.apm_network_log_repository.APMNetworkLogRepositoryImpl
import com.instabug.library.apm_okhttp_event_listener.NetworkLatencyEventCaptor
import com.instabug.library.apm_okhttp_event_listener.NetworkLatencyEventCaptorImpl
import com.instabug.library.apm_okhttp_event_listener.NetworkLatencySpansMapper

object APMOkHttpLoggerServiceLocator {
    @Volatile
    private var _networkLogRepository: APMNetworkLogRepository? = null

    @JvmStatic
    val networkLogRepository: APMNetworkLogRepository
        get() {
            return _networkLogRepository
                ?: synchronized(InterceptorsServiceLocator.apmServiceLocatorLock) {
                    _networkLogRepository ?: run {
                        APMNetworkLogRepositoryImpl(InterceptorsServiceLocator::okHttpSanitizer)
                            .also { _networkLogRepository = it }
                    }
                }
        }

    @JvmStatic
    internal val newNetworkLatencyEventCaptor: NetworkLatencyEventCaptor
        get() = NetworkLatencyEventCaptorImpl(
            InterceptorsServiceLocator::postNetworkLoggingTask,
            NetworkLatencySpansMapper(),
            networkLogRepository
        )
}