/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.apmokhttplogger;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.instabug.apm.di.InterceptorsServiceLocator;
import com.instabug.apm.logger.APMLogger;
import com.instabug.apm.networking.ApmNetworkInterceptorHelper;
import com.instabug.apm.networkinterception.APMNetworkLogWrapper;
import com.instabug.library.apmokhttplogger.InstabugAPMOkHttpBuffer;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.diagnostics.IBGDiagnostics;
import com.instabug.library.networkv2.BodyBufferHelper;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.ObjectMapper;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import okhttp3.Headers;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okio.Buffer;
import okio.BufferedSink;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class InstabugAPMOkhttpInterceptor
implements Interceptor {
    private static final String TAG = "InstabugAPMOkhttpInterceptor";
    private static final String CONTENT_TYPE = "content-type";
    private static final String CONTENT_LENGTH = "content-length";
    public static final String APOLLO_GRAPH_QL_QUERY_NAME_KEY = "x-apollo-operation-name";
    public static final String APOLLO_GRAPH_QL_ERROR_KEY = "errors";
    public static final String GRAPH_QL_SERVER_SIDE_ERROR = "GraphQLError";
    @Nullable
    @VisibleForTesting
    APMNetworkLogWrapper networkLogWrapper;

    public Response intercept(Interceptor.Chain chain) throws IOException {
        return this.populateNetworkResponse(chain);
    }

    private Map<String, String> getResponseHeaders(@NonNull Response response) {
        HashMap<String, String> responseHeadersMap = new HashMap<String, String>();
        Headers responseHeaders = response.headers();
        for (int i = 0; i < responseHeaders.size(); ++i) {
            responseHeadersMap.put(responseHeaders.name(i).toLowerCase(), responseHeaders.value(i));
        }
        return responseHeadersMap;
    }

    private Map<String, String> getRequestHeaders(@NonNull Request request, @Nullable RequestBody requestBody) throws IOException {
        HashMap<String, String> requestHeadersMap = new HashMap<String, String>();
        if (requestBody != null) {
            if (requestBody.contentType() != null) {
                requestHeadersMap.put(CONTENT_TYPE, requestBody.contentType().toString());
            }
            if (requestBody.contentLength() != -1L) {
                requestHeadersMap.put(CONTENT_LENGTH, String.valueOf(requestBody.contentLength()));
            }
        }
        Headers requestHeaders = request.headers();
        for (int i = 0; i < requestHeaders.size(); ++i) {
            String name = requestHeaders.name(i);
            requestHeadersMap.put(name.toLowerCase(), requestHeaders.value(i));
        }
        return requestHeadersMap;
    }

    @Nullable
    private static String bodyToString(RequestBody request) {
        try {
            String contentType;
            String string = contentType = request.contentType() != null ? request.contentType().toString() : "";
            if (BodyBufferHelper.isMultipartType((String)contentType)) {
                return "multipart body was omitted";
            }
            if (!BodyBufferHelper.isBodySizeAllowed((long)request.contentLength())) {
                return "body omitted due to its large size > 1MB";
            }
            Buffer buffer = new Buffer();
            request.writeTo((BufferedSink)buffer);
            return buffer.readUtf8();
        }
        catch (IOException e) {
            InstabugSDKLogger.e((String)TAG, (String)"Failed to read request body", (Throwable)e);
            return null;
        }
    }

    private Response populateNetworkResponse(@NonNull Interceptor.Chain chain) throws IOException {
        Response response;
        APMNetworkLogWrapper networkLogWrapper = null;
        Request request = chain.request();
        Map<String, String> requestHeaders = null;
        boolean shouldProcessGraphQlRequest = false;
        try {
            this.networkLogWrapper = networkLogWrapper = new APMNetworkLogWrapper();
            InstabugSDKLogger.v((String)TAG, (String)"populate network request started");
            networkLogWrapper.setStartTime(Long.valueOf(System.currentTimeMillis() * 1000L));
            RequestBody requestBody = request.body();
            networkLogWrapper.setMethod(request.method());
            networkLogWrapper.setUrl(request.url().toString());
            requestHeaders = this.getRequestHeaders(request, requestBody);
            shouldProcessGraphQlRequest = this.shouldProcessGraphQLRequest(requestHeaders);
            if (shouldProcessGraphQlRequest) {
                networkLogWrapper.setGraphQlQueryName(this.getQueryName(requestHeaders));
            }
            networkLogWrapper.setRequestHeaders(ObjectMapper.toJson(requestHeaders).toString());
            networkLogWrapper.setRequestContentType(requestHeaders.get(CONTENT_TYPE));
            APMLogger.d((String)"Request [$method] $url has started.".replace("$method", request.method()).replace("$url", request.url().toString()));
        }
        catch (Exception exception) {
            this.reportException(exception);
        }
        long startNs = System.nanoTime();
        try {
            response = chain.proceed(request);
            this.handleRequestBody(networkLogWrapper, request);
        }
        catch (IOException ex) {
            this.handleRequestBody(networkLogWrapper, request);
            this.handleExceptionResponse(networkLogWrapper, ex, startNs);
            throw ex;
        }
        this.handleResponse(networkLogWrapper, requestHeaders, shouldProcessGraphQlRequest, response, startNs);
        return response;
    }

    private void handleRequestBody(@Nullable APMNetworkLogWrapper networkLog, Request request) {
        try {
            RequestBody requestBody = request.body();
            if (networkLog != null && requestBody != null) {
                networkLog.setRequestBodySize(requestBody.contentLength());
                networkLog.setRequestBody(InstabugAPMOkhttpInterceptor.bodyToString(requestBody));
            }
        }
        catch (Exception exception) {
            InstabugSDKLogger.e((String)TAG, (String)"Failed to handle Request body", (Throwable)exception);
        }
    }

    private void handleResponse(APMNetworkLogWrapper networkLogWrapper, @Nullable Map<String, String> requestHeaders, boolean shouldProcessGraphQlRequest, Response response, long startNs) {
        if (networkLogWrapper != null && response != null) {
            try {
                long tookMs = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startNs);
                networkLogWrapper.setTotalDuration(tookMs);
                networkLogWrapper.setResponseCode(response.code());
                if (response.code() > 0) {
                    networkLogWrapper.setErrorMessage(null);
                }
                Map<String, String> responseHeaders = this.getResponseHeaders(response);
                networkLogWrapper.setResponseHeaders(ObjectMapper.toJson(responseHeaders).toString());
                networkLogWrapper.setResponseContentType(responseHeaders.get(CONTENT_TYPE));
                String contentLength = responseHeaders.get(CONTENT_LENGTH);
                if (contentLength != null) {
                    networkLogWrapper.setResponseBodySize(Long.parseLong(contentLength));
                }
                try {
                    if (this.isGraphQLRequest(requestHeaders)) {
                        String errorMessage;
                        InstabugAPMOkHttpBuffer buffer = new InstabugAPMOkHttpBuffer(response);
                        networkLogWrapper.setResponseBodySize(buffer.getSize());
                        String body = buffer.getBody();
                        networkLogWrapper.setResponseBody(body);
                        if (shouldProcessGraphQlRequest && (errorMessage = this.getGraphQlServerSideErrorMessage(body)) != null) {
                            networkLogWrapper.setServerSideErrorMessage(errorMessage);
                        }
                    }
                }
                catch (OutOfMemoryError e) {
                    InstabugCore.reportError((Throwable)e, (String)"Not enough memory for saving response");
                    InstabugSDKLogger.e((String)TAG, (String)"Not enough memory for saving response", (Throwable)e);
                }
                catch (Exception e) {
                    InstabugSDKLogger.e((String)TAG, (String)"Failed to get response body", (Throwable)e);
                }
                InstabugSDKLogger.v((String)TAG, (String)"inserting network log");
                networkLogWrapper.insert(null, InterceptorsServiceLocator.getOkHttpSanitizer());
            }
            catch (Exception exception) {
                this.reportException(exception);
            }
        }
    }

    private void handleExceptionResponse(APMNetworkLogWrapper networkLogWrapper, IOException requestException, long startNs) {
        if (networkLogWrapper != null) {
            try {
                long tookMs = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startNs);
                networkLogWrapper.setTotalDuration(tookMs);
                networkLogWrapper.setErrorMessage(requestException.getClass().getSimpleName());
                networkLogWrapper.setResponseCode(0);
                networkLogWrapper.insert((Exception)requestException, InterceptorsServiceLocator.getOkHttpSanitizer());
                InstabugSDKLogger.e((String)TAG, (String)"Failed to proceed request", (Throwable)requestException);
            }
            catch (Exception exception) {
                this.reportException(exception);
            }
        }
    }

    private boolean shouldProcessGraphQLRequest(@NonNull Map<String, String> requestHeaders) {
        return this.isGraphQLRequest(requestHeaders) && this.isGraphQlRequestsInterceptionEnabled();
    }

    private boolean isGraphQLRequest(@Nullable Map<String, String> requestHeaders) {
        if (requestHeaders != null) {
            return requestHeaders.containsKey(APOLLO_GRAPH_QL_QUERY_NAME_KEY);
        }
        return false;
    }

    private boolean isGraphQlRequestsInterceptionEnabled() {
        return ApmNetworkInterceptorHelper.Companion.isGraphQlEnabled();
    }

    @Nullable
    private String getQueryName(@Nullable Map<String, String> requestHeaders) {
        if (requestHeaders != null) {
            return requestHeaders.get(APOLLO_GRAPH_QL_QUERY_NAME_KEY);
        }
        return null;
    }

    @Nullable
    private String getGraphQlServerSideErrorMessage(@Nullable String body) {
        if (body != null) {
            try {
                JSONObject jsonObject = new JSONObject(body);
                JSONArray errorsJsonArray = jsonObject.optJSONArray(APOLLO_GRAPH_QL_ERROR_KEY);
                if (errorsJsonArray != null && errorsJsonArray.length() != 0) {
                    return GRAPH_QL_SERVER_SIDE_ERROR;
                }
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        return null;
    }

    private void reportException(Exception exception) {
        try {
            IBGDiagnostics.reportNonFatal((Throwable)exception, (String)"Exception while trying to intercept an OkHttp request");
            InstabugSDKLogger.e((String)TAG, (String)"Exception while trying to intercept an OkHttp request", (Throwable)exception);
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }
}

