/*
 * Decompiled with CFR 0.152.
 */
package com.inlocomedia.android.location.models;

import android.location.Address;
import com.inlocomedia.android.core.private.bz;
import com.inlocomedia.android.core.private.cc;
import com.inlocomedia.android.core.private.dr;
import com.inlocomedia.android.core.util.Validator;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class SerializableAddress
implements dr {
    private static final long serialVersionUID = 2394237431480133426L;
    private String adminArea;
    private String countryName;
    private String countryCode;
    private Locale locale;
    private String postalCode;
    private String subAdminArea;
    private String locality;
    private String subLocality;
    private String thoroughfare;
    private String subThoroughfare;

    public SerializableAddress() {
    }

    public SerializableAddress(Address address) {
        this.locale = address.getLocale();
        this.setCountryName(address.getCountryName());
        this.setCountryCode(address.getCountryCode());
        this.setAdminArea(address.getAdminArea());
        this.setSubAdminArea(address.getSubAdminArea());
        this.setLocality(address.getLocality());
        this.setSubLocality(address.getSubLocality());
        this.setThoroughfare(address.getThoroughfare());
        this.setSubThoroughfare(address.getSubThoroughfare());
        this.setPostalCode(address.getPostalCode());
    }

    public JSONObject parseToJSON(JSONObject json) throws bz {
        try {
            if (json == null) {
                json = new JSONObject();
            }
            if (!Validator.isNullOrEmpty((String)this.countryName)) {
                json.put("country_name", (Object)this.countryName);
            }
            if (!Validator.isNullOrEmpty((String)this.countryCode)) {
                json.put("geo_country_iso", (Object)this.countryCode);
            }
            if (!Validator.isNullOrEmpty((String)this.adminArea)) {
                json.put("admin_area", (Object)this.adminArea);
            }
            if (!Validator.isNullOrEmpty((String)this.subAdminArea)) {
                json.put("sub_admin_area", (Object)this.subAdminArea);
            }
            if (!Validator.isNullOrEmpty((String)this.locality)) {
                json.put("locality", (Object)this.locality);
            }
            if (!Validator.isNullOrEmpty((String)this.subLocality)) {
                json.put("sub_locality", (Object)this.subLocality);
            }
            if (!Validator.isNullOrEmpty((String)this.thoroughfare)) {
                json.put("thoroughfare", (Object)this.thoroughfare);
            }
            if (!Validator.isNullOrEmpty((String)this.subThoroughfare)) {
                json.put("sub_thoroughfare", (Object)this.subThoroughfare);
            }
            if (!Validator.isNullOrEmpty((String)this.postalCode)) {
                json.put("postal_code", (Object)this.postalCode);
            }
            if (this.locale != null) {
                json.put("address_locale", (Object)cc.a((Locale)this.locale));
            }
            return json;
        }
        catch (JSONException jSONException) {
            throw new bz("Address serialization has failed", (Exception)((Object)jSONException));
        }
    }

    public JSONObject parseToJSON() throws bz {
        return this.parseToJSON(null);
    }

    public void parseFromJSON(JSONObject json) throws bz {
        try {
            if (json.has("country_name")) {
                this.countryName = json.getString("country_name");
            }
            if (json.has("geo_country_iso")) {
                this.countryCode = json.getString("geo_country_iso");
            }
            if (json.has("admin_area")) {
                this.adminArea = json.getString("admin_area");
            }
            if (json.has("sub_admin_area")) {
                this.subAdminArea = json.getString("sub_admin_area");
            }
            if (json.has("locality")) {
                this.locality = json.getString("locality");
            }
            if (json.has("sub_locality")) {
                this.subLocality = json.getString("sub_locality");
            }
            if (json.has("thoroughfare")) {
                this.thoroughfare = json.getString("thoroughfare");
            }
            if (json.has("sub_thoroughfare")) {
                this.subThoroughfare = json.getString("sub_thoroughfare");
            }
            if (json.has("postal_code")) {
                this.postalCode = json.getString("postal_code");
            }
            if (json.has("address_locale")) {
                this.locale = cc.a((String)json.getString("address_locale"));
            }
        }
        catch (JSONException jSONException) {
            throw new bz("Address serialization has failed", (Exception)((Object)jSONException));
        }
    }

    public Map<String, Serializable> toMap() {
        HashMap<String, Serializable> hashMap = new HashMap<String, Serializable>();
        this.toDefaultMap(hashMap);
        if (!Validator.isNullOrEmpty((String)this.countryCode)) {
            hashMap.put("geo_country_iso", (Serializable)((Object)this.countryCode));
        }
        if (this.locale != null) {
            hashMap.put("address_locale", (Serializable)((Object)cc.a((Locale)this.locale)));
        }
        return hashMap;
    }

    private void toDefaultMap(Map<String, Serializable> map) {
        if (!Validator.isNullOrEmpty((String)this.countryName)) {
            map.put("country_name", (Serializable)((Object)this.countryName));
        }
        if (!Validator.isNullOrEmpty((String)this.adminArea)) {
            map.put("admin_area", (Serializable)((Object)this.adminArea));
        }
        if (!Validator.isNullOrEmpty((String)this.subAdminArea)) {
            map.put("sub_admin_area", (Serializable)((Object)this.adminArea));
        }
        if (!Validator.isNullOrEmpty((String)this.locality)) {
            map.put("locality", (Serializable)((Object)this.locality));
        }
        if (!Validator.isNullOrEmpty((String)this.subLocality)) {
            map.put("sub_locality", (Serializable)((Object)this.subLocality));
        }
        if (!Validator.isNullOrEmpty((String)this.thoroughfare)) {
            map.put("thoroughfare", (Serializable)((Object)this.thoroughfare));
        }
        if (!Validator.isNullOrEmpty((String)this.subThoroughfare)) {
            map.put("sub_thoroughfare", (Serializable)((Object)this.subThoroughfare));
        }
        if (!Validator.isNullOrEmpty((String)this.postalCode)) {
            map.put("postal_code", (Serializable)((Object)this.postalCode));
        }
    }

    public String getCountryName() {
        return this.countryName;
    }

    public void setCountryName(String countryName) {
        this.countryName = countryName;
    }

    public String getCountryCode() {
        return this.countryCode;
    }

    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    public String getAdminArea() {
        return this.adminArea;
    }

    public void setAdminArea(String adminArea) {
        this.adminArea = adminArea;
    }

    public String getSubAdminArea() {
        return this.subAdminArea;
    }

    public void setSubAdminArea(String subAdminArea) {
        this.subAdminArea = subAdminArea;
    }

    public String getLocality() {
        return this.locality;
    }

    public void setLocality(String locality) {
        this.locality = locality;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public String getSubLocality() {
        return this.subLocality;
    }

    public void setSubLocality(String subLocality) {
        this.subLocality = subLocality;
    }

    public String getThoroughfare() {
        return this.thoroughfare;
    }

    public void setThoroughfare(String thoroughfare) {
        this.thoroughfare = thoroughfare;
    }

    public String getSubThoroughfare() {
        return this.subThoroughfare;
    }

    public void setSubThoroughfare(String subThoroughfare) {
        this.subThoroughfare = subThoroughfare;
    }

    public String getPostalCode() {
        return this.postalCode;
    }

    public void setPostalCode(String postalCode) {
        this.postalCode = postalCode;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public boolean isEmpty() {
        return this.countryCode == null && this.countryName == null && this.adminArea == null && this.subAdminArea == null && this.locality == null && this.subLocality == null && this.thoroughfare == null && this.subThoroughfare == null && this.postalCode == null;
    }

    public String toString() {
        return "SerializableAddress{, countryName='" + this.countryName + '\'' + ", countryCode='" + this.countryCode + '\'' + ", adminArea='" + this.adminArea + '\'' + ", subAdminArea='" + this.subAdminArea + '\'' + ", locality='" + this.locality + '\'' + ", subLocality='" + this.subLocality + '\'' + ", thoroughfare='" + this.thoroughfare + '\'' + ", subThoroughfare='" + this.subThoroughfare + '\'' + ", postalCode='" + this.postalCode + '\'' + ", locale=" + this.locale + '}';
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (!(o2 instanceof SerializableAddress)) {
            return false;
        }
        SerializableAddress serializableAddress = (SerializableAddress)o2;
        if (this.locale != null ? !this.locale.equals(serializableAddress.locale) : serializableAddress.locale != null) {
            return false;
        }
        if (this.countryName != null ? !this.countryName.equals(serializableAddress.countryName) : serializableAddress.countryName != null) {
            return false;
        }
        if (this.countryCode != null ? !this.countryCode.equals(serializableAddress.countryCode) : serializableAddress.countryCode != null) {
            return false;
        }
        if (this.adminArea != null ? !this.adminArea.equals(serializableAddress.adminArea) : serializableAddress.adminArea != null) {
            return false;
        }
        if (this.subAdminArea != null ? !this.subAdminArea.equals(serializableAddress.subAdminArea) : serializableAddress.subAdminArea != null) {
            return false;
        }
        if (this.locality != null ? !this.locality.equals(serializableAddress.locality) : serializableAddress.locality != null) {
            return false;
        }
        if (this.subLocality != null ? !this.subLocality.equals(serializableAddress.subLocality) : serializableAddress.subLocality != null) {
            return false;
        }
        if (this.thoroughfare != null ? !this.thoroughfare.equals(serializableAddress.thoroughfare) : serializableAddress.thoroughfare != null) {
            return false;
        }
        if (this.subThoroughfare != null ? !this.subThoroughfare.equals(serializableAddress.subThoroughfare) : serializableAddress.subThoroughfare != null) {
            return false;
        }
        return !(this.postalCode != null ? !this.postalCode.equals(serializableAddress.postalCode) : serializableAddress.postalCode != null);
    }

    public int hashCode() {
        int n2 = this.adminArea != null ? this.adminArea.hashCode() : 0;
        n2 = 31 * n2 + (this.subAdminArea != null ? this.subAdminArea.hashCode() : 0);
        n2 = 31 * n2 + (this.countryName != null ? this.countryName.hashCode() : 0);
        n2 = 31 * n2 + (this.countryCode != null ? this.countryCode.hashCode() : 0);
        n2 = 31 * n2 + (this.locality != null ? this.locality.hashCode() : 0);
        n2 = 31 * n2 + (this.subLocality != null ? this.subLocality.hashCode() : 0);
        n2 = 31 * n2 + (this.thoroughfare != null ? this.thoroughfare.hashCode() : 0);
        n2 = 31 * n2 + (this.subThoroughfare != null ? this.subThoroughfare.hashCode() : 0);
        n2 = 31 * n2 + (this.postalCode != null ? this.postalCode.hashCode() : 0);
        n2 = 31 * n2 + (this.locale != null ? this.locale.hashCode() : 0);
        return n2;
    }
}

