/*
 * Decompiled with CFR 0.152.
 */
package com.inlocomedia.android.location.models;

import android.graphics.PointF;
import com.inlocomedia.android.core.exception.InvalidMappingException;
import com.inlocomedia.android.core.serialization.json.JsonReflector;
import com.inlocomedia.android.core.serialization.json.JsonableModel;
import com.inlocomedia.android.location.models.SerializableAddress;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONObject;

public class Location
extends JsonableModel {
    private static final long serialVersionUID = -552705204095270197L;
    @JsonableModel.JsonField(key="x")
    private Float x;
    @JsonableModel.JsonField(key="y")
    private Float y;
    @JsonableModel.JsonField(key="z")
    private Integer floor;
    @JsonableModel.JsonField(key="ang")
    private Float angle;
    @JsonableModel.JsonField(key="precision")
    private Double precision;
    @JsonableModel.JsonField(key="retail_id")
    private String retailId;
    @JsonableModel.JsonField(key="lat")
    private Double latitude;
    @JsonableModel.JsonField(key="lng")
    private Double longitude;
    @JsonableModel.JsonField(key="address")
    private SerializableAddress address;
    @JsonableModel.JsonField(key="in_ts")
    private long indoorTimestamp;
    @JsonableModel.JsonField(key="out_ts")
    private long outdoorTimestamp;

    public Location() {
    }

    public Location(Float x2, Float y2, Integer floor, Float angle, Double precision, String retailId, Double latitude, Double longitude, SerializableAddress address, long indoorTimestamp, long outdoorTimestamp) {
        this.x = x2;
        this.y = y2;
        this.floor = floor;
        this.angle = angle;
        this.precision = precision;
        this.retailId = retailId;
        this.latitude = latitude;
        this.longitude = longitude;
        this.address = address;
        this.indoorTimestamp = indoorTimestamp;
        this.outdoorTimestamp = outdoorTimestamp;
    }

    public Float getX() {
        return this.x;
    }

    public Float getY() {
        return this.y;
    }

    public Integer getFloor() {
        return this.floor;
    }

    public Float getAngle() {
        return this.angle;
    }

    public Double getPrecision() {
        return this.precision;
    }

    public String getRetailId() {
        return this.retailId;
    }

    public Double getLatitude() {
        return this.latitude;
    }

    public Double getLongitude() {
        return this.longitude;
    }

    public PointF getPoint() {
        return new PointF(this.x.floatValue(), this.y.floatValue());
    }

    public long getIndoorTimestamp() {
        return this.indoorTimestamp;
    }

    public long getOutdoorTimestamp() {
        return this.indoorTimestamp;
    }

    public SerializableAddress getAddress() {
        return this.address;
    }

    public double distanceTo(Location to) {
        float f2 = to.x.floatValue() - this.x.floatValue();
        float f3 = to.y.floatValue() - this.y.floatValue();
        return Math.sqrt(f2 * f2 + f3 * f3);
    }

    public static JSONObject parseListToJSON(List<Location> locations) throws InvalidMappingException {
        return JsonReflector.parseCollectionToJSON(locations, (String)"locations");
    }

    public static List<Location> parseListFromJSON(JSONObject json) throws InvalidMappingException {
        return (List)JsonReflector.parseCollectionFromJSON((JSONObject)json, Location.class, (String)"locations", new ArrayList());
    }

    public boolean hasIndoorLocation() {
        return this.x != null && this.y != null && this.floor != null && this.retailId != null;
    }

    public String toString() {
        return "Location{x=" + this.x + ", y=" + this.y + ", floor=" + this.floor + ", angle=" + this.angle + ", precision=" + this.precision + ", retailId='" + this.retailId + '\'' + ", latitude=" + this.latitude + ", longitude=" + this.longitude + ", address=" + this.address + ", indoorTimestamp=" + this.indoorTimestamp + ", outdoorTimestamp=" + this.outdoorTimestamp + '}';
    }

    public static class a {
        private Float a;
        private Float b;
        private Integer c;
        private Float d;
        private Double e;
        private String f;
        private Double g;
        private Double h;
        private SerializableAddress i;
        private long j;
        private long k;

        public a a(Float f2) {
            this.a = f2;
            return this;
        }

        public a b(Float f2) {
            this.b = f2;
            return this;
        }

        public a a(Integer n2) {
            this.c = n2;
            return this;
        }

        public a c(Float f2) {
            this.d = f2;
            return this;
        }

        public a a(Double d2) {
            this.e = d2;
            return this;
        }

        public a a(String string2) {
            this.f = string2;
            return this;
        }

        public a b(Double d2) {
            this.g = d2;
            return this;
        }

        public a c(Double d2) {
            this.h = d2;
            return this;
        }

        public a a(SerializableAddress serializableAddress) {
            this.i = serializableAddress;
            return this;
        }

        public a a(long l2) {
            this.j = l2;
            return this;
        }

        public a b(long l2) {
            this.k = l2;
            return this;
        }

        public Location a() {
            return new Location(this.a, this.b, this.c, this.d, this.e, this.f, this.g, this.h, this.i, this.j, this.k);
        }
    }
}

