/*
 * Decompiled with CFR 0.152.
 */
package com.inlocomedia.android.location.models;

import com.inlocomedia.android.core.exception.InvalidMappingException;
import com.inlocomedia.android.core.serialization.json.JsonReflector;
import com.inlocomedia.android.core.serialization.json.JsonableModel;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class RetailMap
extends JsonableModel {
    private static final long serialVersionUID = -3278490226897002853L;
    @JsonableModel.JsonField(key="id")
    private String identifier;
    @JsonableModel.JsonField(key="version")
    private long version;
    @JsonableModel.JsonField(key="floor")
    private int floor;
    @JsonableModel.JsonField(key="name")
    private String name;
    private boolean loaded;
    @JsonableModel.JsonField(key="img_url")
    private String imageUrl;

    public RetailMap() {
    }

    public RetailMap(JSONObject json) {
        try {
            this.parseFromJSON(json);
        }
        catch (InvalidMappingException invalidMappingException) {
            // empty catch block
        }
    }

    public static List<RetailMap> parseListFromJSON(JSONObject json) throws InvalidMappingException {
        return RetailMap.parseListFromJSON(RetailMap.class, json);
    }

    public static List<RetailMap> parseListFromJSON(Class<? extends RetailMap> klass, JSONObject json) throws InvalidMappingException {
        return (List)JsonReflector.parseCollectionFromJSON((JSONObject)json, RetailMap.class, (String)"retail_maps", new ArrayList());
    }

    public static List<RetailMap> parseListFromJSONArray(JSONArray json) throws InvalidMappingException {
        return (List)JsonReflector.parseCollectionFromJSONArray((JSONArray)json, RetailMap.class, new ArrayList());
    }

    public static JSONArray parseListToJSONArray(List<RetailMap> categories) throws InvalidMappingException {
        return JsonReflector.parseCollectionToJSONArray(categories);
    }

    public boolean hasNewerVersion(RetailMap map) {
        return this.version > map.version;
    }

    public String getId() {
        return this.identifier;
    }

    public void setId(String id2) {
        this.identifier = id2;
    }

    public long getVersion() {
        return this.version;
    }

    public void setVersion(long version) {
        this.version = version;
    }

    public int getFloor() {
        return this.floor;
    }

    public void setFloor(int floor) {
        this.floor = floor;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getImageUrl() {
        return this.imageUrl;
    }

    public void setImageUrl(String imageUrl) {
        this.imageUrl = imageUrl;
    }

    public String toString() {
        return this.getName();
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        n3 = 31 * n3;
        if (this.identifier != null) {
            n3 += this.identifier.hashCode();
        }
        return n3;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        RetailMap retailMap = (RetailMap)((Object)obj);
        return !(this.identifier == null ? retailMap.identifier != null : !this.identifier.equals(retailMap.identifier));
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public void setLoaded(boolean loaded) {
        this.loaded = loaded;
    }

    public static Comparator<RetailMap> getComparatorByFloor() {
        return new Comparator<RetailMap>(){

            public int a(RetailMap retailMap, RetailMap retailMap2) {
                return Integer.valueOf(retailMap.getFloor()).compareTo(retailMap2.getFloor());
            }

            @Override
            public /* synthetic */ int compare(Object object, Object object2) {
                return this.a((RetailMap)((Object)object), (RetailMap)((Object)object2));
            }
        };
    }

    public static RetailMap getRetailMapByFloor(List<RetailMap> maps, int floor) {
        for (RetailMap retailMap : maps) {
            if (retailMap.getFloor() != floor) continue;
            return retailMap;
        }
        return null;
    }
}

