/*
 * Decompiled with CFR 0.152.
 */
package com.inlocomedia.android.location.models;

import android.text.TextUtils;
import com.inlocomedia.android.core.exception.InvalidMappingException;
import com.inlocomedia.android.core.serialization.json.JsonReflector;
import com.inlocomedia.android.core.serialization.json.JsonableModel;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class Retail
extends JsonableModel {
    private static final long serialVersionUID = 2342105754399677354L;
    @JsonableModel.JsonField(key="id")
    private String identifier;
    @JsonableModel.JsonField(key="version")
    private long version;
    @JsonableModel.JsonField(key="name")
    private String name;
    @JsonableModel.JsonField(key="street")
    private String street;
    @JsonableModel.JsonField(key="number")
    private String number;
    @JsonableModel.JsonField(key="neighbourhood")
    private String neighbourhood;
    @JsonableModel.JsonField(key="city")
    private String city;
    @JsonableModel.JsonField(key="state")
    private String state;
    @JsonableModel.JsonField(key="country")
    private String country;
    @JsonableModel.JsonField(key="phone")
    private String phone;
    @JsonableModel.JsonField(key="website")
    private String website;
    @JsonableModel.JsonField(key="lat")
    private double lat;
    @JsonableModel.JsonField(key="lng")
    private double lng;
    @JsonableModel.JsonField(key="desc")
    private String description;
    @JsonableModel.JsonField(key="store_count")
    private int areasAmmount;
    @JsonableModel.JsonField(key="img_url")
    private String imageUrl;
    @JsonableModel.JsonField(key="img_thumb_url")
    private String thumbnailUrl;
    private boolean isLoaded;

    protected static Retail getInstance() {
        return new Retail();
    }

    public Retail() {
    }

    public Retail(String id2, long version, String name) {
        this.setId(id2);
        this.setVersion(version);
        this.setName(name);
    }

    public Retail(String id2, String name, String street, String city, String state) {
        this.setId(id2);
        this.setName(name);
        this.setCity(city);
        this.setStreet(street);
        this.setState(state);
    }

    public Retail(JSONObject json) throws InvalidMappingException {
        this.parseFromJSON(json);
    }

    public String getId() {
        return this.identifier;
    }

    public void setId(String id2) {
        this.identifier = id2;
    }

    public long getVersion() {
        return this.version;
    }

    public void setVersion(long version) {
        this.version = version;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String toString() {
        return this.identifier + ":" + this.getName();
    }

    public String getStreet() {
        return this.street;
    }

    public void setStreet(String street) {
        this.street = street;
    }

    public String getNumber() {
        return this.number;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public String getNeighbourhood() {
        return this.neighbourhood;
    }

    public void setNeighbourhood(String neighbourhood) {
        this.neighbourhood = neighbourhood;
    }

    public String getCity() {
        return this.city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public String getPhone() {
        return this.phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public String getWebsite() {
        return this.website;
    }

    public void setWebsite(String website) {
        this.website = website;
    }

    public double getLatitude() {
        return this.lat;
    }

    public void setLatitude(double latitude) {
        this.lat = latitude;
    }

    public double getLongitude() {
        return this.lng;
    }

    public void setLongitude(double longitude) {
        this.lng = longitude;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getCompletedAddress() {
        StringBuffer stringBuffer = new StringBuffer();
        this.appendAddressComponent(stringBuffer, "", this.street);
        this.appendAddressComponent(stringBuffer, ", ", this.number);
        this.appendAddressComponent(stringBuffer, ", ", this.neighbourhood);
        this.appendAddressComponent(stringBuffer, ", ", this.city);
        this.appendAddressComponent(stringBuffer, ", ", this.state);
        this.appendAddressComponent(stringBuffer, " - ", this.country);
        return stringBuffer.toString();
    }

    private void appendAddressComponent(StringBuffer sb, String separator, String component) {
        if (!TextUtils.isEmpty((CharSequence)component)) {
            if (sb.length() > 0) {
                sb.append(separator);
            }
            sb.append(component);
        }
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        n3 = 31 * n3;
        if (this.identifier != null) {
            n3 += this.identifier.hashCode();
        }
        return n3;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        Retail retail = (Retail)((Object)obj);
        return !(this.identifier == null ? retail.identifier != null : !this.identifier.equals(retail.identifier));
    }

    public boolean isLoaded() {
        return this.isLoaded;
    }

    public void setLoaded(boolean isLoaded) {
        this.isLoaded = isLoaded;
    }

    public int getAreasAmmount() {
        return this.areasAmmount;
    }

    public void setAreasAmmount(int storesAmmount) {
        this.areasAmmount = storesAmmount;
    }

    public String getImageUrl() {
        return this.imageUrl;
    }

    public void setImageUrl(String imageUrl) {
        this.imageUrl = imageUrl;
    }

    public String getThumbnailUrl() {
        return this.thumbnailUrl;
    }

    public void setThumbnailUrl(String thumbnailUrl) {
        this.thumbnailUrl = thumbnailUrl;
    }

    public static List<Retail> parseListFromJSON(JSONObject json) throws InvalidMappingException {
        return (List)JsonReflector.parseCollectionFromJSON((JSONObject)json, Retail.class, (String)"retails", new ArrayList());
    }

    public static JSONObject parseListToJSON(List<Retail> retails) throws InvalidMappingException {
        return JsonReflector.parseCollectionToJSON(retails, (String)"retails");
    }

    public static List<Retail> parseListFromJSONArray(JSONArray json) throws InvalidMappingException {
        return (List)JsonReflector.parseCollectionFromJSONArray((JSONArray)json, Retail.class, new ArrayList());
    }

    public static JSONArray parseListToJSONArray(List<Retail> categories) throws InvalidMappingException {
        return JsonReflector.parseCollectionToJSONArray(categories);
    }
}

