/*
 * Decompiled with CFR 0.152.
 */
package com.inlocomedia.android.location;

import android.content.Context;
import android.support.annotation.NonNull;
import com.inlocomedia.android.core.log.Logger;
import com.inlocomedia.android.location.InLocoOptions;
import com.inlocomedia.android.location.geofencing.GeofencingEventsListener;
import com.inlocomedia.android.location.geofencing.h;
import com.inlocomedia.android.location.geofencing.n;
import com.inlocomedia.android.location.geofencing.s;
import com.inlocomedia.android.location.models.Location;
import com.inlocomedia.android.location.private.af;
import com.inlocomedia.android.location.private.bt;
import com.inlocomedia.android.location.private.cq;
import com.inlocomedia.android.location.private.u;
import com.inlocomedia.android.location.private.v;

public class InLocoPrivate {
    private static String TAG = Logger.makeTag(InLocoPrivate.class);

    public static void initGeofencing(@NonNull Context context) {
        v.a(context.getApplicationContext(), u.b.c);
    }

    public static void initConfigurableModels(@NonNull Context context) {
        v.a(context.getApplicationContext(), u.b.b);
    }

    public static void initLocation(@NonNull Context context) {
        v.a(context.getApplicationContext(), u.b.a);
    }

    public static void initCrowdSourcing(@NonNull Context context) {
        v.a(context.getApplicationContext(), u.b.d);
    }

    public static boolean hasMapsAccess(Context context) {
        return af.c(context);
    }

    public static boolean hasLocationReceiver(Context context) {
        return af.f(context);
    }

    public static boolean hasBootCompletedPermission(Context context) {
        return af.i(context);
    }

    public static void requestLocationRefresh(Context context) {
        if (InLocoOptions.getInstance(context).isLocationTrackingEnabled()) {
            bt.c(context);
        }
    }

    public static Location getLastKnownValidLocation(Context context) {
        if (InLocoOptions.getInstance(context).isLocationTrackingEnabled()) {
            return cq.a(context).v();
        }
        return null;
    }

    public static class Geofencing {
        public static boolean isAvailable(Context context) {
            if (InLocoOptions.getInstance(context).isLocationTrackingEnabled()) {
                return n.a(context);
            }
            return false;
        }

        public static void requestRefresh(Context context) {
            if (InLocoOptions.getInstance(context).isLocationTrackingEnabled()) {
                h.b(context);
            }
        }

        public static void registerListener(Context context, Class<? extends GeofencingEventsListener> listener, String category) {
            if (InLocoOptions.getInstance(context).isLocationTrackingEnabled()) {
                h.a(context, listener, category);
            }
        }

        public static void unregisterListener(Context context, String category) {
            if (InLocoOptions.getInstance(context).isLocationTrackingEnabled()) {
                h.a(context, category);
            }
        }

        public static boolean containsEnterTransition(int geofencingTransition) {
            return s.a(geofencingTransition, 1);
        }

        public static boolean containsDwellTransition(int geofencingTransition) {
            return s.a(geofencingTransition, 4);
        }

        public static boolean containsPollingTransition(int geofencingTransition) {
            return s.a(geofencingTransition, 8);
        }
    }
}

