/*
 * Decompiled with CFR 0.152.
 */
package com.inlocomedia.android.location;

import android.annotation.SuppressLint;
import android.content.Context;
import com.inlocomedia.android.core.profile.Device;
import com.inlocomedia.android.core.util.SharedPreferencesManager;
import com.inlocomedia.android.core.util.Validator;

@SuppressLint(value={"CommitPrefEdits"})
public final class InLocoOptions {
    private static final String PREFS_NAME = "in.ubee.api.UbeeOptios";
    private static final String PREFS_DEVELOPMENT_ENABLED = "in.ubee.api.UbeeOptios#DEVELOPMENT";
    private static final String PREFS_MAPS_KEY = "in.ubee.api.UbeeOptios#MAPS_KEY";
    private static final String PREFS_MAPS_SECRET = "in.ubee.api.UbeeOptios#MAPS_SECRET";
    private static final String PREFS_ADS_KEY = "in.ubee.api.UbeeOptios#ADS_KEY";
    private static final String PREFS_LOCATION_KEY = "in.ubee.api.UbeeOptios#LOCATION_KEY";
    private static final String PREFS_LOGS_ENABLED = "in.ubee.api.UbeeOptios#LOGS_ENABLED";
    private static final String PREFS_CACHE_SIZE = "in.ubee.api.UbeeOptios#CACHE_SIZE";
    private static final String PREFS_LOCATION_TRACKING_ENABLED = "com.inlocomedia.android.location.InLocoOptions#LOCATION_TRACKING_ENABLED";
    private static InLocoOptions sInstance;
    private final Context mContext;
    private static final long CACHE_SIZE_DEFAULT = 0xA00000L;

    public static synchronized InLocoOptions newInstance(Context context) {
        sInstance = new InLocoOptions(context, true);
        return sInstance;
    }

    public static synchronized InLocoOptions getInstance(Context context) {
        if (sInstance == null) {
            sInstance = new InLocoOptions(context, false);
        }
        return sInstance;
    }

    private InLocoOptions(Context context, boolean clearPrefs) {
        this.mContext = context.getApplicationContext();
        if (clearPrefs) {
            this.clear();
        }
    }

    public void clear() {
        InLocoOptions.getPrefsEntry(this.mContext).clear();
    }

    public String getMapsKey() {
        return InLocoOptions.getPrefsEntry(this.mContext).getString(PREFS_MAPS_KEY, null);
    }

    public String getMapsSecret() {
        return InLocoOptions.getPrefsEntry(this.mContext).getString(PREFS_MAPS_SECRET, null);
    }

    public void setMapsKey(String mapsProductionKey, String mapsProductionSecret) {
        InLocoOptions.getPrefsEntry(this.mContext).put(PREFS_MAPS_KEY, mapsProductionKey).put(PREFS_MAPS_SECRET, mapsProductionSecret).commit();
    }

    public String getLocationKey() {
        String string = InLocoOptions.getPrefsEntry(this.mContext).getString(PREFS_LOCATION_KEY, null);
        return string != null ? string : InLocoOptions.getPrefsEntry(this.mContext).getString(PREFS_ADS_KEY, null);
    }

    public void setLocationKey(String locationProductionKey) {
        InLocoOptions.getPrefsEntry(this.mContext).put(PREFS_LOCATION_KEY, locationProductionKey).commit();
    }

    public void setCacheSize(long cacheSize) {
        InLocoOptions.getPrefsEntry(this.mContext).put(PREFS_CACHE_SIZE, cacheSize).commit();
    }

    public long getCacheSize() {
        return InLocoOptions.getPrefsEntry(this.mContext).getLong(PREFS_CACHE_SIZE, 0xA00000L);
    }

    public void setLogEnabled(boolean enabled) {
        InLocoOptions.getPrefsEntry(this.mContext).put(PREFS_LOGS_ENABLED, enabled).commit();
    }

    public boolean isLogEnabled() {
        return InLocoOptions.getPrefsEntry(this.mContext).getBoolean(PREFS_LOGS_ENABLED, true);
    }

    public void setLocationTrackingEnabled(boolean enabled) {
        InLocoOptions.getPrefsEntry(this.mContext).put(PREFS_LOCATION_TRACKING_ENABLED, enabled).commit();
    }

    public boolean isLocationTrackingEnabled() {
        return InLocoOptions.getPrefsEntry(this.mContext).getBoolean(PREFS_LOCATION_TRACKING_ENABLED, true);
    }

    @Deprecated
    public void setDevelopmentEnvironment(boolean enabled) {
        InLocoOptions.getPrefsEntry(this.mContext).put(PREFS_DEVELOPMENT_ENABLED, enabled).commit();
    }

    public boolean isDevelopmentEnvironment() {
        return InLocoOptions.getPrefsEntry(this.mContext).getBoolean(PREFS_DEVELOPMENT_ENABLED, false);
    }

    public void setDevelopmentDevices(String ... developmentDevices) {
        boolean bl2 = false;
        String string = Device.getDevelopmentDeviceId((Context)this.mContext);
        if (!Validator.isNullOrEmpty((String)string) && developmentDevices != null) {
            for (String string2 : developmentDevices) {
                if (!string.equals(string2)) continue;
                bl2 = true;
                break;
            }
        }
        InLocoOptions.getPrefsEntry(this.mContext).put(PREFS_DEVELOPMENT_ENABLED, bl2).commit();
    }

    private static SharedPreferencesManager.Entry getPrefsEntry(Context context) {
        return SharedPreferencesManager.getInstance((Context)context).getEntry(PREFS_NAME);
    }

    public static void reset(Context context) {
        InLocoOptions.getPrefsEntry(context).clear();
        sInstance = null;
    }
}

