/*
 * Decompiled with CFR 0.152.
 */
package com.inlocomedia.android.common;

import android.support.annotation.Nullable;
import com.inlocomedia.android.core.annotations.ApiAccess;
import com.inlocomedia.android.core.log.DevLogger;
import java.util.Set;

@ApiAccess
public final class InLocoOptions {
    private static final boolean VISITS_ENABLED_BY_DEFAULT = true;
    private static final boolean SCREEN_TRACKING_ENABLED_DEFAULT = false;
    private static final boolean PRIVACY_CONSENT_REQUIRED_DEFAULT = false;
    private static final boolean LOG_ENABLED_DEFAULT = true;
    private static final boolean BACKGROUND_WAKEUP_ENABLED_DEFAULT = true;
    private String appId;
    private boolean visitsEnabledByDefault;
    private boolean screenTrackingEnabled;
    private boolean privacyConsentRequired;
    private boolean logEnabled;
    private Set<String> developmentDevices;
    private boolean backgroundWakeupEnabled;

    private InLocoOptions(Builder builder) {
        this.appId = builder.appId;
        this.visitsEnabledByDefault = builder.visitsEnabledByDefault != null ? builder.visitsEnabledByDefault : true;
        this.screenTrackingEnabled = builder.screenTrackingEnabled != null ? builder.screenTrackingEnabled : false;
        this.privacyConsentRequired = builder.privacyConsentRequired != null ? builder.privacyConsentRequired : false;
        this.logEnabled = builder.logEnabled != null ? builder.logEnabled : true;
        this.developmentDevices = builder.developmentDevices;
        this.backgroundWakeupEnabled = builder.backgroundWakeupEnabled != null ? builder.backgroundWakeupEnabled : true;
    }

    @Nullable
    public String getAppId() {
        return this.appId;
    }

    public boolean isVisitsEnabledByDefault() {
        return this.visitsEnabledByDefault;
    }

    public boolean isScreenTrackingEnabled() {
        return this.screenTrackingEnabled;
    }

    public boolean isPrivacyConsentRequired() {
        return this.privacyConsentRequired;
    }

    public boolean isLogEnabled() {
        return this.logEnabled;
    }

    @Nullable
    public Set<String> getDevelopmentDevices() {
        return this.developmentDevices;
    }

    public boolean isBackgroundWakeupEnabled() {
        return this.backgroundWakeupEnabled;
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        InLocoOptions inLocoOptions = (InLocoOptions)o2;
        if (this.visitsEnabledByDefault != inLocoOptions.visitsEnabledByDefault) {
            return false;
        }
        if (this.screenTrackingEnabled != inLocoOptions.screenTrackingEnabled) {
            return false;
        }
        if (this.privacyConsentRequired != inLocoOptions.privacyConsentRequired) {
            return false;
        }
        if (this.logEnabled != inLocoOptions.logEnabled) {
            return false;
        }
        if (this.backgroundWakeupEnabled != inLocoOptions.backgroundWakeupEnabled) {
            return false;
        }
        if (this.appId != null ? !this.appId.equals(inLocoOptions.appId) : inLocoOptions.appId != null) {
            return false;
        }
        return this.developmentDevices != null ? this.developmentDevices.equals(inLocoOptions.developmentDevices) : inLocoOptions.developmentDevices == null;
    }

    public int hashCode() {
        int n2 = this.appId != null ? this.appId.hashCode() : 0;
        n2 = 31 * n2 + (this.visitsEnabledByDefault ? 1 : 0);
        n2 = 31 * n2 + (this.screenTrackingEnabled ? 1 : 0);
        n2 = 31 * n2 + (this.privacyConsentRequired ? 1 : 0);
        n2 = 31 * n2 + (this.logEnabled ? 1 : 0);
        n2 = 31 * n2 + (this.developmentDevices != null ? this.developmentDevices.hashCode() : 0);
        n2 = 31 * n2 + (this.backgroundWakeupEnabled ? 1 : 0);
        return n2;
    }

    public String toString() {
        return "InLocoOptions{appId='" + this.appId + '\'' + ", visitsEnabledByDefault=" + this.visitsEnabledByDefault + ", screenTrackingEnabled=" + this.screenTrackingEnabled + ", privacyConsentRequired=" + this.privacyConsentRequired + ", logEnabled=" + this.logEnabled + ", developmentDevices=" + this.developmentDevices + ", backgroundWakeupEnabled=" + this.backgroundWakeupEnabled + '}';
    }

    @ApiAccess
    public static class Builder {
        private String appId;
        private Boolean visitsEnabledByDefault;
        private Boolean screenTrackingEnabled;
        private Boolean privacyConsentRequired;
        private Boolean logEnabled;
        private Set<String> developmentDevices;
        private Boolean backgroundWakeupEnabled;

        public Builder appId(String appId) {
            this.appId = appId;
            return this;
        }

        public Builder visitsEnabledByDefault(Boolean visitsEnabledByDefault) {
            this.visitsEnabledByDefault = visitsEnabledByDefault;
            return this;
        }

        public Builder screenTrackingEnabled(Boolean screenTrackingEnabled) {
            this.screenTrackingEnabled = screenTrackingEnabled;
            return this;
        }

        public Builder privacyConsentRequired(Boolean privacyConsentRequired) {
            this.privacyConsentRequired = privacyConsentRequired;
            return this;
        }

        public Builder logEnabled(Boolean logEnabled) {
            this.logEnabled = logEnabled;
            return this;
        }

        public Builder developmentDevices(Set<String> developmentDevices) {
            this.developmentDevices = developmentDevices;
            return this;
        }

        public Builder backgroundWakeupEnabled(Boolean backgroundWakeupEnabled) {
            this.backgroundWakeupEnabled = backgroundWakeupEnabled;
            return this;
        }

        public InLocoOptions build() {
            if (this.appId == null) {
                DevLogger.e((String)"InLocoOptions is missing App ID: SDK won't work if initialized with this InLocoOptions");
            }
            return new InLocoOptions(this);
        }
    }
}

