/*
 * Decompiled with CFR 0.152.
 */
package com.inlocomedia.android.common;

import android.content.Context;
import android.support.annotation.NonNull;
import com.inlocomedia.android.core.annotations.ApiAccess;
import com.inlocomedia.android.core.util.Validator;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

@ApiAccess
public class ConsentDialogOptions {
    private final Context context;
    private final String title;
    private final String message;
    private final String acceptText;
    private final String denyText;
    private final Set<String> consentTypes;

    private ConsentDialogOptions(Builder builder) {
        this.context = builder.context;
        this.title = builder.title;
        this.message = builder.message;
        this.acceptText = builder.acceptText;
        this.denyText = builder.denyText;
        this.consentTypes = builder.consentTypes;
    }

    public Context getContext() {
        return this.context;
    }

    public String getTitle() {
        return this.title;
    }

    public String getMessage() {
        return this.message;
    }

    public String getAcceptText() {
        return this.acceptText;
    }

    public String getDenyText() {
        return this.denyText;
    }

    public Set<String> getConsentTypes() {
        return this.consentTypes;
    }

    @ApiAccess
    public static class Builder {
        private Context context;
        private String title;
        private String message;
        private String acceptText;
        private String denyText;
        private Set<String> consentTypes;

        public Builder(Context context) {
            this.context = context;
        }

        public Builder title(String title) {
            this.title = title;
            return this;
        }

        public Builder message(@NonNull String message) {
            this.message = message;
            return this;
        }

        public Builder acceptText(@NonNull String acceptText) {
            this.acceptText = acceptText;
            return this;
        }

        public Builder denyText(@NonNull String denyText) {
            this.denyText = denyText;
            return this;
        }

        public Builder consentTypes(String ... consentTypes) {
            this.consentTypes = new HashSet<String>(Arrays.asList(consentTypes));
            return this;
        }

        public Builder consentTypes(@NonNull Set<String> consentTypes) {
            this.consentTypes = consentTypes;
            return this;
        }

        public ConsentDialogOptions build() {
            if (Validator.isNullOrEmpty((String)this.title)) {
                throw new IllegalArgumentException("The field 'Title' can't be empty or null");
            }
            if (Validator.isNullOrEmpty((String)this.message)) {
                throw new IllegalArgumentException("The field 'Message' can't be empty or null");
            }
            if (Validator.isNullOrEmpty((String)this.acceptText)) {
                throw new IllegalArgumentException("The field 'Accept Text' can't be empty or null");
            }
            if (Validator.isNullOrEmpty((String)this.denyText)) {
                throw new IllegalArgumentException("The field 'Deny Text' can't be empty or null");
            }
            if (Validator.isNullOrEmpty(this.consentTypes)) {
                throw new IllegalArgumentException("The field 'Consent Types' can't be empty or null");
            }
            return new ConsentDialogOptions(this);
        }
    }
}

