/*
 * Decompiled with CFR 0.152.
 */
package com.inlocomedia.android.ads;

import android.content.Context;
import android.graphics.Point;
import android.support.annotation.Nullable;
import android.view.WindowManager;
import com.inlocomedia.android.ads.private.cs;
import com.inlocomedia.android.core.annotations.ApiAccess;
import com.inlocomedia.android.core.private.br;
import com.inlocomedia.android.core.private.bx;
import com.inlocomedia.android.core.util.ag;
import org.json.JSONObject;

@ApiAccess
public enum AdType {
    NATIVE_LARGE("native_large_list", -1, -1),
    NATIVE_SMALL("native_small_list", -1, -1),
    NATIVE_OFFER("native_offer_list", -1, -1),
    DISPLAY_BANNER_SMALL("display_small", 320, 50),
    DISPLAY_BANNER_SMALL_LANDSCAPE("display_small_landscape", 480, 32),
    DISPLAY_BANNER_FULL_IAB("display_full_iab", 468, 60),
    DISPLAY_BANNER_LARGE("display_large", 320, 100),
    DISPLAY_BANNER_TABLET("display_tablet", 728, 90),
    DISPLAY_BANNER_MEDIUM_RECTANGLE("display_medium_rectangle_iab", 300, 250),
    DISPLAY_FULLSCREEN("display_full_screen", 320, 480),
    DISPLAY_FULLSCREEN_LANDSCAPE("display_full_screen_landscape", 480, 320),
    DISPLAY_FULLSCREEN_TABLET("display_full_screen_tablet", 768, 1024),
    DISPLAY_FULLSCREEN_TABLET_LANDSCAPE("display_full_screen_landscape_tablet", 1024, 768),
    DISPLAY_TILE("display_tile", 240, 240),
    SMART_BANNER("smart_banner", -1, -2);

    private static final float SMART_BANNER_HEIGHT_THRESHOLD = 0.15f;
    private String value;
    private int width;
    private int height;
    private ag screenHelper;

    private AdType(String value, int width, int height) {
        this.value = value;
        this.width = width;
        this.height = height;
        this.screenHelper = cs.b();
    }

    public bx getSize(Context context) {
        Point point = new Point();
        ((WindowManager)context.getSystemService("window")).getDefaultDisplay().getSize(point);
        float f2 = this.width;
        float f3 = this.height;
        if (f2 == -1.0f) {
            f2 = (float)point.x * this.screenHelper.b();
        }
        if (f3 == -1.0f) {
            f3 = (float)point.y * this.screenHelper.b();
        }
        return new bx(f2, f3);
    }

    public int getWidthPx(Context context) {
        return (int)((float)this.width * this.screenHelper.b());
    }

    public int getHeightPx(Context context) {
        return (int)((float)this.height * this.screenHelper.b());
    }

    public int getWidthDp() {
        return this.width;
    }

    public int getHeightDp() {
        return this.height;
    }

    public static AdType getBySize(int width, int height) {
        for (AdType adType : AdType.values()) {
            if (!adType.equals(width, height)) continue;
            return adType;
        }
        return null;
    }

    public static AdType getByValue(String value) {
        for (AdType adType : AdType.values()) {
            if (!adType.equals(value)) continue;
            return adType;
        }
        return null;
    }

    @Deprecated
    @Nullable
    public static AdType fromJSON(JSONObject json) throws br {
        return null;
    }

    @Deprecated
    public JSONObject parseToJSON(JSONObject json) throws br {
        return new JSONObject();
    }

    public String getValue() {
        return this.value;
    }

    @Deprecated
    public AdType getFunctionalAdType(Context context) {
        return null;
    }

    public String getAdUnitType() {
        switch (this) {
            case DISPLAY_BANNER_FULL_IAB: 
            case DISPLAY_BANNER_LARGE: 
            case DISPLAY_BANNER_MEDIUM_RECTANGLE: 
            case DISPLAY_BANNER_SMALL: 
            case DISPLAY_BANNER_SMALL_LANDSCAPE: 
            case DISPLAY_BANNER_TABLET: 
            case DISPLAY_TILE: 
            case SMART_BANNER: {
                return "banner";
            }
            case DISPLAY_FULLSCREEN: 
            case DISPLAY_FULLSCREEN_LANDSCAPE: 
            case DISPLAY_FULLSCREEN_TABLET: 
            case DISPLAY_FULLSCREEN_TABLET_LANDSCAPE: {
                return "interstitial";
            }
            case NATIVE_LARGE: 
            case NATIVE_OFFER: 
            case NATIVE_SMALL: {
                return "native";
            }
        }
        return null;
    }

    @Deprecated
    public static AdType getFullscreenType(Context context, int screenOrientation) {
        return null;
    }

    public boolean isDisplay() {
        switch (this) {
            case DISPLAY_BANNER_FULL_IAB: 
            case DISPLAY_BANNER_LARGE: 
            case DISPLAY_BANNER_MEDIUM_RECTANGLE: 
            case DISPLAY_BANNER_SMALL: 
            case DISPLAY_BANNER_SMALL_LANDSCAPE: 
            case DISPLAY_BANNER_TABLET: 
            case DISPLAY_TILE: 
            case SMART_BANNER: 
            case DISPLAY_FULLSCREEN: 
            case DISPLAY_FULLSCREEN_LANDSCAPE: 
            case DISPLAY_FULLSCREEN_TABLET: 
            case DISPLAY_FULLSCREEN_TABLET_LANDSCAPE: {
                return true;
            }
        }
        return false;
    }

    public boolean isNative() {
        switch (this) {
            case NATIVE_LARGE: 
            case NATIVE_OFFER: 
            case NATIVE_SMALL: {
                return true;
            }
        }
        return false;
    }

    public boolean isFullScreen() {
        switch (this) {
            case DISPLAY_FULLSCREEN: 
            case DISPLAY_FULLSCREEN_LANDSCAPE: 
            case DISPLAY_FULLSCREEN_TABLET: 
            case DISPLAY_FULLSCREEN_TABLET_LANDSCAPE: {
                return true;
            }
        }
        return false;
    }

    private boolean equals(int width, int height) {
        return this.getWidthDp() == width && this.getHeightDp() == height;
    }

    private boolean equals(String value) {
        return this.getValue().equals(value);
    }

    public String toString() {
        return this.value + "_" + this.getWidthDp() + "x" + this.getHeightDp();
    }

    public static AdType getByAttr(int attr) {
        switch (attr) {
            case 100: {
                return NATIVE_SMALL;
            }
            case 101: {
                return NATIVE_LARGE;
            }
            case 102: {
                return NATIVE_OFFER;
            }
            case 0: {
                return SMART_BANNER;
            }
            case 200: {
                return DISPLAY_BANNER_SMALL;
            }
            case 202: {
                return DISPLAY_BANNER_LARGE;
            }
            case 204: {
                return DISPLAY_BANNER_MEDIUM_RECTANGLE;
            }
            case 201: {
                return DISPLAY_BANNER_SMALL_LANDSCAPE;
            }
            case 203: {
                return DISPLAY_BANNER_FULL_IAB;
            }
            case 300: {
                return DISPLAY_FULLSCREEN;
            }
            case 301: {
                return DISPLAY_FULLSCREEN_LANDSCAPE;
            }
            case 205: {
                return DISPLAY_BANNER_TABLET;
            }
            case 302: {
                return DISPLAY_FULLSCREEN_TABLET;
            }
            case 303: {
                return DISPLAY_FULLSCREEN_TABLET_LANDSCAPE;
            }
            case 206: {
                return DISPLAY_TILE;
            }
        }
        return null;
    }
}

