/*
 * Decompiled with CFR 0.152.
 */
package com.inlocomedia.android.ads;

import android.content.Context;
import android.os.SystemClock;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import android.view.View;
import com.inlocomedia.android.ads.AdError;
import com.inlocomedia.android.ads.AdManagerListener;
import com.inlocomedia.android.ads.AdRequest;
import com.inlocomedia.android.ads.AdType;
import com.inlocomedia.android.ads.core.b;
import com.inlocomedia.android.ads.core.c;
import com.inlocomedia.android.ads.core.f;
import com.inlocomedia.android.ads.core.j;
import com.inlocomedia.android.ads.core.k;
import com.inlocomedia.android.ads.core.p;
import com.inlocomedia.android.ads.core.s;
import com.inlocomedia.android.ads.exception.AdvertisementException;
import com.inlocomedia.android.ads.private.bx;
import com.inlocomedia.android.ads.private.by;
import com.inlocomedia.android.ads.private.cs;
import com.inlocomedia.android.ads.private.da;
import com.inlocomedia.android.ads.private.m;
import com.inlocomedia.android.common.core.e;
import com.inlocomedia.android.common.core.i;
import com.inlocomedia.android.common.private.ah;
import com.inlocomedia.android.common.private.co;
import com.inlocomedia.android.core.annotations.ApiAccess;
import com.inlocomedia.android.core.log.DevLogger;
import com.inlocomedia.android.core.private.eh;
import com.inlocomedia.android.core.private.ej;
import com.inlocomedia.android.core.util.Validator;
import com.inlocomedia.android.core.util.ag;
import com.inlocomedia.android.core.util.an;
import com.inlocomedia.android.core.util.q;
import java.util.concurrent.atomic.AtomicBoolean;

@ApiAccess
public class AdManager {
    public static final String TAG = com.inlocomedia.android.core.log.a.a(AdManager.class);
    private static final int UNLOADED = 0;
    private static final int LOADING = 1;
    private static final int DEFAULT = 2;
    private static final int ON_AD_ERROR = 3;
    private static final int DESTROYED = 4;
    private static final int REFRESH_INTERVAL_DEFAULT = 30000;
    private static final int REFRESH_DISABLED = 0;
    private int mLoadState;
    private da mViewabilityTracker;
    @VisibleForTesting
    private long mRequestStartedTimestamp;
    @VisibleForTesting
    private long mRequestCompletedTimestamp;
    @VisibleForTesting
    private AdRequest mAdRequest;
    private a mAdRefresher;
    private long mRefreshInterval = 30000L;
    private String mAdUnitId;
    private by mCurrentAd;
    private View mAdView;
    private boolean mIsAdViewable;
    private com.inlocomedia.android.ads.a mAdViewManagerBuilder;
    private AdType mRequestedType;
    private j mAdViewManager;
    private AdManagerListener mAdManagerListener;
    private ah errorNotifier;
    private c adRequestManager;
    private com.inlocomedia.android.ads.util.b adLoadTimer;
    private j.a mAdViewManagerInterface = new j.a(){

        @Override
        public final void a(by by2, View view) {
            AdManager.this.mRequestCompletedTimestamp = SystemClock.elapsedRealtime();
            if (AdManager.this.mCurrentAd != null && AdManager.this.mCurrentAd != by2) {
                AdManager.this.mViewabilityTracker.a(AdManager.this.mCurrentAd);
            }
            AdManager.this.mIsAdViewable = false;
            AdManager.this.mAdView = view;
            AdManager.this.mCurrentAd = by2;
            AdManager.this.mViewabilityTracker.a(by2, view, new da.b(){

                @Override
                public void a() {
                    AdManager.this.onVisualizationRegistered();
                }

                @Override
                public void a(boolean bl2) {
                    AdManager.this.mIsAdViewable = bl2;
                    AdManager.this.onVisibilityChanged(AdManager.this.mAdView, AdManager.this.mIsAdViewable);
                }
            });
            AdManager.this.mLoadState = 2;
            AdManager.this.adLoadTimer.a(by2, true);
            DevLogger.i((String)"Ad view is ready");
            AdManager.this.mAdRefresher.d();
            AdManager.this.mAdRefresher.a();
            if (AdManager.this.mAdManagerListener != null) {
                AdManager.this.mAdManagerListener.onAdViewReady(AdManager.this);
            }
        }

        @Override
        public boolean a(by by2) {
            return AdManager.this.mViewabilityTracker.b(by2);
        }

        @Override
        public void a() {
            if (AdManager.this.mAdManagerListener != null) {
                AdManager.this.mAdManagerListener.onAdLeftApplication(AdManager.this);
            }
        }
    };

    public AdManager(com.inlocomedia.android.ads.a adViewManagerBuilder, AdType adType, da viewabilityTracker, AdManagerListener adManagerListener) {
        this.mViewabilityTracker = viewabilityTracker != null ? viewabilityTracker : new da();
        this.mIsAdViewable = false;
        this.mAdRefresher = new a(this);
        this.mAdManagerListener = adManagerListener;
        this.mRequestedType = adType;
        this.mAdViewManagerBuilder = adViewManagerBuilder;
        this.errorNotifier = co.a();
        this.adRequestManager = cs.e();
        this.adLoadTimer = new com.inlocomedia.android.ads.util.b();
        this.mLoadState = 0;
    }

    public final void loadAd(@NonNull Context context) {
        AdRequest adRequest = null;
        if (p.d.d()) {
            adRequest = new AdRequest();
        }
        this.loadAd(context, adRequest);
    }

    public final void loadAd(@NonNull Context context, AdRequest adRequest) {
        this.adLoadTimer.a();
        i.a((Context)context, s.a);
        this.errorNotifier = co.a();
        this.adRequestManager = cs.e();
        this.mRequestStartedTimestamp = SystemClock.elapsedRealtime();
        DevLogger.i((String)("Loading ad view" + (adRequest != null ? ". " + adRequest : "")));
        if (!this.mustRequestNewAd()) {
            return;
        }
        this.mAdRefresher.c();
        this.mAdRequest = adRequest;
        if (this.mAdRequest != null && this.mAdRequest.getAdUnitId() == null) {
            adRequest.setAdUnitId(this.mAdUnitId);
        }
        if (an.a((long)this.mRequestCompletedTimestamp, (long)SystemClock.elapsedRealtime(), (long)this.mRefreshInterval)) {
            this.requestAd(context, new bx(this.getType(), this.mAdRequest));
        } else {
            long l2 = SystemClock.elapsedRealtime() - this.mRequestCompletedTimestamp;
            this.mAdRefresher.a(this.mRefreshInterval - l2);
        }
    }

    private void requestAd(@NonNull Context context, bx target) {
        this.mLoadState = 1;
        b<com.inlocomedia.android.ads.b> b2 = new b<com.inlocomedia.android.ads.b>(context, target, (f)new com.inlocomedia.android.ads.c()){

            @Override
            public void a(com.inlocomedia.android.ads.b b2) {
                by by2 = b2.c();
                k k2 = b2.a();
                if (k2 != null) {
                    this.a(k2);
                }
                if (by2 != null) {
                    this.a(by2);
                }
            }

            @Override
            public void a(AdError adError) {
                AdManager.this.mRequestCompletedTimestamp = SystemClock.elapsedRealtime();
                AdManager.this.mLoadState = 3;
                AdManager.this.notifyAdError(adError);
                AdManager.this.mAdRefresher.a();
            }

            @Override
            private void a(k k2) {
                AdManager.this.setRefreshInterval(k2.b());
            }

            @Override
            private void a(by by2) {
                AdManager.this.loadFrom(by2);
            }
        };
        this.adRequestManager.a(b2);
    }

    public void loadFrom(by advertisement) {
        try {
            j j2;
            if (this.mAdViewManager == null) {
                j2 = this.mAdViewManagerBuilder.a(advertisement).a();
            } else if (this.mAdViewManager.a(advertisement.a())) {
                j2 = this.mAdViewManager;
            } else {
                this.mAdViewManager.d();
                j2 = this.mAdViewManagerBuilder.a(advertisement).a();
            }
            j2.a(advertisement, this.mAdViewManagerInterface);
            this.mAdViewManager = j2;
        }
        catch (Throwable throwable) {
            this.errorNotifier.a(TAG, throwable, (e)p.d);
            this.mAdManagerListener.onAdError(this, AdError.INTERNAL_ERROR);
        }
    }

    private boolean mustRequestNewAd() {
        if (!Validator.isValidSDKVersion()) {
            this.onValidationError("loadAd() failed. Invalid SDK version.", AdError.INVALID_SDK_VERSION);
            return false;
        }
        if (!p.d.d()) {
            this.onValidationError("loadAd() failed. The SDK is in a invalid state. Check the log for the error that caused it", AdError.INTERNAL_ERROR);
            return false;
        }
        if (this.mLoadState == 4) {
            DevLogger.w((String)"loadAd() failed. Ad view already destroyed");
            this.notifyAdError(AdError.INVALID_REQUEST);
            return false;
        }
        if (this.mLoadState == 1) {
            DevLogger.w((String)"loadAd() was ignored. Ad view is already loading.");
            return false;
        }
        try {
            m.a(this);
        }
        catch (AdvertisementException advertisementException) {
            this.onValidationError("loadAd() failed. Invalid request with error: " + advertisementException.b(), AdError.INVALID_REQUEST);
            return false;
        }
        return true;
    }

    private void onValidationError(String errorMessage, AdError adError) {
        this.mLoadState = 3;
        DevLogger.w((String)errorMessage);
        this.notifyAdError(adError);
        this.mAdRefresher.a();
    }

    public void onVisualizationRegistered() {
        if (this.mAdViewManager != null) {
            this.mAdViewManager.e();
        }
    }

    private void onVisibilityChanged(View view, boolean visible) {
        if (view.isInEditMode() || !Validator.isValidSDKVersion()) {
            return;
        }
        if (visible) {
            this.mAdRefresher.b();
        } else {
            this.mAdRefresher.c();
        }
    }

    private void notifyAdError(AdError adError) {
        DevLogger.w((String)("AdManager error: (" + (Object)((Object)adError) + ")"));
        this.adLoadTimer.a(this.mCurrentAd, false);
        if (this.mAdManagerListener != null) {
            this.mAdManagerListener.onAdError(this, adError);
        }
    }

    public void resume() {
        if (!Validator.isValidSDKVersion()) {
            return;
        }
        this.mAdRefresher.b();
    }

    public void pause() {
        if (!Validator.isValidSDKVersion()) {
            return;
        }
        this.mAdRefresher.c();
    }

    public void destroy() {
        if (!Validator.isValidSDKVersion()) {
            return;
        }
        this.mLoadState = 4;
        this.mAdRefresher.c();
        this.mViewabilityTracker.a();
        this.setRefreshInterval(0L);
        if (this.mAdView != null) {
            this.mAdView.setVisibility(8);
        }
    }

    public final boolean isLoaded() {
        return this.mLoadState == 2;
    }

    private void setRefreshInterval(long intervalInSeconds) {
        this.mRefreshInterval = intervalInSeconds;
    }

    private long getRefreshInterval() {
        return this.mRefreshInterval;
    }

    public void setRefreshEnabled(boolean enabled) {
        this.mRefreshInterval = enabled ? 30000L : 0L;
    }

    public final AdType getType() {
        return this.mRequestedType;
    }

    public final void setType(AdType type) {
        this.mRequestedType = type;
    }

    public void setAdUnitId(String adUnitId) {
        this.mAdUnitId = adUnitId;
    }

    public View getAdView() {
        return this.mAdView;
    }

    public void setAdManagerListener(AdManagerListener mAdManagerListener) {
        this.mAdManagerListener = mAdManagerListener;
    }

    public boolean isRefreshEnabled() {
        return this.mRefreshInterval != 0L;
    }

    private static class a {
        private AdManager a;
        private q b;
        private AtomicBoolean c = new AtomicBoolean(false);
        private long d;
        private long e;
        private ah f;
        private ag g;

        a(AdManager adManager) {
            this.e = adManager.getRefreshInterval();
            this.a = adManager;
            this.f = adManager.errorNotifier;
            this.g = cs.b();
        }

        private boolean a(@Nullable AdManager adManager) {
            return adManager != null && adManager.mAdView != null && adManager.isRefreshEnabled() && adManager.mIsAdViewable && (adManager.isLoaded() || adManager.mLoadState == 3);
        }

        private boolean b(@Nullable AdManager adManager) {
            return adManager != null && adManager.mAdView != null && this.g.a() && (adManager.mIsAdViewable || adManager.mLoadState == 3);
        }

        public boolean a() {
            return this.a != null && this.a(this.a.getRefreshInterval());
        }

        public boolean a(long l2) {
            boolean bl2 = this.b(l2);
            if (bl2) {
                this.e = l2;
                DevLogger.i((String)("Ad view refresh was started. Will refresh in " + l2 + "ms."));
            }
            return bl2;
        }

        public boolean b() {
            boolean bl2 = this.b(this.e);
            if (bl2) {
                DevLogger.i((String)("Ad view refresh was resumed. Will refresh in " + this.e + "ms."));
            }
            return bl2;
        }

        public boolean c() {
            boolean bl2 = this.e();
            if (bl2) {
                long l2 = SystemClock.elapsedRealtime() - this.d;
                this.e = Math.max(0L, this.e - l2);
                DevLogger.i((String)("Ad view refresh was paused " + this.e + "ms before refreshing."));
            }
            return bl2;
        }

        public void d() {
            this.e = this.a.getRefreshInterval();
        }

        private boolean b(long l2) {
            if (this.a(this.a) && this.c.compareAndSet(false, true)) {
                this.b = new q(){

                    public void a() {
                        a.this.c.set(false);
                        try {
                            if (a.this.b(a.this.a)) {
                                a.this.a.loadAd(a.this.a.getAdView().getContext(), a.this.a.mAdRequest);
                            } else {
                                DevLogger.i((String)"Ad view refresh was canceled. Ad view is not visible.");
                            }
                        }
                        catch (Throwable throwable) {
                            a.this.f.a(TAG, throwable, (e)p.d);
                        }
                        a.this.b = null;
                    }
                };
                eh.m().b(ej.e()).a((Runnable)this.b).b(l2).a((Thread.UncaughtExceptionHandler)p.d).b();
                this.d = SystemClock.elapsedRealtime();
                return true;
            }
            return false;
        }

        private boolean e() {
            if (this.c.compareAndSet(true, false)) {
                if (this.b != null) {
                    this.b.d();
                    this.b = null;
                }
                return true;
            }
            return false;
        }
    }
}

