/*
 * Decompiled with CFR 0.152.
 */
package com.inlocomedia.android.ads.nativeads;

import android.content.Context;
import com.inlocomedia.android.ads.AdError;
import com.inlocomedia.android.ads.AdRequest;
import com.inlocomedia.android.ads.AdType;
import com.inlocomedia.android.ads.c;
import com.inlocomedia.android.ads.core.f;
import com.inlocomedia.android.ads.core.q;
import com.inlocomedia.android.ads.models.a;
import com.inlocomedia.android.ads.models.d;
import com.inlocomedia.android.ads.nativeads.NativeAdResponse;
import com.inlocomedia.android.ads.nativeads.b;
import com.inlocomedia.android.ads.private.bh;
import com.inlocomedia.android.ads.profile.UserProfile;
import com.inlocomedia.android.core.annotations.ApiAccess;
import com.inlocomedia.android.core.log.DevLogger;
import com.inlocomedia.android.core.private.cm;
import com.inlocomedia.android.core.private.fb;
import com.inlocomedia.android.core.private.fm;
import com.inlocomedia.android.core.util.Validator;
import java.util.concurrent.TimeUnit;

@ApiAccess
public final class NativeAdManager {
    private NativeAdManager() {
    }

    public static void requestAd(final Context context, final AdRequest adRequest, final RequestListener listener) {
        q.e.a(context);
        if (NativeAdManager.checkForErrorsBeforeRequesting(listener)) {
            DevLogger.i((String)("Requesting NativeAd" + (adRequest != null ? ". " + adRequest : "")));
            a a2 = new a(AdType.NATIVE_LARGE, adRequest, 7);
            bh.k().a(new com.inlocomedia.android.ads.core.b<com.inlocomedia.android.ads.b>(context, a2, (f)new c()){

                @Override
                public void a(com.inlocomedia.android.ads.b b2) {
                    d d2 = (d)b2.c();
                    if (d2 != null) {
                        DevLogger.i((String)"NativeAd received");
                        if (adRequest.shouldFetchImages()) {
                            b.a a2 = NativeAdManager.createDownloadListener(listener);
                            b b3 = new b(a2);
                            b3.a(d2, context, TimeUnit.SECONDS.toMillis(15L));
                        } else {
                            final NativeAdResponse nativeAdResponse = new NativeAdResponse(d2);
                            fb.e().a(new Runnable(){

                                @Override
                                public void run() {
                                    if (listener != null) {
                                        listener.onAdReceived(nativeAdResponse);
                                    }
                                }
                            }, fm.f());
                        }
                    }
                }

                @Override
                public void a(AdError adError) {
                    DevLogger.w((String)("NativeAd request has failed with error: " + (Object)((Object)adError)));
                    NativeAdManager.notifyAdError(listener, adError);
                }
            });
        }
    }

    public static void requestAd(Context context, RequestListener listener) {
        AdRequest adRequest = null;
        if (q.e.a()) {
            adRequest = new AdRequest();
            adRequest.setUserProfile(UserProfile.getSavedProfile(context));
        }
        NativeAdManager.requestAd(context, adRequest, listener);
    }

    private static boolean checkForErrorsBeforeRequesting(RequestListener listener) {
        if (!Validator.isValidSDKVersion()) {
            DevLogger.w((String)"Request ad failed. Unsupported Android SDK version.");
            NativeAdManager.notifyAdError(listener, AdError.INVALID_SDK_VERSION);
            return false;
        }
        if (!q.e.a()) {
            DevLogger.w((String)"Request ad failed. Invalid sdk state");
            NativeAdManager.notifyAdError(listener, AdError.INTERNAL_ERROR);
            return false;
        }
        return true;
    }

    private static void notifyAdError(final RequestListener listener, final AdError adError) {
        fb.e().a(new Runnable(){

            @Override
            public void run() {
                if (listener != null) {
                    listener.onAdError(adError);
                }
            }
        }, fm.f());
    }

    private static b.a createDownloadListener(final RequestListener requestListener) {
        return new b.a(){

            @Override
            public void a(final NativeAdResponse nativeAdResponse) {
                fb.e().a(new Runnable(){

                    @Override
                    public void run() {
                        if (requestListener != null) {
                            requestListener.onAdReceived(nativeAdResponse);
                        }
                    }
                }, fm.f());
            }

            @Override
            public void a(cm cm2) {
                requestListener.onAdError(AdError.fromThrowable((Throwable)cm2));
            }
        };
    }

    @ApiAccess
    public static interface RequestListener {
        public void onAdReceived(NativeAdResponse var1);

        public void onAdError(AdError var1);
    }
}

