/*
 * Decompiled with CFR 0.152.
 */
package com.inlocomedia.android.ads.models;

import com.inlocomedia.android.ads.models.b;
import com.inlocomedia.android.core.annotations.ApiAccess;
import com.inlocomedia.android.core.private.cq;
import org.json.JSONException;
import org.json.JSONObject;

@ApiAccess
public class NotificationAd
extends b {
    private static final long serialVersionUID = 5383736211745408229L;
    private String title;
    private String description;
    private String iconUrl;
    private String imageUrl;
    private String htmlUrl;
    private String html;
    private boolean soundEnabled;
    private boolean vibrationEnabled;

    public NotificationAd(JSONObject json) throws cq {
        super(json, "notification");
    }

    @Override
    public void parseFromJSON(JSONObject json) throws cq {
        super.parseFromJSON(json);
        this.title = json.optString("title", null);
        this.description = json.optString("description", null);
        this.htmlUrl = json.optString("html_url", null);
        try {
            if (json.has("markup")) {
                this.html = json.getString("markup");
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        this.soundEnabled = json.optBoolean("sound_enabled", true);
        this.vibrationEnabled = json.optBoolean("vibration_enabled", true);
        this.iconUrl = json.optString("icon_url", null);
        this.imageUrl = json.optString("image_url", null);
        if (this.iconUrl == null) {
            this.iconUrl = this.imageUrl;
            this.imageUrl = null;
        }
    }

    @Override
    public JSONObject parseToJSON() {
        JSONObject jSONObject = super.parseToJSON();
        try {
            jSONObject.putOpt("title", (Object)this.title);
            jSONObject.putOpt("description", (Object)this.description);
            jSONObject.putOpt("icon_url", (Object)this.iconUrl);
            jSONObject.putOpt("html_url", (Object)this.htmlUrl);
            if (jSONObject.has("markup")) {
                jSONObject.put("markup", (Object)this.html);
            }
            jSONObject.putOpt("sound_enabled", (Object)this.soundEnabled);
            jSONObject.putOpt("vibration_enabled", (Object)this.vibrationEnabled);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return jSONObject;
    }

    @Override
    public String getAdContentType() {
        return "notification";
    }

    @Override
    public boolean isVideo() {
        return false;
    }

    public String getIconUrl() {
        return this.iconUrl;
    }

    public String getImageUrl() {
        return this.imageUrl;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String newTitle) {
        this.title = newTitle;
    }

    public String getDescription() {
        return this.description;
    }

    public String getHtmlUrl() {
        return this.htmlUrl;
    }

    public String getHtml() {
        return this.html;
    }

    public boolean isSoundEnabled() {
        return this.soundEnabled;
    }

    public boolean isVibrationEnabled() {
        return this.vibrationEnabled;
    }
}

