/*
 * Decompiled with CFR 0.152.
 */
package com.inlocomedia.android.ads;

import android.content.Context;
import android.os.SystemClock;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import android.view.View;
import com.inlocomedia.android.ads.AdError;
import com.inlocomedia.android.ads.AdManagerListener;
import com.inlocomedia.android.ads.AdRequest;
import com.inlocomedia.android.ads.AdType;
import com.inlocomedia.android.ads.core.b;
import com.inlocomedia.android.ads.core.c;
import com.inlocomedia.android.ads.core.f;
import com.inlocomedia.android.ads.core.i;
import com.inlocomedia.android.ads.core.j;
import com.inlocomedia.android.ads.core.o;
import com.inlocomedia.android.ads.exception.AdvertisementException;
import com.inlocomedia.android.ads.private.bf;
import com.inlocomedia.android.ads.private.bl;
import com.inlocomedia.android.ads.private.l;
import com.inlocomedia.android.ads.profile.UserProfile;
import com.inlocomedia.android.core.annotations.ApiAccess;
import com.inlocomedia.android.core.e;
import com.inlocomedia.android.core.log.DevLogger;
import com.inlocomedia.android.core.log.d;
import com.inlocomedia.android.core.private.eo;
import com.inlocomedia.android.core.private.eq;
import com.inlocomedia.android.core.util.Validator;
import com.inlocomedia.android.core.util.ai;
import com.inlocomedia.android.core.util.ao;
import com.inlocomedia.android.core.util.q;
import java.util.concurrent.atomic.AtomicBoolean;

@ApiAccess
public class AdManager {
    public static final String TAG = d.a(AdManager.class);
    private static final int UNLOADED = 0;
    private static final int LOADING = 1;
    private static final int DEFAULT = 2;
    private static final int ON_AD_ERROR = 3;
    private static final int DESTROYED = 4;
    private static final int REFRESH_INTERVAL_DEFAULT = 30000;
    private static final int REFRESH_DISABLED = 0;
    private int mLoadState;
    private bl mViewabilityTracker;
    @VisibleForTesting(otherwise=5)
    private long mRequestStartedTimestamp;
    @VisibleForTesting
    private long mRequestCompletedTimestamp;
    @VisibleForTesting
    private AdRequest mAdRequest;
    private a mAdRefresher;
    private long mRefreshInterval = 30000L;
    private String mAdUnitId;
    private com.inlocomedia.android.ads.models.b mCurrentAd;
    private View mAdView;
    private boolean mIsAdViewable;
    private com.inlocomedia.android.ads.a mAdViewManagerBuilder;
    private AdType mRequestedType;
    private i mAdViewManager;
    private AdManagerListener mAdManagerListener;
    private com.inlocomedia.android.core.log.c errorNotifier;
    private c adRequestManager;
    private com.inlocomedia.android.ads.util.b adLoadTimer;
    private i.a mAdViewManagerInterface = new i.a(){

        @Override
        public final void a(com.inlocomedia.android.ads.models.b b2, View view) {
            AdManager.this.mRequestCompletedTimestamp = SystemClock.elapsedRealtime();
            if (AdManager.this.mCurrentAd != null && AdManager.this.mCurrentAd != b2) {
                AdManager.this.mViewabilityTracker.a(AdManager.this.mCurrentAd);
            }
            AdManager.this.mIsAdViewable = false;
            AdManager.this.mAdView = view;
            AdManager.this.mCurrentAd = b2;
            AdManager.this.mViewabilityTracker.a(b2, view, new bl.b(){

                @Override
                public void a() {
                    AdManager.this.onVisualizationRegistered();
                }

                @Override
                public void a(boolean bl2) {
                    AdManager.this.mIsAdViewable = bl2;
                    AdManager.this.onVisibilityChanged(AdManager.this.mAdView, AdManager.this.mIsAdViewable);
                }
            });
            AdManager.this.mLoadState = 2;
            AdManager.this.adLoadTimer.a(b2, true);
            DevLogger.i((String)"Ad view is ready");
            AdManager.this.mAdRefresher.d();
            AdManager.this.mAdRefresher.a();
            if (AdManager.this.mAdManagerListener != null) {
                AdManager.this.mAdManagerListener.onAdViewReady(AdManager.this);
            }
        }

        @Override
        public boolean a(com.inlocomedia.android.ads.models.b b2) {
            return AdManager.this.mViewabilityTracker.b(b2);
        }

        @Override
        public void a() {
            if (AdManager.this.mAdManagerListener != null) {
                AdManager.this.mAdManagerListener.onAdLeftApplication(AdManager.this);
            }
        }
    };

    public AdManager(com.inlocomedia.android.ads.a adViewManagerBuilder, AdType adType, bl viewabilityTracker, AdManagerListener adManagerListener) {
        this.mViewabilityTracker = viewabilityTracker != null ? viewabilityTracker : new bl();
        this.mIsAdViewable = false;
        this.mAdRefresher = new a(this);
        this.mAdManagerListener = adManagerListener;
        this.mRequestedType = adType;
        this.mAdViewManagerBuilder = adViewManagerBuilder;
        this.errorNotifier = bf.a();
        this.adRequestManager = bf.k();
        this.adLoadTimer = new com.inlocomedia.android.ads.util.b();
        this.mLoadState = 0;
    }

    public final void loadAd(@NonNull Context context) {
        AdRequest adRequest = null;
        if (o.e.a()) {
            adRequest = new AdRequest();
            adRequest.setUserProfile(UserProfile.getSavedProfile(context));
        }
        this.loadAd(context, adRequest);
    }

    public final void loadAd(@NonNull Context context, AdRequest adRequest) {
        this.adLoadTimer.a();
        o.e.a(context);
        this.errorNotifier = bf.a();
        this.adRequestManager = bf.k();
        this.mRequestStartedTimestamp = SystemClock.elapsedRealtime();
        DevLogger.i((String)("Loading ad view" + (adRequest != null ? ". " + adRequest : "")));
        if (!this.mustRequestNewAd()) {
            return;
        }
        this.mAdRefresher.c();
        this.mAdRequest = adRequest;
        if (this.mAdRequest != null && this.mAdRequest.getAdUnitId() == null) {
            adRequest.setAdUnitId(this.mAdUnitId);
        }
        if (ao.a((long)this.mRequestCompletedTimestamp, (long)SystemClock.elapsedRealtime(), (long)this.mRefreshInterval)) {
            this.requestAd(context, new com.inlocomedia.android.ads.models.a(this.getType(), this.mAdRequest));
        } else {
            long l2 = SystemClock.elapsedRealtime() - this.mRequestCompletedTimestamp;
            this.mAdRefresher.a(this.mRefreshInterval - l2);
        }
    }

    private void requestAd(@NonNull Context context, com.inlocomedia.android.ads.models.a target) {
        this.mLoadState = 1;
        b<com.inlocomedia.android.ads.b> b2 = new b<com.inlocomedia.android.ads.b>(context, target, (f)new com.inlocomedia.android.ads.c()){

            @Override
            public void a(com.inlocomedia.android.ads.b b2) {
                com.inlocomedia.android.ads.models.b b3 = b2.c();
                j j2 = b2.a();
                if (j2 != null) {
                    this.a(j2);
                }
                if (b3 != null) {
                    this.a(b3);
                }
            }

            @Override
            public void a(AdError adError) {
                AdManager.this.mRequestCompletedTimestamp = SystemClock.elapsedRealtime();
                AdManager.this.mLoadState = 3;
                AdManager.this.notifyAdError(adError);
                AdManager.this.mAdRefresher.a();
            }

            @Override
            private void a(j j2) {
                AdManager.this.setRefreshInterval(j2.b());
            }

            @Override
            private void a(com.inlocomedia.android.ads.models.b b2) {
                AdManager.this.loadFrom(b2);
            }
        };
        this.adRequestManager.a(b2);
    }

    public void loadFrom(com.inlocomedia.android.ads.models.b advertisement) {
        try {
            i i2;
            if (this.mAdViewManager == null) {
                i2 = this.mAdViewManagerBuilder.a(advertisement).a();
            } else if (this.mAdViewManager.a(advertisement.getAdContentType())) {
                i2 = this.mAdViewManager;
            } else {
                this.mAdViewManager.d();
                i2 = this.mAdViewManagerBuilder.a(advertisement).a();
            }
            i2.a(advertisement, this.mAdViewManagerInterface);
            this.mAdViewManager = i2;
        }
        catch (Throwable throwable) {
            this.errorNotifier.a(TAG, throwable, (e)o.e);
            this.mAdManagerListener.onAdError(this, AdError.INTERNAL_ERROR);
        }
    }

    private boolean mustRequestNewAd() {
        if (!Validator.isValidSDKVersion()) {
            this.onValidationError("loadAd() failed. Invalid SDK version.", AdError.INVALID_SDK_VERSION);
            return false;
        }
        if (!o.e.a()) {
            this.onValidationError("loadAd() failed. The SDK is in a invalid state. Check the log for the error that caused it", AdError.INTERNAL_ERROR);
            return false;
        }
        if (this.mLoadState == 4) {
            DevLogger.w((String)"loadAd() failed. Ad view already destroyed");
            this.notifyAdError(AdError.INVALID_REQUEST);
            return false;
        }
        if (this.mLoadState == 1) {
            DevLogger.w((String)"loadAd() was ignored. Ad view is already loading.");
            return false;
        }
        try {
            l.a(this);
        }
        catch (AdvertisementException advertisementException) {
            this.onValidationError("loadAd() failed. Invalid request with error: " + advertisementException.b(), AdError.INVALID_REQUEST);
            return false;
        }
        return true;
    }

    private void onValidationError(String errorMessage, AdError adError) {
        this.mLoadState = 3;
        DevLogger.w((String)errorMessage);
        this.notifyAdError(adError);
        this.mAdRefresher.a();
    }

    public void onVisualizationRegistered() {
        if (this.mAdViewManager != null) {
            this.mAdViewManager.e();
        }
    }

    private void onVisibilityChanged(View view, boolean visible) {
        if (view.isInEditMode() || !Validator.isValidSDKVersion()) {
            return;
        }
        if (visible) {
            this.mAdRefresher.b();
        } else {
            this.mAdRefresher.c();
        }
    }

    private void notifyAdError(AdError adError) {
        DevLogger.w((String)("AdManager error: (" + (Object)((Object)adError) + ")"));
        this.adLoadTimer.a(this.mCurrentAd, false);
        if (this.mAdManagerListener != null) {
            this.mAdManagerListener.onAdError(this, adError);
        }
    }

    public void resume() {
        if (!Validator.isValidSDKVersion()) {
            return;
        }
        this.mAdRefresher.b();
    }

    public void pause() {
        if (!Validator.isValidSDKVersion()) {
            return;
        }
        this.mAdRefresher.c();
    }

    public void destroy() {
        if (!Validator.isValidSDKVersion()) {
            return;
        }
        this.mLoadState = 4;
        this.mAdRefresher.c();
        this.mViewabilityTracker.a();
        this.setRefreshInterval(0L);
        if (this.mAdView != null) {
            this.mAdView.setVisibility(8);
        }
    }

    public final boolean isLoaded() {
        return this.mLoadState == 2;
    }

    private void setRefreshInterval(long intervalInSeconds) {
        this.mRefreshInterval = intervalInSeconds;
    }

    private long getRefreshInterval() {
        return this.mRefreshInterval;
    }

    public void setRefreshEnabled(boolean enabled) {
        this.mRefreshInterval = enabled ? 30000L : 0L;
    }

    public final AdType getType() {
        return this.mRequestedType;
    }

    public final void setType(AdType type) {
        this.mRequestedType = type;
    }

    public void setAdUnitId(String adUnitId) {
        this.mAdUnitId = adUnitId;
    }

    public View getAdView() {
        return this.mAdView;
    }

    public void setAdManagerListener(AdManagerListener mAdManagerListener) {
        this.mAdManagerListener = mAdManagerListener;
    }

    public boolean isRefreshEnabled() {
        return this.mRefreshInterval != 0L;
    }

    private static class a {
        private AdManager a;
        private q b;
        private AtomicBoolean c = new AtomicBoolean(false);
        private long d;
        private long e;
        private com.inlocomedia.android.core.log.c f;
        private ai g;

        a(AdManager adManager) {
            this.e = adManager.getRefreshInterval();
            this.a = adManager;
            this.f = adManager.errorNotifier;
            this.g = bf.e();
        }

        private boolean a(@Nullable AdManager adManager) {
            return adManager != null && adManager.mAdView != null && adManager.isRefreshEnabled() && adManager.mIsAdViewable && (adManager.isLoaded() || adManager.mLoadState == 3);
        }

        private boolean b(@Nullable AdManager adManager) {
            return adManager != null && adManager.mAdView != null && this.g.a() && (adManager.mIsAdViewable || adManager.mLoadState == 3);
        }

        public boolean a() {
            return this.a != null && this.a(this.a.getRefreshInterval());
        }

        public boolean a(long l2) {
            boolean bl2 = this.b(l2);
            if (bl2) {
                this.e = l2;
                DevLogger.i((String)("Ad view refresh was started. Will refresh in " + l2 + "ms."));
            }
            return bl2;
        }

        public boolean b() {
            boolean bl2 = this.b(this.e);
            if (bl2) {
                DevLogger.i((String)("Ad view refresh was resumed. Will refresh in " + this.e + "ms."));
            }
            return bl2;
        }

        public boolean c() {
            boolean bl2 = this.e();
            if (bl2) {
                long l2 = SystemClock.elapsedRealtime() - this.d;
                this.e = Math.max(0L, this.e - l2);
                DevLogger.i((String)("Ad view refresh was paused " + this.e + "ms before refreshing."));
            }
            return bl2;
        }

        public void d() {
            this.e = this.a.getRefreshInterval();
        }

        private boolean b(long l2) {
            if (this.a(this.a) && this.c.compareAndSet(false, true)) {
                this.b = new q(){

                    public void a() {
                        a.this.c.set(false);
                        try {
                            if (a.this.b(a.this.a)) {
                                a.this.a.loadAd(a.this.a.getAdView().getContext(), a.this.a.mAdRequest);
                            } else {
                                DevLogger.i((String)"Ad view refresh was canceled. Ad view is not visible.");
                            }
                        }
                        catch (Throwable throwable) {
                            a.this.f.a(TAG, throwable, (e)o.e);
                        }
                        a.this.b = null;
                    }
                };
                eo.m().b(eq.e()).a((Runnable)this.b).b(l2).a((Thread.UncaughtExceptionHandler)o.e).b();
                this.d = SystemClock.elapsedRealtime();
                return true;
            }
            return false;
        }

        private boolean e() {
            if (this.c.compareAndSet(true, false)) {
                if (this.b != null) {
                    this.b.d();
                    this.b = null;
                }
                return true;
            }
            return false;
        }
    }
}

