/*
 * Decompiled with CFR 0.152.
 */
package com.inlocomedia.android.ads.models;

import android.support.annotation.VisibleForTesting;
import com.inlocomedia.android.core.private.bx;
import com.inlocomedia.android.core.private.cb;
import com.inlocomedia.android.core.private.dp;
import com.inlocomedia.android.core.private.dq;
import com.inlocomedia.android.core.util.ak;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class b
implements dq,
Serializable {
    private static final long serialVersionUID = 1692143295088426602L;
    private String adId;
    private String creativeId;
    private String adUnitType;
    @VisibleForTesting
    public cb size;
    private HashMap<String, String> clickDestinationUrls;
    private HashMap<String, String> deeplinkUrls;
    private String registerViewabilityUrl;
    private Set<String> registerViewabilityUrls;
    private Set<String> registerPageViewUrls;
    private String registerClickUrl;
    private String backToApplicationUrl;
    private String adRequestId;
    private long timestamp;
    private boolean responsive;
    private int screenOrientation;
    private boolean useExternalBrowser;
    private boolean miniBrowserOverviewMode;

    public b() {
    }

    protected b(JSONObject jSONObject, String string2) throws bx {
        this.adUnitType = string2;
        this.parseFromJSON(jSONObject);
    }

    public void parseFromJSON(JSONObject json) throws bx {
        try {
            int n2;
            if (json.has("campaign_id")) {
                this.adId = json.getString("campaign_id");
            }
            if (json.has("creative_id")) {
                this.creativeId = json.getString("creative_id");
            }
            if (json.has("size")) {
                this.size = new cb(json.getJSONObject("size"));
            }
            if (json.has("responsive")) {
                this.responsive = json.getBoolean("responsive");
            }
            if (json.has("orientation")) {
                int n3 = json.getInt("orientation");
                switch (n3) {
                    case 2: {
                        this.screenOrientation = 2;
                        break;
                    }
                    case 1: {
                        this.screenOrientation = 1;
                        break;
                    }
                    default: {
                        this.screenOrientation = 0;
                    }
                }
            }
            if (json.has("click_destination_urls")) {
                this.clickDestinationUrls = dp.a((JSONObject)json.getJSONObject("click_destination_urls"));
            }
            if (json.has("deeplink_urls")) {
                this.deeplinkUrls = dp.a((JSONObject)json.getJSONObject("deeplink_urls"));
            }
            if (json.has("viewability_url")) {
                this.registerViewabilityUrl = json.getString("viewability_url");
            }
            if (json.has("viewability_urls")) {
                this.registerViewabilityUrls = new HashSet<String>();
                JSONArray jSONArray = json.getJSONArray("viewability_urls");
                for (n2 = 0; n2 < jSONArray.length(); ++n2) {
                    this.registerViewabilityUrls.add(jSONArray.getString(n2));
                }
            }
            if (json.has("page_view_urls")) {
                this.registerPageViewUrls = new HashSet<String>();
                JSONArray jSONArray = json.getJSONArray("page_view_urls");
                for (n2 = 0; n2 < jSONArray.length(); ++n2) {
                    this.registerPageViewUrls.add(jSONArray.getString(n2));
                }
            }
            if (json.has("click_url")) {
                this.registerClickUrl = json.getString("click_url");
            }
            if (json.has("back_to_application_url")) {
                this.backToApplicationUrl = json.getString("back_to_application_url");
            }
            this.useExternalBrowser = json.optBoolean("use_external_browser", true);
            this.miniBrowserOverviewMode = json.optBoolean("overview_mode", false);
            this.adRequestId = json.optString("ad_request_id", null);
        }
        catch (JSONException jSONException) {
            throw new bx("Invalid JSONMapping for Advertisement", (Exception)((Object)jSONException));
        }
    }

    public JSONObject parseToJSON() {
        JSONObject jSONObject = new JSONObject();
        try {
            JSONArray jSONArray;
            if (this.adId != null) {
                jSONObject.put("campaign_id", (Object)this.adId);
            }
            if (this.creativeId != null) {
                jSONObject.put("creative_id", (Object)this.creativeId);
            }
            if (this.size != null) {
                jSONObject.put("size", (Object)this.size);
            }
            jSONObject.put("responsive", this.responsive);
            jSONObject.put("orientation", this.screenOrientation);
            if (this.registerViewabilityUrl != null) {
                jSONObject.put("viewability_url", (Object)this.registerViewabilityUrl);
            }
            if (this.registerViewabilityUrls != null && !this.registerViewabilityUrls.isEmpty()) {
                jSONArray = new JSONArray();
                for (String string2 : this.registerViewabilityUrls) {
                    jSONArray.put((Object)string2);
                }
                jSONObject.put("viewability_urls", (Object)jSONArray);
            }
            if (this.registerPageViewUrls != null && !this.registerPageViewUrls.isEmpty()) {
                jSONArray = new JSONArray();
                for (String string2 : this.registerPageViewUrls) {
                    jSONArray.put((Object)string2);
                }
                jSONObject.put("page_view_urls", (Object)jSONArray);
            }
            if (this.registerClickUrl != null) {
                jSONObject.put("click_url", (Object)this.registerClickUrl);
            }
            if (this.backToApplicationUrl != null) {
                jSONObject.put("back_to_application_url", (Object)this.backToApplicationUrl);
            }
            if (!this.useExternalBrowser) {
                jSONObject.put("use_external_browser", this.useExternalBrowser);
            }
            if (this.miniBrowserOverviewMode) {
                jSONObject.put("overview_mode", this.miniBrowserOverviewMode);
            }
            if (this.adRequestId != null) {
                jSONObject.put("ad_request_id", (Object)this.adRequestId);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return jSONObject;
    }

    public abstract String getAdContentType();

    public String getAdUnitType() {
        return this.adUnitType;
    }

    public cb getSize() {
        return this.size;
    }

    public String getBackToApplicationUrl() {
        return this.backToApplicationUrl;
    }

    public void setBackToApplicationUrl(String newBackToApplicationUrl) {
        this.backToApplicationUrl = newBackToApplicationUrl;
    }

    public String getRegisterClickUrl() {
        return this.registerClickUrl;
    }

    public void setRegisterClickUrl(String newRegisterClickUrl) {
        this.registerClickUrl = newRegisterClickUrl;
    }

    public String getRegisterViewabilityUrl() {
        return this.registerViewabilityUrl;
    }

    public void setRegisterViewabilityUrl(String registerUrl) {
        this.registerViewabilityUrl = registerUrl;
    }

    public Set<String> getRegisterViewabilityUrls() {
        return this.registerViewabilityUrls;
    }

    public void setRegisterViewabilityUrls(Set<String> registerViewabilityUrls) {
        this.registerViewabilityUrls = registerViewabilityUrls;
    }

    public Set<String> getRegisterPageViewUrls() {
        return this.registerPageViewUrls;
    }

    public void setRegisterPageViewUrls(Set<String> registerPageViewUrls) {
        this.registerPageViewUrls = registerPageViewUrls;
    }

    public String getAdId() {
        return this.adId;
    }

    public void setAdId(String adId) {
        this.adId = adId;
    }

    public String getCreativeId() {
        return this.creativeId;
    }

    public void setCreativeId(String creativeId) {
        this.creativeId = creativeId;
    }

    @VisibleForTesting
    public HashMap<String, String> getDeeplinkUrls() {
        return this.deeplinkUrls;
    }

    @VisibleForTesting
    public HashMap<String, String> getClickDestinationUrls() {
        return this.clickDestinationUrls;
    }

    public String getContentUrl(String key) {
        return this.getUrlFromHash(this.clickDestinationUrls, key);
    }

    public String getFirstContentUrlKey() {
        return this.getFirstKeyFromHash(this.clickDestinationUrls);
    }

    public String getFirstContentUrl() {
        return this.getFirstUrlFromHash(this.clickDestinationUrls);
    }

    public String getDeeplinkUrl(String key) {
        return this.getUrlFromHash(this.deeplinkUrls, key);
    }

    public String getFirstDeeplinkUrl() {
        return this.getFirstUrlFromHash(this.deeplinkUrls);
    }

    public boolean isResponsive() {
        return this.responsive;
    }

    public int getScreenOrientation() {
        return this.screenOrientation;
    }

    private String getFirstKeyFromHash(HashMap<String, String> hash) {
        return hash != null ? hash.keySet().iterator().next() : null;
    }

    private String getFirstUrlFromHash(HashMap<String, String> hash) {
        return hash != null ? hash.get(hash.keySet().iterator().next()) : null;
    }

    private String getUrlFromHash(HashMap<String, String> hash, String key) {
        return hash != null ? hash.get(key) : null;
    }

    public byte[] toBytes() throws bx {
        return ak.a((Serializable)this);
    }

    public String getAdRequestId() {
        return this.adRequestId;
    }

    public void setAdRequestId(String adRequestId) {
        this.adRequestId = adRequestId;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public abstract boolean isVideo();

    public boolean shouldUseExternalBrowser() {
        return this.useExternalBrowser;
    }

    public boolean isOverviewModeEnabled() {
        return this.miniBrowserOverviewMode;
    }

    public void setUseExternalBrowser(boolean useExternalBrowser) {
        this.useExternalBrowser = useExternalBrowser;
    }

    public void setOverviewModeEnabled(boolean miniBrowserOverviewMode) {
        this.miniBrowserOverviewMode = miniBrowserOverviewMode;
    }

    public String toString() {
        return "Ad [AdId:" + this.getAdId() + "], [ContentType:" + this.getAdContentType() + " ]";
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        b b2 = (b)o2;
        if (this.adRequestId != null ? !this.adRequestId.equals(b2.adRequestId) : b2.adRequestId != null) {
            return false;
        }
        if (this.timestamp != b2.timestamp) {
            return false;
        }
        if (this.responsive != b2.responsive) {
            return false;
        }
        if (this.screenOrientation != b2.screenOrientation) {
            return false;
        }
        if (this.useExternalBrowser != b2.useExternalBrowser) {
            return false;
        }
        if (this.miniBrowserOverviewMode != b2.miniBrowserOverviewMode) {
            return false;
        }
        if (this.adId != null ? !this.adId.equals(b2.adId) : b2.adId != null) {
            return false;
        }
        if (this.creativeId != null ? !this.creativeId.equals(b2.creativeId) : b2.creativeId != null) {
            return false;
        }
        if (this.adUnitType != null ? !this.adUnitType.equals(b2.adUnitType) : b2.adUnitType != null) {
            return false;
        }
        if (this.size != null ? !this.size.equals((Object)b2.size) : b2.size != null) {
            return false;
        }
        if (this.clickDestinationUrls != null ? !this.clickDestinationUrls.equals(b2.clickDestinationUrls) : b2.clickDestinationUrls != null) {
            return false;
        }
        if (this.deeplinkUrls != null ? !this.deeplinkUrls.equals(b2.deeplinkUrls) : b2.deeplinkUrls != null) {
            return false;
        }
        if (this.registerViewabilityUrl != null ? !this.registerViewabilityUrl.equals(b2.registerViewabilityUrl) : b2.registerViewabilityUrl != null) {
            return false;
        }
        if (this.registerViewabilityUrls != null ? !this.registerViewabilityUrls.equals(b2.registerViewabilityUrls) : b2.registerViewabilityUrls != null) {
            return false;
        }
        if (this.registerPageViewUrls != null ? !this.registerPageViewUrls.equals(b2.registerPageViewUrls) : b2.registerPageViewUrls != null) {
            return false;
        }
        if (this.registerClickUrl != null ? !this.registerClickUrl.equals(b2.registerClickUrl) : b2.registerClickUrl != null) {
            return false;
        }
        return !(this.backToApplicationUrl == null ? b2.backToApplicationUrl != null : !this.backToApplicationUrl.equals(b2.backToApplicationUrl));
    }

    public int hashCode() {
        int n2 = this.adId != null ? this.adId.hashCode() : 0;
        n2 = 31 * n2 + (this.creativeId != null ? this.creativeId.hashCode() : 0);
        n2 = 31 * n2 + this.getAdContentType().hashCode();
        n2 = 31 * n2 + (this.clickDestinationUrls != null ? this.clickDestinationUrls.hashCode() : 0);
        n2 = 31 * n2 + (this.deeplinkUrls != null ? this.deeplinkUrls.hashCode() : 0);
        n2 = 31 * n2 + (this.registerViewabilityUrl != null ? this.registerViewabilityUrl.hashCode() : 0);
        n2 = 31 * n2 + (this.registerViewabilityUrls != null ? this.registerViewabilityUrls.hashCode() : 0);
        n2 = 31 * n2 + (this.registerPageViewUrls != null ? this.registerPageViewUrls.hashCode() : 0);
        n2 = 31 * n2 + (this.registerClickUrl != null ? this.registerClickUrl.hashCode() : 0);
        n2 = 31 * n2 + (this.backToApplicationUrl != null ? this.backToApplicationUrl.hashCode() : 0);
        n2 = 31 * n2 + (this.adRequestId != null ? this.adRequestId.hashCode() : 0);
        n2 = 31 * n2 + (int)(this.timestamp ^ this.timestamp >>> 32);
        return n2;
    }
}

