/*
 * Decompiled with CFR 0.152.
 */
package com.inlocomedia.android.ads.util;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import android.view.ViewPropertyAnimator;
import android.widget.ImageView;
import com.inlocomedia.android.ads.private.bd;
import com.inlocomedia.android.ads.util.ImageRequest;
import com.inlocomedia.android.core.R;
import com.inlocomedia.android.core.annotations.ApiAccess;
import com.inlocomedia.android.core.c;
import com.inlocomedia.android.core.e;
import com.inlocomedia.android.core.log.c;
import com.inlocomedia.android.core.private.bt;
import com.inlocomedia.android.core.private.bv;
import com.inlocomedia.android.core.private.dw;
import com.inlocomedia.android.core.private.dy;
import com.inlocomedia.android.core.private.dz;
import com.inlocomedia.android.core.private.ec;
import com.inlocomedia.android.core.private.ed;
import com.inlocomedia.android.core.private.ei;
import com.inlocomedia.android.core.private.k;
import com.inlocomedia.android.core.private.z;

@TargetApi(value=14)
@ApiAccess
public final class ImageViewDownloadManager {
    private static final String TAG = c.a(ImageViewDownloadManager.class);
    private static final int TAG_KEY_URL = R.id.ilm_private_id_url;
    private static final int TAG_KEY_IS_RECYCLED = R.id.ilm_private_id_recycled;
    private static final int TAG_KEY_PLACEHOLDER = R.id.ilm_private_id_placeholder;
    private static final int TAG_KEY_REQUEST = R.id.ilm_private_id_request;
    private static final int TAG_KEY_BITMAP_REQUEST_LISTENER = R.id.ilm_private_id_request_listener;
    private static final int TAG_KEY_USER_LISTENER = R.id.ilm_private_id_user_listener;

    public static ImageRequest with(Context context) {
        return new ImageRequest(context);
    }

    public static void setMaxMemoryCacheSize(int maxMemorySize) {
        bd.d().a(maxMemorySize);
    }

    public static void clearMemoryCache() {
        bd.d().a();
    }

    static boolean downloadAndSet(final @NonNull ImageRequest imageRequest) {
        try {
            final ImageView imageView = imageRequest.getImageView();
            String string2 = imageRequest.getUrl();
            z<Void> z2 = imageRequest.getListener();
            if (string2.equals(imageView.getTag(TAG_KEY_URL))) {
                return false;
            }
            dw.m().b(dy.e()).b((dz)new ed(){

                public void a() throws Throwable {
                    imageView.setImageDrawable(null);
                    imageView.measure(0, 0);
                    if (imageRequest.hasPlaceholderImage()) {
                        ImageViewDownloadManager.displayInProgressPlaceholder(imageView, imageRequest.getPlaceholderDrawable());
                    }
                }
            }).c();
            ImageViewDownloadManager.cancelPotentialDownload(imageView);
            ImageViewDownloadManager.saveUrl(imageView, string2);
            ImageViewDownloadManager.saveUserListener(imageView, z2);
            ImageViewDownloadManager.savePlaceholderIfNecessary(imageView);
            Bitmap bitmap = null;
            if (imageRequest.isMemoryCacheEnabled()) {
                bitmap = bd.d().a(string2);
            }
            if (bitmap != null && bitmap.getWidth() >= imageView.getMeasuredWidth() && bitmap.getHeight() >= imageView.getMeasuredHeight()) {
                imageView.setImageBitmap(bitmap);
                if (z2 != null) {
                    z2.a(null);
                }
                return false;
            }
            a a2 = new a(imageRequest, string2);
            imageView.setTag(TAG_KEY_BITMAP_REQUEST_LISTENER, (Object)a2);
            imageView.setTag(TAG_KEY_REQUEST, (Object)bd.k().a(string2, a2, string2, null, imageRequest.getImageView(), imageRequest.getMaxWidth(), imageRequest.getMaxHeight()));
            return true;
        }
        catch (Throwable throwable) {
            bd.a().a(TAG, throwable, (e)c.b.a);
            return false;
        }
    }

    private static void cancelPotentialDownload(@NonNull ImageView iv) {
        try {
            a a2;
            final k k2 = (k)iv.getTag(TAG_KEY_REQUEST);
            if (k2 != null) {
                dw.m().b((ei)dy.b()).b((dz)new ed(){

                    public void a() throws Throwable {
                        k2.a();
                    }
                }).c();
            }
            if ((a2 = (a)iv.getTag(TAG_KEY_BITMAP_REQUEST_LISTENER)) != null) {
                a2.a();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void saveUserListener(@NonNull ImageView iv, @Nullable z<Void> listener) {
        iv.setTag(TAG_KEY_USER_LISTENER, listener);
    }

    private static void saveUrl(@NonNull ImageView iv, @NonNull String imageUrl) {
        iv.setTag(TAG_KEY_URL, (Object)imageUrl);
    }

    private static void savePlaceholderIfNecessary(@NonNull ImageView iv) {
        try {
            boolean bl;
            boolean bl2 = bl = iv.getTag(TAG_KEY_IS_RECYCLED) != null;
            if (!bl) {
                iv.setTag(TAG_KEY_IS_RECYCLED, (Object)true);
                Drawable drawable2 = iv.getDrawable();
                if (drawable2 != null) {
                    iv.setTag(TAG_KEY_PLACEHOLDER, (Object)drawable2.getConstantState());
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void displayInProgressPlaceholder(final @NonNull ImageView iv, final Drawable placeholder) {
        dw.m().b(dy.e()).b((dz)new ed(){

            public void a() throws Throwable {
                iv.setImageDrawable(placeholder);
                ImageViewDownloadManager.showImageView(iv, false);
            }
        }).a(new ec(){

            public void a(Throwable t2) throws Throwable {
                ImageViewDownloadManager.hideImageView(iv, false);
            }
        }).c();
    }

    private static void displayErrorPlaceholderIfExists(final @NonNull ImageRequest imageRequest) {
        dw.m().b(dy.e()).b((dz)new ed(){

            public void a() throws Throwable {
                ImageView imageView = imageRequest.getImageView();
                if (imageRequest.hasErrorImage()) {
                    imageView.setImageDrawable(imageRequest.getErrorDrawable());
                    ImageViewDownloadManager.showImageView(imageView, false);
                } else {
                    ImageViewDownloadManager.hideImageView(imageView, false);
                }
            }
        }).a(new ec(){

            public void a(Throwable t2) throws Throwable {
                ImageViewDownloadManager.hideImageView(imageRequest.getImageView(), false);
            }
        }).c();
    }

    private static void showImageView(@NonNull ImageView iv, boolean fade) {
        if (fade) {
            ViewPropertyAnimator viewPropertyAnimator = iv.animate();
            viewPropertyAnimator.cancel();
            iv.setAlpha(0.0f);
            viewPropertyAnimator.alpha(1.0f).start();
        } else {
            iv.setAlpha(1.0f);
        }
    }

    private static void hideImageView(ImageView iv, boolean fade) {
        if (fade) {
            ViewPropertyAnimator viewPropertyAnimator = iv.animate();
            viewPropertyAnimator.cancel();
            viewPropertyAnimator.alpha(0.0f).start();
        } else {
            iv.setAlpha(0.0f);
        }
    }

    private static void notifyRequestFailure(final @NonNull ImageView iv, final bt error) {
        dw.m().b(dy.e()).b((dz)new ed(){

            public void a() throws Throwable {
                z z2 = (z)iv.getTag(TAG_KEY_USER_LISTENER);
                if (z2 != null) {
                    z2.a(error);
                }
            }
        }).c();
    }

    private static void notifyRequestFinished(final @NonNull ImageView iv) {
        dw.m().b(dy.e()).b((dz)new ed(){

            public void a() throws Throwable {
                z z2 = (z)iv.getTag(TAG_KEY_USER_LISTENER);
                if (z2 != null) {
                    z2.a(null);
                }
            }
        }).c();
    }

    private static class a
    implements z<Bitmap> {
        private final ImageRequest a;
        private final String b;
        private boolean c;

        a(ImageRequest imageRequest, String string2) {
            this.a = imageRequest;
            this.b = string2;
            this.c = false;
        }

        public void a(final Bitmap bitmap) {
            block5: {
                if (this.c) {
                    return;
                }
                try {
                    final ImageView imageView = this.a.getImageView();
                    if (imageView == null || imageView.getTag(TAG_KEY_URL) == null || !imageView.getTag(TAG_KEY_URL).equals(this.b)) {
                        return;
                    }
                    imageView.setTag(TAG_KEY_URL, null);
                    if (this.a.isMemoryCacheEnabled()) {
                        bd.d().a(this.b, bitmap);
                    }
                    dw.m().b(dy.e()).b((dz)new ed(){

                        public void a() {
                            if (a.this.c) {
                                return;
                            }
                            imageView.setImageBitmap(bitmap);
                            ImageViewDownloadManager.notifyRequestFinished(imageView);
                        }
                    }).a(new ec(){

                        public void a(Throwable t2) {
                            Log.w((String)TAG, (String)("Cannot set bitmap. MainQueue.execute() has failed: " + bt.a((Throwable)t2)));
                            ImageViewDownloadManager.displayErrorPlaceholderIfExists(a.this.a);
                            ImageViewDownloadManager.notifyRequestFinished(imageView);
                        }
                    }).c();
                }
                catch (Throwable throwable) {
                    ImageView imageView = this.a.getImageView();
                    if (imageView == null) break block5;
                    ImageViewDownloadManager.displayErrorPlaceholderIfExists(this.a);
                    ImageViewDownloadManager.notifyRequestFailure(imageView, new bt("Unhandled error in ImageView loading", throwable));
                    bd.a().a(TAG, throwable, (e)c.b.a);
                }
            }
        }

        public void a(bt error) {
            if (this.c) {
                return;
            }
            if (error instanceof bv && this.a != null) {
                bd.a().a(TAG, (Throwable)error, (e)c.b.a);
            }
            if (this.a != null) {
                ImageViewDownloadManager.displayErrorPlaceholderIfExists(this.a);
                ImageViewDownloadManager.notifyRequestFailure(this.a.getImageView(), error);
            }
        }

        private void a() {
            this.c = true;
        }
    }
}

