/*
 * Decompiled with CFR 0.152.
 */
package com.inlocomedia.android.ads.private;

import android.content.Context;
import android.support.annotation.VisibleForTesting;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import com.inlocomedia.android.ads.AdActivity;
import com.inlocomedia.android.ads.AdManager;
import com.inlocomedia.android.ads.AdReceiver;
import com.inlocomedia.android.ads.AdView;
import com.inlocomedia.android.ads.R;
import com.inlocomedia.android.ads.VideoAdActivity;
import com.inlocomedia.android.ads.core.l;
import com.inlocomedia.android.ads.core.o;
import com.inlocomedia.android.ads.exception.AdvertisementException;
import com.inlocomedia.android.ads.exception.AdvertisementRequestException;
import com.inlocomedia.android.ads.models.NotificationAd;
import com.inlocomedia.android.ads.models.b;
import com.inlocomedia.android.ads.models.c;
import com.inlocomedia.android.ads.models.d;
import com.inlocomedia.android.ads.models.e;
import com.inlocomedia.android.ads.nativeads.NativeAdViewMapper;
import com.inlocomedia.android.ads.private.bf;
import com.inlocomedia.android.core.log.DevLogger;
import com.inlocomedia.android.core.private.bw;
import com.inlocomedia.android.core.private.y;
import com.inlocomedia.android.core.util.Validator;
import com.inlocomedia.android.location.InLocoPrivate;

public final class j {
    public static void a(Context context) throws bw, y {
        Validator.sdkVersion();
        if (!j.b(context)) {
            throw new y("You must register your application for ads before using this service");
        }
    }

    public static boolean b(Context context) {
        return Validator.clientId((com.inlocomedia.android.core.private.d)l.a(context));
    }

    public static void c(Context context) {
        try {
            Validator.isActivityRegistered((Context)context, AdActivity.class);
        }
        catch (RuntimeException runtimeException) {
            o.e.g();
            DevLogger.e((String)("Missing required Activity: " + AdActivity.class.getName() + ". Have you declared the AdActivity in your AndroidManifest file?"));
        }
        try {
            Validator.isActivityRegistered((Context)context, VideoAdActivity.class);
        }
        catch (RuntimeException runtimeException) {
            DevLogger.w((String)("Missing activity: " + VideoAdActivity.class.getName() + ". Have you declared the activity in your AndroidManifest file? Video ads will not work."));
        }
    }

    public static boolean d(Context context) {
        int n2 = context.checkCallingOrSelfPermission("android.permission.VIBRATE");
        return n2 == 0;
    }

    public static boolean e(Context context) {
        if (com.inlocomedia.android.ads.util.d.a()) {
            boolean bl = InLocoPrivate.hasLocationReceiver((Context)context);
            boolean bl2 = Validator.isReceiverRegistered((Context)context, AdReceiver.class, null);
            if (!InLocoPrivate.hasBootCompletedPermission((Context)context)) {
                DevLogger.e((String)"You must enable the RECEIVE_BOOT_COMPLETED permission in your AndroidManifest file");
            }
            if (bl && bl2) {
                return true;
            }
            if (!bl) {
                DevLogger.e((String)"LocationReceiver receiver not found. Did you declare it in your AndroidManifest file?");
            }
            if (!bl2) {
                DevLogger.e((String)"AdReceiver receiver not found. Did you declare it in your AndroidManifest file?");
            }
        } else {
            DevLogger.w((String)"In order to use Notification Ads, you have to add the In Loco Location SDK as a dependency as well.");
        }
        return false;
    }

    public static void f(Context context) {
        Validator.manifest((Context)context);
        j.c(context);
    }

    public static void a(d d2) throws AdvertisementException {
        try {
            j.a((b)d2);
            if (!d2.getAdContentType().equals("native")) {
                throw new IllegalArgumentException("NativeAd AdContentType");
            }
            Validator.notNullNorEmpty((String)d2.a(), (String)"Native ad title");
            if (!Validator.isValidUrl((String)d2.d()) && !Validator.isValidUrl((String)d2.e())) {
                throw new IllegalArgumentException("Native ad image or icon.");
            }
        }
        catch (IllegalArgumentException | NullPointerException runtimeException) {
            throw new AdvertisementException("Invalid native ad validation: " + runtimeException.toString(), runtimeException);
        }
    }

    public static void a(NotificationAd notificationAd) throws AdvertisementException {
        try {
            j.a((b)notificationAd);
            if (!notificationAd.getAdContentType().equals("notification")) {
                throw new IllegalArgumentException("NotificationAd AdContentType");
            }
            Validator.notNullNorEmpty((String)notificationAd.getTitle(), (String)"Ad title");
        }
        catch (IllegalArgumentException | NullPointerException runtimeException) {
            throw new AdvertisementException("Invalid notification ad validation: " + runtimeException.toString(), runtimeException);
        }
    }

    public static void a(c c2) throws AdvertisementException {
        try {
            j.a((b)c2);
            if (!c2.getAdContentType().equals("display")) {
                throw new IllegalArgumentException("DisplayAd AdContentType");
            }
            Validator.notNullNorEmpty((String)c2.a(), (String)"DisplayAd html");
            Validator.notNull((Object)c2.getSize(), (String)"Ad size");
        }
        catch (IllegalArgumentException | NullPointerException runtimeException) {
            throw new AdvertisementException("Invalid display ad validation: " + runtimeException.toString(), runtimeException);
        }
    }

    public static void a(Context context, e e2) throws AdvertisementException {
        try {
            bf bf2;
            j.a(e2);
            if (!e2.getAdContentType().equals("video")) {
                throw new IllegalArgumentException("VideoAd AdContentType");
            }
            Validator.isActivityRegistered((Context)context, VideoAdActivity.class);
            Validator.notNull((Object)e2.getSize(), (String)"Ad size");
            Validator.isValidUrl((String)e2.a(), (String)"VideoAd video url");
            Validator.notNull((Object)e2.e(), (String)"VideoAd time to skip");
            if (e2.c() != null) {
                Validator.notEmpty((String)e2.c(), (String)"VideoAd pre roll markup");
            }
            if (e2.b() != null) {
                Validator.notEmpty((String)e2.b(), (String)"VideoAd post roll markup");
            }
            if ((bf2 = e2.g()) != null) {
                Validator.isValidUrl((String)bf2.c(), (String)"VideoAd banner icon url");
                Validator.notNullNorEmpty((String)bf2.d(), (String)"VideoAd banner call to action");
                Validator.notNullNorEmpty((String)bf2.b(), (String)"VideoAd banner description");
                Validator.notNullNorEmpty((String)bf2.a(), (String)"VideoAd banner title");
            }
            Validator.notNull((Object)e2.d(), (String)"VideoAd video duration");
            if (e2.d() <= 0) {
                throw new IllegalArgumentException("Video duration must be greater than zero");
            }
        }
        catch (RuntimeException runtimeException) {
            throw new AdvertisementException("Invalid video ad validation: " + runtimeException.toString(), runtimeException);
        }
    }

    @VisibleForTesting
    public static void a(b b2) {
        Validator.notNull((Object)b2, (String)"Ad");
        Validator.notNullNorEmpty((String)b2.getAdId(), (String)"Ad id");
        Validator.notNullNorEmpty((String)b2.getRegisterViewabilityUrl(), (String)"Ad viewability url");
        Validator.isValidUrl((String)b2.getRegisterViewabilityUrl(), (String)"Ad viewability url");
        Validator.notNullNorEmpty((String)b2.getRegisterClickUrl(), (String)"Ad register click url");
        Validator.isValidUrl((String)b2.getRegisterClickUrl(), (String)"Ad register click url");
        Validator.notNullNorEmpty((String)b2.getBackToApplicationUrl(), (String)"Ad back to application url");
        Validator.isValidUrl((String)b2.getBackToApplicationUrl(), (String)"Ad back to application url");
        Validator.notNull((Object)b2.getAdUnitType(), (String)"Ad unit type");
        Validator.notNull((Object)b2.getAdContentType(), (String)"Ad content type");
    }

    public static void a(AdView adView) throws AdvertisementException {
        try {
            Validator.notNull((Object)((Object)adView), (String)"Advertisement View");
            Validator.notNull((Object)((Object)adView.getType()), (String)"AdType");
            if (adView.getType().isNative()) {
                j.a((View)adView);
            } else if (!adView.getType().isDisplay()) {
                throw new IllegalArgumentException("Invalid advertisement type received");
            }
        }
        catch (IllegalArgumentException | NullPointerException runtimeException) {
            throw new AdvertisementRequestException("Advertisement request has failed: " + runtimeException.toString(), runtimeException);
        }
    }

    public static void a(AdManager adManager) throws AdvertisementException {
        try {
            Validator.notNull((Object)((Object)adManager.getType()), (String)"AdType");
            if (!adManager.getType().isDisplay() && !adManager.getType().isNative()) {
                throw new IllegalArgumentException("Invalid advertisement type received");
            }
        }
        catch (IllegalArgumentException | NullPointerException runtimeException) {
            throw new AdvertisementRequestException("Advertisement request has failed: " + runtimeException.toString(), runtimeException);
        }
    }

    static void a(View view) throws AdvertisementException {
        try {
            if (view.findViewById(R.id.ilm_title) == null) {
                throw new IllegalArgumentException("'Title' is required");
            }
            if (view.findViewById(R.id.ilm_image) == null && view.findViewById(R.id.ilm_icon) == null) {
                throw new IllegalArgumentException("'Image' or 'Icon' is required");
            }
            j.b(view.findViewById(R.id.ilm_call_to_action), "'Call to Action' must extend from TextView");
            j.b(view.findViewById(R.id.ilm_title), "'Title' must be a TextView");
            j.b(view.findViewById(R.id.ilm_description), "'Description' must be a TextView");
            j.b(view.findViewById(R.id.ilm_highlight), "'Highlight' must be a TextView");
            j.b(view.findViewById(R.id.ilm_expiration), "'Expiration' must be a TextView");
            j.a(view.findViewById(R.id.ilm_image), "'Image' must be a ImageView");
            j.a(view.findViewById(R.id.ilm_icon), "'Icon' must be a ImageView");
        }
        catch (IllegalArgumentException | NullPointerException runtimeException) {
            throw new AdvertisementException("Invalid Native AdView: " + runtimeException.toString(), runtimeException);
        }
    }

    public static void a(View view, NativeAdViewMapper nativeAdViewMapper) throws AdvertisementException {
        try {
            if (view.findViewById(nativeAdViewMapper.getTitleId()) == null) {
                throw new IllegalArgumentException("'Title' is required");
            }
            if (view.findViewById(nativeAdViewMapper.getImageId()) == null && view.findViewById(nativeAdViewMapper.getIconId()) == null) {
                throw new IllegalArgumentException("'Image' or 'Icon' is required");
            }
            j.b(view.findViewById(nativeAdViewMapper.getCallToActionId()), "'Call to Action' must extend from TextView");
            j.b(view.findViewById(nativeAdViewMapper.getTitleId()), "'Title' must be a TextView");
            j.b(view.findViewById(nativeAdViewMapper.getDescriptionId()), "'Description' must be a TextView");
            j.b(view.findViewById(nativeAdViewMapper.getDescriptionId()), "'Highlight' must be a TextView");
            j.b(view.findViewById(nativeAdViewMapper.getExpirationTextId()), "'Expiration' must be a TextView");
            j.a(view.findViewById(nativeAdViewMapper.getImageId()), "'Image' must be a ImageView");
            j.a(view.findViewById(nativeAdViewMapper.getImageId()), "'Icon' must be a ImageView");
        }
        catch (IllegalArgumentException | NullPointerException runtimeException) {
            throw new AdvertisementException("Invalid Native Ad View: " + runtimeException.toString(), runtimeException);
        }
    }

    private static void a(View view, String string) {
        if (view != null && !(view instanceof ImageView)) {
            throw new IllegalArgumentException("Invalid image view type." + string + " must be a subclass of " + ImageView.class.getCanonicalName());
        }
    }

    private static void b(View view, String string) {
        if (view != null && !(view instanceof TextView)) {
            throw new IllegalArgumentException("Invalid text view type." + string + " must be a subclass of " + TextView.class.getCanonicalName());
        }
    }
}

