/*
 * Decompiled with CFR 0.152.
 */
package com.inlocomedia.android.ads.private;

import android.content.Context;
import android.support.annotation.VisibleForTesting;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import com.inlocomedia.android.ads.AdActivity;
import com.inlocomedia.android.ads.AdManager;
import com.inlocomedia.android.ads.AdReceiver;
import com.inlocomedia.android.ads.AdView;
import com.inlocomedia.android.ads.R;
import com.inlocomedia.android.ads.VideoAdActivity;
import com.inlocomedia.android.ads.core.l;
import com.inlocomedia.android.ads.core.o;
import com.inlocomedia.android.ads.exception.AdvertisementException;
import com.inlocomedia.android.ads.exception.AdvertisementRequestException;
import com.inlocomedia.android.ads.nativeads.NativeAdViewMapper;
import com.inlocomedia.android.ads.private.an;
import com.inlocomedia.android.ads.private.ao;
import com.inlocomedia.android.ads.private.ap;
import com.inlocomedia.android.ads.private.aq;
import com.inlocomedia.android.ads.private.ar;
import com.inlocomedia.android.ads.private.bl;
import com.inlocomedia.android.ads.util.d;
import com.inlocomedia.android.core.log.DevLogger;
import com.inlocomedia.android.core.private.aa;
import com.inlocomedia.android.core.private.by;
import com.inlocomedia.android.core.private.f;
import com.inlocomedia.android.core.util.Validator;
import com.inlocomedia.android.location.InLocoPrivate;

public final class j {
    public static void a(Context context) throws by, aa {
        Validator.sdkVersion();
        if (!j.b(context)) {
            throw new aa("You must register your application for ads before using this service");
        }
    }

    public static boolean b(Context context) {
        return Validator.clientId((f)l.a(context));
    }

    public static void c(Context context) {
        try {
            Validator.isActivityRegistered((Context)context, AdActivity.class);
        }
        catch (RuntimeException runtimeException) {
            o.e.g();
            DevLogger.e((String)("Missing required Activity: " + AdActivity.class.getName() + ". Have you declared the AdActivity in your AndroidManifest file?"));
        }
        try {
            Validator.isActivityRegistered((Context)context, VideoAdActivity.class);
        }
        catch (RuntimeException runtimeException) {
            DevLogger.w((String)("Missing activity: " + VideoAdActivity.class.getName() + ". Have you declared the activity in your AndroidManifest file? Video ads will not work."));
        }
    }

    public static boolean d(Context context) {
        int n2 = context.checkCallingOrSelfPermission("android.permission.VIBRATE");
        return n2 == 0;
    }

    public static boolean e(Context context) {
        if (d.a()) {
            boolean bl2 = InLocoPrivate.hasLocationReceiver((Context)context);
            boolean bl3 = Validator.isReceiverRegistered((Context)context, AdReceiver.class, null);
            if (!InLocoPrivate.hasBootCompletedPermission((Context)context)) {
                DevLogger.e((String)"You must enable the RECEIVE_BOOT_COMPLETED permission in your AndroidManifest file");
            }
            if (bl2 && bl3) {
                return true;
            }
            if (!bl2) {
                DevLogger.e((String)"LocationReceiver receiver not found. Did you declare it in your AndroidManifest file?");
            }
            if (!bl3) {
                DevLogger.e((String)"AdReceiver receiver not found. Did you declare it in your AndroidManifest file?");
            }
        } else {
            DevLogger.w((String)"In order to use Notification Ads, you have to add the In Loco Location SDK as a dependency as well.");
        }
        return false;
    }

    public static void f(Context context) {
        Validator.manifest((Context)context);
        j.c(context);
    }

    public static void a(ap ap2) throws AdvertisementException {
        try {
            j.a((an)ap2);
            if (!ap2.a().equals("native")) {
                throw new IllegalArgumentException("NativeAd AdContentType");
            }
            Validator.notNullNorEmpty((String)ap2.t(), (String)"Native ad title");
            if (!Validator.isValidUrl((String)ap2.w()) && !Validator.isValidUrl((String)ap2.x())) {
                throw new IllegalArgumentException("Native ad image or icon.");
            }
        }
        catch (IllegalArgumentException | NullPointerException runtimeException) {
            throw new AdvertisementException("Invalid native ad validation: " + runtimeException.toString(), runtimeException);
        }
    }

    public static void a(aq aq2) throws AdvertisementException {
        try {
            j.a((an)aq2);
            if (!aq2.a().equals("notification")) {
                throw new IllegalArgumentException("NotificationAd AdContentType");
            }
            Validator.notNullNorEmpty((String)aq2.v(), (String)"Ad title");
        }
        catch (IllegalArgumentException | NullPointerException runtimeException) {
            throw new AdvertisementException("Invalid notification ad validation: " + runtimeException.toString(), runtimeException);
        }
    }

    public static void a(ao ao2) throws AdvertisementException {
        try {
            j.a((an)ao2);
            if (!ao2.a().equals("display")) {
                throw new IllegalArgumentException("DisplayAd AdContentType");
            }
            Validator.notNullNorEmpty((String)ao2.t(), (String)"DisplayAd html");
            Validator.notNull((Object)ao2.c(), (String)"Ad size");
        }
        catch (IllegalArgumentException | NullPointerException runtimeException) {
            throw new AdvertisementException("Invalid display ad validation: " + runtimeException.toString(), runtimeException);
        }
    }

    public static void a(Context context, ar ar2) throws AdvertisementException {
        try {
            bl bl2;
            j.a(ar2);
            if (!ar2.a().equals("video")) {
                throw new IllegalArgumentException("VideoAd AdContentType");
            }
            Validator.isActivityRegistered((Context)context, VideoAdActivity.class);
            Validator.notNull((Object)ar2.c(), (String)"Ad size");
            Validator.isValidUrl((String)ar2.t(), (String)"VideoAd video url");
            Validator.notNull((Object)ar2.x(), (String)"VideoAd time to skip");
            if (ar2.v() != null) {
                Validator.notEmpty((String)ar2.v(), (String)"VideoAd pre roll markup");
            }
            if (ar2.u() != null) {
                Validator.notEmpty((String)ar2.u(), (String)"VideoAd post roll markup");
            }
            if ((bl2 = ar2.z()) != null) {
                Validator.isValidUrl((String)bl2.c(), (String)"VideoAd banner icon url");
                Validator.notNullNorEmpty((String)bl2.d(), (String)"VideoAd banner call to action");
                Validator.notNullNorEmpty((String)bl2.b(), (String)"VideoAd banner description");
                Validator.notNullNorEmpty((String)bl2.a(), (String)"VideoAd banner title");
            }
            Validator.notNull((Object)ar2.w(), (String)"VideoAd video duration");
            if (ar2.w() <= 0) {
                throw new IllegalArgumentException("Video duration must be greater than zero");
            }
        }
        catch (RuntimeException runtimeException) {
            throw new AdvertisementException("Invalid video ad validation: " + runtimeException.toString(), runtimeException);
        }
    }

    @VisibleForTesting
    public static void a(an an2) {
        Validator.notNull((Object)an2, (String)"Ad");
        Validator.notNullNorEmpty((String)an2.i(), (String)"Ad id");
        Validator.notNullNorEmpty((String)an2.f(), (String)"Ad viewability url");
        Validator.isValidUrl((String)an2.f(), (String)"Ad viewability url");
        Validator.notNullNorEmpty((String)an2.e(), (String)"Ad register click url");
        Validator.isValidUrl((String)an2.e(), (String)"Ad register click url");
        Validator.notNullNorEmpty((String)an2.d(), (String)"Ad back to application url");
        Validator.isValidUrl((String)an2.d(), (String)"Ad back to application url");
        Validator.notNull((Object)an2.b(), (String)"Ad unit type");
        Validator.notNull((Object)an2.a(), (String)"Ad content type");
    }

    public static void a(AdView adView) throws AdvertisementException {
        try {
            Validator.notNull((Object)((Object)adView), (String)"Advertisement View");
            Validator.notNull((Object)((Object)adView.getType()), (String)"AdType");
            if (adView.getType().isNative()) {
                j.a((View)adView);
            } else if (!adView.getType().isDisplay()) {
                throw new IllegalArgumentException("Invalid advertisement type received");
            }
        }
        catch (IllegalArgumentException | NullPointerException runtimeException) {
            throw new AdvertisementRequestException("Advertisement request has failed: " + runtimeException.toString(), runtimeException);
        }
    }

    public static void a(AdManager adManager) throws AdvertisementException {
        try {
            Validator.notNull((Object)((Object)adManager.getType()), (String)"AdType");
            if (!adManager.getType().isDisplay() && !adManager.getType().isNative()) {
                throw new IllegalArgumentException("Invalid advertisement type received");
            }
        }
        catch (IllegalArgumentException | NullPointerException runtimeException) {
            throw new AdvertisementRequestException("Advertisement request has failed: " + runtimeException.toString(), runtimeException);
        }
    }

    static void a(View view) throws AdvertisementException {
        try {
            if (view.findViewById(R.id.ilm_title) == null) {
                throw new IllegalArgumentException("'Title' is required");
            }
            if (view.findViewById(R.id.ilm_image) == null && view.findViewById(R.id.ilm_icon) == null) {
                throw new IllegalArgumentException("'Image' or 'Icon' is required");
            }
            j.b(view.findViewById(R.id.ilm_call_to_action), "'Call to Action' must extend from TextView");
            j.b(view.findViewById(R.id.ilm_title), "'Title' must be a TextView");
            j.b(view.findViewById(R.id.ilm_description), "'Description' must be a TextView");
            j.b(view.findViewById(R.id.ilm_highlight), "'Highlight' must be a TextView");
            j.b(view.findViewById(R.id.ilm_expiration), "'Expiration' must be a TextView");
            j.a(view.findViewById(R.id.ilm_image), "'Image' must be a ImageView");
            j.a(view.findViewById(R.id.ilm_icon), "'Icon' must be a ImageView");
        }
        catch (IllegalArgumentException | NullPointerException runtimeException) {
            throw new AdvertisementException("Invalid Native AdView: " + runtimeException.toString(), runtimeException);
        }
    }

    public static void a(View view, NativeAdViewMapper nativeAdViewMapper) throws AdvertisementException {
        try {
            if (view.findViewById(nativeAdViewMapper.getTitleId()) == null) {
                throw new IllegalArgumentException("'Title' is required");
            }
            if (view.findViewById(nativeAdViewMapper.getImageId()) == null && view.findViewById(nativeAdViewMapper.getIconId()) == null) {
                throw new IllegalArgumentException("'Image' or 'Icon' is required");
            }
            j.b(view.findViewById(nativeAdViewMapper.getCallToActionId()), "'Call to Action' must extend from TextView");
            j.b(view.findViewById(nativeAdViewMapper.getTitleId()), "'Title' must be a TextView");
            j.b(view.findViewById(nativeAdViewMapper.getDescriptionId()), "'Description' must be a TextView");
            j.b(view.findViewById(nativeAdViewMapper.getDescriptionId()), "'Highlight' must be a TextView");
            j.b(view.findViewById(nativeAdViewMapper.getExpirationTextId()), "'Expiration' must be a TextView");
            j.a(view.findViewById(nativeAdViewMapper.getImageId()), "'Image' must be a ImageView");
            j.a(view.findViewById(nativeAdViewMapper.getImageId()), "'Icon' must be a ImageView");
        }
        catch (IllegalArgumentException | NullPointerException runtimeException) {
            throw new AdvertisementException("Invalid Native Ad View: " + runtimeException.toString(), runtimeException);
        }
    }

    private static void a(View view, String string) {
        if (view != null && !(view instanceof ImageView)) {
            throw new IllegalArgumentException("Invalid image view type." + string + " must be a subclass of " + ImageView.class.getCanonicalName());
        }
    }

    private static void b(View view, String string) {
        if (view != null && !(view instanceof TextView)) {
            throw new IllegalArgumentException("Invalid text view type." + string + " must be a subclass of " + TextView.class.getCanonicalName());
        }
    }
}

