/*
 * Decompiled with CFR 0.152.
 */
package com.inlocomedia.android.ads.nativeads;

import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import com.inlocomedia.android.ads.nativeads.NativeAdViewMapper;
import com.inlocomedia.android.ads.private.k;
import com.inlocomedia.android.core.log.DevLogger;

public class NativeViewBinder {
    private View mContainer;
    private TextView mTitle;
    private TextView mDescription;
    private TextView mHighlight;
    private TextView mCallToAction;
    private TextView mExpirationText;
    private ImageView mImage;
    private ImageView mIcon;

    public NativeViewBinder(Builder builder) {
        this.mContainer = builder.container;
        this.mTitle = builder.title;
        this.mHighlight = builder.highlight;
        this.mDescription = builder.description;
        this.mCallToAction = builder.callToAction;
        this.mExpirationText = builder.expirationText;
        this.mImage = builder.image;
        this.mIcon = builder.icon;
    }

    public View getContainer() {
        return this.mContainer;
    }

    public TextView getTitle() {
        return this.mTitle;
    }

    public TextView getHighlightText() {
        return this.mHighlight;
    }

    public TextView getDescription() {
        return this.mDescription;
    }

    public TextView getCallToAction() {
        return this.mCallToAction;
    }

    public TextView getExpirationText() {
        return this.mExpirationText;
    }

    public ImageView getImage() {
        return this.mImage;
    }

    public ImageView getIcon() {
        return this.mIcon;
    }

    public static class Builder {
        private View container;
        private TextView title;
        private TextView description;
        private TextView highlight;
        private TextView callToAction;
        private TextView expirationText;
        private ImageView image;
        private ImageView icon;
        private NativeAdViewMapper viewMapper;

        public Builder setContainer(View container) {
            this.container = container;
            return this;
        }

        public Builder setTitle(TextView title) {
            this.title = title;
            return this;
        }

        public Builder setDescription(TextView description) {
            this.description = description;
            return this;
        }

        public Builder setHighlight(TextView highlight) {
            this.highlight = highlight;
            return this;
        }

        public Builder setCallToAction(TextView callToAction) {
            this.callToAction = callToAction;
            return this;
        }

        public Builder setExpirationText(TextView expirationText) {
            this.expirationText = expirationText;
            return this;
        }

        public Builder setImage(ImageView image) {
            this.image = image;
            return this;
        }

        public Builder setIcon(ImageView icon) {
            this.icon = icon;
            return this;
        }

        public Builder setMapper(NativeAdViewMapper mapper) {
            this.viewMapper = mapper;
            return this;
        }

        public boolean isValid() {
            if (this.container == null) {
                DevLogger.e((String)"The container View cannot be null");
                return false;
            }
            if (this.title == null) {
                DevLogger.e((String)"The title TextView cannot be null");
                return false;
            }
            if (this.image == null && this.icon == null) {
                DevLogger.e((String)"It is necessary to set either the icon or content image");
            }
            return k.a(this.container, (View)this.title, false) && k.a(this.container, (View)this.highlight, true) && k.a(this.container, (View)this.description, true) && k.a(this.container, (View)this.callToAction, true) && k.a(this.container, (View)this.expirationText, true) && k.a(this.container, (View)this.image, true) && k.a(this.container, (View)this.icon, true);
        }

        private void extractViewsFromMapper() {
            if (this.container != null) {
                this.title = (TextView)this.container.findViewById(this.viewMapper.getTitleId());
                this.description = (TextView)this.container.findViewById(this.viewMapper.getDescriptionId());
                this.highlight = (TextView)this.container.findViewById(this.viewMapper.getHighlightId());
                this.callToAction = (TextView)this.container.findViewById(this.viewMapper.getCallToActionId());
                this.expirationText = (TextView)this.container.findViewById(this.viewMapper.getExpirationTextId());
                this.image = (ImageView)this.container.findViewById(this.viewMapper.getImageId());
                this.icon = (ImageView)this.container.findViewById(this.viewMapper.getIconId());
            }
        }

        public NativeViewBinder build() {
            if (this.viewMapper != null) {
                this.extractViewsFromMapper();
            }
            if (!this.isValid()) {
                throw new IllegalArgumentException("The container view can't be null and it is necessary to set at least the title label and either the icon or content image. Also, every subview must be a descendent of the container view.");
            }
            return new NativeViewBinder(this);
        }
    }
}

