/*
 * Decompiled with CFR 0.152.
 */
package com.inlocomedia.android.ads.notification;

import android.app.Activity;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import android.support.v4.app.NotificationCompat;
import android.webkit.URLUtil;
import com.inlocomedia.android.ads.AdActivity;
import com.inlocomedia.android.ads.AdError;
import com.inlocomedia.android.ads.AdRequest;
import com.inlocomedia.android.ads.AdType;
import com.inlocomedia.android.ads.core.a;
import com.inlocomedia.android.ads.core.n;
import com.inlocomedia.android.ads.core.o;
import com.inlocomedia.android.ads.notification.NotificationAdRequest;
import com.inlocomedia.android.ads.notification.NotificationAdResponse;
import com.inlocomedia.android.ads.notification.b;
import com.inlocomedia.android.ads.notification.c;
import com.inlocomedia.android.ads.notification.d;
import com.inlocomedia.android.ads.notification.f;
import com.inlocomedia.android.ads.private.ad;
import com.inlocomedia.android.ads.private.ak;
import com.inlocomedia.android.ads.private.ao;
import com.inlocomedia.android.ads.private.bh;
import com.inlocomedia.android.ads.private.h;
import com.inlocomedia.android.ads.private.x;
import com.inlocomedia.android.ads.profile.UserProfile;
import com.inlocomedia.android.core.AppContext;
import com.inlocomedia.android.core.Module;
import com.inlocomedia.android.core.exception.InLocoMediaException;
import com.inlocomedia.android.core.log.DevLogger;
import com.inlocomedia.android.core.log.ErrorNotifier;
import com.inlocomedia.android.core.log.Logger;
import com.inlocomedia.android.core.permissions.PermissionResult;
import com.inlocomedia.android.core.permissions.PermissionsHandler;
import com.inlocomedia.android.core.permissions.PermissionsListener;
import com.inlocomedia.android.core.profile.Device;
import com.inlocomedia.android.core.util.IntervalSynchronizer;
import com.inlocomedia.android.core.util.ThreadPool;
import com.inlocomedia.android.core.util.Validator;
import com.inlocomedia.android.location.InLoco;
import com.inlocomedia.android.location.InLocoPrivate;
import com.inlocomedia.android.location.geofencing.SimpleGeofence;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class e
implements d {
    private static final String a = Logger.makeTag(e.class);
    private static final long b = TimeUnit.SECONDS.toMillis(5L);
    private IntervalSynchronizer c;
    private final Map<String, NotificationAdResponse> d;
    private final ErrorNotifier e;
    private final com.inlocomedia.android.ads.core.c f;

    public e(Context context, com.inlocomedia.android.ads.core.c c2, ErrorNotifier errorNotifier) {
        AppContext.set((Context)context);
        this.c = new IntervalSynchronizer(60000L);
        this.d = Collections.synchronizedMap(new HashMap());
        this.f = c2;
        this.e = errorNotifier;
    }

    @Override
    public void a(final Activity activity, final boolean bl2) {
        ThreadPool.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    boolean bl22;
                    o.f.a(activity.getApplicationContext());
                    boolean bl3 = bl22 = com.inlocomedia.android.ads.notification.f.c((Context)activity) != bl2;
                    if (bl22 && com.inlocomedia.android.ads.notification.e.c((Context)activity)) {
                        if (bl2) {
                            e.this.a(activity, new PermissionsListener(){

                                public void onPermissionRequestCompleted(HashMap<String, PermissionResult> permissionResultHashMap) {
                                    PermissionResult permissionResult = permissionResultHashMap.get("android.permission.ACCESS_FINE_LOCATION");
                                    if (permissionResult != null && permissionResult.isAuthorized()) {
                                        if (!com.inlocomedia.android.ads.util.d.a((Context)activity)) {
                                            DevLogger.w((String)"Notifications could not be enabled. Did you add the 'com.google.android.gms:play-services-location' dependency?");
                                            return;
                                        }
                                        DevLogger.i((String)"Enabling Notifications");
                                        e.this.c = new IntervalSynchronizer(60000L);
                                        InLocoPrivate.Geofencing.registerListener((Context)activity, d.a.class, (String)"push");
                                        com.inlocomedia.android.ads.notification.f.a((Context)activity, true);
                                    } else {
                                        DevLogger.w((String)"Notification error: Missing required permission android.permission.ACCESS_FINE_LOCATION");
                                    }
                                }
                            });
                        } else {
                            DevLogger.i((String)"Disabling notifications");
                            InLocoPrivate.Geofencing.unregisterListener((Context)activity, (String)"push");
                        }
                        com.inlocomedia.android.ads.notification.f.a((Context)activity, bl2);
                    }
                }
                catch (Throwable throwable) {
                    e.this.e.notifyError(a, throwable, (Module)o.e);
                }
            }
        });
    }

    private void a(Activity activity, PermissionsListener permissionsListener) {
        boolean bl2 = com.inlocomedia.android.ads.notification.f.d((Context)activity);
        PermissionsHandler permissionsHandler = bh.b();
        if (bl2) {
            String[] stringArray = new String[]{"android.permission.ACCESS_FINE_LOCATION"};
            permissionsHandler.requestPermissions((Context)activity, stringArray, true, permissionsListener);
        } else {
            HashMap<String, PermissionResult> hashMap = new HashMap<String, PermissionResult>();
            PermissionResult permissionResult = new PermissionResult(permissionsHandler.isPermissionEnabled((Context)activity, "android.permission.ACCESS_FINE_LOCATION"), false);
            hashMap.put("android.permission.ACCESS_FINE_LOCATION", permissionResult);
            permissionsListener.onPermissionRequestCompleted(hashMap);
        }
    }

    @Override
    public void a(Context context, NotificationAdRequest notificationAdRequest) {
        Validator.notNull((Object)context, (String)"Context");
        Validator.notNull((Object)notificationAdRequest, (String)"Notification Ad Request");
        try {
            if (Validator.isValidSDKVersion()) {
                com.inlocomedia.android.ads.notification.f.a(context, notificationAdRequest.getAdUnitId());
                com.inlocomedia.android.ads.notification.f.a(context, notificationAdRequest.getNotificationIconResourceId());
                com.inlocomedia.android.ads.notification.f.b(context, notificationAdRequest.isAskForPermissionEnabled());
            }
        }
        catch (Throwable throwable) {
            this.e.notifyError(a, throwable, (Module)o.e);
        }
    }

    @Override
    public boolean a(Context context) {
        try {
            return com.inlocomedia.android.ads.notification.f.c(context);
        }
        catch (Throwable throwable) {
            this.e.notifyError(a, throwable, (Module)o.e);
            return false;
        }
    }

    @Override
    public void a(Context context, Intent intent) {
        DevLogger.i((String)"Notification clicked");
        try {
            ao ao2 = (ao)intent.getSerializableExtra("com.android.inlocomedia.ads.notification_click_extra");
            AdActivity.startActivity(context, ad.a(ao2, com.inlocomedia.android.ads.core.a.b(ao2, ao2.k())).a());
        }
        catch (Throwable throwable) {
            this.e.notifyError(a, throwable, (Module)o.e);
        }
    }

    @Override
    public void a(int n2, Collection<SimpleGeofence> collection) {
        try {
            String string2;
            if (!this.a(AppContext.get())) {
                return;
            }
            String string3 = string2 = InLocoPrivate.Geofencing.containsEnterTransition((int)n2) || InLocoPrivate.Geofencing.containsDwellTransition((int)n2) || InLocoPrivate.Geofencing.containsPollingTransition((int)n2) ? "com.inlocomedia.location.event.actions.INSIDE" : "com.inlocomedia.location.event.actions.OUTSIDE";
            if (InLocoPrivate.Geofencing.containsEnterTransition((int)n2) || InLocoPrivate.Geofencing.containsDwellTransition((int)n2) || InLocoPrivate.Geofencing.containsPollingTransition((int)n2)) {
                for (SimpleGeofence simpleGeofence : collection) {
                    if (simpleGeofence.type != 1 || !simpleGeofence.category.equals("push")) continue;
                    this.a();
                    break;
                }
            }
            Intent intent = new Intent(string2);
            intent.setPackage(AppContext.get().getPackageName());
            AppContext.get().sendBroadcast(intent);
        }
        catch (Throwable throwable) {
            this.e.notifyError(a, throwable, (Module)o.e);
        }
    }

    @VisibleForTesting
    protected void a() {
        ThreadPool.executeAt((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    if (e.this.c.tryLock()) {
                        AdRequest adRequest = new AdRequest();
                        adRequest.setUserProfile(UserProfile.getSavedProfile(AppContext.get()));
                        adRequest.setAdUnitId(com.inlocomedia.android.ads.notification.f.a(AppContext.get()));
                        DevLogger.i((String)("Requesting Notification. " + adRequest));
                        ak ak2 = new ak(AdType.NOTIFICATION, adRequest, 25);
                        com.inlocomedia.android.ads.core.b<com.inlocomedia.android.ads.core.e> b2 = e.this.a(ak2);
                        e.this.f.a(b2);
                    }
                }
                catch (Throwable throwable) {
                    e.this.e.notifyError(a, throwable, (Module)o.e);
                    e.this.c.unlock();
                }
            }
        }, (long)b);
    }

    @VisibleForTesting
    protected com.inlocomedia.android.ads.core.b<com.inlocomedia.android.ads.core.e> a(ak ak2) {
        return new com.inlocomedia.android.ads.core.b<com.inlocomedia.android.ads.core.e>(AppContext.get(), ak2, (com.inlocomedia.android.ads.core.f)new c()){

            @Override
            public void a(com.inlocomedia.android.ads.core.e e2) {
                ao ao2 = (ao)e2.c();
                if (ao2 != null) {
                    DevLogger.i((String)"NotificationAd received");
                    if (this.a(ao2)) {
                        b.a a2 = e.this.b();
                        b b2 = new b(a2);
                        b2.a(AppContext.get(), ao2);
                    } else {
                        this.a(AdError.INVALID_REQUEST);
                    }
                }
            }

            @Override
            public void a(AdError adError) {
                DevLogger.w((String)("Notification request has failed with error: " + (Object)((Object)adError)));
                e.this.c.unlock();
            }

            private boolean a(ao ao2) {
                boolean bl2 = Device.canHandleIntentForUri((Context)AppContext.get(), (String)ao2.m());
                boolean bl3 = !Validator.isNullOrEmpty((String)ao2.x());
                boolean bl4 = URLUtil.isValidUrl((String)ao2.w());
                if (!(bl3 || bl4 || bl2)) {
                    if (ao2.m() != null) {
                        DevLogger.w((String)("No listener for the url " + ao2.m()));
                    } else {
                        DevLogger.w((String)"The notification does not have any displayable content");
                    }
                    return false;
                }
                return true;
            }
        };
    }

    b.a b() {
        return new b.a(){

            @Override
            public void a(NotificationAdResponse notificationAdResponse) {
                try {
                    long l2 = System.currentTimeMillis();
                    com.inlocomedia.android.ads.notification.f.a(AppContext.get(), l2);
                    Intent intent = new Intent("com.inlocomedia.android.ads.actions.NOTIFICATION_READY");
                    intent.putExtra("NOTIFICATION_EXTRA_ID", Long.toString(l2));
                    intent.setPackage(AppContext.get().getPackageName());
                    if (e.this.b(AppContext.get(), intent)) {
                        e.this.a(l2, notificationAdResponse, intent);
                    } else {
                        e.this.a(notificationAdResponse);
                    }
                }
                catch (Throwable throwable) {
                    e.this.e.notifyError(a, throwable, (Module)o.e);
                }
                e.this.c.unlock();
            }

            @Override
            public void a(InLocoMediaException inLocoMediaException) {
                DevLogger.w((String)"Notification request has failed", (Throwable)inLocoMediaException);
                e.this.c.unlock();
            }
        };
    }

    @VisibleForTesting
    protected void a(long l2, NotificationAdResponse notificationAdResponse, Intent intent) {
        this.d.put(Long.toString(l2), notificationAdResponse);
        AppContext.get().sendBroadcast(intent);
    }

    @VisibleForTesting
    protected boolean b(Context context, Intent intent) {
        return !context.getPackageManager().queryBroadcastReceivers(intent, 65536).isEmpty();
    }

    @Override
    @Nullable
    public NotificationAdResponse a(String string2) {
        return this.d.get(string2);
    }

    @Override
    public void b(String string2) {
        NotificationAdResponse notificationAdResponse = this.d.remove(string2);
        if (notificationAdResponse != null) {
            this.a(notificationAdResponse);
        }
    }

    @Override
    public boolean c(String string2) {
        NotificationAdResponse notificationAdResponse = this.d.remove(string2);
        return notificationAdResponse != null;
    }

    @VisibleForTesting(otherwise=2)
    protected void a(NotificationAdResponse notificationAdResponse) {
        if (com.inlocomedia.android.ads.notification.f.c(AppContext.get())) {
            NotificationCompat.BigPictureStyle bigPictureStyle;
            PendingIntent pendingIntent = n.a(AppContext.get(), notificationAdResponse.getNotificationAd());
            NotificationCompat.Builder builder = new NotificationCompat.Builder(AppContext.get());
            builder.setAutoCancel(true);
            builder.setContentIntent(pendingIntent);
            builder.setContentTitle((CharSequence)notificationAdResponse.getTitle());
            builder.setSmallIcon(com.inlocomedia.android.ads.notification.f.b(AppContext.get()));
            builder.setContentText((CharSequence)notificationAdResponse.getDescription());
            if (notificationAdResponse.getIcon() != null) {
                builder.setLargeIcon(notificationAdResponse.getIcon());
            }
            if (notificationAdResponse.getImage() != null) {
                bigPictureStyle = new NotificationCompat.BigPictureStyle(builder);
                bigPictureStyle.bigPicture(notificationAdResponse.getImage());
                bigPictureStyle.setSummaryText((CharSequence)notificationAdResponse.getDescription());
            } else {
                bigPictureStyle = new NotificationCompat.BigTextStyle(builder);
                bigPictureStyle.bigText((CharSequence)notificationAdResponse.getDescription());
            }
            bigPictureStyle = builder.build();
            if (notificationAdResponse.getNotificationAd().y()) {
                bigPictureStyle.defaults |= 1;
            }
            if (notificationAdResponse.getNotificationAd().z() && h.d(AppContext.get())) {
                bigPictureStyle.defaults |= 2;
            }
            NotificationManager notificationManager = (NotificationManager)AppContext.get().getSystemService("notification");
            notificationManager.notify(8233, (Notification)bigPictureStyle);
            x x2 = new x(notificationAdResponse.getNotificationAd());
            x2.a(AppContext.get());
        }
    }

    private static boolean c(Context context) {
        if (!Validator.isValidSDKVersion()) {
            DevLogger.w((String)("Notifications could not be toggled: " + (Object)((Object)AdError.INVALID_SDK_VERSION)));
            return false;
        }
        if (!h.b(context)) {
            DevLogger.w((String)"Notifications could not be enabled. You must register your application for ads before using this service");
            return false;
        }
        if (!o.e.isValid()) {
            DevLogger.w((String)"Notifications could not be enabled: Invalid application state. Check your log for more details");
            return false;
        }
        if (!InLoco.isLocationTrackingEnabled((Context)context)) {
            DevLogger.w((String)"Notifications could not be enabled. You must enable background location tracking before using this service");
            return false;
        }
        if (com.inlocomedia.android.ads.notification.e.d(context)) {
            DevLogger.w((String)"Notifications could not be enabled. Notification channels are not supported yet.");
            return false;
        }
        return h.e(context);
    }

    private static boolean d(Context context) {
        return Validator.isAboveAndroid25() && Validator.targetsAboveVersion((Context)context, (int)25);
    }
}

