/*
 * Decompiled with CFR 0.152.
 */
package com.inlocomedia.android.ads;

import android.annotation.SuppressLint;
import android.content.Context;
import com.inlocomedia.android.ads.util.d;
import com.inlocomedia.android.core.data.local.SharedPreferencesManager;
import com.inlocomedia.android.core.log.DevLogger;
import com.inlocomedia.android.core.profile.Device;
import com.inlocomedia.android.core.util.Validator;
import com.inlocomedia.android.location.InLocoOptions;

@SuppressLint(value={"CommitPrefEdits"})
public class InLocoMediaOptions {
    private static final String PREFS_NAME = "com.inlocomedia.android.ads.InLocoMediaOptions";
    private static final String PREFS_DEVELOPMENT_ENABLED = "com.inlocomedia.android.ads.InLocoMediaOptions#DEVELOPMENT";
    private static final String PREFS_ADS_KEY = "com.inlocomedia.android.ads.InLocoMediaOptions#ADS_KEY";
    private static final String PREFS_LOGS_ENABLED = "com.inlocomedia.android.ads.InLocoMediaOptions#LOGS_ENABLED";
    private static InLocoMediaOptions sInstance;
    private final Context mContext;

    public static synchronized InLocoMediaOptions newInstance(Context context) {
        sInstance = new InLocoMediaOptions(context, true);
        return sInstance;
    }

    public static synchronized InLocoMediaOptions getInstance(Context context) {
        if (sInstance == null) {
            sInstance = new InLocoMediaOptions(context, false);
        }
        return sInstance;
    }

    private InLocoMediaOptions(Context context, boolean clearPrefs) {
        this.mContext = context.getApplicationContext();
        if (clearPrefs) {
            this.clear();
        }
    }

    public void clear() {
        InLocoMediaOptions.getPrefsEntry(this.mContext).clear();
        if (d.a()) {
            InLocoOptions.getInstance((Context)this.mContext).clear();
        }
    }

    public String getAdsKey() {
        return InLocoMediaOptions.getPrefsEntry(this.mContext).getString(PREFS_ADS_KEY, null);
    }

    public void setAdsKey(String adsProductionKey) {
        InLocoMediaOptions.getPrefsEntry(this.mContext).put(PREFS_ADS_KEY, adsProductionKey).commit();
        if (d.a()) {
            InLocoOptions.getInstance((Context)this.mContext).setLocationKey(adsProductionKey);
        }
    }

    public void setGeneralCacheSize(long cacheSize) {
        if (d.a()) {
            InLocoOptions.getInstance((Context)this.mContext).setGeneralCacheSize(cacheSize);
        } else {
            DevLogger.w((String)"In order to use Location, you have to add the In Loco Location SDK as a dependency as well.");
        }
    }

    public long getGeneralCacheSize() {
        if (d.a()) {
            return InLocoOptions.getInstance((Context)this.mContext).getGeneralCacheSize();
        }
        DevLogger.w((String)"In order to use Location, you have to add the In Loco Location SDK as a dependency as well.");
        return -1L;
    }

    public void setFilesCacheSize(long cacheSize) {
        if (d.a()) {
            InLocoOptions.getInstance((Context)this.mContext).setFilesCacheSize(cacheSize);
        } else {
            DevLogger.w((String)"In order to use Location, you have to add the In Loco Location SDK as a dependency as well.");
        }
    }

    public long getFilesCacheSize() {
        if (d.a()) {
            return InLocoOptions.getInstance((Context)this.mContext).getFilesCacheSize();
        }
        DevLogger.w((String)"In order to use Location, you have to add the In Loco Location SDK as a dependency as well.");
        return -1L;
    }

    public void setLogEnabled(boolean enabled) {
        InLocoMediaOptions.getPrefsEntry(this.mContext).put(PREFS_LOGS_ENABLED, enabled).commit();
        if (d.a()) {
            InLocoOptions.getInstance((Context)this.mContext).setLogEnabled(enabled);
        }
    }

    public boolean isLogEnabled() {
        return InLocoMediaOptions.getPrefsEntry(this.mContext).getBoolean(PREFS_LOGS_ENABLED, true);
    }

    public void setLocationTrackingEnabled(boolean enabled) {
        if (d.a()) {
            InLocoOptions.getInstance((Context)this.mContext).setLocationTrackingEnabled(enabled);
        }
    }

    public boolean isLocationTrackingEnabled() {
        return d.a() && InLocoOptions.getInstance((Context)this.mContext).isLocationTrackingEnabled();
    }

    public boolean isDevelopmentEnvironment() {
        return InLocoMediaOptions.getPrefsEntry(this.mContext).getBoolean(PREFS_DEVELOPMENT_ENABLED, false);
    }

    public void setDevelopmentDevices(String ... developmentDevices) {
        boolean bl2 = false;
        String string2 = Device.getDevelopmentDeviceId((Context)this.mContext);
        if (!Validator.isNullOrEmpty((String)string2) && developmentDevices != null) {
            for (String string3 : developmentDevices) {
                if (!string2.equals(string3)) continue;
                bl2 = true;
                break;
            }
        }
        InLocoMediaOptions.getPrefsEntry(this.mContext).put(PREFS_DEVELOPMENT_ENABLED, bl2).commit();
        if (d.a()) {
            InLocoOptions.getInstance((Context)this.mContext).setDevelopmentDevices(developmentDevices);
        }
    }

    private static SharedPreferencesManager.Entry getPrefsEntry(Context context) {
        return SharedPreferencesManager.getInstance((Context)context).getEntry(PREFS_NAME);
    }

    public static void reset(Context context) {
        InLocoMediaOptions.getPrefsEntry(context).clear();
        if (d.a()) {
            InLocoOptions.reset((Context)context);
        }
        sInstance = null;
    }
}

