/*
 * Decompiled with CFR 0.152.
 */
package com.inlocomedia.android.ads.private;

import android.content.Context;
import android.support.annotation.VisibleForTesting;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import com.inlocomedia.android.ads.AdActivity;
import com.inlocomedia.android.ads.AdManager;
import com.inlocomedia.android.ads.AdReceiver;
import com.inlocomedia.android.ads.AdView;
import com.inlocomedia.android.ads.R;
import com.inlocomedia.android.ads.VideoAdActivity;
import com.inlocomedia.android.ads.core.i;
import com.inlocomedia.android.ads.core.j;
import com.inlocomedia.android.ads.exception.AdvertisementException;
import com.inlocomedia.android.ads.exception.AdvertisementRequestException;
import com.inlocomedia.android.ads.nativeads.NativeAdViewMapper;
import com.inlocomedia.android.ads.private.ai;
import com.inlocomedia.android.ads.private.aj;
import com.inlocomedia.android.ads.private.ak;
import com.inlocomedia.android.ads.private.al;
import com.inlocomedia.android.ads.private.am;
import com.inlocomedia.android.ads.private.bb;
import com.inlocomedia.android.ads.util.d;
import com.inlocomedia.android.core.communication.AuthenticationId;
import com.inlocomedia.android.core.communication.exception.UnauthorizedException;
import com.inlocomedia.android.core.exception.InvalidAndroidSDKVersion;
import com.inlocomedia.android.core.log.DevLogger;
import com.inlocomedia.android.core.util.Validator;
import com.inlocomedia.android.location.InLocoPrivate;

public final class g {
    public static void a(Context context) throws InvalidAndroidSDKVersion, UnauthorizedException {
        Validator.sdkVersion();
        if (!g.b(context)) {
            throw new UnauthorizedException("You must register your application for ads before using this service");
        }
    }

    public static boolean b(Context context) {
        return Validator.clientId((AuthenticationId)i.a(context));
    }

    public static void c(Context context) {
        try {
            Validator.isActivityRegistered((Context)context, AdActivity.class);
        }
        catch (RuntimeException runtimeException) {
            j.b.a.setInvalid();
            DevLogger.e((String)("Missing required Activity: " + AdActivity.class.getName() + ". Have you declared the AdActivity in your AndroidManifest file?"));
        }
        try {
            Validator.isActivityRegistered((Context)context, VideoAdActivity.class);
        }
        catch (RuntimeException runtimeException) {
            DevLogger.w((String)("Missing activity: " + AdActivity.class.getName() + ". Have you declared the activity in your AndroidManifest file? Video ads will not work."));
        }
    }

    public static boolean d(Context context) {
        int n2 = context.checkCallingOrSelfPermission("android.permission.VIBRATE");
        return n2 == 0;
    }

    public static boolean e(Context context) {
        if (d.a()) {
            boolean bl = InLocoPrivate.hasLocationReceiver((Context)context);
            boolean bl2 = Validator.isReceiverRegistered((Context)context, AdReceiver.class, null);
            if (!InLocoPrivate.hasBootCompletedPermission((Context)context)) {
                DevLogger.e((String)"You must enable the RECEIVE_BOOT_COMPLETED permission in your AndroidManifest file");
            }
            if (bl && bl2) {
                return true;
            }
            if (!bl) {
                DevLogger.e((String)"LocationReceiver receiver not found. Did you declare it in your AndroidManifest file?");
            }
            if (!bl2) {
                DevLogger.e((String)"AdReceiver receiver not found. Did you declare it in your AndroidManifest file?");
            }
        } else {
            DevLogger.w((String)"In order to use Notification Ads, you have to add the In Loco Location SDK as a dependency as well.");
        }
        return false;
    }

    public static void f(Context context) {
        Validator.manifest((Context)context);
        g.c(context);
    }

    public static void a(ak ak2) throws AdvertisementException {
        try {
            g.a((ai)ak2);
            if (!ak2.a().equals("native")) {
                throw new IllegalArgumentException("NativeAd AdContentType");
            }
            Validator.notNullNorEmpty((String)ak2.q(), (String)"Native ad title");
            if (!Validator.isValidUrl((String)ak2.t()) && !Validator.isValidUrl((String)ak2.u())) {
                throw new IllegalArgumentException("Native ad image or icon.");
            }
        }
        catch (IllegalArgumentException | NullPointerException runtimeException) {
            throw new AdvertisementException("Invalid native ad validation: " + runtimeException.toString(), runtimeException);
        }
    }

    public static void a(al al2) throws AdvertisementException {
        try {
            g.a((ai)al2);
            if (!al2.a().equals("notification")) {
                throw new IllegalArgumentException("NotificationAd AdContentType");
            }
            Validator.notNullNorEmpty((String)al2.s(), (String)"Ad title");
        }
        catch (IllegalArgumentException | NullPointerException runtimeException) {
            throw new AdvertisementException("Invalid notification ad validation: " + runtimeException.toString(), runtimeException);
        }
    }

    public static void a(aj aj2) throws AdvertisementException {
        try {
            g.a((ai)aj2);
            if (!aj2.a().equals("display")) {
                throw new IllegalArgumentException("DisplayAd AdContentType");
            }
            Validator.notNullNorEmpty((String)aj2.q(), (String)"DisplayAd html");
            Validator.notNull((Object)aj2.c(), (String)"Ad size");
        }
        catch (IllegalArgumentException | NullPointerException runtimeException) {
            throw new AdvertisementException("Invalid display ad validation: " + runtimeException.toString(), runtimeException);
        }
    }

    public static void a(Context context, am am2) throws AdvertisementException {
        try {
            bb bb2;
            g.a(am2);
            if (!am2.a().equals("video")) {
                throw new IllegalArgumentException("VideoAd AdContentType");
            }
            Validator.isActivityRegistered((Context)context, VideoAdActivity.class);
            Validator.notNull((Object)am2.c(), (String)"Ad size");
            Validator.isValidUrl((String)am2.q(), (String)"VideoAd video url");
            Validator.notNull((Object)am2.u(), (String)"VideoAd time to skip");
            if (am2.s() != null) {
                Validator.notEmpty((String)am2.s(), (String)"VideoAd pre roll markup");
            }
            if (am2.r() != null) {
                Validator.notEmpty((String)am2.r(), (String)"VideoAd post roll markup");
            }
            if ((bb2 = am2.w()) != null) {
                Validator.isValidUrl((String)bb2.c(), (String)"VideoAd banner icon url");
                Validator.notNullNorEmpty((String)bb2.d(), (String)"VideoAd banner call to action");
                Validator.notNullNorEmpty((String)bb2.b(), (String)"VideoAd banner description");
                Validator.notNullNorEmpty((String)bb2.a(), (String)"VideoAd banner title");
            }
            Validator.notNull((Object)am2.t(), (String)"VideoAd video duration");
            if (am2.t() <= 0) {
                throw new IllegalArgumentException("Video duration must be greater than zero");
            }
        }
        catch (RuntimeException runtimeException) {
            throw new AdvertisementException("Invalid video ad validation: " + runtimeException.toString(), runtimeException);
        }
    }

    @VisibleForTesting
    static void a(ai ai2) {
        Validator.notNull((Object)ai2, (String)"Ad");
        Validator.notNullNorEmpty((String)ai2.i(), (String)"Ad campaign id");
        Validator.notNullNorEmpty((String)ai2.f(), (String)"Ad viewability url");
        Validator.isValidUrl((String)ai2.f(), (String)"Ad viewability url");
        Validator.notNullNorEmpty((String)ai2.e(), (String)"Ad register click url");
        Validator.isValidUrl((String)ai2.e(), (String)"Ad register click url");
        Validator.notNullNorEmpty((String)ai2.d(), (String)"Ad back to application url");
        Validator.isValidUrl((String)ai2.d(), (String)"Ad back to application url");
        Validator.notNull((Object)ai2.b(), (String)"Ad unit type");
        Validator.notNull((Object)ai2.a(), (String)"Ad content type");
    }

    public static void a(AdView adView) throws AdvertisementException {
        try {
            Validator.notNull((Object)((Object)adView), (String)"Advertisement View");
            Validator.notNull((Object)((Object)adView.getType()), (String)"AdType");
            if (adView.getType().isNative()) {
                g.a((View)adView);
            } else if (!adView.getType().isDisplay()) {
                throw new IllegalArgumentException("Invalid advertisement type received");
            }
        }
        catch (IllegalArgumentException | NullPointerException runtimeException) {
            throw new AdvertisementRequestException("Advertisement request has failed: " + runtimeException.toString(), runtimeException);
        }
    }

    public static void a(AdManager adManager) throws AdvertisementException {
        try {
            Validator.notNull((Object)((Object)adManager.getType()), (String)"AdType");
            if (!adManager.getType().isDisplay() && !adManager.getType().isNative()) {
                throw new IllegalArgumentException("Invalid advertisement type received");
            }
        }
        catch (IllegalArgumentException | NullPointerException runtimeException) {
            throw new AdvertisementRequestException("Advertisement request has failed: " + runtimeException.toString(), runtimeException);
        }
    }

    public static void a(View view) throws AdvertisementException {
        try {
            if (view.findViewById(R.id.ilm_title) == null) {
                throw new IllegalArgumentException("'Title' is required");
            }
            if (view.findViewById(R.id.ilm_image) == null && view.findViewById(R.id.ilm_icon) == null) {
                throw new IllegalArgumentException("'Image' or 'Icon' is required");
            }
            g.b(view.findViewById(R.id.ilm_call_to_action), "'Call to Action' must extend from TextView");
            g.b(view.findViewById(R.id.ilm_title), "'Title' must be a TextView");
            g.b(view.findViewById(R.id.ilm_description), "'Description' must be a TextView");
            g.b(view.findViewById(R.id.ilm_highlight), "'Highlight' must be a TextView");
            g.b(view.findViewById(R.id.ilm_expiration), "'Expiration' must be a TextView");
            g.a(view.findViewById(R.id.ilm_image), "'Image' must be a ImageView");
            g.a(view.findViewById(R.id.ilm_icon), "'Icon' must be a ImageView");
        }
        catch (IllegalArgumentException | NullPointerException runtimeException) {
            throw new AdvertisementException("Invalid Native AdView: " + runtimeException.toString(), runtimeException);
        }
    }

    public static void a(View view, NativeAdViewMapper nativeAdViewMapper) throws AdvertisementException {
        try {
            if (view.findViewById(nativeAdViewMapper.getTitleId()) == null) {
                throw new IllegalArgumentException("'Title' is required");
            }
            if (view.findViewById(nativeAdViewMapper.getImageId()) == null && view.findViewById(nativeAdViewMapper.getIconId()) == null) {
                throw new IllegalArgumentException("'Image' or 'Icon' is required");
            }
            g.b(view.findViewById(nativeAdViewMapper.getCallToActionId()), "'Call to Action' must extend from TextView");
            g.b(view.findViewById(nativeAdViewMapper.getTitleId()), "'Title' must be a TextView");
            g.b(view.findViewById(nativeAdViewMapper.getDescriptionId()), "'Description' must be a TextView");
            g.b(view.findViewById(nativeAdViewMapper.getDescriptionId()), "'Highlight' must be a TextView");
            g.b(view.findViewById(nativeAdViewMapper.getExpirationTextId()), "'Expiration' must be a TextView");
            g.a(view.findViewById(nativeAdViewMapper.getImageId()), "'Image' must be a ImageView");
            g.a(view.findViewById(nativeAdViewMapper.getImageId()), "'Icon' must be a ImageView");
        }
        catch (IllegalArgumentException | NullPointerException runtimeException) {
            throw new AdvertisementException("Invalid Native Ad View: " + runtimeException.toString(), runtimeException);
        }
    }

    private static void a(View view, String string2) {
        if (view != null && !(view instanceof ImageView)) {
            throw new IllegalArgumentException("Invalid image view type." + string2 + " must be a subclass of " + ImageView.class.getCanonicalName());
        }
    }

    private static void b(View view, String string2) {
        if (view != null && !(view instanceof TextView)) {
            throw new IllegalArgumentException("Invalid text view type." + string2 + " must be a subclass of " + TextView.class.getCanonicalName());
        }
    }
}

