/*
 * Decompiled with CFR 0.152.
 */
package com.inlocomedia.android.ads.notification;

import android.app.Activity;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import android.support.v4.app.NotificationCompat;
import android.webkit.URLUtil;
import com.inlocomedia.android.ads.AdActivity;
import com.inlocomedia.android.ads.AdError;
import com.inlocomedia.android.ads.AdRequest;
import com.inlocomedia.android.ads.AdType;
import com.inlocomedia.android.ads.core.j;
import com.inlocomedia.android.ads.core.k;
import com.inlocomedia.android.ads.core.l;
import com.inlocomedia.android.ads.notification.NotificationAdRequest;
import com.inlocomedia.android.ads.notification.NotificationAdResponse;
import com.inlocomedia.android.ads.notification.b;
import com.inlocomedia.android.ads.notification.d;
import com.inlocomedia.android.ads.private.ag;
import com.inlocomedia.android.ads.private.ak;
import com.inlocomedia.android.ads.private.g;
import com.inlocomedia.android.ads.private.w;
import com.inlocomedia.android.ads.profile.UserProfile;
import com.inlocomedia.android.core.Module;
import com.inlocomedia.android.core.annotations.AccessedByTests;
import com.inlocomedia.android.core.exception.InLocoMediaException;
import com.inlocomedia.android.core.log.CriticalErrorManager;
import com.inlocomedia.android.core.log.DevLogger;
import com.inlocomedia.android.core.log.Logger;
import com.inlocomedia.android.core.permissions.PermissionResult;
import com.inlocomedia.android.core.permissions.PermissionsListener;
import com.inlocomedia.android.core.permissions.PermissionsManager;
import com.inlocomedia.android.core.profile.Device;
import com.inlocomedia.android.core.util.IntervalSynchronizer;
import com.inlocomedia.android.core.util.ThreadPool;
import com.inlocomedia.android.core.util.Validator;
import com.inlocomedia.android.location.InLoco;
import com.inlocomedia.android.location.InLocoPrivate;
import com.inlocomedia.android.location.geofencing.GeofencingEventsListener;
import com.inlocomedia.android.location.geofencing.SimpleGeofence;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class c {
    private static final String a = Logger.makeTag(c.class);
    private final Context b;
    private IntervalSynchronizer c;
    private final Map<String, NotificationAdResponse> d;
    @AccessedByTests
    private static c e;

    @VisibleForTesting
    c(Context context) {
        this.b = context.getApplicationContext();
        this.c = new IntervalSynchronizer(60000L);
        this.d = Collections.synchronizedMap(new HashMap());
    }

    public static synchronized c a(Context context) {
        if (e == null) {
            e = new c(context);
        }
        return e;
    }

    public static void a(final Activity activity, final boolean bl) {
        ThreadPool.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    boolean bl3;
                    k.a(activity.getApplicationContext(), j.b.d);
                    boolean bl2 = bl3 = com.inlocomedia.android.ads.notification.d.c((Context)activity) != bl;
                    if (bl3 && com.inlocomedia.android.ads.notification.c.d((Context)activity)) {
                        final c c2 = com.inlocomedia.android.ads.notification.c.a((Context)activity);
                        if (bl) {
                            com.inlocomedia.android.ads.notification.c.b(activity, new PermissionsListener(){

                                public void onPermissionRequestCompleted(HashMap<String, PermissionResult> permissionResultHashMap) {
                                    if (permissionResultHashMap.get("android.permission.ACCESS_FINE_LOCATION").isAuthorized()) {
                                        if (!com.inlocomedia.android.ads.util.d.a((Context)activity)) {
                                            DevLogger.w((String)"Notifications could not be enabled. Did you add the 'com.google.android.gms:play-services-location' dependency?");
                                            return;
                                        }
                                        DevLogger.i((String)"Enabling Notifications");
                                        c2.c = new IntervalSynchronizer(60000L);
                                        InLocoPrivate.Geofencing.registerListener((Context)activity, a.class, (String)c2.a());
                                        com.inlocomedia.android.ads.notification.d.a((Context)activity, true);
                                    } else {
                                        DevLogger.w((String)"Notification error: Missing required permission android.permission.ACCESS_FINE_LOCATION");
                                    }
                                }
                            });
                        } else {
                            DevLogger.i((String)"Disabling notifications");
                            InLocoPrivate.Geofencing.unregisterListener((Context)activity, (String)c2.a());
                        }
                        com.inlocomedia.android.ads.notification.d.a((Context)activity, bl);
                    }
                }
                catch (Throwable throwable) {
                    CriticalErrorManager.notifyError((String)a, (Throwable)throwable, (Module)j.b.a);
                }
            }
        });
    }

    private static void b(Activity activity, PermissionsListener permissionsListener) {
        boolean bl = com.inlocomedia.android.ads.notification.d.d((Context)activity);
        PermissionsManager permissionsManager = PermissionsManager.getInstance();
        if (bl) {
            String[] stringArray = new String[]{"android.permission.ACCESS_FINE_LOCATION"};
            permissionsManager.requestPermissions((Context)activity, stringArray, true, permissionsListener);
        } else {
            HashMap<String, PermissionResult> hashMap = new HashMap<String, PermissionResult>();
            PermissionResult permissionResult = new PermissionResult(permissionsManager.isPermissionEnabled((Context)activity, "android.permission.ACCESS_FINE_LOCATION"), false);
            hashMap.put("android.permission.ACCESS_FINE_LOCATION", permissionResult);
            permissionsListener.onPermissionRequestCompleted(hashMap);
        }
    }

    public static void a(Context context, NotificationAdRequest notificationAdRequest) {
        Validator.notNull((Object)context, (String)"Context");
        Validator.notNull((Object)notificationAdRequest, (String)"Notification Ad Request");
        try {
            if (Validator.isValidSDKVersion()) {
                com.inlocomedia.android.ads.notification.d.a(context, notificationAdRequest.getAdUnitId());
                com.inlocomedia.android.ads.notification.d.a(context, notificationAdRequest.getNotificationIconResourceId());
                com.inlocomedia.android.ads.notification.d.b(context, notificationAdRequest.isAskForPermissionEnabled());
            }
        }
        catch (Throwable throwable) {
            CriticalErrorManager.notifyError((String)a, (Throwable)throwable, (Module)j.b.a, (boolean)true);
        }
    }

    public static boolean b(Context context) {
        try {
            return com.inlocomedia.android.ads.notification.d.c(context);
        }
        catch (Throwable throwable) {
            CriticalErrorManager.notifyError((String)a, (Throwable)throwable, (Module)j.b.a, (boolean)true);
            return false;
        }
    }

    public static void a(Context context, Intent intent) {
        DevLogger.i((String)"Notification clicked");
        try {
            ak ak2 = (ak)intent.getSerializableExtra("com.android.inlocomedia.ads.notification_click_extra");
            AdActivity.startActivityToManageAdClick(context, ak2, com.inlocomedia.android.ads.core.a.b(ak2, ak2.j()));
        }
        catch (Throwable throwable) {
            CriticalErrorManager.notifyError((String)a, (Throwable)throwable, (Module)j.b.a, (boolean)true);
        }
    }

    private void a(int n2, Collection<SimpleGeofence> collection) {
        try {
            String string2;
            if (!com.inlocomedia.android.ads.notification.c.b(this.b)) {
                return;
            }
            String string3 = string2 = InLocoPrivate.Geofencing.containsEnterTransition((int)n2) || InLocoPrivate.Geofencing.containsDwellTransition((int)n2) || InLocoPrivate.Geofencing.containsPollingTransition((int)n2) ? "com.inlocomedia.location.event.actions.INSIDE" : "com.inlocomedia.location.event.actions.OUTSIDE";
            if (InLocoPrivate.Geofencing.containsEnterTransition((int)n2) || InLocoPrivate.Geofencing.containsDwellTransition((int)n2) || InLocoPrivate.Geofencing.containsPollingTransition((int)n2)) {
                for (SimpleGeofence simpleGeofence : collection) {
                    if (simpleGeofence.type != 1 || !simpleGeofence.category.equals("push")) continue;
                    this.b();
                    break;
                }
            }
            Intent intent = new Intent(string2);
            intent.setPackage(this.b.getPackageName());
            this.b.sendBroadcast(intent);
        }
        catch (Throwable throwable) {
            CriticalErrorManager.notifyError((String)a, (Throwable)throwable, (Module)j.b.a, (boolean)true);
        }
    }

    public String a() {
        return "push";
    }

    @VisibleForTesting
    void b() {
        try {
            if (this.c.tryLock()) {
                AdRequest adRequest = new AdRequest();
                adRequest.setUserProfile(UserProfile.getSavedProfile(this.b));
                adRequest.setAdUnitId(com.inlocomedia.android.ads.notification.d.a(this.b));
                DevLogger.i((String)("Requesting Notification. " + adRequest));
                ag ag2 = new ag(AdType.NOTIFICATION, adRequest, 25);
                com.inlocomedia.android.ads.core.b<ak, Void> b2 = this.a(ag2);
                com.inlocomedia.android.ads.core.c.a(b2);
            }
        }
        catch (Throwable throwable) {
            CriticalErrorManager.notifyError((String)a, (Throwable)throwable, (Module)j.b.a, (boolean)true);
            this.c.unlock();
        }
    }

    @VisibleForTesting
    protected com.inlocomedia.android.ads.core.b<ak, Void> a(ag ag2) {
        return new com.inlocomedia.android.ads.core.b<ak, Void>(this.b, ag2){

            @Override
            public void a(ak ak2) {
                DevLogger.i((String)"NotificationAd received");
                if (this.b(ak2)) {
                    b.a a2 = c.this.c();
                    b b2 = new b(a2);
                    b2.a(c.this.b, ak2);
                } else {
                    this.a(AdError.INVALID_REQUEST);
                }
            }

            @Override
            public void a(AdError adError) {
                DevLogger.w((String)("Notification request has failed with error: " + (Object)((Object)adError)));
                c.this.c.unlock();
            }

            private boolean b(ak ak2) {
                boolean bl = Device.canHandleIntentForUri((Context)c.this.b, (String)ak2.l());
                boolean bl2 = !Validator.isNullOrEmpty((String)ak2.t());
                boolean bl3 = URLUtil.isValidUrl((String)ak2.s());
                if (!(bl2 || bl3 || bl)) {
                    if (ak2.l() != null) {
                        DevLogger.w((String)("No listener for the url " + ak2.l()));
                    } else {
                        DevLogger.w((String)"The notification does not have any displayable content");
                    }
                    return false;
                }
                return true;
            }
        };
    }

    b.a c() {
        return new b.a(){

            @Override
            public void a(NotificationAdResponse notificationAdResponse) {
                try {
                    long l2 = System.currentTimeMillis();
                    com.inlocomedia.android.ads.notification.d.a(c.this.b, l2);
                    Intent intent = new Intent("com.inlocomedia.android.ads.actions.NOTIFICATION_READY");
                    intent.putExtra("NOTIFICATION_EXTRA_ID", Long.toString(l2));
                    intent.setPackage(c.this.b.getPackageName());
                    if (c.this.b(c.this.b, intent)) {
                        c.this.a(l2, notificationAdResponse, intent);
                    } else {
                        c.this.a(notificationAdResponse);
                    }
                }
                catch (Throwable throwable) {
                    CriticalErrorManager.notifyError((String)a, (Throwable)throwable, (Module)j.b.a, (boolean)true);
                }
                c.this.c.unlock();
            }

            @Override
            public void a(InLocoMediaException inLocoMediaException) {
                DevLogger.w((String)"Notification request has failed", (Throwable)inLocoMediaException);
                c.this.c.unlock();
            }
        };
    }

    @VisibleForTesting
    protected void a(long l2, NotificationAdResponse notificationAdResponse, Intent intent) {
        this.d.put(Long.toString(l2), notificationAdResponse);
        this.b.sendBroadcast(intent);
    }

    @VisibleForTesting
    protected boolean b(Context context, Intent intent) {
        return !context.getPackageManager().queryBroadcastReceivers(intent, 65536).isEmpty();
    }

    @Nullable
    public NotificationAdResponse a(String string2) {
        return this.d.get(string2);
    }

    public void b(String string2) {
        NotificationAdResponse notificationAdResponse = this.d.remove(string2);
        if (notificationAdResponse != null) {
            this.a(notificationAdResponse);
        }
    }

    public boolean c(String string2) {
        NotificationAdResponse notificationAdResponse = this.d.remove(string2);
        return notificationAdResponse != null;
    }

    @VisibleForTesting(otherwise=2)
    protected void a(NotificationAdResponse notificationAdResponse) {
        if (com.inlocomedia.android.ads.notification.d.c(this.b)) {
            NotificationCompat.BigPictureStyle bigPictureStyle;
            PendingIntent pendingIntent = l.a(this.b, notificationAdResponse.getNotificationAd());
            NotificationCompat.Builder builder = new NotificationCompat.Builder(this.b);
            builder.setAutoCancel(true);
            builder.setContentIntent(pendingIntent);
            builder.setContentTitle((CharSequence)notificationAdResponse.getTitle());
            builder.setSmallIcon(com.inlocomedia.android.ads.notification.d.b(this.b));
            builder.setContentText((CharSequence)notificationAdResponse.getDescription());
            if (notificationAdResponse.getIcon() != null) {
                builder.setLargeIcon(notificationAdResponse.getIcon());
            }
            if (notificationAdResponse.getImage() != null) {
                bigPictureStyle = new NotificationCompat.BigPictureStyle(builder);
                bigPictureStyle.bigPicture(notificationAdResponse.getImage());
                bigPictureStyle.setSummaryText((CharSequence)notificationAdResponse.getDescription());
            } else {
                bigPictureStyle = new NotificationCompat.BigTextStyle(builder);
                bigPictureStyle.bigText((CharSequence)notificationAdResponse.getDescription());
            }
            bigPictureStyle = builder.build();
            if (notificationAdResponse.getNotificationAd().u()) {
                bigPictureStyle.defaults |= 1;
            }
            if (notificationAdResponse.getNotificationAd().v() && g.d(this.b)) {
                bigPictureStyle.defaults |= 2;
            }
            NotificationManager notificationManager = (NotificationManager)this.b.getSystemService("notification");
            notificationManager.notify(8233, (Notification)bigPictureStyle);
            w w2 = new w(notificationAdResponse.getNotificationAd());
            w2.a(this.b);
        }
    }

    private static boolean d(Context context) {
        if (!Validator.isValidSDKVersion()) {
            DevLogger.w((String)("Notifications could not be toggled: " + (Object)((Object)AdError.INVALID_SDK_VERSION)));
            return false;
        }
        if (!g.b(context)) {
            DevLogger.w((String)"Notifications could not be enabled. You must register your application for ads before using this service");
            return false;
        }
        if (!j.b.a.isValid()) {
            DevLogger.w((String)"Notifications could not be enabled: Invalid application state. Check your log for more details");
            return false;
        }
        if (!InLoco.isLocationTrackingEnabled((Context)context)) {
            DevLogger.w((String)"Notifications could not be enabled. You must enable background location tracking before using this service");
            return false;
        }
        return g.e(context);
    }

    public static class a
    implements GeofencingEventsListener {
        public void onGeofenceEvent(Context context, int geofenceTransition, Collection<SimpleGeofence> triggeringGeofences) {
            com.inlocomedia.android.ads.notification.c.a(context).a(geofenceTransition, triggeringGeofences);
        }
    }
}

