/*
 * Decompiled with CFR 0.152.
 */
package com.inlocomedia.android.ads.core;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.PointF;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import com.inlocomedia.android.ads.AdError;
import com.inlocomedia.android.ads.AdType;
import com.inlocomedia.android.ads.R;
import com.inlocomedia.android.ads.core.e;
import com.inlocomedia.android.ads.core.j;
import com.inlocomedia.android.ads.mraid.a;
import com.inlocomedia.android.ads.private.ah;
import com.inlocomedia.android.ads.private.ai;
import com.inlocomedia.android.ads.private.aj;
import com.inlocomedia.android.ads.private.al;
import com.inlocomedia.android.ads.private.s;
import com.inlocomedia.android.ads.views.CloseableLayout;
import com.inlocomedia.android.core.Module;
import com.inlocomedia.android.core.log.CriticalErrorManager;
import com.inlocomedia.android.core.log.Logger;
import java.util.concurrent.CopyOnWriteArraySet;

public class AdContentView
extends CloseableLayout {
    private static final String TAG = Logger.makeTag(AdContentView.class);
    private e mAdViewController;
    private AdType mRequestedType;
    private View.OnClickListener mOnClickListener;
    private CopyOnWriteArraySet<View.OnClickListener> mClickListenerSet;

    public AdContentView(Context context) {
        super(context);
        this.init(context, null);
    }

    public AdContentView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public AdContentView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    @SuppressLint(value={"NewApi"})
    public AdContentView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(context, attrs);
    }

    private void init(Context context, @Nullable AttributeSet attrs) {
        this.mOnClickListener = new View.OnClickListener(){

            public void onClick(View v2) {
                if (AdContentView.this.mClickListenerSet != null) {
                    for (View.OnClickListener onClickListener : AdContentView.this.mClickListenerSet) {
                        onClickListener.onClick(v2);
                    }
                }
            }
        };
        if (attrs != null) {
            TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.ilmBaseAdView);
            int n2 = typedArray.getInt(R.styleable.ilmBaseAdView_ilmAdType, -1);
            if (n2 != -1) {
                this.mRequestedType = AdType.getByAttr(n2);
            }
            boolean bl = typedArray.getBoolean(R.styleable.ilmBaseAdView_ilmCloseEnabled, this.isCloseEnabled());
            this.setCloseEnabled(bl);
            int n3 = typedArray.getInt(R.styleable.ilmBaseAdView_ilmCloseButtonGravity, this.getCloseButtonGravity());
            this.setCloseButtonGravity(n3);
            typedArray.recycle();
        }
        if (this.mRequestedType == null || this.mRequestedType.isNative()) {
            this.mAdViewController = new com.inlocomedia.android.ads.nativeads.a(this, attrs);
        }
    }

    protected void loadFrom(ah advertisement, @NonNull e.a listener) {
        try {
            this.loadFromAdvertisement(advertisement, listener);
        }
        catch (Throwable throwable) {
            CriticalErrorManager.notifyError((String)TAG, (Throwable)throwable, (Module)j.b.a, (boolean)true);
            listener.a(AdError.INTERNAL_ERROR);
        }
    }

    private void loadFromAdvertisement(ah ad2, @NonNull e.a listener) {
        String string2;
        switch (string2 = ad2.a()) {
            case "display": {
                this.loadFromDisplayAd((ai)ad2, listener);
                break;
            }
            case "native": {
                this.loadFromNativeAd((aj)ad2, listener);
                break;
            }
            case "video": {
                this.loadFromVideoAd((al)ad2, listener);
            }
        }
    }

    private void loadFromVideoAd(al videoAd, @NonNull e.a listener) {
        com.inlocomedia.android.ads.video.a a2;
        if (this.mAdViewController == null) {
            a2 = new com.inlocomedia.android.ads.video.a(this);
        } else if (this.mAdViewController instanceof com.inlocomedia.android.ads.video.a) {
            a2 = (com.inlocomedia.android.ads.video.a)this.mAdViewController;
        } else {
            this.mAdViewController.g();
            a2 = new com.inlocomedia.android.ads.video.a(this);
        }
        a2.a(videoAd, listener);
        this.mAdViewController = a2;
    }

    private void loadFromDisplayAd(ai displayAd, @NonNull e.a listener) {
        if (displayAd.p()) {
            a a2;
            if (this.mAdViewController == null) {
                a2 = new a(this);
            } else if (this.mAdViewController instanceof a) {
                a2 = (a)this.mAdViewController;
            } else {
                this.mAdViewController.g();
                a2 = new a(this);
            }
            a2.a(displayAd, listener);
            this.mAdViewController = a2;
        } else {
            s s2;
            if (this.mAdViewController == null) {
                s2 = new s(this);
            } else if (this.mAdViewController instanceof s) {
                s2 = (s)this.mAdViewController;
            } else {
                this.mAdViewController.g();
                s2 = new s(this);
            }
            s2.a(displayAd, listener);
            this.mAdViewController = s2;
        }
    }

    private void loadFromNativeAd(aj nativeAd, @NonNull e.a listener) {
        com.inlocomedia.android.ads.nativeads.a a2;
        if (this.mAdViewController == null) {
            a2 = new com.inlocomedia.android.ads.nativeads.a(this, null);
        } else if (this.mAdViewController instanceof com.inlocomedia.android.ads.nativeads.a) {
            a2 = (com.inlocomedia.android.ads.nativeads.a)this.mAdViewController;
        } else {
            this.mAdViewController.g();
            a2 = new com.inlocomedia.android.ads.nativeads.a(this, null);
        }
        a2.a(nativeAd, listener);
        this.mAdViewController = a2;
    }

    public void setOnClickListener(View.OnClickListener onClickListener) {
        super.setOnClickListener(this.mOnClickListener);
        if (this.mClickListenerSet == null) {
            this.mClickListenerSet = new CopyOnWriteArraySet();
        }
        this.mClickListenerSet.add(onClickListener);
    }

    public final AdType getType() {
        return this.mRequestedType;
    }

    public final void setType(AdType type) {
        this.mRequestedType = type;
    }

    @Override
    protected final void onClose() {
        this.setVisibility(8);
        if (this.mAdViewController != null) {
            this.mAdViewController.e();
        }
    }

    public boolean onBackPressed() {
        return this.mAdViewController != null && this.mAdViewController.h();
    }

    public void resume() {
        if (this.mAdViewController != null) {
            this.mAdViewController.f();
        }
    }

    public void pause(boolean isFinishing) {
        if (this.mAdViewController != null) {
            this.mAdViewController.b(isFinishing);
        }
    }

    public void destroy() {
        if (this.mAdViewController != null) {
            this.mAdViewController.g();
        }
    }

    @Override
    public void onOrientationChanged(int orientation) {
        super.onOrientationChanged(orientation);
        if (this.mAdViewController != null) {
            this.mAdViewController.a(orientation);
        }
    }

    @Override
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.mAdViewController != null) {
            this.mAdViewController.d(true);
        }
    }

    @Override
    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.mAdViewController != null) {
            this.mAdViewController.d(false);
        }
    }

    @Override
    protected void onVisibilityChanged(boolean visible) {
        super.onVisibilityChanged(visible);
        if (this.mAdViewController != null) {
            this.mAdViewController.c(visible);
        }
    }

    @Override
    public boolean onInterceptTouchEvent(@NonNull MotionEvent event) {
        if (this.mAdViewController != null) {
            this.mAdViewController.a(new PointF(event.getX(), event.getY()));
        }
        return super.onInterceptTouchEvent(event);
    }

    public boolean isAdPlaying() {
        return this.mAdViewController != null && this.mAdViewController.d();
    }

    public void onVisualizationRegistered() {
        if (this.mAdViewController != null) {
            this.mAdViewController.a(this);
        }
    }

    public void setActivity(Activity activity) {
        if (this.mAdViewController != null) {
            this.mAdViewController.a(activity);
        }
    }

    protected void setChildClickEnabled(boolean childClickEnabled) {
        if (this.mAdViewController != null && this.mAdViewController instanceof com.inlocomedia.android.ads.nativeads.a) {
            ((com.inlocomedia.android.ads.nativeads.a)this.mAdViewController).e(childClickEnabled);
        }
    }

    @VisibleForTesting
    protected final e getAdViewController() {
        return this.mAdViewController;
    }

    @VisibleForTesting
    protected final void setAdViewController(e adViewController) {
        this.mAdViewController = adViewController;
    }
}

