/*
 * Decompiled with CFR 0.152.
 */
package com.inlocomedia.android.ads.private;

import android.content.Context;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import com.inlocomedia.android.ads.AdActivity;
import com.inlocomedia.android.ads.AdReceiver;
import com.inlocomedia.android.ads.AdType;
import com.inlocomedia.android.ads.AdView;
import com.inlocomedia.android.ads.R;
import com.inlocomedia.android.ads.core.h;
import com.inlocomedia.android.ads.core.i;
import com.inlocomedia.android.ads.exception.AdvertisementException;
import com.inlocomedia.android.ads.exception.AdvertisementRequestException;
import com.inlocomedia.android.ads.private.ah;
import com.inlocomedia.android.ads.private.ai;
import com.inlocomedia.android.ads.private.aj;
import com.inlocomedia.android.ads.private.ak;
import com.inlocomedia.android.ads.private.al;
import com.inlocomedia.android.ads.private.bd;
import com.inlocomedia.android.core.annotations.VisibleForTesting;
import com.inlocomedia.android.core.communication.AuthenticationId;
import com.inlocomedia.android.core.communication.exception.UnauthorizedException;
import com.inlocomedia.android.core.exception.InvalidAndroidSDKVersion;
import com.inlocomedia.android.core.log.DevLogger;
import com.inlocomedia.android.core.util.Validator;
import com.inlocomedia.android.location.InLocoPrivate;

public final class g {
    public static void a(Context context) throws InvalidAndroidSDKVersion, UnauthorizedException {
        Validator.sdkVersion();
        if (!g.b(context)) {
            throw new UnauthorizedException("You must register your application for ads before using this service");
        }
    }

    public static boolean b(Context context) {
        return Validator.clientId((AuthenticationId)h.a(context));
    }

    public static void c(Context context) {
        PackageInfo packageInfo;
        PackageManager packageManager = context.getPackageManager();
        try {
            packageInfo = packageManager.getPackageInfo(context.getPackageName(), 1);
            if (packageInfo.activities == null) {
                return;
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return;
        }
        boolean bl = false;
        for (ActivityInfo activityInfo : packageInfo.activities) {
            if (!AdActivity.class.getName().equals(activityInfo.name)) continue;
            bl = true;
            break;
        }
        if (!bl) {
            i.b.a.setInvalid();
            DevLogger.e((String)("Missing required Activity: " + AdActivity.class.getName() + ". Have you declared the AdActivity in your AndroidManifest file?"));
        }
    }

    public static boolean d(Context context) {
        int n2 = context.checkCallingOrSelfPermission("android.permission.VIBRATE");
        return n2 == 0;
    }

    public static boolean e(Context context) {
        if (bd.a()) {
            boolean bl = InLocoPrivate.hasLocationReceiver((Context)context);
            boolean bl2 = Validator.isReceiverRegistered((Context)context, AdReceiver.class, null);
            if (!InLocoPrivate.hasBootCompletedPermission((Context)context)) {
                DevLogger.e((String)"You must enable the RECEIVE_BOOT_COMPLETED permission in your AndroidManifest file");
                return false;
            }
            if (bl && bl2) {
                return true;
            }
            if (!bl) {
                DevLogger.e((String)"LocationReceiver receiver not found. Did you declare it in your AndroidManifest file?");
            }
            if (!bl2) {
                DevLogger.e((String)"AdReceiver receiver not found. Did you declare it in your AndroidManifest file?");
            }
        } else {
            DevLogger.w((String)"In order to use Notification Ads, you have to add the In Loco Location SDK as a dependency as well.");
        }
        return false;
    }

    public static void f(Context context) {
        Validator.manifest((Context)context);
        g.c(context);
    }

    public static void a(ak ak2) throws AdvertisementException {
        try {
            g.a((ah)ak2);
            g.c(ak2.a());
            Validator.notNullNorEmpty((String)ak2.w(), (String)"Native ad title");
            if (!Validator.isValidUrl((String)ak2.z()) && !Validator.isValidUrl((String)ak2.A())) {
                throw new IllegalArgumentException("Native ad image or icon.");
            }
        }
        catch (IllegalArgumentException | NullPointerException runtimeException) {
            throw new AdvertisementException("Invalid native ad validation: " + runtimeException.toString(), runtimeException);
        }
    }

    public static void a(al al2) throws AdvertisementException {
        try {
            g.a((ah)al2);
            g.a(al2.a());
            Validator.notNullNorEmpty((String)al2.y(), (String)"Ad title");
        }
        catch (IllegalArgumentException | NullPointerException runtimeException) {
            throw new AdvertisementException("Invalid notification ad validation: " + runtimeException.toString(), runtimeException);
        }
    }

    public static void a(aj aj2) throws AdvertisementException {
        try {
            g.a((ah)aj2);
            g.b(aj2.a());
            Validator.notNullNorEmpty((String)aj2.x(), (String)"DisplayAd html");
        }
        catch (IllegalArgumentException | NullPointerException runtimeException) {
            throw new AdvertisementException("Invalid display ad validation: " + runtimeException.toString(), runtimeException);
        }
    }

    public static void a(ai ai2) throws AdvertisementException {
        try {
            g.a((ah)ai2);
            g.d(ai2.a());
        }
        catch (IllegalArgumentException | NullPointerException runtimeException) {
            throw new AdvertisementException("Invalid custom ad validation: " + runtimeException.toString(), runtimeException);
        }
    }

    @VisibleForTesting
    static void a(ah ah2) {
        Validator.notNull((Object)ah2, (String)"Ad");
        Validator.notNullNorEmpty((String)ah2.f(), (String)"Ad id");
        Validator.notNullNorEmpty((String)ah2.d(), (String)"Ad visualization url");
        Validator.isValidUrl((String)ah2.d(), (String)"Ad visualization url");
        Validator.notNullNorEmpty((String)ah2.c(), (String)"Ad register click url");
        Validator.isValidUrl((String)ah2.c(), (String)"Ad register click url");
        Validator.notNullNorEmpty((String)ah2.b(), (String)"Ad back to application url");
        Validator.isValidUrl((String)ah2.b(), (String)"Ad back to application url");
        Validator.notNull((Object)((Object)ah2.a()), (String)"Ad type");
    }

    public static void a(AdView adView) throws AdvertisementException {
        try {
            Validator.notNull((Object)((Object)adView), (String)"Advertisement View");
            Validator.notNull((Object)((Object)adView.getType()), (String)"AdType");
            if (adView.getType().isNative()) {
                g.a((View)adView);
            } else if (!adView.getType().isDisplay()) {
                throw new IllegalArgumentException("Invalid advertisement type received");
            }
        }
        catch (IllegalArgumentException | NullPointerException runtimeException) {
            throw new AdvertisementRequestException("Advertisement request has failed: " + runtimeException.toString(), runtimeException);
        }
    }

    public static void a(View view) throws AdvertisementException {
        try {
            if (view.findViewById(R.id.ilm_title) == null) {
                throw new IllegalArgumentException("'Title' is required");
            }
            if (view.findViewById(R.id.ilm_image) == null && view.findViewById(R.id.ilm_icon) == null) {
                throw new IllegalArgumentException("'Image' or 'Icon' is required");
            }
            g.b(view.findViewById(R.id.ilm_call_to_action), "'Call to Action' must extend from TextView");
            g.b(view.findViewById(R.id.ilm_title), "'Title' must be a TextView");
            g.b(view.findViewById(R.id.ilm_description), "'Description' must be a TextView");
            g.b(view.findViewById(R.id.ilm_highlight), "'Highlight' must be a TextView");
            g.b(view.findViewById(R.id.ilm_offer), "'Offer' must be a TextView");
            g.b(view.findViewById(R.id.ilm_expiration), "'Expiration' must be a TextView");
            g.a(view.findViewById(R.id.ilm_image), "'Image' must be a ImageView");
            g.a(view.findViewById(R.id.ilm_icon), "'Icon' must be a ImageView");
        }
        catch (IllegalArgumentException | NullPointerException runtimeException) {
            throw new AdvertisementException("Invalid Native AdView: " + runtimeException.toString(), runtimeException);
        }
    }

    private static void a(View view, String string2) {
        if (view != null && !(view instanceof ImageView)) {
            throw new IllegalArgumentException("Invalid image view type." + string2 + " must be a subclass of " + ImageView.class.getCanonicalName());
        }
    }

    private static void b(View view, String string2) {
        if (view != null && !(view instanceof TextView)) {
            throw new IllegalArgumentException("Invalid text view type." + string2 + " must be a subclass of " + TextView.class.getCanonicalName());
        }
    }

    private static void a(AdType adType) {
        if (!adType.isNotification()) {
            throw new IllegalArgumentException("Notification ad type invalid/missing on validation case " + adType.getValue());
        }
    }

    private static void b(AdType adType) {
        if (!adType.isDisplay()) {
            throw new IllegalArgumentException("Display ad type invalid/missing on validation case " + adType.getValue());
        }
    }

    private static void c(AdType adType) {
        if (!adType.isNative()) {
            throw new IllegalArgumentException("Native ad type invalid/missing on validation case " + adType.getValue());
        }
    }

    private static void d(AdType adType) {
        if (!adType.isCustom()) {
            throw new IllegalArgumentException("Custom ad type invalid/missing on validation case " + adType.getValue());
        }
    }
}

